/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.servicehelper;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRArrayUtils;

public class HRImageAttachmentHelper {
    public static void uploadImage(String pageId, Map<String, List<Object>> attmDataMap, Long billId, String entityId) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper(pageId);
        QFilter qFilter = new QFilter("billno", "=", (Object)billId);
        qFilter.and(new QFilter("entityid", "=", (Object)entityId));
        hrBaseServiceHelper.deleteByFilter(new QFilter[]{qFilter});
        DynamicObjectCollection saveDynamicObject = new DynamicObjectCollection();
        for (Map.Entry<String, List<Object>> attm : attmDataMap.entrySet()) {
            String attmKey = attm.getKey();
            for (Object attmUrl : attm.getValue()) {
                DynamicObject emptyImgAttm = hrBaseServiceHelper.generateEmptyDynamicObject();
                emptyImgAttm.set("creatorid", (Object)Long.parseLong(RequestContext.get().getUserId()));
                emptyImgAttm.set("createtime", (Object)new Date());
                emptyImgAttm.set("url", attmUrl);
                emptyImgAttm.set("entityid", (Object)entityId);
                emptyImgAttm.set("billno", (Object)billId);
                emptyImgAttm.set("attmkey", (Object)attmKey);
                saveDynamicObject.add((Object)emptyImgAttm);
            }
        }
        if (!saveDynamicObject.isEmpty()) {
            hrBaseServiceHelper.save(saveDynamicObject);
        }
    }

    public static void uploadImage(String pageId, List<Map<String, Object>> attmDataList, Map<String, List<String>> imageUrl) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper(pageId);
        DynamicObjectCollection saveDynamicObject = new DynamicObjectCollection();
        for (Map<String, Object> attamData : attmDataList) {
            String attmKey = (String)attamData.get("attmkey");
            List<String> imgUrlList = imageUrl.get(attmKey);
            for (String imgUrl : imgUrlList) {
                DynamicObject emptyImgAttm = hrBaseServiceHelper.generateEmptyDynamicObject();
                emptyImgAttm.set("creatorid", (Object)Long.parseLong(RequestContext.get().getUserId()));
                emptyImgAttm.set("createtime", (Object)new Date());
                emptyImgAttm.set("url", (Object)imgUrl.trim());
                emptyImgAttm.set("entityid", attamData.get("entityid"));
                emptyImgAttm.set("billno", attamData.get("id"));
                emptyImgAttm.set("attmkey", (Object)attmKey);
                saveDynamicObject.add((Object)emptyImgAttm);
            }
        }
        if (!saveDynamicObject.isEmpty()) {
            hrBaseServiceHelper.save(saveDynamicObject);
        }
    }

    public static Map<String, List<String>> getImageAttms(String pageId, Long businessKey, String formKey) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper(pageId);
        QFilter qFilter = new QFilter("billno", "=", (Object)businessKey);
        qFilter.and(new QFilter("entityid", "=", (Object)formKey));
        Object[] dynamicObjectArray = hrBaseServiceHelper.query("url, attmkey", new QFilter[]{qFilter});
        if (null != dynamicObjectArray && !HRArrayUtils.isEmpty((Object[])dynamicObjectArray)) {
            HashMap<String, List<String>> returnImgHashMap = new HashMap<String, List<String>>();
            for (Object dynamicObject : dynamicObjectArray) {
                if (returnImgHashMap.containsKey(dynamicObject.get("attmkey"))) {
                    ((List)returnImgHashMap.get(dynamicObject.get("attmkey"))).add((String)dynamicObject.get("url"));
                    continue;
                }
                returnImgHashMap.put((String)dynamicObject.get("attmkey"), new ArrayList());
                ((List)returnImgHashMap.get(dynamicObject.get("attmkey"))).add((String)dynamicObject.get("url"));
            }
            return returnImgHashMap;
        }
        return null;
    }

    public static Map<String, List<String>> getImageAttms(String pageId, Long businessKey, List<String> formKeys) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper(pageId);
        QFilter qFilter = new QFilter("billno", "=", (Object)businessKey);
        int size = formKeys.size();
        for (int i = 0; i < size; ++i) {
            if (i == 0) {
                qFilter.and(new QFilter("entityid", "=", (Object)formKeys.get(i)));
                continue;
            }
            qFilter.or(new QFilter("entityid", "=", (Object)formKeys.get(i)));
        }
        Object[] dynamicObjectArray = hrBaseServiceHelper.query("url, attmkey", new QFilter[]{qFilter});
        if (null != dynamicObjectArray && !HRArrayUtils.isEmpty((Object[])dynamicObjectArray)) {
            HashMap<String, List<String>> returnImgMap = new HashMap<String, List<String>>();
            for (Object dynObj : dynamicObjectArray) {
                if (returnImgMap.containsKey(dynObj.get("attmkey"))) {
                    ((List)returnImgMap.get(dynObj.get("attmkey"))).add((String)dynObj.get("url"));
                    continue;
                }
                returnImgMap.put((String)dynObj.get("attmkey"), new ArrayList());
                ((List)returnImgMap.get(dynObj.get("attmkey"))).add((String)dynObj.get("url"));
            }
            return returnImgMap;
        }
        return null;
    }
}

