/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.servicehelper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.cache.HRAppCache;
import kd.hr.hbp.common.cache.IHRAppCache;
import kd.hr.hbp.common.model.PerserModel;
import kd.hr.hbp.common.util.HRStringUtils;
import org.apache.commons.lang3.StringUtils;

public class HRPerserlenHelper {
    private static final Log LOGGER = LogFactory.getLog(HRPerserlenHelper.class);
    public static long COMMON_YEAR_DAYS = 365L;
    public static long LEAP_YEAR_DAYS = 366L;
    private static final HRBaseServiceHelper DEV_PARAM_CONFIG = new HRBaseServiceHelper("hpfs_devconfig");
    private static final HRBaseServiceHelper perserlenHelper = new HRBaseServiceHelper("hrpi_perserlen");
    private static final HRBaseServiceHelper personHelper = new HRBaseServiceHelper("hrpi_person");

    public static BigDecimal calcComsercount(Date joincomDate, BigDecimal adjustTime, Long personId) {
        Date date = HRPerserlenHelper.getUseDate(personId);
        return HRPerserlenHelper.getCalcComsercount(joincomDate, adjustTime, personId, date);
    }

    public static BigDecimal calcComsercountByEmployeeId(Date joincomDate, BigDecimal adjustTime, Long employeeId) {
        DynamicObject employeeInfo = HRPerserlenHelper.getEmployeeInfoByEmployeeId(employeeId);
        if (null == employeeInfo) {
            return BigDecimal.ZERO;
        }
        Date date = HRPerserlenHelper.getEndDateByEmployeeInfo(employeeInfo);
        return HRPerserlenHelper.getCalcComsercount(joincomDate, adjustTime, employeeInfo.getLong("person.id"), date);
    }

    public static BigDecimal calcComsercount(Date joincomDate, BigDecimal adjustTime, Long personId, Date useDate) {
        return HRPerserlenHelper.getCalcComsercount(joincomDate, adjustTime, personId, useDate);
    }

    public static BigDecimal calcComsercount(Date joincomDate, BigDecimal adjustTime, Long personId, Long employeeId) {
        Date date = HRPerserlenHelper.getUseDate(personId);
        return HRPerserlenHelper.getCalcComsercount(joincomDate, adjustTime, personId, date, employeeId);
    }

    public static BigDecimal getCalcComsercount(Date joincomDate, BigDecimal adjustTime, Long personId, Date useDate) {
        BigDecimal serviceLen = adjustTime.add(HRPerserlenHelper.calcYearsDiff(useDate, joincomDate));
        ArrayList<PerserModel> perserModelList = new ArrayList<PerserModel>(2);
        PerserModel perserModel = new PerserModel();
        perserModel.setPersonId(personId.longValue());
        perserModel.setJoincomDate(joincomDate);
        perserModelList.add(perserModel);
        LOGGER.info("==getCalcComsercount:{}==", perserModelList);
        HRPerserlenHelper.getHisComserCount(perserModelList);
        if (CollectionUtils.isEmpty(perserModelList)) {
            return serviceLen;
        }
        BigDecimal lastComserCount = ((PerserModel)perserModelList.get(0)).getLastComserCount();
        return serviceLen.add(lastComserCount);
    }

    public static BigDecimal getCalcComsercount(Date joincomDate, BigDecimal adjustTime, Long personId, Date useDate, Long employeeId) {
        BigDecimal serviceLen = adjustTime.add(HRPerserlenHelper.calcYearsDiff(useDate, joincomDate));
        ArrayList<PerserModel> perserModelList = new ArrayList<PerserModel>(2);
        PerserModel perserModel = new PerserModel();
        perserModel.setPersonId(personId.longValue());
        perserModel.setJoincomDate(joincomDate);
        perserModel.setEmployeeId(employeeId.longValue());
        perserModelList.add(perserModel);
        LOGGER.info("==getCalcComsercount:{}==", perserModelList);
        HRPerserlenHelper.getHisComserCount(perserModelList);
        if (CollectionUtils.isEmpty(perserModelList)) {
            return serviceLen;
        }
        BigDecimal lastComserCount = ((PerserModel)perserModelList.get(0)).getLastComserCount();
        return serviceLen.add(lastComserCount);
    }

    public static void getBatchCalcComsercount(List<PerserModel> perserModelList) {
        if (CollectionUtils.isEmpty(perserModelList)) {
            return;
        }
        LOGGER.info("==getBatchCalcComsercount.size:{}==", (Object)perserModelList.size());
        List<PerserModel> filterPerserModelList = perserModelList.stream().filter(perserModel -> perserModel.getAdjustTime() != null && perserModel.getUseDate() != null && perserModel.getJoincomDate() != null && perserModel.getPersonId() != 0L && perserModel.getEmployeeId() != 0L).collect(Collectors.toList());
        HRPerserlenHelper.getHisComserCount(filterPerserModelList);
        for (PerserModel perserModel2 : perserModelList) {
            BigDecimal lastComCount;
            long personId = perserModel2.getPersonId();
            BigDecimal serviceLen = perserModel2.getAdjustTime().add(HRPerserlenHelper.calcYearsDiff(perserModel2.getUseDate(), perserModel2.getJoincomDate()));
            if (serviceLen == null) {
                serviceLen = BigDecimal.ZERO;
            }
            if ((lastComCount = perserModel2.getLastComserCount()) == null) {
                lastComCount = BigDecimal.ZERO;
            }
            perserModel2.setComserCount(serviceLen.add(lastComCount));
        }
    }

    public static Date getUseDate(Long personId) {
        DynamicObject personStatusDy = HRPerserlenHelper.getPersonLabrelstatus(personId);
        return HRPerserlenHelper.getEndDateByEmployeeInfo(personStatusDy);
    }

    public static Date getEndDateByEmployeeInfo(DynamicObject employeeInfo) {
        DynamicObject laborrelstatusDy;
        Date date = new Date();
        if (employeeInfo != null && (laborrelstatusDy = employeeInfo.getDynamicObject("laborrelstatus")) != null) {
            long statusId;
            long l = statusId = laborrelstatusDy.getDynamicObject("labrelstatusprd") != null ? laborrelstatusDy.getLong("labrelstatusprd.id") : 0L;
            if (statusId == 1020L) {
                date = employeeInfo.getDate("enddate");
            }
        }
        if (date == null) {
            date = new Date();
        }
        return date;
    }

    public static DynamicObject getPersonLabrelstatus(Long personId) {
        if (personId == null || personId == 0L) {
            return null;
        }
        QFilter statusQFilter = new QFilter("iscurrentversion", "=", (Object)"1").and(new QFilter("datastatus", "=", (Object)"1"));
        QFilter isLatestFilter = new QFilter("islatestrecord", "=", (Object)"1");
        HRBaseServiceHelper empentrelHepler = new HRBaseServiceHelper("hrpi_employee");
        QFilter filter = new QFilter("person.id", "=", (Object)personId).and(statusQFilter).and(isLatestFilter);
        return empentrelHepler.queryOne("laborrelstatus, enddate", filter);
    }

    public static DynamicObject getEmployeeInfoByEmployeeId(Long employeeId) {
        if (employeeId == null || employeeId == 0L) {
            return null;
        }
        QFilter statusQFilter = new QFilter("iscurrentversion", "=", (Object)"1").and(new QFilter("datastatus", "=", (Object)"1"));
        HRBaseServiceHelper employeeHelper = new HRBaseServiceHelper("hrpi_employee");
        QFilter filter = new QFilter("id", "=", (Object)employeeId).and(statusQFilter);
        return employeeHelper.loadDynamicObject(filter);
    }

    public static BigDecimal calcYearsDiff(Date dateO, Date dateT) {
        if (null == dateO || null == dateT || dateO.before(dateT)) {
            LOGGER.error("date calculate failed , we will return zero");
            return BigDecimal.ZERO;
        }
        return HRPerserlenHelper.calcYearsDiffNew(dateO, dateT);
    }

    public static BigDecimal calcYearsDiffNew(Date endDate, Date startDate) {
        return HRPerserlenHelper.calcYearsDiffWithRoundingMode(endDate, startDate, HRPerserlenHelper.getBusiYearRoundingMode());
    }

    public static BigDecimal calcYearsDiffWithRoundingMode(Date endDate, Date startDate, RoundingMode roundingMode) {
        BigDecimal yearLen;
        LocalDate localEndDate;
        LocalDate localStartDate;
        BigDecimal specialYearLen;
        if (endDate == null || startDate == null || endDate.before(startDate)) {
            return BigDecimal.ZERO;
        }
        if (null == roundingMode) {
            roundingMode = HRPerserlenHelper.getBusiYearRoundingMode();
        }
        if ((specialYearLen = HRPerserlenHelper.halfYearSpecialCalculate(localStartDate = startDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate(), localEndDate = endDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate())) != BigDecimal.ZERO) {
            return specialYearLen;
        }
        int startDateYear = localStartDate.getYear();
        int endDateYear = localEndDate.getYear();
        Tuple<Date, BigDecimal> nearNodeTuple = HRPerserlenHelper.calculateNearNodeDate(localStartDate, localEndDate);
        if (endDateYear == startDateYear) {
            if (localStartDate.getMonthValue() == 2 && localStartDate == localStartDate.with(TemporalAdjusters.lastDayOfMonth()) && localEndDate.getMonthValue() == 8 && localEndDate != localEndDate.with(TemporalAdjusters.lastDayOfMonth())) {
                return BigDecimal.ZERO;
            }
            long days = localStartDate.until(localEndDate, ChronoUnit.DAYS);
            yearLen = HRPerserlenHelper.getYearLenWithRoundingMode(localEndDate, days, 1, RoundingMode.DOWN);
        } else {
            LocalDate startDateCurYearLastDate = LocalDate.of(startDateYear, 12, 31);
            long firstYearDiffDays = localStartDate.until(startDateCurYearLastDate, ChronoUnit.DAYS);
            BigDecimal midYearNum = BigDecimal.valueOf(endDateYear - startDateYear - 1);
            LocalDate endDateCurYearFirstDate = LocalDate.of(endDateYear, 1, 1);
            long lastYearDiffDays = endDateCurYearFirstDate.until(localEndDate, ChronoUnit.DAYS);
            BigDecimal startDateYearLen = HRPerserlenHelper.getYearLen(localStartDate, firstYearDiffDays, 16);
            BigDecimal endDateYearLen = HRPerserlenHelper.getYearLen(localEndDate, lastYearDiffDays, 16);
            yearLen = startDateYearLen.add(midYearNum).add(endDateYearLen).setScale(1, roundingMode);
        }
        if (nearNodeTuple != null && (endDate.after((Date)nearNodeTuple.item1) && yearLen.compareTo((BigDecimal)nearNodeTuple.item2) < 0 || endDate.before((Date)nearNodeTuple.item1) && yearLen.compareTo((BigDecimal)nearNodeTuple.item2) > 0)) {
            yearLen = (BigDecimal)nearNodeTuple.item2;
        }
        return yearLen;
    }

    private static Tuple<Date, BigDecimal> calculateNearNodeDate(LocalDate startDate, LocalDate endDate) {
        if (null == startDate || null == endDate) {
            return null;
        }
        long intervalMonths = HRPerserlenHelper.betweenMonths(startDate, endDate);
        if (intervalMonths < 3L) {
            return null;
        }
        long modulo = intervalMonths % 6L;
        if (modulo != 0L) {
            intervalMonths = modulo > 3L ? intervalMonths + (6L - modulo) : intervalMonths - modulo;
        }
        BigDecimal inervalOfYear = BigDecimal.valueOf(intervalMonths).divide(new BigDecimal("12"));
        Date sDate = Date.from(startDate.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
        Date nearNodeDate = HRPerserlenHelper.getAddMonthDate(sDate, sDate, inervalOfYear);
        return Tuple.create((Object)nearNodeDate, (Object)inervalOfYear);
    }

    private static BigDecimal halfYearSpecialCalculate(LocalDate startDate, LocalDate endDate) {
        if (null == startDate || null == endDate) {
            return BigDecimal.ZERO;
        }
        long intervalMonths = HRPerserlenHelper.betweenMonths(startDate, endDate);
        if (intervalMonths % 6L != 0L) {
            return BigDecimal.ZERO;
        }
        BigDecimal inervalOfYear = BigDecimal.valueOf(intervalMonths).divide(new BigDecimal("12"));
        LocalDate lastDayOfMonth4StartDay = startDate.with(TemporalAdjusters.lastDayOfMonth());
        LocalDate lastDayOfMonth4EndDay = endDate.with(TemporalAdjusters.lastDayOfMonth());
        int dayOfMonth4StartDay = startDate.getDayOfMonth();
        int dayOfMonth4EndtDay = endDate.getDayOfMonth();
        if (lastDayOfMonth4StartDay.equals(startDate) && lastDayOfMonth4EndDay.equals(endDate)) {
            return inervalOfYear;
        }
        if (endDate.getMonthValue() == 2 && lastDayOfMonth4EndDay.equals(endDate) && startDate.getMonthValue() == 8 && (29 == dayOfMonth4EndtDay || 30 == dayOfMonth4EndtDay)) {
            return inervalOfYear;
        }
        if (!(dayOfMonth4StartDay != dayOfMonth4EndtDay || lastDayOfMonth4StartDay.equals(startDate) || lastDayOfMonth4EndDay.equals(endDate) && endDate.getMonthValue() != 2)) {
            return inervalOfYear;
        }
        return BigDecimal.ZERO;
    }

    public static long betweenMonths(LocalDate startDate, LocalDate endDate) {
        if (null == startDate || null == endDate) {
            return 0L;
        }
        int startYear = startDate.getYear();
        int startMonth = startDate.getMonthValue();
        int endYear = endDate.getYear();
        int endMonth = endDate.getMonthValue();
        return (endYear - startYear) * 12 + (endMonth - startMonth);
    }

    private static BigDecimal getYearLen(LocalDate localDate, long days, int scale) {
        return HRPerserlenHelper.getYearLenWithRoundingMode(localDate, days, scale, HRPerserlenHelper.getBusiYearRoundingMode());
    }

    private static BigDecimal getYearLenWithRoundingMode(LocalDate localDate, long days, int scale, RoundingMode roundingMode) {
        if (null == roundingMode) {
            roundingMode = HRPerserlenHelper.getBusiYearRoundingMode();
        }
        BigDecimal yearLen = localDate.isLeapYear() ? BigDecimal.valueOf(days).divide(BigDecimal.valueOf(366L), scale, roundingMode) : BigDecimal.valueOf(days).divide(BigDecimal.valueOf(365L), scale, roundingMode);
        return yearLen;
    }

    public static Date getAddMonthDate(Date date, BigDecimal precision) {
        BigDecimal month = BigDecimal.valueOf(12L).multiply(precision);
        LocalDate localDate = date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        LocalDate realLocalDate = localDate.plusMonths(month.longValue());
        return Date.from(realLocalDate.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
    }

    public static Date getAddMonthDate(Date baseDate, Date startDate, BigDecimal precision) {
        BigDecimal month = BigDecimal.valueOf(12L).multiply(precision);
        LocalDate localDate = startDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        LocalDate realLocalDate = localDate.plusMonths(month.longValue());
        boolean lastDayOfMonth = HRPerserlenHelper.lastDayOfMonth(baseDate);
        if (lastDayOfMonth) {
            LocalDate realLastDayOfMonth = realLocalDate.with(TemporalAdjusters.lastDayOfMonth());
            if (!realLastDayOfMonth.equals(realLocalDate)) {
                realLocalDate = realLastDayOfMonth;
            }
        } else {
            LocalDate baseLocalDate = baseDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
            if (BigDecimal.valueOf(0.5).equals(precision) && 8 == baseLocalDate.getMonthValue() && (29 == baseLocalDate.getDayOfMonth() || 30 == baseLocalDate.getDayOfMonth()) && 8 == realLocalDate.getMonthValue()) {
                int year = realLocalDate.getYear();
                int monthValue = realLocalDate.getMonthValue();
                int dayOfMonth = baseLocalDate.getDayOfMonth();
                realLocalDate = LocalDate.of(year, monthValue, dayOfMonth);
            }
        }
        return Date.from(realLocalDate.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
    }

    private static boolean lastDayOfMonth(Date date) {
        LocalDate localDate = date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        LocalDate lastDayOfMonth = localDate.with(TemporalAdjusters.lastDayOfMonth());
        return lastDayOfMonth.equals(localDate);
    }

    public static RoundingMode getBusiYearRoundingMode() {
        String roundingModeStr = HRPerserlenHelper.getDevParamConfigByBusinessKey("hspm_business_year_rounding_mode", "businessvalue");
        try {
            if (HRStringUtils.equalsIgnoreCase((String)roundingModeStr, (String)"UNNECESSARY")) {
                roundingModeStr = "HALF_UP";
            }
            return RoundingMode.valueOf(roundingModeStr);
        }
        catch (IllegalArgumentException e) {
            LOGGER.warn("", (Throwable)e);
            return RoundingMode.HALF_UP;
        }
    }

    public static String getDevParamConfigByBusinessKey(String businessKey, String queryValue) {
        DynamicObject cacheObject;
        IHRAppCache ihrAppCache = HRAppCache.get((String)"hpfs:DevelopParamConfig");
        String cache = (String)ihrAppCache.get(businessKey, String.class);
        if (StringUtils.isNotBlank((CharSequence)cache) && (cacheObject = (DynamicObject)SerializationUtils.deSerializeFromBase64((String)cache)) != null) {
            return cacheObject.getString(queryValue);
        }
        DEV_PARAM_CONFIG.queryOriginalOne("businessvalue,largebusinessvalue_tag", new QFilter[]{new QFilter("businesskey", "=", (Object)businessKey)});
        DynamicObject configObject = DEV_PARAM_CONFIG.queryOriginalOne("businessvalue,largebusinessvalue_tag", new QFilter[]{new QFilter("businesskey", "=", (Object)businessKey)});
        ihrAppCache.put(businessKey, (Object)SerializationUtils.serializeToBase64((Object)configObject));
        return configObject == null ? "" : configObject.getString(queryValue);
    }

    public static void getHisComserCount(List<PerserModel> perserModelList) {
        List<DynamicObject> personPerserList;
        QFilter idFilter;
        if (CollectionUtils.isEmpty(perserModelList)) {
            return;
        }
        LOGGER.info("==getHisComserCount perserModelList.size:{}=", (Object)perserModelList.size());
        Set personIds = perserModelList.stream().map(PerserModel::getPersonId).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(personIds)) {
            return;
        }
        QFilter statusFilter = new QFilter("iscurrentversion", "=", (Object)"1").and(new QFilter("datastatus", "=", (Object)"1"));
        DynamicObject[] personDys = personHelper.query("id, personindexid", new QFilter[]{statusFilter, idFilter = new QFilter("id", "in", personIds)});
        if (personDys == null || personDys.length == 0) {
            return;
        }
        Map<Long, Long> personIdpidTmp = Arrays.stream(personDys).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy.getLong("personindexid"), (oldVal, newVal) -> newVal));
        Map<Long, Long> personIdpidMap = personIds.stream().collect(Collectors.toMap(personId -> personId, personId -> personIdpidTmp.get(personId) == null ? Long.valueOf(0L) : (Long)personIdpidTmp.get(personId), (oldVal, newVal) -> newVal));
        if (CollectionUtils.isEmpty(personIdpidMap)) {
            return;
        }
        QFilter pidFilter = new QFilter("personindexid", "in", personIdpidMap.values());
        DynamicObject[] personDysByPid = personHelper.query("id, personindexid", new QFilter[]{pidFilter, statusFilter});
        Map<Long, List<DynamicObject>> pidpersonDysMap = Arrays.stream(personDysByPid).collect(Collectors.groupingBy(dy -> dy.getLong("personindexid")));
        HashMap personIdpersonDysMap = new HashMap(pidpersonDysMap.size());
        for (Map.Entry<Long, Long> entry : personIdpidMap.entrySet()) {
            List<DynamicObject> personList;
            Long l = entry.getKey();
            Long pid = entry.getValue();
            if (pid == 0L || CollectionUtils.isEmpty(personList = pidpersonDysMap.get(pid))) continue;
            personIdpersonDysMap.put(l, personList.stream().map(dy -> dy.getLong("id")).collect(Collectors.toList()));
        }
        if (CollectionUtils.isEmpty(personIdpersonDysMap)) {
            return;
        }
        ArrayList allPersonIds = new ArrayList();
        for (Map.Entry entry : personIdpersonDysMap.entrySet()) {
            if (CollectionUtils.isEmpty((Collection)((Collection)entry.getValue()))) continue;
            allPersonIds.addAll((Collection)entry.getValue());
        }
        if (CollectionUtils.isEmpty(allPersonIds)) {
            return;
        }
        QFilter qFilter = new QFilter("person.id", "in", allPersonIds);
        DynamicObject[] dynamicObjectArray = perserlenHelper.query("comsercount, joincomdate, person.id, employee", new QFilter[]{qFilter, statusFilter});
        HashMap<Long, List<Object>> personIdPerserDyMap = new HashMap<Long, List<Object>>(personIds.size());
        for (Long personId3 : personIds) {
            List personIdsList = (List)personIdpersonDysMap.get(personId3);
            if (CollectionUtils.isEmpty((Collection)personIdsList)) {
                personIdPerserDyMap.put(personId3, new ArrayList(1));
                continue;
            }
            personPerserList = new ArrayList();
            for (Long personid : personIdsList) {
                for (DynamicObject perserDy : dynamicObjectArray) {
                    if (perserDy.getLong("person.id") != personid.longValue()) continue;
                    personPerserList.add(perserDy);
                }
            }
            personIdPerserDyMap.put(personId3, personPerserList);
        }
        for (PerserModel perserModel : perserModelList) {
            Long personId4 = perserModel.getPersonId();
            personPerserList = (List)personIdPerserDyMap.get(personId4);
            if (CollectionUtils.isEmpty(personPerserList)) {
                perserModel.setLastComserCount(BigDecimal.ZERO);
                continue;
            }
            Date joinDate = perserModel.getJoincomDate();
            long employeeId = perserModel.getEmployeeId();
            if (joinDate == null) continue;
            Optional<DynamicObject> maxJoinComDateOnbrd = personPerserList.stream().filter(perser -> perser.getDate("joincomdate") != null).filter(perser -> joinDate.after(perser.getDate("joincomdate"))).filter(perser -> employeeId != perser.getLong("employee.id")).max(Comparator.comparing(dy -> dy.getDate("joincomdate")));
            if (maxJoinComDateOnbrd.isPresent()) {
                BigDecimal comsercount = maxJoinComDateOnbrd.get().getBigDecimal("comsercount");
                perserModel.setLastComserCount(comsercount);
                continue;
            }
            perserModel.setLastComserCount(BigDecimal.ZERO);
        }
    }

    public static BigDecimal calcComsercountByPid(Date joincomDate, BigDecimal adjustTime, Long pid, Date useDate) {
        BigDecimal serviceLen = adjustTime.add(HRPerserlenHelper.calcYearsDiff(useDate, joincomDate));
        BigDecimal comserCount = HRPerserlenHelper.calcRecOnbrdComsercounByPid(pid, joincomDate);
        return serviceLen.add(comserCount);
    }

    public static BigDecimal calcRecOnbrdComsercounByPid(Long pid, Date joincomDate) {
        BigDecimal comsercount = BigDecimal.ZERO;
        if (pid == null || pid == 0L) {
            return comsercount;
        }
        QFilter pidFilter = new QFilter("personindexid", "=", (Object)pid);
        QFilter statusFilter = new QFilter("iscurrentversion", "=", (Object)"1").and(new QFilter("datastatus", "=", (Object)"1"));
        DynamicObject[] personDysByPid = personHelper.query("id, personindexid", new QFilter[]{pidFilter, statusFilter});
        if (personDysByPid == null || personDysByPid.length == 0) {
            return comsercount;
        }
        List personIds = Arrays.stream(personDysByPid).map(dy -> dy.getLong("id")).collect(Collectors.toList());
        QFilter personIdsQFilter = new QFilter("person.id", "in", personIds);
        DynamicObject[] perserDysByPersonId = perserlenHelper.query("comsercount, joincomdate, person.id", new QFilter[]{personIdsQFilter, statusFilter});
        if (perserDysByPersonId == null || perserDysByPersonId.length == 0) {
            return comsercount;
        }
        Optional<DynamicObject> maxJoinComDateOnbrd = Arrays.stream(perserDysByPersonId).filter(perser -> perser.getDate("joincomdate") != null).filter(perser -> joincomDate.after(perser.getDate("joincomdate"))).max(Comparator.comparing(dy -> dy.getDate("joincomdate")));
        if (maxJoinComDateOnbrd.isPresent()) {
            comsercount = maxJoinComDateOnbrd.get().getBigDecimal("comsercount");
        }
        return comsercount;
    }

    public static BigDecimal getSocialWorkage(DynamicObject perserDy) {
        if (perserDy == null) {
            return BigDecimal.ZERO;
        }
        Date joinworktime = perserDy.getDate("joinworktime");
        BigDecimal adjustworktime = perserDy.getBigDecimal("adjustworkage");
        return HRPerserlenHelper.getSocialWorkage(joinworktime, adjustworktime);
    }

    public static BigDecimal getSocialWorkage(Date joinWorktime, BigDecimal adjustworkage) {
        if (joinWorktime == null) {
            LOGGER.error("==joinWorktime is null==");
            return BigDecimal.ZERO;
        }
        if (adjustworkage == null) {
            adjustworkage = BigDecimal.ZERO;
        }
        return adjustworkage.add(HRPerserlenHelper.calcYearsDiff(new Date(), joinWorktime));
    }
}

