/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.servicehelper;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MQFactory;
import kd.bos.mq.MessagePublisher;
import kd.bos.mq.config.QueueDef;
import kd.bos.mq.support.dynamic.DynamicQueueManager;
import kd.bos.mq.support.dynamic.DynamicQueueManagerFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.cache.HRAppCache;
import kd.hr.hbp.common.cache.IHRAppCache;
import kd.hr.hbp.common.mservice.HRMSendMsgResult;
import kd.hr.hbp.common.util.HRBaseUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class HRProducerServiceHelper {
    private static final Log LOGGER = LogFactory.getLog(HRProducerServiceHelper.class);
    public static final Map<String, String> META_FIELD_MAPPING = Maps.newHashMapWithExpectedSize((int)16);
    private static final Map<String, Class> CLASS_CHECK_MAP = Maps.newHashMapWithExpectedSize((int)16);
    private static final Map<String, Integer> LENGTH_CHECK_MAP = Maps.newHashMapWithExpectedSize((int)16);
    private static final IHRAppCache CACHE = HRAppCache.get((String)"hbp");
    private static final int SEND_MSG_MAX = 500;
    private static final int QUERY_MSG_STATUS_MAX = 500;
    private static final String lockKeyPre = "hr_hbp_msgcenter_";
    private static final HRBaseServiceHelper MSG_TPL_HELPER = new HRBaseServiceHelper("hbp_msgcenterinputtpl");

    public static HRMSendMsgResult publishAction(List<Map<String, Object>> actionInfoList) {
        HRMSendMsgResult result = new HRMSendMsgResult();
        if (actionInfoList == null || actionInfoList.size() == 0) {
            result.setErrorResult(Boolean.FALSE, "3", ResManager.loadKDString((String)"\u6d3b\u52a8\u4fe1\u606f\u5217\u8868\u4e3a\u7a7a\uff0c\u8bf7\u4f20\u5165\u6d3b\u52a8\u4fe1\u606f\u5217\u8868\u3002", (String)"HRProducerServiceHelper_5", (String)"hrmp-hbp-business", (Object[])new Object[0]));
            return result;
        }
        result.setTotalCnt(actionInfoList.size());
        if (actionInfoList.size() > 500) {
            result.setResult(Boolean.FALSE, "3", 0, actionInfoList.size(), String.format(Locale.ROOT, ResManager.loadKDString((String)"\u53d1\u9001\u4fe1\u606f\u8d85\u8fc7\u6700\u5927\u6570%1$s\uff0c\u8bf7\u62c6\u5206\u540e\u91cd\u8bd5\u3002", (String)"HRProducerServiceHelper_6", (String)"hrmp-hbp-business", (Object[])new Object[0]), 500));
            return result;
        }
        List<Map<String, Object>> validateList = HRProducerServiceHelper.validateActionList(actionInfoList);
        if (validateList.size() > 0) {
            result.setReturnData(validateList);
            result.setResult(Boolean.FALSE, "3", 0, actionInfoList.size(), ResManager.loadKDString((String)"\u6d88\u606f\u672a\u53d1\u9001\uff0c\u8bf7\u68c0\u67e5\u53d1\u9001\u4fe1\u606f\u7684\u6570\u636e\u5408\u6cd5\u6027\u3002", (String)"HRProducerServiceHelper_7", (String)"hrmp-hbp-business", (Object[])new Object[0]));
            return result;
        }
        HRProducerServiceHelper.publishActionList(actionInfoList, result);
        return result;
    }

    private static void publishActionList(List<Map<String, Object>> actionInfoList, HRMSendMsgResult result) {
        ArrayList publishResultList = new ArrayList(10);
        int failedCnt = 0;
        int successedCnt = 0;
        for (Map<String, Object> actionInfo : actionInfoList) {
            HashMap<String, Object> resultInfo = new HashMap<String, Object>(16);
            resultInfo.put("msgNumber", actionInfo.get("msgNumber"));
            resultInfo.put("actionId", actionInfo.get("actionId"));
            try {
                Map<String, Object> messageInfo = HRProducerServiceHelper.getMessage(actionInfo);
                HRProducerServiceHelper.publishMsgToQueue(messageInfo, false);
                resultInfo.put("isSuccess", 1);
                ++successedCnt;
                LOGGER.info("send_msg_success_msgNumber={}", messageInfo.get("msgNumber"));
            }
            catch (Exception exp) {
                resultInfo.put("isSuccess", 0);
                resultInfo.put("errMsg", exp.getMessage());
                ++failedCnt;
            }
            publishResultList.add(resultInfo);
        }
        result.setResult(Boolean.valueOf(successedCnt > 0), HRProducerServiceHelper.getPublishReturnCode(successedCnt, failedCnt), successedCnt, failedCnt, "");
        result.setReturnData(publishResultList);
    }

    private static final String getPublishReturnCode(int successedCnt, int failedCnt) {
        if (successedCnt > 0 && failedCnt == 0) {
            return "1";
        }
        if (successedCnt == 0 && failedCnt > 0) {
            return "3";
        }
        return "2";
    }

    private static List<Map<String, Object>> validateActionList(List<Map<String, Object>> actionInfoList) {
        List resultList;
        HashMap<String, Object> resultInfo;
        ArrayList<Map<String, Object>> validateResultList = new ArrayList<Map<String, Object>>(10);
        ArrayList msgPkList = new ArrayList(10);
        HashSet<String> msgPkSet = new HashSet<String>(16);
        for (Map<String, Object> actionInfo : actionInfoList) {
            try {
                HRProducerServiceHelper.validateAction(actionInfo, Boolean.FALSE);
                String msgPk = actionInfo.get("msgNumber") + ";" + actionInfo.get("actionId");
                if (msgPkSet.contains(msgPk)) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u6d3b\u52a8\u4e0b\u5df2\u5b58\u5728\u76f8\u540c\u7f16\u53f7\u7684\u6d88\u606f\u3002", (String)"HRProducerServiceHelper_2", (String)"hrmp-hbp-business", (Object[])new Object[0]));
                }
                if (validateResultList.size() != 0) continue;
                HashMap<String, Object> pkFields = new HashMap<String, Object>(16);
                pkFields.put("msgNumber", actionInfo.get("msgNumber"));
                pkFields.put("actionId", actionInfo.get("actionId"));
                msgPkList.add(pkFields);
                msgPkSet.add(msgPk);
            }
            catch (Exception exp) {
                resultInfo = new HashMap<String, Object>(16);
                resultInfo.put("msgNumber", actionInfo == null ? "" : actionInfo.get("msgNumber"));
                resultInfo.put("actionId", actionInfo == null ? "" : actionInfo.get("actionId"));
                resultInfo.put("isSuccess", 0);
                resultInfo.put("errMsg", exp.getMessage());
                validateResultList.add(resultInfo);
            }
        }
        if (validateResultList.size() == 0 && msgPkList.size() > 0 && (resultList = (List)HRMServiceHelper.invokeBizService("hrmp", "hrcs", "IHRCSMsgService", "getMsgCenterListInfo", msgPkList)) != null) {
            for (Map itemMap : resultList) {
                resultInfo = new HashMap(16);
                resultInfo.put("msgNumber", itemMap.get("msgNumber"));
                resultInfo.put("actionId", itemMap.get("actionId"));
                resultInfo.put("isSuccess", 0);
                resultInfo.put("errMsg", ResManager.loadKDString((String)"\u8be5\u6d3b\u52a8\u4e0b\u5df2\u5b58\u5728\u76f8\u540c\u7f16\u53f7\u7684\u6d88\u606f\u3002", (String)"HRProducerServiceHelper_2", (String)"hrmp-hbp-business", (Object[])new Object[0]));
                validateResultList.add(resultInfo);
            }
        }
        return validateResultList;
    }

    public static void publishAction(Map<String, Object> actionInfo) {
        HRProducerServiceHelper.validateAction(actionInfo);
        Map<String, Object> messageInfo = HRProducerServiceHelper.getMessage(actionInfo);
        HRProducerServiceHelper.publishMsgToQueue(messageInfo, false);
        LOGGER.info("send_msg_success_msgNumber={}", messageInfo.get("msgNumber"));
    }

    private static String cacheMsgKey(Map<String, Object> actionInfo) {
        String msgKeyStr;
        Object actionId;
        StringBuilder msgKey = new StringBuilder(lockKeyPre);
        Object msgNumber = actionInfo.get("msgNumber");
        if (Objects.nonNull(msgNumber)) {
            msgKey.append(msgNumber);
        }
        if (Objects.nonNull(actionId = actionInfo.get("actionId"))) {
            msgKey.append(actionId);
        }
        if (StringUtils.isNotEmpty((CharSequence)((CharSequence)CACHE.get(msgKeyStr = msgKey.toString(), String.class)))) {
            LOGGER.error("publish_message_cacheMsgKey_isDuplicate ,msgKeyStr:{}", (Object)msgKeyStr);
            throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u6d3b\u52a8\u4e0b\u5df2\u5b58\u5728\u76f8\u540c\u7f16\u53f7\u7684\u6d88\u606f\u3002", (String)"HRProducerServiceHelper_2", (String)"hrmp-hbp-business", (Object[])new Object[0]));
        }
        CACHE.put(msgKeyStr, (Object)msgKeyStr);
        return msgKeyStr;
    }

    public static void publishActionIndbtrans(Map<String, Object> actionInfo, boolean indbtrans) {
        HRProducerServiceHelper.validateAction(actionInfo);
        Map<String, Object> messageInfo = HRProducerServiceHelper.getMessage(actionInfo);
        HRProducerServiceHelper.publishMsgToQueue(messageInfo, indbtrans);
        LOGGER.info("send_msg_success_msgNumber={}", messageInfo.get("msgNumber"));
    }

    private static void validateAction(Map<String, Object> actionInfo, Boolean isCheckDuplicate) {
        HRProducerServiceHelper.validateIsNull(actionInfo, "msgNumber", "msgTitle", "msgPubNo", "senderId", "sendTime", "actionId");
        HRProducerServiceHelper.validateValueType(CLASS_CHECK_MAP, actionInfo);
        HRProducerServiceHelper.validateLength(LENGTH_CHECK_MAP, actionInfo);
        if (isCheckDuplicate.booleanValue()) {
            HRProducerServiceHelper.validateIsDuplicate(actionInfo, "msgNumber", "actionId");
        }
    }

    private static void validateAction(Map<String, Object> actionInfo) {
        HRProducerServiceHelper.validateAction(actionInfo, Boolean.TRUE);
    }

    private static Map<String, Object> getMessage(Map<String, Object> actionInfo) {
        HashMap messageMap = Maps.newHashMapWithExpectedSize((int)16);
        messageMap.put("msgNumber", actionInfo.get("msgNumber"));
        messageMap.put("groupNumber", actionInfo.get("groupNumber"));
        messageMap.put("groupSeq", actionInfo.get("groupSeq"));
        messageMap.put("groupCount", actionInfo.get("groupCount"));
        messageMap.put("msgTitle", actionInfo.get("msgTitle"));
        messageMap.put("msgDesc", actionInfo.get("msgDesc"));
        messageMap.put("actionId", actionInfo.get("actionId"));
        messageMap.put("msgTag", actionInfo.get("msgTag"));
        messageMap.put("senderId", actionInfo.get("senderId"));
        messageMap.put("sendTime", actionInfo.get("sendTime"));
        messageMap.put("params", actionInfo.get("params"));
        String msgPubNo = (String)actionInfo.get("msgPubNo");
        messageMap.put("msgPubNo", msgPubNo);
        Map<String, Object> pubAndSubInfo = HRProducerServiceHelper.getSimplePubAndSubInfo(msgPubNo);
        long msgPublisherId = (Long)pubAndSubInfo.get("msgPublisherId");
        messageMap.put("msgPublisherId", msgPublisherId);
        messageMap.put("msgProBo", pubAndSubInfo.get("msgProBo"));
        messageMap.put("msgCloud", pubAndSubInfo.get("msgCloud"));
        messageMap.put("msgApp", pubAndSubInfo.get("msgApp"));
        messageMap.put("msgBusinessType", pubAndSubInfo.get("msgBusinessType"));
        messageMap.put("pubEr", pubAndSubInfo.get("pubEr"));
        List subInfoList = (List)pubAndSubInfo.get("subInfoList");
        messageMap.put("subInfoList", subInfoList);
        return messageMap;
    }

    private static Map<String, Object> getSimplePubAndSubInfo(String msgPubNo) {
        return (Map)HRMServiceHelper.invokeBizService("hrmp", "hrcs", "IHRCSMsgService", "getSimplePubAndSubInfo", msgPubNo);
    }

    private static void publishMsgToQueue(Map<String, Object> messageInfo, boolean indbtrans) {
        if (ObjectUtils.isNotEmpty((Object)messageInfo.get("groupNumber"))) {
            HRProducerServiceHelper.publishHRMPQueue("kd.hr.service.message.sequentialm_queue", messageInfo, indbtrans);
        } else {
            HRProducerServiceHelper.publishHRMPQueue("kd.hr.service.message.hrdefalult_queue", messageInfo, indbtrans);
        }
    }

    public static void publishHRMPQueue(String queue, Object message, boolean indbtrans) {
        HRProducerServiceHelper.publishIndbtrans("hrmp", queue, message, indbtrans);
    }

    public static void publishHRQueue(String queue, Object message) {
        HRProducerServiceHelper.publish("hr", queue, message);
    }

    public static void publishHRQueueIndbtrans(String queue, Object message, boolean indbtrans) {
        HRProducerServiceHelper.publishIndbtrans("hr", queue, message, indbtrans);
    }

    public static void publishIndbtrans(String region, String queue, Object messageMap, boolean indbtrans) {
        HRProducerServiceHelper.createDynamicQueue(region, queue);
        try (MessagePublisher messagePublisher = MQFactory.get().createSimplePublisher(region, queue);){
            if (indbtrans) {
                messagePublisher.publishInDbTranscation(messageMap);
            } else {
                messagePublisher.publish(messageMap);
            }
        }
    }

    public static void publishDynamicQueue(String region, String queue, Object messageMap) {
        HRProducerServiceHelper.createDynamicQueue(region, queue);
        try (MessagePublisher messagePublisher = MQFactory.get().createSimplePublisher(region, queue);){
            messagePublisher.publish(messageMap);
        }
    }

    private static void createDynamicQueue(String region, String queue) {
        DynamicQueueManager dynamicQueueManager = DynamicQueueManagerFactory.get((String)region);
        QueueDef queueDef = dynamicQueueManager.getQueueDef(queue);
        if (null == queueDef) {
            QueueDef queueDefNew = new QueueDef();
            queueDefNew.setName(queue);
            dynamicQueueManager.add(queueDefNew, false);
        }
    }

    public static void publish(String region, String queue, Object messageMap) {
        try (MessagePublisher messagePublisher = MQFactory.get().createSimplePublisher(region, queue);){
            messagePublisher.publish(messageMap);
        }
    }

    public static void publish(String queue, String message) {
        HRProducerServiceHelper.publish("hr", queue, message);
    }

    public static void publish(String region, String queue, String message) {
        try (MessagePublisher messagePublisher = MQFactory.get().createSimplePublisher(region, queue);){
            messagePublisher.publish(message);
        }
    }

    private static void validateIsNull(Map<String, Object> actionInfo, String ... keys) {
        if (Objects.isNull(actionInfo)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53c2\u6570\u5b9e\u4f8b\u5bf9\u8c61\u4e3a\u7a7a\u3002", (String)"HRProducerServiceHelper_0", (String)"hrmp-hbp-business", (Object[])new Object[0]));
        }
        if (Objects.isNull(keys)) {
            return;
        }
        StringBuilder nullKeys = new StringBuilder();
        for (String key : keys) {
            Object value = actionInfo.get(key);
            if (!Objects.isNull(value)) continue;
            if (ObjectUtils.isNotEmpty((Object)nullKeys)) {
                nullKeys.append(",");
            }
            nullKeys.append(key);
        }
        if (ObjectUtils.isNotEmpty((Object)nullKeys)) {
            throw new KDBizException(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u8bf7\u586b\u5199%1$s\u3002", (String)"HRProducerServiceHelper_1", (String)"hrmp-hbp-business", (Object[])new Object[0]), nullKeys));
        }
    }

    private static void validateIsDuplicate(Map<String, Object> actionInfo, String ... keys) {
        boolean result;
        if (Objects.isNull(keys)) {
            return;
        }
        ArrayList<QFilter> filters = new ArrayList<QFilter>(keys.length);
        for (String key : keys) {
            String dyKey;
            Object value = actionInfo.get(key);
            if (!Objects.nonNull(value) || !HRStringUtils.isNotEmpty((String)(dyKey = META_FIELD_MAPPING.get(key)))) continue;
            filters.add(new QFilter(dyKey, "=", value));
        }
        if (!filters.isEmpty() && (result = ((Boolean)HRMServiceHelper.invokeBizService("hrmp", "hrcs", "IHRCSMsgService", "validateMsgIsDuplicate", new Object[]{filters.toArray(new QFilter[0])})).booleanValue())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u6d3b\u52a8\u4e0b\u5df2\u5b58\u5728\u76f8\u540c\u7f16\u53f7\u7684\u6d88\u606f\u3002", (String)"HRProducerServiceHelper_2", (String)"hrmp-hbp-business", (Object[])new Object[0]));
        }
    }

    private static void validateValueType(Map<String, Class> valueKeyClassMap, Map<String, Object> valueMap) {
        if (Objects.isNull(valueKeyClassMap) || Objects.isNull(valueMap)) {
            return;
        }
        for (Map.Entry<String, Class> entry : valueKeyClassMap.entrySet()) {
            String key = entry.getKey();
            Class clazz = entry.getValue();
            Object value = valueMap.get(key);
            if (Objects.isNull(value) || Objects.isNull(clazz) || clazz.isInstance(value)) continue;
            throw new KDBizException(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5b57\u6bb5%1$s\u5bf9\u5e94\u7684\u503c\u7c7b\u578b\u9519\u8bef,\u9700\u8981\u7684\u503c\u7c7b\u578b\u4e3a%2$s\u3002", (String)"HRProducerServiceHelper_3", (String)"hrmp-hbp-business", (Object[])new Object[0]), key, clazz.getSimpleName()));
        }
    }

    private static void validateLength(Map<String, Integer> valueKeyLengthMap, Map<String, Object> valueMap) {
        if (Objects.isNull(valueKeyLengthMap) || Objects.isNull(valueMap)) {
            return;
        }
        for (Map.Entry<String, Integer> entry : valueKeyLengthMap.entrySet()) {
            String key = entry.getKey();
            Integer length = entry.getValue();
            Object value = valueMap.get(key);
            if (Objects.isNull(value) || Objects.isNull(length) || String.valueOf(value).length() <= length) continue;
            throw new KDBizException(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5b57\u6bb5%1$s\u5bf9\u5e94\u7684\u503c\u8d85\u8fc7\u9650\u5236\u957f\u5ea6%2$s\u3002", (String)"HRProducerServiceHelper_4", (String)"hrmp-hbp-business", (Object[])new Object[0]), key, length));
        }
    }

    public static DynamicObject buildMsgDyObj(Map<String, Object> tempMap, Map<String, String> subInfo) {
        DynamicObject dy = MSG_TPL_HELPER.generateEmptyDynamicObject();
        Long msgCenterId = (Long)tempMap.get("msgCenterId");
        String msgNumber = (String)tempMap.get("msgNumber");
        String msgTitle = (String)tempMap.get("msgTitle");
        String msgDesc = (String)tempMap.get("msgDesc");
        Long actionId = (Long)tempMap.get("actionId");
        Long senderId = (Long)tempMap.get("senderId");
        Date sendTime = (Date)tempMap.get("sendTime");
        Long msgProBo = (Long)tempMap.get("msgProBo");
        String params = (String)tempMap.get("params");
        Object msgCloud = tempMap.get("msgCloud");
        Object msgApp = tempMap.get("msgApp");
        Object msgBusinessType = tempMap.get("msgBusinessType");
        dy.set("number", (Object)msgNumber);
        dy.set("name", (Object)msgTitle);
        dy.set("status", (Object)"C");
        dy.set("enable", (Object)"1");
        dy.set("description", (Object)msgDesc);
        dy.set("index", (Object)0);
        dy.set("issyspreset", (Object)0);
        dy.set("msgcloud", msgCloud);
        dy.set("msgapp", msgApp);
        dy.set("msgsubno", (Object)subInfo.get("msgSubNo"));
        dy.set("msgbusinesstype", msgBusinessType);
        dy.set("msgaction", (Object)actionId);
        dy.set("sender", (Object)senderId);
        dy.set("sendtime", (Object)sendTime);
        dy.set("msgbo", (Object)msgProBo);
        dy.set("msgcontent", (Object)params);
        dy.set("msgcenterbo", (Object)msgCenterId);
        if (ObjectUtils.isNotEmpty((Object)tempMap.get("groupNumber"))) {
            dy.set("groupnum", tempMap.get("groupNumber"));
        }
        if (ObjectUtils.isNotEmpty((Object)tempMap.get("groupSeq"))) {
            dy.set("groupseq", tempMap.get("groupSeq"));
        }
        if (ObjectUtils.isNotEmpty((Object)tempMap.get("groupCount"))) {
            dy.set("groupcount", tempMap.get("groupCount"));
        }
        HRBaseUtils.setSysField((DynamicObject)dy);
        return dy;
    }

    static {
        META_FIELD_MAPPING.put("msgNumber", "number");
        META_FIELD_MAPPING.put("actionId", "action");
        CLASS_CHECK_MAP.put("msgNumber", String.class);
        CLASS_CHECK_MAP.put("msgTitle", String.class);
        CLASS_CHECK_MAP.put("msgDesc", String.class);
        CLASS_CHECK_MAP.put("actionId", Long.class);
        CLASS_CHECK_MAP.put("msgTag", String.class);
        CLASS_CHECK_MAP.put("senderId", Long.class);
        CLASS_CHECK_MAP.put("sendTime", Date.class);
        CLASS_CHECK_MAP.put("params", String.class);
        CLASS_CHECK_MAP.put("msgPubNo", String.class);
        LENGTH_CHECK_MAP.put("msgNumber", 60);
        LENGTH_CHECK_MAP.put("msgTitle", 100);
        LENGTH_CHECK_MAP.put("msgDesc", 255);
        LENGTH_CHECK_MAP.put("msgTag", 100);
    }
}

