/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.servicehelper;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.list.JoinEntity;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.impl.ORMUtil;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.service.query.es.EsListDataProvider;
import kd.hr.hbp.business.service.query.ksql.KsqlConfig;
import kd.hr.hbp.business.service.query.ksql.KsqlListDataProvider;
import kd.hr.hbp.business.service.query.util.DataSetUtil;
import kd.hr.hbp.business.service.query.util.ListProviderDynamicObjCollectionUtil;
import kd.hr.hbp.business.servicehelper.EntityReleaseInfoService;
import kd.hr.hbp.common.enums.query.EnumQueryEntityDatasourceType;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.common.util.QueryEntityTypeUtil;
import kd.sdk.annotation.SdkInternal;
import kd.sdk.annotation.SdkPublic;
import org.apache.commons.lang3.StringUtils;

@SdkPublic
public class HRQueryEntityHelper {
    private static final Log LOGGER = LogFactory.getLog(ListProviderDynamicObjCollectionUtil.class);
    private static final HRQueryEntityHelper INSTANCE = new HRQueryEntityHelper();
    private static final String FIELD_DATASOURCETYPE = "datasourcetype";
    private static final String FIELD_KSQLQUERYTYPE = "ksqlquerytype";
    private static final String FIELD_KSQLUSEUNION = "ksqluseunion";
    static ThreadLocal<QueryEntityParamInfo> currentRequestParam = new ThreadLocal();

    private HRQueryEntityHelper() {
    }

    public static HRQueryEntityHelper getInstance() {
        return INSTANCE;
    }

    public DynamicObjectCollection getQueryDyoColl(QueryEntityType queryEntityType, String queryFileds, QFilter[] qFilters, String orderBys) {
        return this.getQueryDyoColl(queryEntityType, queryFileds, qFilters, orderBys, false, 0, 0);
    }

    public DynamicObjectCollection getQueryDyoColl(QueryEntityType queryEntityType, String queryFileds, QFilter[] qFilters, String orderBys, int start, int limit) {
        return this.getQueryDyoColl(queryEntityType, queryFileds, qFilters, orderBys, true, start, limit);
    }

    @SdkInternal
    public DynamicObjectCollection getQueryDyoColl(QueryEntityType queryEntityType, String queryFileds, QFilter[] qFilters, String orderBys, boolean isLimitCount, int start, int limit, Map<String, List<QFilter>> relationMap) {
        queryFileds = this.addQueryPkFileds(queryEntityType, queryFileds);
        QueryEntityTypeUtil queryEntityUtil = new QueryEntityTypeUtil(queryEntityType, queryFileds, true);
        DynamicObjectType returnType = queryEntityUtil.genDynamicObjectType();
        return this.getQueryDyoColl(queryEntityType, returnType, queryFileds, qFilters, orderBys, isLimitCount, start, limit, relationMap);
    }

    @SdkInternal
    public DynamicObjectCollection getQueryDyoColl(QueryEntityType queryEntityType, String queryFileds, QFilter[] qFilters, String orderBys, boolean isLimitCount, int start, int limit) {
        return this.getQueryDyoColl(queryEntityType, queryFileds, qFilters, orderBys, isLimitCount, start, limit, null);
    }

    @SdkInternal
    public DynamicObjectCollection getQueryDyoColl(QueryEntityType queryEntityType, DynamicObjectType returnType, String queryFileds, QFilter[] qFilters, String orderBys, boolean isLimitCount, int start, int limit) {
        return this.getQueryDyoColl(queryEntityType, returnType, queryFileds, qFilters, orderBys, isLimitCount, start, limit, null);
    }

    @SdkInternal
    public DynamicObjectCollection getQueryDyoColl(QueryEntityType queryEntityType, DynamicObjectType returnType, String queryFileds, QFilter[] qFilters, String orderBys, boolean isLimitCount, int start, int limit, Map<String, List<QFilter>> relationMap) {
        DynamicObjectCollection dyoColl;
        String[] listFields;
        for (String listField : listFields = queryFileds.split(",")) {
            if (returnType.getProperty(listField) != null) continue;
            LOGGER.error("queryEntityType:{} returnType not exists {}", (Object)queryEntityType.getName(), (Object)listField);
        }
        LOGGER.info("queryentitynumber: {} queryFileds:{}", (Object)queryEntityType.getName(), (Object)queryFileds);
        Map<String, Object> confMap = this.queryEntityReleaseInfo(queryEntityType.getName());
        String dataSourceTypeStr = "ALGO";
        String datasourcetype = (String)confMap.get(FIELD_DATASOURCETYPE);
        if (HRStringUtils.isNotEmpty((String)datasourcetype)) {
            dataSourceTypeStr = datasourcetype;
        }
        if (HRStringUtils.equals((String)EnumQueryEntityDatasourceType.ES.getType(), (String)dataSourceTypeStr)) {
            dyoColl = this.getESQueryDynamicObjectCollection(queryEntityType, returnType, queryFileds, qFilters, orderBys, isLimitCount, start, limit);
        } else if (HRStringUtils.equals((String)EnumQueryEntityDatasourceType.KSQL.getType(), (String)dataSourceTypeStr)) {
            String ksqlQueryType = (String)confMap.get(FIELD_KSQLQUERYTYPE);
            boolean ksqlUseUnion = (Boolean)confMap.get(FIELD_KSQLUSEUNION);
            dyoColl = this.getKSqlQueryDynamicObjectCollection(queryEntityType, returnType, queryFileds, qFilters, orderBys, isLimitCount, start, limit, ksqlQueryType, ksqlUseUnion, relationMap);
        } else {
            try (DataSet dataSet = queryEntityType.getQueryDataSet(queryFileds, qFilters, orderBys, isLimitCount, start, limit);){
                RowMeta rowMeta = dataSet.getRowMeta();
                Iterator iter = dataSet.iterator();
                dyoColl = ORMUtil.toDynamicObjectCollection((Iterator)iter, (RowMeta)rowMeta, (String)queryEntityType.getEntityName());
            }
        }
        return dyoColl;
    }

    @SdkInternal
    public DataSet getQueryDataSet(QueryEntityType queryEntityType, String queryFileds, QFilter[] qFilters, String orderBys, Map<String, List<QFilter>> relationMap) {
        return this.getQueryDataSet(queryEntityType, queryFileds, qFilters, orderBys, false, 0, 0, relationMap);
    }

    public DataSet getQueryDataSet(QueryEntityType queryEntityType, String queryFileds, QFilter[] qFilters, String orderBys) {
        return this.getQueryDataSet(queryEntityType, queryFileds, qFilters, orderBys, false, 0, 0, null);
    }

    public DataSet getQueryDataSet(QueryEntityType queryEntityType, String queryFileds, QFilter[] qFilters, String orderBys, int start, int limit) {
        return this.getQueryDataSet(queryEntityType, queryFileds, qFilters, orderBys, true, start, limit);
    }

    @SdkInternal
    public DataSet getQueryDataSet(QueryEntityType queryEntityType, String queryFileds, QFilter[] qFilters, String orderBys, boolean isLimitCount, int start, int limit) {
        return this.getQueryDataSet(queryEntityType, queryFileds, qFilters, orderBys, isLimitCount, start, limit, null);
    }

    @SdkInternal
    public DataSet getQueryDataSet(QueryEntityType queryEntityType, String queryFileds, QFilter[] qFilters, String orderBys, boolean isLimitCount, int start, int limit, Map<String, List<QFilter>> relationMap) {
        DataSet dataSet;
        Map<String, Object> confMap = this.queryEntityReleaseInfo(queryEntityType.getName());
        String dataSourceTypeStr = "ALGO";
        String datasourcetype = (String)confMap.get(FIELD_DATASOURCETYPE);
        if (HRStringUtils.isNotEmpty((String)datasourcetype)) {
            dataSourceTypeStr = datasourcetype;
        }
        if (HRStringUtils.equals((String)EnumQueryEntityDatasourceType.ES.getType(), (String)dataSourceTypeStr) || HRStringUtils.equals((String)EnumQueryEntityDatasourceType.KSQL.getType(), (String)dataSourceTypeStr)) {
            DynamicObjectCollection dyoColl = this.getQueryDyoColl(queryEntityType, queryFileds, qFilters, orderBys, isLimitCount, start, limit, relationMap);
            dataSet = DataSetUtil.convertToDataSet(queryEntityType, queryFileds, dyoColl);
        } else {
            dataSet = queryEntityType.getQueryDataSet(queryFileds, qFilters, orderBys, isLimitCount, start, limit);
        }
        return dataSet;
    }

    public List<Object> queryAllPkByKSql(QueryEntityType queryEntityType, QFilter[] qFilters, String orderBys, int start, int limit) {
        return this.queryAllPkByKSql(queryEntityType, qFilters, orderBys, start, limit, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternal
    public List<Object> queryAllPkByKSql(QueryEntityType queryEntityType, QFilter[] qFilters, String orderBys, int start, int limit, Map<String, List<QFilter>> relationMap) {
        Map<String, Object> confMap = this.queryEntityReleaseInfo(queryEntityType.getName());
        String dataSourceTypeStr = "ALGO";
        String datasourcetype = (String)confMap.get(FIELD_DATASOURCETYPE);
        if (HRStringUtils.isNotEmpty((String)datasourcetype)) {
            dataSourceTypeStr = datasourcetype;
        }
        List<Object> pkIds = null;
        if (HRStringUtils.equals((String)EnumQueryEntityDatasourceType.KSQL.getType(), (String)dataSourceTypeStr)) {
            String ksqlQueryType = (String)confMap.get(FIELD_KSQLQUERYTYPE);
            boolean ksqlUseUnion = (Boolean)confMap.get(FIELD_KSQLUSEUNION);
            String cacheKey = queryEntityType.getName() + UUID.randomUUID().toString().substring(1, 26);
            String queryType = "FULLSQL";
            if (HRStringUtils.equals((String)ksqlQueryType, (String)"IDQUERY")) {
                queryType = "PKSQL";
            }
            KsqlListDataProvider ksqlListDataProvider = new KsqlListDataProvider(new KsqlConfig(), "hbp", cacheKey, queryType, (Boolean)ksqlUseUnion);
            pkIds = ksqlListDataProvider.queryAllPk(queryEntityType, qFilters, orderBys, start, limit, relationMap);
        } else {
            try (DataSet dataSet = null;){
                dataSet = queryEntityType.getQueryDataSet("id", qFilters, orderBys);
                if (dataSet != null) {
                    pkIds = Lists.newArrayListWithExpectedSize((int)16);
                    while (dataSet.hasNext()) {
                        Row next = dataSet.next();
                        pkIds.add(next.getLong("id"));
                    }
                }
            }
        }
        return pkIds;
    }

    @SdkInternal
    public List<Object> queryAllPkByKSql(QueryEntityType queryEntityType, QFilter[] qFilters, String orderBys, Map<String, List<QFilter>> relationMap) {
        return this.queryAllPkByKSql(queryEntityType, qFilters, orderBys, 0, -1, relationMap);
    }

    public List<Object> queryAllPkByKSql(QueryEntityType queryEntityType, QFilter[] qFilters, String orderBys) {
        return this.queryAllPkByKSql(queryEntityType, qFilters, orderBys, null);
    }

    private String addQueryPkFileds(QueryEntityType queryEntityType, String queryFileds) {
        String mainEntityPk;
        String[] listFields = queryFileds.split(",");
        ArrayList<String> listFileds = new ArrayList<String>(Arrays.asList(listFields));
        if (!listFileds.contains(mainEntityPk = queryEntityType.getPrimaryKey().getName())) {
            listFileds.add(mainEntityPk);
        }
        for (JoinEntity joinEntity : queryEntityType.getJoinEntitys()) {
            String joinEntityNum = joinEntity.getEntityName();
            ISimpleProperty primaryKey = EntityMetadataCache.getDataEntityType((String)joinEntityNum).getPrimaryKey();
            String joinPkField = joinEntityNum + "." + primaryKey.getName();
            if (listFileds.contains(joinPkField)) continue;
            listFileds.add(joinPkField);
        }
        return StringUtils.join(listFileds, (String)",");
    }

    @SdkInternal
    public Map<String, Object> queryEntityReleaseInfo(String queryEntityName) {
        HashMap confMap = Maps.newHashMapWithExpectedSize((int)3);
        DynamicObject entityReleaseInfo = EntityReleaseInfoService.getEntityReleaseInfoByName(queryEntityName);
        if (Objects.isNull(entityReleaseInfo)) {
            return confMap;
        }
        confMap.put(FIELD_DATASOURCETYPE, entityReleaseInfo.getString(FIELD_DATASOURCETYPE));
        confMap.put(FIELD_KSQLQUERYTYPE, entityReleaseInfo.getString(FIELD_KSQLQUERYTYPE));
        confMap.put(FIELD_KSQLUSEUNION, entityReleaseInfo.getBoolean(FIELD_KSQLUSEUNION));
        return confMap;
    }

    private DynamicObjectCollection getKSqlQueryDynamicObjectCollection(QueryEntityType queryEntityType, DynamicObjectType returnType, String queryFileds, QFilter[] qFilters, String orderBys, boolean isLimitCount, int start, int limit, String ksqlQueryType, boolean ksqlUseUnion, Map<String, List<QFilter>> relationMap) {
        String cacheKey = queryEntityType.getName() + UUID.randomUUID().toString().substring(1, 26);
        String queryType = "FULLSQL";
        if (HRStringUtils.equals((String)ksqlQueryType, (String)"IDQUERY")) {
            queryType = "PKSQL";
        }
        KsqlListDataProvider ksqlListDataProvider = new KsqlListDataProvider(new KsqlConfig(), "hbp", cacheKey, queryType, (Boolean)ksqlUseUnion);
        LOGGER.info("query param:[queryFileds:{},orderBys:{},isLimitCount:{},start:{},limit:{},queryType:{}]", new Object[]{queryFileds, orderBys, isLimitCount, start, limit, queryType});
        return ksqlListDataProvider.queryDynamicObjectCollection(queryEntityType, returnType, queryFileds, qFilters, orderBys, isLimitCount, start, limit, relationMap);
    }

    private DynamicObjectCollection getESQueryDynamicObjectCollection(QueryEntityType queryEntityType, DynamicObjectType returnType, String queryFileds, QFilter[] qFilters, String orderBys, boolean isLimitCount, int start, int limit) {
        String cacheKey = queryEntityType.getName() + UUID.randomUUID().toString().substring(1, 26);
        EsListDataProvider esListDataProvider = new EsListDataProvider(cacheKey);
        return esListDataProvider.queryDynamicObjectCollection(queryEntityType, returnType, queryFileds, qFilters, orderBys, isLimitCount, start, limit);
    }

    public static void setCurrentRequestParam(QueryEntityParamInfo queryEntityParamInfo) {
        currentRequestParam.set(queryEntityParamInfo);
    }

    public static QueryEntityParamInfo getCurrentRequestParam() {
        if (currentRequestParam.get() == null) {
            QueryEntityParamInfo queryEntityParamInfo = new QueryEntityParamInfo();
            currentRequestParam.set(queryEntityParamInfo);
        }
        return currentRequestParam.get();
    }

    public static class QueryEntityParamInfo {
        boolean mulBaseDataCollectionToString;

        public boolean isMulBaseDataCollectionToString() {
            return this.mulBaseDataCollectionToString;
        }

        public void setMulBaseDataCollectionToString(boolean mulBaseDataCollectionToString) {
            this.mulBaseDataCollectionToString = mulBaseDataCollectionToString;
        }
    }
}

