/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.virtulentity;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.hr.hbp.business.service.complexobj.model.OrderField;
import kd.hr.hbp.business.service.complexobj.util.AlgoDataTypeTransUtil;
import kd.hr.hbp.business.virtulentity.IVirtualEntityService;
import kd.hr.hbp.business.virtulentity.VirtualConfigInfo;
import kd.hr.hbp.common.model.complexobj.DataTypeEnum;
import kd.hr.hbp.common.model.virtulentity.SummaryQueryResultInfo;
import kd.hr.hbp.common.model.virtulentity.TotalRowValueInfo;
import kd.hr.hbp.common.model.virtulentity.VirtualEntityQueryParamInfo;
import kd.hr.hbp.common.model.virtulentity.VirtualFieldInfo;
import kd.hr.hbp.common.model.virtulentity.dimvalue.DimensionValueInfo;
import kd.hr.hbp.common.util.HRDateTimeUtils;

public class VirtualEntityServiceDemo
implements IVirtualEntityService {
    @Override
    public VirtualConfigInfo getVirtualConfig() {
        return null;
    }

    @Override
    public DataSet getDetailReportData(VirtualEntityQueryParamInfo queryParamInfo) {
        List selectedFieldInfoList = queryParamInfo.getSelectedFieldInfoList();
        Field[] fields = new Field[selectedFieldInfoList.size()];
        for (int i = 0; i < selectedFieldInfoList.size(); ++i) {
            VirtualFieldInfo virtualFieldInfo = (VirtualFieldInfo)selectedFieldInfoList.get(i);
            DataTypeEnum fieldValueType = virtualFieldInfo.getFieldValueType();
            String number = virtualFieldInfo.getNumber();
            fields[i] = new Field(number, AlgoDataTypeTransUtil.getDataType(fieldValueType));
        }
        RowMeta rowMeta = new RowMeta(fields);
        DataSetBuilder builder = Algo.create((String)"VirtualEntityServiceDemo").createDataSetBuilder(rowMeta);
        for (int i = 0; i < 200; ++i) {
            builder.append(this.genData(i, fields));
        }
        return builder.build();
    }

    @Override
    public List<List<DimensionValueInfo>> getSummaryReportColumnDimensionData(VirtualEntityQueryParamInfo queryParamInfo) {
        List columnDimensionList = queryParamInfo.getColumnDimensionList();
        ArrayList<List<DimensionValueInfo>> rst = new ArrayList<List<DimensionValueInfo>>(20);
        for (int i = 0; i < 200; ++i) {
            ArrayList<DimensionValueInfo> dimensionValueInfos = new ArrayList<DimensionValueInfo>(columnDimensionList.size());
            for (VirtualFieldInfo virtualFieldInfo : columnDimensionList) {
                DimensionValueInfo dimensionVal = this.getDimensionVal(i, virtualFieldInfo);
                dimensionValueInfos.add(dimensionVal);
            }
            rst.add(dimensionValueInfos);
        }
        return rst;
    }

    private DimensionValueInfo getDimensionVal(int basic, VirtualFieldInfo virtualFieldInfo) {
        DimensionValueInfo dimensionValueInfo = new DimensionValueInfo();
        DataType dataType = AlgoDataTypeTransUtil.getDataType(virtualFieldInfo.getFieldValueType());
        if (dataType.equals((Object)DataType.TimestampType)) {
            String serverTimeZone = HRDateTimeUtils.getServerTimeZone();
            dimensionValueInfo.setName(serverTimeZone);
            dimensionValueInfo.setId(serverTimeZone);
        } else if (dataType.equals((Object)DataType.StringType)) {
            String data = "test data " + basic;
            dimensionValueInfo.setName(data);
            dimensionValueInfo.setId(data);
        } else if (dataType.equals((Object)DataType.BooleanType)) {
            dimensionValueInfo.setName("true");
            dimensionValueInfo.setId("1");
        } else if (dataType.equals((Object)DataType.IntegerType)) {
            dimensionValueInfo.setName(String.valueOf(basic));
            dimensionValueInfo.setId(String.valueOf(basic));
        } else if (dataType.equals((Object)DataType.LongType)) {
            dimensionValueInfo.setName(String.valueOf(basic));
            dimensionValueInfo.setId(String.valueOf(basic));
        } else if (dataType.equals((Object)DataType.BigDecimalType)) {
            dimensionValueInfo.setName(String.valueOf(basic));
            dimensionValueInfo.setId(String.valueOf(basic));
        }
        return dimensionValueInfo;
    }

    private Object[] genData(int basic, Field[] fields) {
        Object[] row = new Object[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            DataType dataType = fields[i].getDataType();
            if (dataType.equals((Object)DataType.TimestampType)) {
                row[i] = new Date();
                continue;
            }
            if (dataType.equals((Object)DataType.StringType)) {
                row[i] = "test data " + basic;
                continue;
            }
            if (dataType.equals((Object)DataType.BooleanType)) {
                row[i] = true;
                continue;
            }
            if (dataType.equals((Object)DataType.IntegerType)) {
                row[i] = basic;
                continue;
            }
            if (dataType.equals((Object)DataType.LongType)) {
                row[i] = (long)basic;
                continue;
            }
            if (!dataType.equals((Object)DataType.BigDecimalType)) continue;
            row[i] = BigDecimal.valueOf(basic);
        }
        return row;
    }

    @Override
    public SummaryQueryResultInfo getSummaryReportData(VirtualEntityQueryParamInfo queryParamInfo) {
        List selectedFieldInfoList = queryParamInfo.getSelectedFieldInfoList();
        Field[] fields = new Field[selectedFieldInfoList.size()];
        for (int i = 0; i < selectedFieldInfoList.size(); ++i) {
            VirtualFieldInfo virtualFieldInfo = (VirtualFieldInfo)selectedFieldInfoList.get(i);
            DataTypeEnum fieldValueType = virtualFieldInfo.getFieldValueType();
            String number = virtualFieldInfo.getNumber();
            fields[i] = new Field(number, AlgoDataTypeTransUtil.getDataType(fieldValueType));
        }
        RowMeta rowMeta = new RowMeta(fields);
        DataSetBuilder builder = Algo.create((String)"VirtualEntityServiceDemo").createDataSetBuilder(rowMeta);
        for (int i = 0; i < 200; ++i) {
            builder.append(this.genData(i, fields));
        }
        DataSet dataSet = builder.build();
        SummaryQueryResultInfo summaryQueryResultInfo = new SummaryQueryResultInfo(dataSet, true);
        return summaryQueryResultInfo;
    }

    @Override
    public TotalRowValueInfo getTotalRow(VirtualEntityQueryParamInfo queryParamInfo) {
        List selectedFieldInfoList = queryParamInfo.getSelectedFieldInfoList();
        Field[] fields = new Field[selectedFieldInfoList.size()];
        for (int i = 0; i < selectedFieldInfoList.size(); ++i) {
            VirtualFieldInfo virtualFieldInfo = (VirtualFieldInfo)selectedFieldInfoList.get(i);
            DataTypeEnum fieldValueType = virtualFieldInfo.getFieldValueType();
            String number = virtualFieldInfo.getNumber();
            fields[i] = new Field(number, AlgoDataTypeTransUtil.getDataType(fieldValueType));
        }
        RowMeta rowMeta = new RowMeta(fields);
        DataSetBuilder builder = Algo.create((String)"VirtualEntityServiceDemo").createDataSetBuilder(rowMeta);
        for (int i = 0; i < 20; ++i) {
            builder.append(this.genData(i, fields));
        }
        return new TotalRowValueInfo(builder.build(), true);
    }

    @Override
    public Long getTotalCount(VirtualEntityQueryParamInfo queryParamInfo) {
        return 200L;
    }

    @Override
    public List<OrderField> getOrderFields() {
        return null;
    }
}

