/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.opplugin.validator;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;

public class HRAPISourceSaveValidator
extends AbstractValidator {
    private static final String API_TYPE_COMMON = "1";

    public void validate() {
        ExtendedDataEntity[] datas = this.getDataEntities();
        String operationKey = this.getOperateKey();
        DynamicObject dy = datas[0].getDataEntity();
        String number = dy.getString("number");
        boolean isCommonApi = API_TYPE_COMMON.equalsIgnoreCase(dy.getString("type"));
        switch (operationKey) {
            case "save": {
                if (this.regexNumberContainChan(number)) {
                    this.addFatalErrorMessage(datas[0], ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u82f1\u6587\u3001\u6570\u5b57\u6216\u7279\u6b8a\u5b57\u7b26\u3002", (String)"HRAPISourceSaveValidator_0", (String)"hrmp-hbp-opplugin", (Object[])new Object[0]));
                }
                if (isCommonApi && !this.validateCommonApiType(dy)) {
                    this.addFatalErrorMessage(datas[0], ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u4e2a\u5b9e\u4f53\u5b57\u6bb5\u4f5c\u4e3aAPI\u53c2\u6570\u3002", (String)"HRAPISourceSaveValidator_1", (String)"hrmp-hbp-opplugin", (Object[])new Object[0]));
                }
                if (!isCommonApi && !this.validateCustomApiType(dy)) {
                    this.addFatalErrorMessage(datas[0], ResManager.loadKDString((String)"\u5f53API\u7c7b\u578b\u4e3a\u81ea\u5b9a\u4e49API\u65f6\uff0c\u8bf7\u6c42\u53c2\u6570\u7684\u53c2\u6570\u7ed3\u6784\u548c\u8fd4\u56de\u53c2\u6570\u7684\u53c2\u6570\u7ed3\u6784\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"HRAPISourceSaveValidator_2", (String)"hrmp-hbp-opplugin", (Object[])new Object[0]));
                }
                if (!isCommonApi && !this.validateInputParam(dy)) {
                    this.addFatalErrorMessage(datas[0], ResManager.loadKDString((String)"\u5f53API\u7c7b\u578b\u4e3a\u81ea\u5b9a\u4e49API\u65f6\uff0c\u8bf7\u6c42\u53c2\u6570\u4e0d\u53ef\u91cd\u590d\u3002", (String)"HRAPISourceSaveValidator_3", (String)"hrmp-hbp-opplugin", (Object[])new Object[0]));
                }
                if (isCommonApi || this.validateOutputParam(dy)) break;
                this.addFatalErrorMessage(datas[0], ResManager.loadKDString((String)"\u5f53API\u7c7b\u578b\u4e3a\u81ea\u5b9a\u4e49API\u65f6\uff0c\u8fd4\u56de\u53c2\u6570\u4e0d\u53ef\u91cd\u590d\u3002", (String)"HRAPISourceSaveValidator_4", (String)"hrmp-hbp-opplugin", (Object[])new Object[0]));
                break;
            }
        }
    }

    private boolean regexNumberContainChan(String str) {
        Pattern chieseWordPattern = Pattern.compile("[\\u4e00-\\u9fa5]");
        Matcher isNum = chieseWordPattern.matcher(str);
        return isNum.find();
    }

    private boolean validateCommonApiType(DynamicObject dy) {
        return HRStringUtils.isNotEmpty((String)dy.getString("param"));
    }

    private boolean validateCustomApiType(DynamicObject dy) {
        return HRStringUtils.isNotEmpty((String)dy.getString("inputparam")) && HRStringUtils.isNotEmpty((String)dy.getString("outputparam"));
    }

    private boolean validateInputParam(DynamicObject dy) {
        DynamicObjectCollection items = dy.getDynamicObjectCollection("inputentryentity");
        long count = items.stream().map(it -> it.getString("inputfieldkey")).distinct().count();
        return (long)items.size() == count;
    }

    private boolean validateOutputParam(DynamicObject dy) {
        DynamicObjectCollection items = dy.getDynamicObjectCollection("outputentryentity");
        long count = items.stream().map(it -> it.getString("outputfieldkey")).distinct().count();
        return (long)items.size() == count;
    }

    private boolean validateOutputParamContent(DynamicObject dy) {
        DynamicObjectCollection items = dy.getDynamicObjectCollection("outputentryentity");
        for (DynamicObject item : items) {
            if (item.getDynamicObject("basedatafield") == null) continue;
            String number = item.getDynamicObject("basedatafield").getString("number");
            DynamicObject toObj = BusinessDataServiceHelper.newDynamicObject((String)number);
            DataEntityPropertyCollection toPros = toObj.getDataEntityType().getProperties();
            String outputfieldkey = item.getString("outputfieldkey");
            boolean match = false;
            for (IDataEntityProperty toPro : toPros) {
                if (!HRStringUtils.equals((String)toPro.getName(), (String)outputfieldkey)) continue;
                match = true;
            }
            if (match) continue;
            return false;
        }
        return true;
    }
}

