/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.opplugin.validator;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.service.formula.utils.FormulaUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.datagrade.DataGradeTableVO;
import kd.hr.hbp.common.datagrade.EntryVO;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.common.util.XSSCheckUtils;
import org.apache.commons.lang3.StringUtils;

public class HRDataGradeValidator
extends AbstractValidator {
    private static final Log LOGGER = LogFactory.getLog(HRDataGradeValidator.class);
    private static final String UNIQUE_CODE = "uniquecode";
    private static final String NAME = "name";
    private static final String DESCRIPTION = "description";
    private static final String DATA_GRADE_PARAM = "datagradeparam";
    private static final List<String> XSS_CHECK_FIELDS = Lists.newArrayList((Object[])new String[]{"name", "description"});

    public void validate() {
        ExtendedDataEntity[] data = this.getDataEntities();
        String operationKey = this.getOperateKey();
        if (StringUtils.isBlank((CharSequence)operationKey)) {
            return;
        }
        switch (operationKey) {
            case "delete": {
                List childHelpers = FormulaUtils.getFormulaTplAllChildMetaServiceHelper();
                for (ExtendedDataEntity dataEntity : data) {
                    this.checkDataGradeQuote(dataEntity, childHelpers);
                }
                break;
            }
            case "save": 
            case "submit": 
            case "confirmchange": 
            case "confirmchangenoaudit": {
                for (ExtendedDataEntity dataEntity : data) {
                    this.checkXSSValidate(dataEntity);
                }
                break;
            }
        }
    }

    private void checkDataGradeQuote(ExtendedDataEntity dataEntity, List<HRBaseServiceHelper> helpers) {
        DynamicObject data = dataEntity.getDataEntity();
        String uniqueCode = data.getString(UNIQUE_CODE);
        if (HRStringUtils.isEmpty((String)uniqueCode) || CollectionUtils.isEmpty(helpers)) {
            return;
        }
        QFilter uniqueCodeFilter = new QFilter("dependentdatagrade", "like", (Object)("%" + uniqueCode + ",%"));
        QFilter isCurrentFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        QFilter[] queryFilter = new QFilter[]{uniqueCodeFilter, isCurrentFilter};
        for (HRBaseServiceHelper helper : helpers) {
            DynamicObject[] formulaNames;
            try {
                formulaNames = helper.queryOriginalArray("id,name", queryFilter);
            }
            catch (Exception e) {
                LOGGER.error("query_formula_obj_error:", (Throwable)e);
                continue;
            }
            if (!Objects.nonNull(formulaNames) || formulaNames.length <= 0) continue;
            List names = Stream.of(formulaNames).map(dy -> dy.getString(NAME)).distinct().collect(Collectors.toList());
            MainEntityType type = EntityMetadataCache.getDataEntityType((String)helper.getEntityName());
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u8be5\u6570\u636e\u5206\u7ea7\u5728\u201c%1$s\u201d\u4e2d\u88ab\u516c\u5f0f\u201c%2$s\u201d\u5f15\u7528\uff0c\u65e0\u6cd5\u5220\u9664\u3002", (String)"HRDataGradeValidator_1", (String)"hrmp-hbp-opplugin", (Object[])new Object[0]), type.getDisplayName().getLocaleValue(), StringUtils.join(names, (String)",")));
            return;
        }
    }

    private void checkXSSValidate(ExtendedDataEntity dataEntity) {
        DynamicObject data = dataEntity.getDataEntity();
        for (String field : XSS_CHECK_FIELDS) {
            IDataEntityProperty property = (IDataEntityProperty)data.getDataEntityType().getProperties().get((Object)field);
            String fieldValue = data.getString(property);
            if (!XSSCheckUtils.checkXSS((String)fieldValue)) continue;
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u5b57\u6bb5\u5b58\u5728\u975e\u6cd5XSS\u653b\u51fb\u6587\u672c\uff0c\u8bf7\u4fee\u6539\u3002", (String)"HRDataGradeValidator_2", (String)"hrmp-hbp-opplugin", (Object[])new Object[0]), property.getDisplayName().getLocaleValue()));
            return;
        }
        String dataGradeStr = data.getString(DATA_GRADE_PARAM);
        try {
            DataGradeTableVO dataGradeTableVO = (DataGradeTableVO)HRJSONUtils.cast((String)dataGradeStr, DataGradeTableVO.class);
            List condition = dataGradeTableVO.getHead().getCondition();
            for (EntryVO vo : condition) {
                String name = vo.getName();
                if (!XSSCheckUtils.checkXSS((String)name)) continue;
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u6761\u4ef6\u540d\u79f0\u5b57\u6bb5\u5b58\u5728\u975e\u6cd5XSS\u653b\u51fb\u6587\u672c\u201c%1$s\u201d\u8bf7\u4fee\u6539\u3002", (String)"HRDataGradeValidator_3", (String)"hrmp-hbp-opplugin", (Object[])new Object[0]), name));
                return;
            }
            List result = dataGradeTableVO.getHead().getResult();
            for (EntryVO vo : result) {
                String name = vo.getName();
                if (!XSSCheckUtils.checkXSS((String)name)) continue;
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7ed3\u679c\u540d\u79f0\u5b57\u6bb5\u5b58\u5728\u975e\u6cd5XSS\u653b\u51fb\u6587\u672c\u201c%1$s\u201d\u8bf7\u4fee\u6539\u3002", (String)"HRDataGradeValidator_4", (String)"hrmp-hbp-opplugin", (Object[])new Object[0]), name));
                return;
            }
        }
        catch (IOException e) {
            LOGGER.error("kd.hr.hbp.opplugin.validator.HRDataGradeValidator.checkXSSValidate:{}", (Object)e.getMessage());
        }
    }
}

