/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.opplugin.validator.flow;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.hr.hbp.common.util.HRStringUtils;
import org.apache.commons.lang3.StringUtils;

public class JobFlowInsValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] data = this.getDataEntities();
        String operationKey = this.getOperateKey();
        if (StringUtils.isBlank((CharSequence)operationKey)) {
            return;
        }
        switch (operationKey) {
            case "save": 
            case "submit": 
            case "confirmchange": 
            case "confirmchangenoaudit": 
            case "showflowchart": {
                for (ExtendedDataEntity dataEntity : data) {
                    this.checkNull(dataEntity);
                    this.checkType(dataEntity);
                    this.checkEndNodeFrontNodeIds(dataEntity);
                }
                break;
            }
        }
    }

    private void checkType(ExtendedDataEntity dataEntity) {
        String endDisplayName;
        String startDisplayName;
        DynamicObject dy = dataEntity.getDataEntity();
        DynamicObjectCollection flowEntries = dy.getDynamicObjectCollection("hrflowentry");
        ComboProp typeProp = (ComboProp)flowEntries.getDynamicObjectType().getProperty("type");
        int startTypeNum = 0;
        int endTypeNum = 0;
        for (DynamicObject entry : flowEntries) {
            String type = entry.getString("type");
            if (!HRStringUtils.isNotEmpty((String)type)) continue;
            switch (type) {
                case "start": {
                    ++startTypeNum;
                    break;
                }
                case "end": {
                    ++endTypeNum;
                    break;
                }
            }
        }
        if (startTypeNum == 0) {
            startDisplayName = typeProp.getItemByName("start");
            this.addFatalErrorMessage(dataEntity, MessageFormat.format(ResManager.loadKDString((String)"\u5fc5\u987b\u6709\u4e00\u4e2a\u7c7b\u578b\u4e3a[{0}]\u7684\u8282\u70b9", (String)"JobFlowInsValidator_0", (String)"hrmp-hbp-opplugin", (Object[])new Object[0]), startDisplayName));
        } else if (startTypeNum > 1) {
            startDisplayName = typeProp.getItemByName("start");
            this.addFatalErrorMessage(dataEntity, MessageFormat.format(ResManager.loadKDString((String)"\u7c7b\u578b\u4e3a[{0}]\u7684\u8282\u70b9\u53ea\u80fd\u5b58\u5728\u4e00\u4e2a", (String)"JobFlowInsValidator_1", (String)"hrmp-hbp-opplugin", (Object[])new Object[0]), startDisplayName));
        }
        if (endTypeNum == 0) {
            endDisplayName = typeProp.getItemByName("end");
            this.addFatalErrorMessage(dataEntity, MessageFormat.format(ResManager.loadKDString((String)"\u5fc5\u987b\u6709\u4e00\u4e2a\u7c7b\u578b\u4e3a[{0}]\u7684\u8282\u70b9", (String)"JobFlowInsValidator_0", (String)"hrmp-hbp-opplugin", (Object[])new Object[0]), endDisplayName));
        } else if (endTypeNum > 1) {
            endDisplayName = typeProp.getItemByName("end");
            this.addFatalErrorMessage(dataEntity, MessageFormat.format(ResManager.loadKDString((String)"\u7c7b\u578b\u4e3a[{0}]\u7684\u8282\u70b9\u53ea\u80fd\u5b58\u5728\u4e00\u4e2a", (String)"JobFlowInsValidator_1", (String)"hrmp-hbp-opplugin", (Object[])new Object[0]), endDisplayName));
        }
    }

    private void checkNull(ExtendedDataEntity dataEntity) {
        DynamicObject dy = dataEntity.getDataEntity();
        IDataEntityType dataEntityType = dy.getDataEntityType();
        DynamicObjectCollection flowEntries = dy.getDynamicObjectCollection("hrflowentry");
        if (flowEntries.isEmpty()) {
            String detailControlApDisplayName = this.getDetailControlApDisplayName(dataEntityType.getName());
            this.addFatalErrorMessage(dataEntity, MessageFormat.format(ResManager.loadKDString((String)"[{0}]\u4e0d\u80fd\u4e3a\u7a7a", (String)"JobFlowInsValidator_2", (String)"hrmp-hbp-opplugin", (Object[])new Object[0]), detailControlApDisplayName));
            return;
        }
        DynamicProperty typeProp = flowEntries.getDynamicObjectType().getProperty("type");
        DynamicProperty jobInsProp = flowEntries.getDynamicObjectType().getProperty("jobins");
        DynamicProperty jobFlowInsProp = flowEntries.getDynamicObjectType().getProperty("jobflowins");
        DynamicProperty frontNodeNameProp = flowEntries.getDynamicObjectType().getProperty("frontnodename");
        for (DynamicObject entry : flowEntries) {
            String type = entry.getString((IDataEntityProperty)typeProp);
            int seq = entry.getInt("seq");
            if (HRStringUtils.isNotEmpty((String)type)) {
                String frontNodeIds;
                switch (type) {
                    case "job": {
                        DynamicObject job = entry.getDynamicObject((IDataEntityProperty)jobInsProp);
                        if (!Objects.isNull(job)) break;
                        this.addFatalErrorMessage(dataEntity, MessageFormat.format(ResManager.loadKDString((String)"\u7b2c[{0}]\u884c[{1}]\u4e0d\u80fd\u4e3a\u7a7a", (String)"JobFlowInsValidator_3", (String)"hrmp-hbp-opplugin", (Object[])new Object[0]), seq, jobInsProp.getDisplayName().getLocaleValue()));
                        break;
                    }
                    case "jobflow": {
                        DynamicObject jobFlow = entry.getDynamicObject((IDataEntityProperty)jobFlowInsProp);
                        if (!Objects.isNull(jobFlow)) break;
                        this.addFatalErrorMessage(dataEntity, MessageFormat.format(ResManager.loadKDString((String)"\u7b2c[{0}]\u884c[{1}]\u4e0d\u80fd\u4e3a\u7a7a", (String)"JobFlowInsValidator_3", (String)"hrmp-hbp-opplugin", (Object[])new Object[0]), seq, jobFlowInsProp.getDisplayName().getLocaleValue()));
                        break;
                    }
                }
                if ("start".equals(type) || !HRStringUtils.isEmpty((String)(frontNodeIds = entry.getString("frontnodeentryids")))) continue;
                this.addFatalErrorMessage(dataEntity, MessageFormat.format(ResManager.loadKDString((String)"\u7b2c[{0}]\u884c[{1}]\u4e0d\u80fd\u4e3a\u7a7a", (String)"JobFlowInsValidator_3", (String)"hrmp-hbp-opplugin", (Object[])new Object[0]), seq, frontNodeNameProp.getDisplayName().getLocaleValue()));
                continue;
            }
            this.addFatalErrorMessage(dataEntity, MessageFormat.format(ResManager.loadKDString((String)"\u7b2c[{0}]\u884c[{1}]\u4e0d\u80fd\u4e3a\u7a7a", (String)"JobFlowInsValidator_3", (String)"hrmp-hbp-opplugin", (Object[])new Object[0]), seq, typeProp.getDisplayName().getLocaleValue()));
        }
    }

    private void checkEndNodeFrontNodeIds(ExtendedDataEntity dataEntity) {
        DynamicObject data = dataEntity.getDataEntity();
        DynamicObjectCollection flowEntries = data.getDynamicObjectCollection("hrflowentry");
        DynamicProperty frontNodeNameProp = flowEntries.getDynamicObjectType().getProperty("frontnodename");
        ComboProp typeProp = (ComboProp)flowEntries.getDynamicObjectType().getProperty("type");
        Map<String, DynamicObject> boIdToDyMap = flowEntries.stream().collect(Collectors.toMap(entry -> entry.getString("entryboid"), entry -> entry));
        for (DynamicObject entry2 : flowEntries) {
            String type = entry2.getString("type");
            if (!"end".equals(type)) continue;
            String endDisplayName = typeProp.getItemByName(type);
            int seq = entry2.getInt("seq");
            Set<String> allNodeBoIdsExceptEnd = flowEntries.stream().filter(dy -> !"end".equals(dy.getString("type"))).map(dy -> dy.getString("entryboid")).collect(Collectors.toSet());
            Set endFrontNodeIds = Arrays.stream(entry2.getString("frontnodeentryids").split(";")).filter(HRStringUtils::isNotEmpty).collect(Collectors.toSet());
            Set<String> allFrontNodeIdsExceptEnd = this.getAllFrontNodeIdsExceptEnd(flowEntries);
            Set<String> duplicateFrontNodeIds = endFrontNodeIds.stream().filter(allFrontNodeIdsExceptEnd::contains).collect(Collectors.toSet());
            if (!duplicateFrontNodeIds.isEmpty()) {
                this.addFatalErrorMessage(dataEntity, MessageFormat.format(ResManager.loadKDString((String)"\u7b2c[{0}]\u884c[{1}]\u8282\u70b9\u7684[{2}]\u4e2d\uff0c\u8282\u70b9[3]\u5df2\u7ecf\u662f\u5176\u4ed6\u8282\u70b9\u7684\u524d\u5e8f\u8282\u70b9\uff0c\u8bf7\u4fee\u6539\u3002", (String)"JobFlowInsValidator_4", (String)"hrmp-hbp-opplugin", (Object[])new Object[0]), seq, endDisplayName, frontNodeNameProp.getDisplayName().getLocaleValue(), this.getNodeNames(boIdToDyMap, duplicateFrontNodeIds)));
            }
            allNodeBoIdsExceptEnd.removeAll(allFrontNodeIdsExceptEnd);
            allNodeBoIdsExceptEnd.removeAll(endFrontNodeIds);
            if (allNodeBoIdsExceptEnd.isEmpty()) continue;
            this.addFatalErrorMessage(dataEntity, MessageFormat.format(ResManager.loadKDString((String)"\u7b2c[{0}]\u884c[{1}]\u8282\u70b9\u7684[{2}]\u4e2d\uff0c\u7f3a\u5c11\u6ca1\u6709\u88ab\u5176\u4ed6\u8282\u70b9\u914d\u7f6e\u4e3a\u524d\u5e8f\u8282\u70b9\u7684\u8282\u70b9[{3}]\uff0c\u8bf7\u4fee\u6539\u3002", (String)"JobFlowInsValidator_5", (String)"hrmp-hbp-opplugin", (Object[])new Object[0]), seq, endDisplayName, frontNodeNameProp.getDisplayName().getLocaleValue(), this.getNodeNames(boIdToDyMap, allNodeBoIdsExceptEnd)));
        }
    }

    private Set<String> getAllFrontNodeIdsExceptEnd(DynamicObjectCollection entries) {
        return entries.stream().filter(dy -> !"end".equals(dy.getString("type"))).flatMap(dy -> Arrays.stream(dy.getString("frontnodeentryids").split(";"))).filter(HRStringUtils::isNotEmpty).collect(Collectors.toSet());
    }

    private String getNodeNames(Map<String, DynamicObject> idToDyMap, Set<String> ids) {
        StringBuilder name = new StringBuilder();
        for (String id : ids) {
            DynamicObject dy = idToDyMap.get(id);
            String nodeName = this.getNodeName(dy);
            if (!HRStringUtils.isNotEmpty((String)nodeName)) continue;
            name.append(nodeName).append(',');
        }
        if (name.length() > 0) {
            name.deleteCharAt(name.length() - 1);
        }
        return name.toString();
    }

    private String getNodeName(DynamicObject entryDy) {
        String name = "";
        String type = entryDy.getString("type");
        if ("jobflow".equals(type)) {
            DynamicObject jobFlow = entryDy.getDynamicObject("jobflowins");
            if (Objects.nonNull(jobFlow)) {
                name = jobFlow.getString("name");
            }
        } else if ("job".equals(type)) {
            DynamicObject job = entryDy.getDynamicObject("jobins");
            if (Objects.nonNull(job)) {
                name = job.getString("name");
            }
        } else {
            IDataEntityProperty property = (IDataEntityProperty)entryDy.getDataEntityType().getProperties().get((Object)"type");
            if (property instanceof ComboProp) {
                ComboProp comboProp = (ComboProp)property;
                name = comboProp.getItemByName(type);
            }
        }
        return name;
    }

    private String getDetailControlApDisplayName(String entityNumber) {
        String detailDisplayName = "";
        FormMetadata formMetadata = (FormMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)entityNumber, (MetaCategory)MetaCategory.Form), (MetaCategory)MetaCategory.Form);
        Optional<ControlAp> detailControlApOp = formMetadata.getItems().stream().filter(controlAp -> "hrflowentryap".equals(controlAp.getKey())).findFirst();
        if (detailControlApOp.isPresent()) {
            detailDisplayName = detailControlApOp.get().getName().getLocaleValue();
        }
        return detailDisplayName;
    }
}

