/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.opplugin.validator.task;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.entity.validate.ValidationErrorInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;

public class CoordinationTaskValidator
extends HRDataBaseValidator {
    @Override
    public void validate() {
        super.validate();
        String operateKey = this.getOperateKey();
        if ("save".equals(operateKey)) {
            this.validateSave(this.getDataEntities());
        }
    }

    private void validateSave(ExtendedDataEntity[] dataEntities) {
        String errMsg = ResManager.loadKDString((String)"\u76f8\u5173\u4efb\u52a1\u4e0d\u80fd\u4e92\u4e3a\u524d\u7f6e\u9879\uff0c\u8bf7\u68c0\u67e5", (String)"CoordinationTaskValidator_0", (String)"hrmp-hbp-opplugin", (Object[])new Object[0]);
        if (dataEntities.length == 1) {
            boolean isSuccess;
            DynamicObject curTask = dataEntities[0].getDataEntity();
            Map<String, DynamicObjectCollection> tasksMap = this.getTasksByBatchNo(Sets.newHashSet((Object[])new String[]{curTask.getString("batchNo")}));
            DynamicObjectCollection tasks = tasksMap.get(curTask.getString("batchNo"));
            if (!CollectionUtils.isEmpty((Collection)tasks) && !(isSuccess = this.validateRing(tasks, curTask))) {
                this.addErrorMessage(dataEntities[0], errMsg);
            }
        } else {
            ValidateResult validateResult = this.getValidateResult();
            LinkedHashSet batchNoSet = Sets.newLinkedHashSetWithExpectedSize((int)16);
            for (ExtendedDataEntity dataEntity : dataEntities) {
                DynamicObject curTask = dataEntity.getDataEntity();
                batchNoSet.add(curTask.getString("batchNo"));
            }
            Map<String, DynamicObjectCollection> tasksMap = this.getTasksByBatchNo(batchNoSet);
            for (ExtendedDataEntity dataEntity : dataEntities) {
                boolean isSuccess;
                DynamicObject curTask = dataEntity.getDataEntity();
                DynamicObjectCollection tasks = tasksMap.get(curTask.getString("batchNo"));
                if (CollectionUtils.isEmpty((Collection)tasks) || (isSuccess = this.validateRing(tasks, curTask))) continue;
                ValidationErrorInfo errorInfo = new ValidationErrorInfo("", curTask.getPkValue(), dataEntity.getDataEntityIndex(), dataEntity.getRowIndex(), "errorcode_001", this.getOperationName(), errMsg, ErrorLevel.Error);
                errorInfo.setEntityKey(this.getEntityKey());
                errorInfo.setSubRowIndex(dataEntity.getSubRowIndex());
                validateResult.addErrorInfo((OperateErrorInfo)errorInfo);
                this.getFalseDataEntities().add(dataEntity);
            }
        }
    }

    private Map<String, DynamicObjectCollection> getTasksByBatchNo(Set<String> batchNoSet) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(this.getEntityKey());
        DynamicObject[] results = serviceHelper.query("id,number,batchno,parent", new QFilter[]{new QFilter("batchNo", "in", batchNoSet)});
        HashMap tasksMap = Maps.newHashMapWithExpectedSize((int)results.length);
        for (DynamicObject result : results) {
            DynamicObjectCollection tasks = (DynamicObjectCollection)tasksMap.get(result.getString("batchNo"));
            if (tasks == null) {
                tasks = new DynamicObjectCollection();
                tasksMap.put(result.getString("batchNo"), tasks);
            }
            tasks.add((Object)result);
        }
        return tasksMap;
    }

    private boolean validateRing(DynamicObjectCollection tasks, DynamicObject curTask) {
        boolean isSuccess = false;
        long curTaskId = curTask.getLong("id");
        Map<Long, Set<Long>> parentMap = tasks.stream().collect(Collectors.toMap(task -> task.getLong("id"), task -> {
            DynamicObjectCollection baseData = task.getDynamicObjectCollection("parent");
            return baseData.stream().map(bd -> bd.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toSet());
        }));
        Set curParentIdSet = curTask.getDynamicObjectCollection("parent").stream().map(bd -> bd.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toSet());
        Set curOldParentIdSet = parentMap.get(curTaskId);
        if (curOldParentIdSet == null) {
            curOldParentIdSet = Sets.newHashSetWithExpectedSize((int)16);
        } else {
            curOldParentIdSet.clear();
        }
        curOldParentIdSet.addAll(curParentIdSet);
        HashSet rightParentSet = Sets.newHashSetWithExpectedSize((int)tasks.size());
        HashSet leftSonSet = Sets.newHashSetWithExpectedSize((int)tasks.size());
        boolean isParentPass = this.addParentNode(rightParentSet, parentMap, curTaskId, curTaskId);
        boolean isChildrenPass = false;
        if (isParentPass) {
            isChildrenPass = this.addChildrenNode(leftSonSet, parentMap, curTaskId, curTaskId);
        }
        if (isChildrenPass) {
            leftSonSet.retainAll(rightParentSet);
            if (CollectionUtils.isEmpty((Collection)leftSonSet)) {
                isSuccess = true;
            }
        }
        return isSuccess;
    }

    private boolean addParentNode(Set<Long> nodeSet, Map<Long, Set<Long>> parentMap, Long curSaveNode, Long node) {
        Set<Long> parentNode = parentMap.get(node);
        if (!CollectionUtils.isEmpty(parentNode)) {
            for (Long parent : parentNode) {
                nodeSet.add(parent);
                if (Objects.equals(parent, curSaveNode)) {
                    return false;
                }
                this.addParentNode(nodeSet, parentMap, curSaveNode, parent);
            }
        }
        return true;
    }

    private boolean addChildrenNode(Set<Long> nodeSet, Map<Long, Set<Long>> parentMap, Long curSaveNode, Long node) {
        for (Map.Entry<Long, Set<Long>> parentEntry : parentMap.entrySet()) {
            if (!parentEntry.getValue().contains(node)) continue;
            nodeSet.add(parentEntry.getKey());
            if (Objects.equals(parentEntry.getKey(), curSaveNode)) {
                return false;
            }
            this.addChildrenNode(nodeSet, parentMap, curSaveNode, parentEntry.getKey());
        }
        return true;
    }
}

