/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.opplugin.web.hismodel;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.IOperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.ReturnOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ValidatePriority;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.business.application.impl.common.DynamicObjectCommonService;
import kd.hr.hbp.business.domain.repository.HisCommonEntityRepository;
import kd.hr.hbp.business.domain.service.attachment.HisAttachmentService;
import kd.hr.hbp.business.domain.service.impl.newhismodel.HisNonLineTimeService;
import kd.hr.hbp.business.domain.service.newhismodel.IHisNonLineTimeService;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.constants.HRBaseConstants;
import kd.hr.hbp.common.constants.newhismodel.EnumHisDataVersionStatus;
import kd.hr.hbp.common.constants.newhismodel.HisFieldNameConstants;
import kd.hr.hbp.common.constants.newhismodel.HisSysConstants;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.web.hismodel.validator.HisNonLineImportValidator;
import kd.hr.hbp.opplugin.web.hismodel.validator.HisNonLineTimeTplValidator;

public class HisNonLineTimeTplChangeOp
extends AbstractOperationServicePlugIn
implements HRBaseConstants,
HisFieldNameConstants,
HisSysConstants {
    private static final Log LOGGER = LogFactory.getLog(HisNonLineTimeTplChangeOp.class);
    private IHisNonLineTimeService hisNonLineTimeService = new HisNonLineTimeService();

    public void onAddValidators(AddValidatorsEventArgs args) {
        super.onAddValidators(args);
        HisNonLineImportValidator hisNonLineImportValidator = new HisNonLineImportValidator();
        hisNonLineImportValidator.setValidatePriority(ValidatePriority.First);
        args.addValidator((AbstractValidator)hisNonLineImportValidator);
        args.addValidator((AbstractValidator)new HisNonLineTimeTplValidator());
    }

    @ExcludeFromJacocoGeneratedReport
    public void onPreparePropertys(PreparePropertysEventArgs args) {
        List fieldKeys = args.getFieldKeys();
        fieldKeys.add("boid");
        fieldKeys.add("iscurrentversion");
        fieldKeys.add("datastatus");
        fieldKeys.add("sourcevid");
        fieldKeys.add("ismodify");
    }

    @ExcludeFromJacocoGeneratedReport
    public void beforeExecuteOperationTransaction(BeforeOperationArgs args) {
        super.beforeExecuteOperationTransaction(args);
        DynamicObject[] dataCol = args.getDataEntities();
        if (this.getOption().containsVariable("importtype")) {
            List pks = Arrays.stream(args.getDataEntities()).map(data -> data.get("boid")).collect(Collectors.toList());
            this.getOption().setVariableValue("hisImportPKs", SerializationUtils.toJsonString(pks));
        }
        switch (args.getOperationKey()) {
            case "changesave": 
            case "confirmchange": 
            case "auditconfirmchange": {
                this.BeforeSetDyIds(dataCol);
                break;
            }
        }
    }

    @ExcludeFromJacocoGeneratedReport
    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        String operationKey;
        super.beginOperationTransaction(args);
        switch (operationKey = args.getOperationKey()) {
            case "changesave": {
                this.hisNonLineTimeService.handleChangeSaveData(args.getDataEntities());
                break;
            }
            case "confirmchange": {
                String importType = this.getOption().getVariableValue("importtype", null);
                if (HRStringUtils.isNotEmpty((String)importType)) {
                    if (!HRStringUtils.equals((String)importType, (String)"override") && !HRStringUtils.equals((String)importType, (String)"overridenew")) break;
                    DynamicObject[] dataEntities = args.getDataEntities();
                    Arrays.stream(dataEntities).forEach(dy -> {
                        if (!dy.getBoolean("iscurrentversion")) {
                            dy.set("id", (Object)ORM.create().genLongId(dy.getDataEntityType().getName()));
                            DynamicObjectCommonService.getInstance().setMastId(dy);
                        }
                    });
                    this.hisNonLineTimeService.handleConfirmChangeData(args.getDataEntities(), importType);
                    break;
                }
                this.hisNonLineTimeService.handleConfirmChangeData(args.getDataEntities(), null);
                break;
            }
            case "auditconfirmchange": {
                this.hisNonLineTimeService.handleConfirmChangeData(args.getDataEntities(), null);
                break;
            }
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs args) {
        super.afterExecuteOperationTransaction(args);
        DynamicObject[] dataEntities = args.getDataEntities();
        String entityId = dataEntities[0].getDataEntityType().getName();
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityId);
        switch (args.getOperationKey()) {
            case "changesave": {
                Arrays.stream(dataEntities).forEach(dataEntity -> {
                    if (dataEntity.getBoolean("iscurrentversion")) {
                        DynamicObject tempDy = HisCommonEntityRepository.getNonLineTimeTempByBoid((HRBaseServiceHelper)serviceHelper, (Long)dataEntity.getLong("boid"));
                        HisAttachmentService.saveTempAttachments((DynamicObject)tempDy, (OperateOption)this.operateOption, (boolean)true);
                        DynamicObject[] dataCol = new DynamicObject[]{tempDy};
                        HisAttachmentService.getAttachmentsInfo((DynamicObject[])dataCol, (OperateOption)this.operateOption);
                        String jsonString = this.operateOption.getVariableValue("opHisAttachments", null);
                        if (HRStringUtils.isEmpty((String)jsonString)) {
                            return;
                        }
                        this.handleChangeSaveAttachments(jsonString);
                    } else {
                        DynamicObject[] dataCol = new DynamicObject[]{dataEntity};
                        HisAttachmentService.saveTempAttachments((DynamicObject)dataEntity, (OperateOption)this.operateOption, (boolean)true);
                        HisAttachmentService.getAttachmentsInfo((DynamicObject[])dataCol, (OperateOption)this.operateOption);
                        String jsonString = this.operateOption.getVariableValue("opHisAttachments", null);
                        if (HRStringUtils.isEmpty((String)jsonString)) {
                            return;
                        }
                        this.handleChangeSaveAttachments(jsonString);
                    }
                });
                break;
            }
            case "confirmchange": 
            case "auditconfirmchange": {
                String entityNumber = dataEntities[0].getDynamicObjectType().getName();
                MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)entityNumber);
                Map allFields = dataEntityType.getAllFields();
                Arrays.stream(dataEntities).forEach(dataEntity -> {
                    if (!allFields.containsKey("enable") || !HRStringUtils.equals((String)"10", (String)dataEntity.getString("enable"))) {
                        if (dataEntity.getBoolean("iscurrentversion")) {
                            DynamicObject curDy = HisCommonEntityRepository.getNonLineRelCurEffectingDy((HRBaseServiceHelper)serviceHelper, (Long)dataEntity.getLong("boid"));
                            DynamicObject relHisDy = HisCommonEntityRepository.getNonLineDy((HRBaseServiceHelper)serviceHelper, (long)curDy.getLong("sourcevid"));
                            DynamicObject[] dataCol = new DynamicObject[]{relHisDy};
                            HisAttachmentService.handleTempAttachments((DynamicObject[])dataCol, (OperateOption)this.operateOption);
                            HisAttachmentService.getAttachmentsInfo((DynamicObject[])dataCol, (OperateOption)this.operateOption);
                            String jsonString = this.operateOption.getVariableValue("opHisAttachments", null);
                            if (HRStringUtils.isEmpty((String)jsonString)) {
                                return;
                            }
                            HisAttachmentService.deleteCurDyAttachments((DynamicObject)curDy);
                            HisAttachmentService.addDyAttachments((String)jsonString, (long)relHisDy.getLong("id"), (long)curDy.getLong("id"), (String)curDy.getDataEntityType().getName());
                        } else {
                            DynamicObject[] dataCol = new DynamicObject[]{dataEntity};
                            HisAttachmentService.saveTempAttachments((DynamicObject)dataEntity, (OperateOption)this.operateOption, (boolean)true);
                            HisAttachmentService.getAttachmentsInfo((DynamicObject[])dataCol, (OperateOption)this.operateOption);
                            String jsonString = this.operateOption.getVariableValue("opHisAttachments", null);
                            if (HRStringUtils.isEmpty((String)jsonString)) {
                                return;
                            }
                            DynamicObject curEffectingDy = HisCommonEntityRepository.getNonLineRelCurEffectingDy((HRBaseServiceHelper)serviceHelper, (Long)dataEntity.getLong("boid"));
                            HisAttachmentService.deleteCurDyAttachments((DynamicObject)curEffectingDy);
                            HisAttachmentService.addDyAttachments((String)jsonString, (long)dataEntity.getLong("id"), (long)dataEntity.getLong("boid"), (String)dataEntity.getDataEntityType().getName());
                        }
                    }
                });
                break;
            }
        }
    }

    @ExcludeFromJacocoGeneratedReport
    public void onReturnOperation(ReturnOperationArgs args) {
        super.onReturnOperation(args);
        IOperationResult operationResult = args.getOperationResult();
        String importType = this.getOption().getVariableValue("importtype", null);
        if ((HRStringUtils.equals((String)importType, (String)"override") || HRStringUtils.equals((String)importType, (String)"overridenew")) && operationResult.getSuccessPkIds() != null && !operationResult.getSuccessPkIds().isEmpty()) {
            String currentPkStr = this.getOption().getVariableValue("hisImportPKs", null);
            if (HRStringUtils.isEmpty((String)currentPkStr)) {
                return;
            }
            List currentPks = (List)SerializationUtils.fromJsonString((String)currentPkStr, List.class);
            operationResult.getSuccessPkIds().addAll(currentPks);
        }
    }

    @ExcludeFromJacocoGeneratedReport
    private void handleChangeSaveAttachments(String jsonString) {
        Map attachmentListMap = HisAttachmentService.buildHisAttachmentBoList((String)jsonString);
        attachmentListMap.forEach((id, hisAttachmentBoList) -> hisAttachmentBoList.forEach(bo -> AttachmentServiceHelper.upload((String)bo.getEntityNumber(), (Object)id, (String)bo.getAttachKey(), (List)bo.getAttachments())));
    }

    private void BeforeSetDyIds(DynamicObject[] dataCol) {
        if (!this.getOption().containsVariable("importtype")) {
            Arrays.stream(dataCol).forEach(dataDy -> {
                if (!dataDy.getBoolean("iscurrentversion")) {
                    HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(dataDy.getDataEntityType().getName());
                    DynamicObject tempDy = HisCommonEntityRepository.getNonLineTimeTempByBoid((HRBaseServiceHelper)serviceHelper, (Long)dataDy.getLong("boid"));
                    if (HRObjectUtils.isEmpty((Object)tempDy)) {
                        dataDy.set("id", (Object)0L);
                        dataDy.set("datastatus", (Object)EnumHisDataVersionStatus.EFFECTING.getStatus());
                        return;
                    }
                    dataDy.set("id", (Object)tempDy.getLong("id"));
                }
            });
        }
    }
}

