/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.opplugin.web.hismodel;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.bd.service.BaseDataCommonService;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.IOperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.ReturnOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ValidatePriority;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.hr.hbp.business.application.impl.common.DynamicObjectCommonService;
import kd.hr.hbp.business.domain.model.newhismodel.HisVersionReviseParamBo;
import kd.hr.hbp.business.domain.model.newhismodel.HisVersionReviseReturnDataBo;
import kd.hr.hbp.business.domain.repository.HisCommonEntityRepository;
import kd.hr.hbp.business.domain.service.attachment.HisAttachmentService;
import kd.hr.hbp.business.domain.service.impl.newhismodel.HisNonLineTimeService;
import kd.hr.hbp.business.domain.service.impl.newhismodel.HisValidateService;
import kd.hr.hbp.business.domain.service.impl.newhismodel.hisversion.HisVersionReviseService;
import kd.hr.hbp.business.domain.service.newhismodel.IHisNonLineTimeService;
import kd.hr.hbp.business.domain.util.HisModelImportUtil;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.constants.HRBaseConstants;
import kd.hr.hbp.common.constants.newhismodel.EnumHisDataVersionStatus;
import kd.hr.hbp.common.constants.newhismodel.HisFieldNameConstants;
import kd.hr.hbp.common.constants.newhismodel.HisSysConstants;
import kd.hr.hbp.common.model.hismodel.HisAttachmentBo;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.web.hismodel.validator.HisNonLineImportValidator;
import kd.hr.hbp.opplugin.web.hismodel.validator.HisNonLineTimeTplValidator;
import kd.hr.hbp.opplugin.web.hismodel.validator.HisReviseSaveValidator;

@ExcludeFromJacocoGeneratedReport
public class HisNonLineTimeTplOp
extends AbstractOperationServicePlugIn
implements HRBaseConstants,
HisFieldNameConstants,
HisSysConstants {
    private IHisNonLineTimeService hisNonLineTimeService = HisNonLineTimeService.getInstance();

    public void onAddValidators(AddValidatorsEventArgs args) {
        super.onAddValidators(args);
        if (this.getOption().containsVariable("importtype")) {
            HisNonLineImportValidator hisNonLineImportValidator = new HisNonLineImportValidator();
            hisNonLineImportValidator.setValidatePriority(ValidatePriority.First);
            args.addValidator((AbstractValidator)hisNonLineImportValidator);
        }
        args.addValidator((AbstractValidator)new HisNonLineTimeTplValidator());
        args.addValidator((AbstractValidator)new HisReviseSaveValidator());
    }

    public void onPreparePropertys(PreparePropertysEventArgs args) {
        args.getFieldKeys().clear();
        ArrayList fieldsNameList = Lists.newArrayListWithExpectedSize((int)this.billEntityType.getFields().size());
        DataEntityPropertyCollection collection = this.billEntityType.getProperties();
        collection.forEach(entityProperty -> {
            String propertyName = entityProperty.getName();
            if (!HRStringUtils.equals((String)propertyName, (String)"multilanguagetext") && !propertyName.endsWith("_id")) {
                fieldsNameList.add(propertyName);
            }
        });
        args.getFieldKeys().addAll(fieldsNameList);
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs args) {
        String operationKey;
        super.beforeExecuteOperationTransaction(args);
        if (this.getOption().containsVariable("importtype")) {
            List pks = Arrays.stream(args.getDataEntities()).map(data -> data.get("boid")).collect(Collectors.toList());
            this.getOption().setVariableValue("hisImportPKs", SerializationUtils.toJsonString(pks));
        }
        switch (operationKey = args.getOperationKey()) {
            case "save": {
                String importType;
                String isPersonalizeDataParam = this.getOption().getVariableValue("isPersonalizeData", null);
                if (HRStringUtils.equals((String)isPersonalizeDataParam, (String)"1")) {
                    this.hisNonLineTimeService.handlePersonalSaveData(args.getDataEntities());
                }
                if (!HisModelImportUtil.isOverride((String)(importType = this.getOption().getVariableValue("importtype", null))) && !HisModelImportUtil.isOverrideNew((String)importType)) break;
                this.handlePersonalImportData(args);
                break;
            }
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        super.beginOperationTransaction(args);
        String operationKey = args.getOperationKey();
        DynamicObject[] dataEntities = args.getDataEntities();
        String fromFormEdit = this.getOption().getVariableValue("opFromFormEdit", "false");
        switch (operationKey) {
            case "deletehis": {
                this.hisNonLineTimeService.handleDeleteHisData(dataEntities);
                break;
            }
            case "audithisconfirmchange": {
                if (HRStringUtils.equals((String)fromFormEdit, (String)"false")) {
                    HRBaseServiceHelper helper = new HRBaseServiceHelper(dataEntities[0].getDataEntityType().getName());
                    dataEntities = HisCommonEntityRepository.byIdsAllFieldDys((HRBaseServiceHelper)helper, (DynamicObject[])dataEntities);
                    args.setDataEntities(dataEntities);
                }
                HisAttachmentService.getAttachmentsInfo((DynamicObject[])dataEntities, (OperateOption)this.operateOption);
                this.hisNonLineTimeService.handleConfirmChangeData(dataEntities, null);
                break;
            }
            case "submit": {
                if (dataEntities[0].getDataEntityState().getFromDatabase()) {
                    return;
                }
                this.hisNonLineTimeService.handleSubmitData(dataEntities);
                break;
            }
            case "audit": {
                if (HRStringUtils.equals((String)fromFormEdit, (String)"false")) {
                    HRBaseServiceHelper helper = new HRBaseServiceHelper(dataEntities[0].getDataEntityType().getName());
                    dataEntities = HisCommonEntityRepository.byIdsAllFieldDys((HRBaseServiceHelper)helper, (DynamicObject[])dataEntities);
                    Arrays.stream(dataEntities).forEach(dataEntity -> dataEntity.set("status", (Object)"C"));
                    args.setDataEntities(dataEntities);
                }
                HisAttachmentService.getAttachmentsInfo((DynamicObject[])dataEntities, (OperateOption)this.operateOption);
                this.hisNonLineTimeService.handleAuditDatas(dataEntities);
                break;
            }
            case "save": {
                HisAttachmentService.getAttachmentsInfo((DynamicObject[])dataEntities, (OperateOption)this.operateOption);
                String importType = this.getOption().getVariableValue("importtype", null);
                if (HRStringUtils.isNotEmpty((String)importType)) {
                    if (HisModelImportUtil.isOverride((String)importType) || HisModelImportUtil.isOverrideNew((String)importType)) {
                        Set boidSet = Arrays.stream(dataEntities).map(dy -> dy.getLong("boid")).collect(Collectors.toSet());
                        QFilter boidFilter = new QFilter("boid", "in", boidSet);
                        boidFilter.and(new QFilter("iscurrentversion", "=", (Object)Character.valueOf('0')));
                        boidFilter.and(new QFilter("datastatus", "=", (Object)EnumHisDataVersionStatus.TEMP.getStatus()));
                        DynamicObject[] oldTempDys = HisCommonEntityRepository.loadDynamicObjectArray((String)dataEntities[0].getDataEntityType().getName(), (QFilter)boidFilter);
                        Map boidToOldTempDyMaps = Arrays.stream(oldTempDys).collect(Collectors.toMap(dy -> dy.getLong("boid"), Function.identity()));
                        Arrays.stream(dataEntities).forEach(dy -> {
                            if (!dy.getBoolean("iscurrentversion")) {
                                DynamicObject oldTempDy = (DynamicObject)boidToOldTempDyMaps.get(dy.getLong("boid"));
                                if (HRObjectUtils.isEmpty((Object)oldTempDy)) {
                                    dy.set("id", (Object)0L);
                                    DynamicObjectCommonService.getInstance().setMastId(dy);
                                } else {
                                    dy.set("id", (Object)oldTempDy.getLong("id"));
                                }
                            }
                        });
                    }
                    this.hisNonLineTimeService.handleSaveDatas(dataEntities, importType);
                    break;
                }
                if (this.getOption().containsVariable("fromPage")) {
                    String fromPage = this.getOption().getVariableValue("fromPage");
                    if (!"revise".equals(fromPage)) break;
                    this.doReviseOperate(dataEntities);
                    break;
                }
                this.hisNonLineTimeService.handleSaveDatas(dataEntities, null);
                break;
            }
            case "delete": {
                this.hisNonLineTimeService.handleDeleteCurData(dataEntities);
                break;
            }
            case "disable": {
                this.handleCurDyDisableOrEnable(args, fromFormEdit);
                String entityNumber = this.billEntityType.getName();
                Boolean isBaseDataCtrl = BaseDataServiceHelper.checkBaseDataCtrl((String)entityNumber);
                if (!isBaseDataCtrl.booleanValue()) break;
                this.hisNonLineTimeService.handlePersonalDisableData(args.getDataEntities());
                break;
            }
            case "enable": {
                this.handleCurDyDisableOrEnable(args, fromFormEdit);
                break;
            }
        }
    }

    private void handleCurDyDisableOrEnable(BeginOperationTransactionArgs args, String fromFormEdit) {
        DynamicObject[] dataEntities = args.getDataEntities();
        if (HRStringUtils.equals((String)fromFormEdit, (String)"false")) {
            HRBaseServiceHelper helper = new HRBaseServiceHelper(dataEntities[0].getDataEntityType().getName());
            Map idToDyMaps = Arrays.stream(dataEntities).collect(Collectors.toMap(dy -> dy.getLong("id"), Function.identity()));
            dataEntities = HisCommonEntityRepository.byIdsAllFieldDys((HRBaseServiceHelper)helper, (DynamicObject[])dataEntities);
            Arrays.stream(dataEntities).forEach(dataEntity -> {
                DynamicObject dynamicObject = (DynamicObject)idToDyMaps.get(dataEntity.getLong("id"));
                dataEntity.set("enable", dynamicObject.get("enable"));
            });
            args.setDataEntities(dataEntities);
        }
        HisAttachmentService.getAttachmentsInfo((DynamicObject[])dataEntities, (OperateOption)this.operateOption);
        this.hisNonLineTimeService.handleDisableOrEnableData(dataEntities);
    }

    private void doReviseOperate(DynamicObject[] dataEntities) {
        String attachments;
        HisValidateService.getInstance().saveValidate(dataEntities);
        String entityNumber = dataEntities[0].getDataEntityType().getName();
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityNumber);
        Map<Long, List<HisAttachmentBo>> preAttachmentInfoMap = null;
        if (this.getOption().containsVariable("preAttachments") && !"null".equals(attachments = this.getOption().getVariableValue("preAttachments"))) {
            List attachmentMapList = SerializationUtils.fromJsonStringToList((String)attachments, Map.class);
            Map hisAttachBoMap = HisAttachmentService.transAttachmentsInfo((List)attachmentMapList, (String)entityNumber);
            preAttachmentInfoMap = hisAttachBoMap.values().stream().collect(Collectors.groupingBy(HisAttachmentBo::getId));
        }
        List attachMapList = HisAttachmentService.generateAttachmentMap((DynamicObject[])dataEntities);
        Map hisAttachBoMap = HisAttachmentService.transAttachmentsInfo((List)attachMapList, (String)entityNumber);
        Map<Long, List<HisAttachmentBo>> boMap = hisAttachBoMap.values().stream().collect(Collectors.groupingBy(HisAttachmentBo::getId));
        HisVersionReviseParamBo bo = new HisVersionReviseParamBo();
        bo.setReviseDys(dataEntities);
        bo.setEntityNumber(entityNumber);
        bo.setMapHisAttachmentBos(boMap);
        bo.setPreHisAttachmentBos(preAttachmentInfoMap);
        bo.setPersonalDataSyn(true);
        HisVersionReviseService reviseService = HisVersionReviseService.getInstance();
        this.invokeReviseServise(entityNumber, bo, serviceHelper, reviseService);
    }

    private void invokeReviseServise(String entityNumber, HisVersionReviseParamBo bo, HRBaseServiceHelper serviceHelper, HisVersionReviseService service) {
        HisVersionReviseReturnDataBo returnDataBo = service.reviseVersion(bo);
        Map attachmentMap = returnDataBo.getAttachmentMap();
        String attachmentInfo = SerializationUtils.toJsonString((Object)attachmentMap);
        this.operateOption.setVariableValue("revise_attachmentInfo", attachmentInfo);
        this.operateOption.setVariableValue("entityNumber", entityNumber);
        DynamicObject[] returnData = returnDataBo.getReturnData();
        if (returnData != null && returnData.length > 0) {
            serviceHelper.save(returnData);
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs args) {
        super.afterExecuteOperationTransaction(args);
        String jsonString = this.operateOption.getVariableValue("opHisAttachments", null);
        String opHisAttachmentStr = this.operateOption.getVariableValue("revise_attachmentInfo", null);
        if (HRStringUtils.isEmpty((String)jsonString) && HRStringUtils.isEmpty((String)opHisAttachmentStr)) {
            return;
        }
        DynamicObject[] dataEntities = args.getDataEntities();
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(dataEntities[0].getDataEntityType().getName());
        switch (args.getOperationKey()) {
            case "save": {
                if (this.getOption().containsVariable("fromPage")) {
                    HisAttachmentService.uploadReviseAttachment((OperateOption)this.operateOption);
                    return;
                }
                MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)dataEntities[0].getDataEntityType().getName());
                Map allFields = dataEntityType.getAllFields();
                if (!allFields.containsKey("status")) break;
                this.saveRelDyAttachment(jsonString, dataEntities);
                break;
            }
            case "audit": 
            case "disable": 
            case "enable": {
                this.saveRelDyAttachment(jsonString, dataEntities);
                break;
            }
            case "audithisconfirmchange": {
                Arrays.stream(dataEntities).forEach(dataEntity -> {
                    DynamicObject curEffectingDy = HisCommonEntityRepository.getNonLineRelCurEffectingDy((HRBaseServiceHelper)serviceHelper, (Long)dataEntity.getLong("boid"));
                    HisAttachmentService.deleteCurDyAttachments((DynamicObject)curEffectingDy);
                    HisAttachmentService.addDyAttachments((String)jsonString, (long)dataEntity.getLong("id"), (long)dataEntity.getLong("boid"), (String)dataEntity.getDataEntityType().getName());
                });
                break;
            }
        }
    }

    private void saveRelDyAttachment(String jsonString, DynamicObject[] dataEntities) {
        Map attachmentListMap = HisAttachmentService.buildHisAttachmentBoList((String)jsonString);
        Arrays.stream(dataEntities).forEach(dataEntity -> {
            List hisAttachmentBos;
            if (HRStringUtils.equals((String)dataEntity.getString("status"), (String)"C") && (hisAttachmentBos = (List)attachmentListMap.get(dataEntity.getLong("id"))) != null && !hisAttachmentBos.isEmpty()) {
                List relHisAttachmentBos = HisAttachmentService.copyAttachments((Long)dataEntity.getLong("sourcevid"), (String)dataEntity.getDataEntityType().getName(), (List)hisAttachmentBos);
                attachmentListMap.put(dataEntity.getLong("sourcevid"), relHisAttachmentBos);
            }
        });
        attachmentListMap.forEach((id, hisAttachmentBos) -> hisAttachmentBos.forEach(bo -> {
            List attachments = bo.getAttachments();
            AttachmentServiceHelper.upload((String)bo.getEntityNumber(), (Object)id, (String)bo.getAttachKey(), (List)attachments);
        }));
    }

    public void onReturnOperation(ReturnOperationArgs args) {
        String importType;
        super.onReturnOperation(args);
        IOperationResult operationResult = args.getOperationResult();
        if (operationResult.getSuccessPkIds() != null && !operationResult.getSuccessPkIds().isEmpty() && (HisModelImportUtil.isOverride((String)(importType = this.getOption().getVariableValue("importtype", null))) || HisModelImportUtil.isOverrideNew((String)importType))) {
            String currentPkStr = this.getOption().getVariableValue("hisImportPKs", null);
            if (HRStringUtils.isEmpty((String)currentPkStr)) {
                return;
            }
            List currentPks = (List)SerializationUtils.fromJsonString((String)currentPkStr, List.class);
            operationResult.getSuccessPkIds().addAll(currentPks);
        }
    }

    private void handlePersonalImportData(BeforeOperationArgs args) {
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)args.getDataEntities()[0].getDataEntityType().getName());
        Map allFields = dataEntityType.getAllFields();
        if (allFields.containsKey("createorg") && allFields.containsKey("useorg")) {
            DynamicObject[] dataEntities = args.getDataEntities();
            Arrays.stream(dataEntities).forEach(dataEntity -> {
                Long useOrgId = BaseDataCommonService.getLongPropertyFromDynamicObject((DynamicObject)dataEntity, (String)"useorg");
                Long createOrgId = BaseDataCommonService.getLongPropertyFromDynamicObject((DynamicObject)dataEntity, (String)"createorg");
                if (dataEntity.getLong("masterid") != 0L && dataEntity.getPkValue() != null && (Long)dataEntity.getPkValue() != 0L && !useOrgId.equals(0L) && !createOrgId.equals(useOrgId)) {
                    this.hisNonLineTimeService.handlePersonalSaveData(new DynamicObject[]{dataEntity});
                }
            });
        }
    }
}

