/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.opplugin.web.hismodel.tree;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.constants.newhismodel.HisFieldNameConstants;
import kd.hr.hbp.common.constants.newhismodel.HisLineTimeTplConstants;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.hr.hbp.opplugin.web.hismodel.validator.HisLineTimeTreeTplValidator;

public class HisLineTimeTreeTplOp
extends HRDataBaseOp
implements HisFieldNameConstants,
HisLineTimeTplConstants {
    public void onPreparePropertys(PreparePropertysEventArgs args) {
        args.getFieldKeys().clear();
        ArrayList fieldsNameList = Lists.newArrayListWithExpectedSize((int)this.billEntityType.getFields().size());
        DataEntityPropertyCollection collection = this.billEntityType.getProperties();
        collection.forEach(entityProperty -> {
            String propertyName = entityProperty.getName();
            if (!HRStringUtils.equals((String)propertyName, (String)"multilanguagetext") && !propertyName.endsWith("_id")) {
                fieldsNameList.add(propertyName);
            }
        });
        args.getFieldKeys().addAll(fieldsNameList);
    }

    public void onAddValidators(AddValidatorsEventArgs args) {
        super.onAddValidators(args);
        args.addValidator((AbstractValidator)new HisLineTimeTreeTplValidator());
    }

    private void processChangeParent(String longNumberDLM, DynamicObject thisParent, DynamicObject old, DynamicObject current) {
        Object thisId = current.get("id");
        if (thisParent != null && thisParent.getPkValue().equals(thisId)) {
            return;
        }
        boolean isChange = true;
        if (thisParent == null && old.getDynamicObject("parent") == null) {
            isChange = false;
        }
        if (thisParent != null && old.getDynamicObject("parent") != null && thisParent.getPkValue().equals(old.getDynamicObject("parent").getPkValue())) {
            isChange = false;
        }
        if (!isChange) {
            return;
        }
        String selectfield = "number,level,longnumber,parent,fullname,name";
        String pLongNumber = old.getString("longnumber");
        QFilter longFilter = new QFilter("longnumber", "like", (Object)(pLongNumber + longNumberDLM + "%")).and(new QFilter("id", "!=", thisId));
        DynamicObject[] dys = BusinessDataServiceHelper.load((String)this.billEntityType.getName(), (String)selectfield, (QFilter[])new QFilter[]{longFilter}, (String)"level asc");
        HashMap mapLongNumber = Maps.newHashMapWithExpectedSize((int)16);
        HashMap mapFulName = Maps.newHashMapWithExpectedSize((int)16);
        if (dys == null || dys.length == 0) {
            return;
        }
        if (dys[0].getDynamicObject("parent") == null) {
            return;
        }
        if (thisId.equals(dys[0].getDynamicObject("parent").get("id"))) {
            DynamicObject dynamicObject;
            DynamicObject[] dynamicObjectArray = dys;
            int n = dynamicObjectArray.length;
            for (int i = 0; i < n; ++i) {
                DynamicObject dy;
                dynamicObject = dy = dynamicObjectArray[i];
                if (thisParent != null && thisParent.getPkValue().equals(dynamicObject.getPkValue())) {
                    return;
                }
                mapLongNumber.put(dynamicObject.get("id"), dynamicObject.getString("longnumber"));
                mapFulName.put(dynamicObject.get("id"), dynamicObject.getString("fullname"));
            }
            for (DynamicObject dy : dys) {
                String fullName;
                String longNumber;
                dynamicObject = dy;
                DynamicObject tempDyn = (DynamicObject)dynamicObject.get("parent");
                if (tempDyn != null && mapLongNumber.get(tempDyn.get("id")) != null) {
                    longNumber = (String)mapLongNumber.get(tempDyn.get("id")) + longNumberDLM + dynamicObject.getString("number");
                    fullName = (String)mapFulName.get(tempDyn.get("id")) + longNumberDLM + dynamicObject.getString("name");
                } else if (thisParent != null) {
                    longNumber = thisParent.getString("longnumber") + longNumberDLM + current.getString("number") + longNumberDLM + dynamicObject.getString("number");
                    fullName = thisParent.getString("fullname") + longNumberDLM + current.getString("name") + longNumberDLM + dynamicObject.getString("name");
                } else {
                    longNumber = current.getString("number") + longNumberDLM + dynamicObject.getString("number");
                    fullName = current.getString("name") + longNumberDLM + dynamicObject.getString("name");
                }
                if (longNumber.equals(dynamicObject.getString("longnumber")) && fullName.equals(dynamicObject.getString("fullname"))) continue;
                dynamicObject.set("longnumber", (Object)longNumber);
                dynamicObject.set("fullname", (Object)fullName);
                mapLongNumber.put(dynamicObject.get("id"), longNumber);
                mapFulName.put(dynamicObject.get("id"), fullName);
            }
        }
        HRBaseServiceHelper helper = new HRBaseServiceHelper(this.billEntityType.getName());
        helper.save(dys);
    }
}

