/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.opplugin.web.hismodel.validator;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.bd.service.BaseDataCommonService;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.hr.hbp.business.domain.util.HisLineOpUtil;
import kd.hr.hbp.business.domain.util.HisModelEditAuditTool;
import kd.hr.hbp.business.domain.util.HisModelImportUtil;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.cache.HRAppCache;
import kd.hr.hbp.common.cache.IHRAppCache;
import kd.hr.hbp.common.constants.newhismodel.EnumHisDataVersionStatus;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRMapUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.tuple.Pair;

public class HisLineImportValidator
extends AbstractValidator {
    private static final Log LOGGER = LogFactory.getLog(HisLineImportValidator.class);
    private final String extParam;

    public HisLineImportValidator(String extParam) {
        this.extParam = extParam;
    }

    public void validate() {
        String importType;
        String hisCurrentNumberCode = this.getOption().getVariableValue("hisCurrentNumberCode", null);
        if (HRStringUtils.isNotEmpty((String)hisCurrentNumberCode)) {
            IDataEntityType dataEntityType = this.getDataEntities()[0].getDataEntity().getDataEntityType();
            String numberField = ((BillEntityType)dataEntityType).getBillNo();
            int numberIndex = ((IDataEntityProperty)dataEntityType.getProperties().get((Object)numberField)).getOrdinal();
            String numberFieldChanged = this.getOption().getVariableValue("hisCurrentNumberCodeIsChanged");
            this.getDataEntities()[0].getDataEntity().set(numberField, (Object)hisCurrentNumberCode);
            if (HRStringUtils.equals((String)numberFieldChanged, (String)"false")) {
                this.getDataEntities()[0].getDataEntity().getDataEntityState().setBizChanged(numberIndex, false);
            }
        }
        if (HRStringUtils.isEmpty((String)(importType = this.getOption().getVariableValue("importtype", null)))) {
            return;
        }
        long startTime = System.currentTimeMillis();
        HashSet newDataPks = Sets.newHashSetWithExpectedSize((int)16);
        this.handleNewDataForOverrideNewImport(importType, newDataPks);
        Set<Object> personDataIds = this.validatePersonal(importType);
        this.copyDataForImport(importType);
        this.validateImportPolicy(importType, newDataPks, personDataIds);
        this.validateEffStartDate(importType, newDataPks, personDataIds);
        LOGGER.info("hisImport_HisLineImportValidator, operate: {}, time: {}, dataCount: {}", new Object[]{this.getOperateKey(), System.currentTimeMillis() - startTime, this.dataEntities.length});
    }

    private void handleNewDataForOverrideNewImport(String importType, Set<Object> newDataPks) {
        if (!"overridenew".equals(importType)) {
            return;
        }
        for (ExtendedDataEntity dataEntity : this.getDataEntities()) {
            DynamicObject data = dataEntity.getDataEntity();
            if (data.getDataEntityState().getFromDatabase()) continue;
            data.set("iscurrentversion", (Object)Boolean.TRUE);
            newDataPks.add(data.getPkValue());
        }
    }

    private void copyDataForImport(String importType) {
        String cacheKey;
        if (HisLineImportValidator.isNewOrDel(importType)) {
            return;
        }
        DataEntityPropertyCollection properties = this.getDataEntities()[0].getDataEntity().getDataEntityType().getProperties();
        boolean hasStatus = HisModelImportUtil.hasStatus((DataEntityPropertyCollection)properties);
        boolean hasEnable = HisModelImportUtil.hasEnable((DataEntityPropertyCollection)properties);
        Pair dataEntities = this.getDataEntities();
        IDataEntityType dataEntityType = dataEntities[0].getDataEntity().getDataEntityType();
        String entityNumber = dataEntityType.getName();
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityNumber);
        IHRAppCache ihrAppCache = HRAppCache.get((String)"hbp");
        Boolean needAudit = (Boolean)ihrAppCache.get(cacheKey = String.format("HisImportNeedAudit_%s_%s", entityNumber, HisModelImportUtil.getImportCacheKeySuffix()), Boolean.class);
        if (needAudit == null) {
            needAudit = HisModelEditAuditTool.getNeedAuditForOp((IDataEntityType)dataEntityType);
        }
        Map enableMap = new HashMap(0);
        Map statusMap = new HashMap(0);
        if (hasEnable || hasStatus) {
            Pair dbEnableAndStatus = HisModelImportUtil.getDbEnableAndStatus((boolean)hasStatus, (boolean)hasEnable, (HRBaseServiceHelper)serviceHelper, () -> HisLineImportValidator.lambda$copyDataForImport$1((ExtendedDataEntity[])dataEntities));
            enableMap = (Map)dbEnableAndStatus.getLeft();
            statusMap = (Map)dbEnableAndStatus.getRight();
        }
        for (Pair extendedDataEntity : dataEntities) {
            boolean curNonAudited;
            boolean nonEnabling;
            DynamicObject curDyn = extendedDataEntity.getDataEntity();
            boolean isUpd = curDyn.getDataEntityState().getFromDatabase();
            if (!isUpd) continue;
            boolean isAudited = hasStatus && HRStringUtils.equals((String)"C", (String)MapUtils.getString(statusMap, (Object)curDyn.get("id")));
            boolean bl = nonEnabling = hasEnable && !HRStringUtils.equals((String)"10", (String)MapUtils.getString(enableMap, (Object)curDyn.get("id")));
            if (!isAudited || !nonEnabling) continue;
            String curDynStatus = curDyn.getString("status");
            String curDynEnable = curDyn.getString("enable");
            boolean bl2 = curNonAudited = StringUtils.equals((CharSequence)curDynStatus, (CharSequence)"A") || StringUtils.equals((CharSequence)curDynStatus, (CharSequence)"B");
            if (needAudit.booleanValue() && curNonAudited) {
                if (StringUtils.equals((CharSequence)curDynEnable, (CharSequence)"10")) {
                    this.addFatalErrorMessage((ExtendedDataEntity)extendedDataEntity, ResManager.loadKDString((String)"\u6570\u636e\u5df2\u8bb0\u5f55\u5386\u53f2\uff0c\u4e0d\u5141\u8bb8\u53d8\u66f4\u6570\u636e\u72b6\u6001\uff0c\u4e5f\u4e0d\u5141\u8bb8\u53d8\u66f4\u4f7f\u7528\u72b6\u6001\u4e3a\u201c\u5f85\u542f\u7528\u201d\u3002", (String)"HisNonLineImportValidator_2", (String)"hrmp-hbp-opplugin", (Object[])new Object[0]));
                    continue;
                }
                this.addFatalErrorMessage((ExtendedDataEntity)extendedDataEntity, ResManager.loadKDString((String)"\u6570\u636e\u5df2\u8bb0\u5f55\u5386\u53f2\uff0c\u4e0d\u5141\u8bb8\u53d8\u66f4\u6570\u636e\u72b6\u6001\u3002", (String)"HisNonLineImportValidator_3", (String)"hrmp-hbp-opplugin", (Object[])new Object[0]));
                continue;
            }
            if (!StringUtils.equals((CharSequence)curDynEnable, (CharSequence)"10")) continue;
            this.addFatalErrorMessage((ExtendedDataEntity)extendedDataEntity, ResManager.loadKDString((String)"\u6570\u636e\u5df2\u8bb0\u5f55\u5386\u53f2\uff0c\u4e0d\u5141\u8bb8\u53d8\u66f4\u4f7f\u7528\u72b6\u6001\u4e3a\u201c\u5f85\u542f\u7528\u201d\u3002", (String)"HisNonLineImportValidator_4", (String)"hrmp-hbp-opplugin", (Object[])new Object[0]));
        }
        boolean isBaseDataCtrl = this.isBdBaseData();
        for (ExtendedDataEntity dataEntity : this.getDataEntities()) {
            String currentDataEnable;
            DynamicObject data = dataEntity.getDataEntity();
            if (!data.getDataEntityState().getFromDatabase()) continue;
            if (isBaseDataCtrl) {
                Long useOrgId = BaseDataCommonService.getLongPropertyFromDynamicObject((DynamicObject)data, (String)"useorg");
                Long createOrgId = BaseDataCommonService.getLongPropertyFromDynamicObject((DynamicObject)data, (String)"createorg");
                if (data.getLong("masterid") != 0L && data.getPkValue() != null && (Long)data.getPkValue() != 0L && !useOrgId.equals(0L) && !createOrgId.equals(useOrgId)) continue;
            }
            Set ignoreFields = Stream.of("bsled", "hisversion", "versionsource").collect(Collectors.toSet());
            if (hasEnable && HRStringUtils.equals((String)(currentDataEnable = MapUtils.getString(enableMap, (Object)data.get("id"))), (String)"10")) continue;
            Long boId = data.getLong("boid");
            if (hasStatus) {
                if (HRStringUtils.equals((String)"C", (String)MapUtils.getString(statusMap, (Object)data.get("id")))) {
                    data = HisLineOpUtil.copyTempVersionDy((String)this.getEntityKey(), (DynamicObject)data, ignoreFields);
                    data.set("id", (Object)boId);
                }
            } else {
                data = HisLineOpUtil.copyTempVersionDy((String)this.getEntityKey(), (DynamicObject)data, ignoreFields);
                data.set("id", (Object)boId);
            }
            boolean hasMasterId = properties.containsKey((Object)"masterid");
            if (isBaseDataCtrl && hasMasterId) {
                data.set("masterid", (Object)boId);
            }
            if (hasEnable) {
                String currentDataEnable2 = data.getString("enable");
                this.getOption().setVariableValue("hisPageEnable", currentDataEnable2);
            }
            dataEntity.setDataEntity(data);
        }
    }

    private Set<Object> validatePersonal(String importType) {
        HashSet personDataIds = Sets.newHashSetWithExpectedSize((int)this.getDataEntities().length);
        if (HisLineImportValidator.isNewOrDel(importType)) {
            return personDataIds;
        }
        if (!this.isBdBaseData()) {
            return personDataIds;
        }
        HashSet beEffDataIds = Sets.newHashSetWithExpectedSize((int)this.getDataEntities().length);
        List personalDataCol = Arrays.stream(this.getDataEntities()).filter(data -> {
            boolean isPersonal;
            Long useOrgId = BaseDataCommonService.getLongPropertyFromDynamicObject((DynamicObject)data.getDataEntity(), (String)"useorg");
            Long createOrgId = BaseDataCommonService.getLongPropertyFromDynamicObject((DynamicObject)data.getDataEntity(), (String)"createorg");
            boolean bl = isPersonal = data.getDataEntity().getLong("masterid") != 0L && data.getBillPkId() != null && (Long)data.getBillPkId() != 0L && !useOrgId.equals(0L) && !createOrgId.equals(useOrgId);
            if (isPersonal) {
                personDataIds.add(data.getBillPkId());
                if (HRStringUtils.equals((String)data.getDataEntity().getString("datastatus"), (String)EnumHisDataVersionStatus.TO_BE_EFFECT.getStatus())) {
                    beEffDataIds.add(data.getBillPkId());
                }
            }
            return isPersonal;
        }).map(ExtendedDataEntity::getDataEntity).collect(Collectors.toList());
        if (personalDataCol.isEmpty()) {
            return personDataIds;
        }
        this.validatePersonalEffStartDate(personDataIds, beEffDataIds);
        return personDataIds;
    }

    private void validatePersonalEffStartDate(Set<Object> personDataIds, Set<Object> beEffDataIds) {
        HashMap beEffDateMap = Maps.newHashMapWithExpectedSize((int)beEffDataIds.size());
        if (beEffDataIds.size() > 0) {
            HRBaseServiceHelper helper = new HRBaseServiceHelper(this.getEntityKey());
            DynamicObjectCollection beEffDys = helper.queryOriginalCollection("id, firstbsed", new QFilter[]{new QFilter("id", "in", beEffDataIds)});
            for (DynamicObject beEffDy : beEffDys) {
                beEffDateMap.put(beEffDy.get("id"), beEffDy.getDate("firstbsed"));
            }
        }
        long current = System.currentTimeMillis();
        long dayTime = current - (current + (long)TimeZone.getDefault().getRawOffset()) % 86400000L;
        Date today = new Date(dayTime);
        for (ExtendedDataEntity dataEntity : this.getDataEntities()) {
            Object billPkId = dataEntity.getBillPkId();
            if (!personDataIds.contains(billPkId)) continue;
            Date date = dataEntity.getDataEntity().getDate("bsed");
            if (beEffDataIds.contains(billPkId)) {
                Date beEffDate = (Date)beEffDateMap.get(billPkId);
                if (beEffDate == null || beEffDate.getTime() == date.getTime()) continue;
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u4e2a\u6027\u5316\u6570\u636e\u7684\u751f\u6548\u65e5\u671f\u5e94\u665a\u4e8e\u6216\u7b49\u4e8e\u539f\u59cb\u6570\u636e\u7684\u751f\u6548\u65e5\u671f\uff1a%s\u3002", (String)"HisLineImportValidator_04", (String)"hrmp-hbp-opplugin", (Object[])new Object[0]), HRDateTimeUtils.getUserSettingFormat().format(beEffDate)));
                continue;
            }
            if (date != null && today.getTime() == date.getTime()) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4e2a\u6027\u5316\u6570\u636e\u7684\u751f\u6548\u65e5\u671f\u4ec5\u5141\u8bb8\u586b\u5199\u5f53\u524d\u65e5\u671f\u3002", (String)"HisLineImportValidator_03", (String)"hrmp-hbp-opplugin", (Object[])new Object[0]));
        }
    }

    private void validateEffStartDate(String importType, Set<Object> newDataPks, Set<Object> personDataIds) {
        if (HisLineImportValidator.isNewOrDel(importType)) {
            return;
        }
        ExtendedDataEntity[] dataCol = this.getDataEntities();
        Set boIds = Arrays.stream(dataCol).map(data -> data.getValue("boid")).collect(Collectors.toSet());
        HRBaseServiceHelper helper = new HRBaseServiceHelper(this.getEntityKey());
        QFilter qFilter = new QFilter("id", "in", boIds);
        DynamicObjectCollection dys = helper.queryOriginalCollection("id, bsed, iscurrentversion, datastatus", new QFilter[]{qFilter});
        Map<Object, Date> currentMap = dys.stream().collect(Collectors.toMap(dy -> dy.get("id"), dy -> dy.getDate("bsed")));
        for (ExtendedDataEntity dy2 : dataCol) {
            Date effStartDate;
            DynamicObject dataEntity;
            Date currentEffStartDate;
            if (newDataPks.contains(dy2.getBillPkId()) || personDataIds.contains(dy2.getBillPkId()) || (currentEffStartDate = currentMap.get((dataEntity = dy2.getDataEntity()).get("boid"))) == null || EnumHisDataVersionStatus.isTemp((String)dataEntity.getString("datastatus")) && dataEntity.getBoolean("iscurrentversion") || (effStartDate = (Date)dy2.getValue("bsed")) == null || currentEffStartDate.getTime() <= effStartDate.getTime()) continue;
            this.addErrorMessage(dy2, String.format(ResManager.loadKDString((String)"\u53d8\u66f4\u751f\u6548\u65e5\u671f\u5e94\u665a\u4e8e\u6216\u7b49\u4e8e\u5f53\u524d\u751f\u6548\u65e5\u671f\uff1a%s\u3002", (String)"HisLineImportValidator_01", (String)"hrmp-hbp-opplugin", (Object[])new Object[0]), HRDateTimeUtils.formatUserSettingFromDate((Date)currentEffStartDate)));
        }
    }

    private void validateImportPolicy(String importType, Set<Object> newDataPks, Set<Object> personDataIds) {
        Map extParamMap;
        if (HisLineImportValidator.isNewOrDel(importType)) {
            return;
        }
        String updateType = null;
        if (StringUtils.isNotBlank((CharSequence)this.extParam) && !HRMapUtils.isEmpty((Map)(extParamMap = (Map)SerializationUtils.fromJsonString((String)this.extParam, Map.class)))) {
            updateType = (String)extParamMap.get("updatetype");
        }
        if (StringUtils.isBlank(updateType)) {
            String entityId = this.getEntityKey();
            IHRAppCache appCache = HRAppCache.get((String)"hbp");
            String cacheKey = String.format("HRHisModelImport_%s_%s_UpdateType", entityId, RequestContext.get().getCurrUserId());
            updateType = (String)appCache.get(cacheKey, String.class);
        }
        if (HRStringUtils.equals(updateType, (String)"1")) {
            return;
        }
        ExtendedDataEntity[] dataCol = this.getDataEntities();
        List idList = Arrays.stream(dataCol).filter(data -> !newDataPks.contains(data.getBillPkId())).map(ExtendedDataEntity::getBillPkId).collect(Collectors.toList());
        if (idList.isEmpty()) {
            return;
        }
        QFilter boIdFilter = new QFilter("boid", "in", idList);
        QFilter statusFilter = new QFilter("datastatus", "=", (Object)EnumHisDataVersionStatus.TO_BE_EFFECT.getStatus());
        QFilter versionFilter = new QFilter("iscurrentversion", "=", (Object)Character.valueOf('0'));
        QFilter[] qFilters = new QFilter[]{boIdFilter, statusFilter, versionFilter};
        HRBaseServiceHelper helper = new HRBaseServiceHelper(this.getEntityKey());
        DynamicObjectCollection hisData = helper.queryOriginalCollection("boid, bsed", qFilters);
        Map<Object, List<DynamicObject>> hisDataMap = hisData.stream().collect(Collectors.groupingBy(data -> data.get("boid")));
        if (hisDataMap.isEmpty()) {
            return;
        }
        for (ExtendedDataEntity dy : dataCol) {
            Date effStartDate = dy.getDataEntity().getDate("bsed");
            List<DynamicObject> hisDataList = hisDataMap.get(dy.getBillPkId());
            if (hisDataList == null || hisDataList.isEmpty() || personDataIds.contains(dy.getBillPkId()) || !hisDataList.stream().anyMatch(data -> data.getDate("bsed").getTime() > effStartDate.getTime())) continue;
            this.addErrorMessage(dy, ResManager.loadKDString((String)"\u7cfb\u7edf\u6570\u636e\u5728\u53d8\u66f4\u751f\u6548\u65e5\u671f\u540e\uff0c\u5b58\u5728\u201c\u5f85\u751f\u6548\u201d\u7248\u672c\uff0c\u4e0d\u6267\u884c\u66f4\u65b0\u64cd\u4f5c\u3002", (String)"HisLineImportValidator_02", (String)"hrmp-hbp-opplugin", (Object[])new Object[0]));
        }
    }

    private static boolean isNewOrDel(String importType) {
        return HRStringUtils.equals((String)"new", (String)importType) || HRStringUtils.equals((String)"delete", (String)importType);
    }

    private boolean isBdBaseData() {
        String isBdBaseDataKey;
        IHRAppCache cache = HRAppCache.get((String)"hbp");
        String isBdBaseData = (String)cache.get(isBdBaseDataKey = String.format("HisImportIsBdBaseData_%s_%s", this.getEntityKey(), HisModelImportUtil.getImportCacheKeySuffix()), String.class);
        if (HRStringUtils.isEmpty((String)isBdBaseData)) {
            Boolean isBaseDataCtrl = BaseDataServiceHelper.checkBaseDataCtrl((String)this.getEntityKey());
            isBdBaseData = isBaseDataCtrl != false ? "1" : "0";
        }
        return HRStringUtils.equals((String)isBdBaseData, (String)"1");
    }

    private static /* synthetic */ Set lambda$copyDataForImport$1(ExtendedDataEntity[] dataEntities) {
        return Arrays.stream(dataEntities).map(item -> item.getValue("id")).collect(Collectors.toSet());
    }
}

