/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.opplugin.web.hismodel.validator;

import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.constants.newhismodel.EnumHisDataVersionStatus;
import kd.hr.hbp.common.constants.newhismodel.HisFieldNameConstants;
import kd.hr.hbp.common.constants.newhismodel.HisLineTimeTplConstants;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public class HisLineTimeBdTplValidator
extends AbstractValidator
implements HisFieldNameConstants,
HisLineTimeTplConstants {
    private static final Log LOGGER = LogFactory.getLog(HisLineTimeBdTplValidator.class);

    public void validate() {
        String operation;
        long startTime = System.currentTimeMillis();
        switch (operation = this.getOperateKey()) {
            case "save": 
            case "confirmchange": 
            case "confirmchangenoaudit": {
                this.validMasterEnable();
                break;
            }
        }
        LOGGER.info("hisImport_HisLineTimeBdTplValidator, operate: {}, time: {}, dataCount: {}", new Object[]{operation, System.currentTimeMillis() - startTime, this.dataEntities.length});
    }

    private void validMasterEnable() {
        DynamicObject dataEntity = this.getDataEntities()[0].getDataEntity();
        String hisAction = this.getOption().getVariableValue("his_action", null);
        if (!this.isHisLineVersionChangePage(hisAction, dataEntity)) {
            return;
        }
        HRBaseServiceHelper helper = new HRBaseServiceHelper(this.entityKey);
        Object boId = dataEntity.get("boid");
        DynamicObject currentDy = helper.queryOriginalOne("id, masterid", boId);
        if (Objects.equals(currentDy.get("id"), currentDy.get("masterid"))) {
            return;
        }
        QFilter boIdQFilter = new QFilter("boid", "=", currentDy.get("masterid"));
        QFilter versionQFilter = new QFilter("iscurrentversion", "=", (Object)Character.valueOf('0'));
        QFilter effDateQFilter = new QFilter("bsed", "<=", dataEntity.get("bsled")).and(new QFilter("bsled", ">=", dataEntity.get("bsed")));
        QFilter enableQFilter = new QFilter("enable", "=", (Object)"0");
        QFilter statusFilter = new QFilter("datastatus", "in", Arrays.asList(EnumHisDataVersionStatus.TO_BE_EFFECT.getStatus(), EnumHisDataVersionStatus.EFFECTING.getStatus(), EnumHisDataVersionStatus.INVALIDED.getStatus()));
        DynamicObjectCollection validDataCol = helper.queryOriginalCollection("id, bsed, bsled", new QFilter[]{boIdQFilter, versionQFilter, effDateQFilter, enableQFilter, statusFilter});
        if (validDataCol.isEmpty()) {
            return;
        }
        SimpleDateFormat format = HRDateTimeUtils.getUserSettingFormat();
        StringBuilder tips = new StringBuilder();
        for (DynamicObject dy : validDataCol) {
            Date startDate = dy.getDate("bsed");
            Date endDate = dy.getDate("bsled");
            String startDateStr = format.format(startDate);
            String endDateStr = format.format(endDate);
            tips.append(startDateStr).append('~').append(endDateStr).append('\u3001');
        }
        this.addErrorMessage(this.getDataEntities()[0], String.format(ResManager.loadKDString((String)"\u53d8\u66f4\u5931\u8d25\uff0c\u82e5\u53d8\u66f4\u540e\u6b64\u4e2a\u6027\u5316\u6570\u636e\u5c06\u5728%1$s~%2$s\u7f6e\u4e3a\u201c\u53ef\u7528\u201d\u72b6\u6001\uff0c\u4e0e\u539f\u59cb\u6570\u636e%3$s\u7684\u201c\u7981\u7528\u201d\u72b6\u6001\u51b2\u7a81\uff0c\u4e0d\u5141\u8bb8\u53d8\u66f4\u3002", (String)"HisLineTimeBdTplValidator_02", (String)"hrmp-hbp-opplugin", (Object[])new Object[0]), format.format(dataEntity.get("bsed")), format.format(dataEntity.get("bsled")), tips.substring(0, tips.length() - 1)));
    }

    private boolean isHisLineVersionChangePage(String action, DynamicObject dataEntity) {
        String dataStatus = dataEntity.getString("datastatus");
        return (HRStringUtils.equals((String)action, (String)"open_data_page") || HRStringUtils.equals((String)action, (String)"modify_data_page")) && HRStringUtils.equals((String)dataStatus, (String)EnumHisDataVersionStatus.TEMP.getStatus()) || HRStringUtils.equals((String)action, (String)"open_insert_data_page") || HRStringUtils.equals((String)action, (String)"open_copy_his_data_page");
    }
}

