/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.opplugin.web.hismodel.validator;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.TimeZone;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.application.impl.common.HRLongValueParseService;
import kd.hr.hbp.business.domain.service.impl.newhismodel.HisEffDateCommonService;
import kd.hr.hbp.business.domain.service.impl.newhismodel.HisInitValidateService;
import kd.hr.hbp.business.domain.service.impl.newhismodel.personal.HisPersonalCommonService;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.constants.newhismodel.EnumHisDataVersionStatus;
import kd.hr.hbp.common.constants.newhismodel.EventOperateEnums;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public class HisLineTimeTplValidator
extends AbstractValidator {
    private static final Log LOGGER = LogFactory.getLog(HisLineTimeTplValidator.class);

    public void validate() {
        String operation;
        long startTime = System.currentTimeMillis();
        switch (operation = this.getOperateKey()) {
            case "save": {
                this.validEffDate();
                if (this.getOption().containsVariable("ispersonalizedata") && "1".equals(this.getOption().getVariableValue("ispersonalizedata"))) break;
                this.validInitNoComplete(operation, null);
                break;
            }
            case "his_delete": {
                this.validateDeleteHisOp();
                break;
            }
            case "confirmchange": 
            case "confirmchangenoaudit": {
                String fromFormEdit = this.getOption().getVariableValue("opFromFormEdit", "false");
                HashSet noNeedValidateInit = Sets.newHashSetWithExpectedSize((int)16);
                if (HRStringUtils.equals((String)fromFormEdit, (String)"false")) {
                    this.validateConfirmChangeOp(noNeedValidateInit);
                } else {
                    this.validEffDate();
                }
                this.validInitNoComplete(operation, noNeedValidateInit);
                break;
            }
            case "his_disable": {
                String hisDisableDate = this.getOption().getVariableValue("hisDisableDate", null);
                boolean setDisableDate = true;
                Date disableDate = null;
                if (HRStringUtils.isNotEmpty((String)hisDisableDate)) {
                    try {
                        disableDate = HRDateTimeUtils.parseDate((String)hisDisableDate);
                    }
                    catch (ParseException ex) {
                        LOGGER.error((Throwable)ex);
                    }
                } else {
                    setDisableDate = false;
                }
                if (!this.validateIsDisableDataOp()) break;
                this.validateDisableDataOp(setDisableDate, disableDate);
                this.validateAlreadyDisabled(setDisableDate, disableDate);
                break;
            }
            case "enable": {
                this.validateIsEnableDataOp();
                break;
            }
            case "unaudit": {
                this.validateUnAuditDataOp();
                break;
            }
            case "insertdata_his": {
                this.validInitNoComplete(operation, null);
                break;
            }
        }
        LOGGER.info("hisImport_HisLineTimeTplValidator, operate: {}, time: {}, dataCount: {}", new Object[]{operation, System.currentTimeMillis() - startTime, this.dataEntities.length});
    }

    private void validEffDate() {
        Date currentStartDate;
        DynamicObject dataEntity = this.getDataEntities()[0].getDataEntity();
        Date effStartDate = dataEntity.getDate("bsed");
        String hisAction = this.getOption().getVariableValue("his_action", null);
        if (!HRStringUtils.equals((String)hisAction, (String)"open_insert_data_page")) {
            this.validatePersonalDate(effStartDate);
            return;
        }
        String currentStartDateStr = this.getOption().getVariableValue("currentDataEffDate", null);
        if (HRStringUtils.isEmpty((String)currentStartDateStr)) {
            Long boId = dataEntity.getLong("boid");
            currentStartDate = HisEffDateCommonService.getInstance().getCurrentVersionEffStartDate(dataEntity.getDataEntityType().getName(), boId);
            if (currentStartDate == null) {
                return;
            }
            currentStartDateStr = HRDateTimeUtils.format((Date)effStartDate, (String)"yyyy-MM-dd");
        } else {
            try {
                currentStartDate = HRDateTimeUtils.parseDate((String)currentStartDateStr);
            }
            catch (ParseException ex) {
                LOGGER.error((Throwable)ex);
                return;
            }
        }
        if (currentStartDate == null) {
            return;
        }
        if (effStartDate.getTime() < currentStartDate.getTime()) {
            this.addErrorMessage(this.getDataEntities()[0], String.format(ResManager.loadKDString((String)"\u53d8\u66f4\u751f\u6548\u65e5\u671f\u5e94\u665a\u4e8e\u6216\u7b49\u4e8e\u5f53\u524d\u751f\u6548\u65e5\u671f\uff1a%s\u3002", (String)"HisLineTimeTplValidator_08", (String)"hrmp-hbp-opplugin", (Object[])new Object[0]), HRDateTimeUtils.formatUserSettingFromString((String)currentStartDateStr)));
        }
    }

    private void validatePersonalDate(Date effStartDate) {
        DynamicObject dataEntity = this.getDataEntities()[0].getDataEntity();
        Date personalDate = HisPersonalCommonService.getInstance().queryPersonalDate(dataEntity.getDataEntityType().getName(), dataEntity.get("boid"));
        if (personalDate == null) {
            return;
        }
        if (effStartDate.getTime() < personalDate.getTime()) {
            this.addErrorMessage(this.getDataEntities()[0], String.format(ResManager.loadKDString((String)"\u751f\u6548\u65e5\u671f\u5e94\u665a\u4e8e\u6216\u7b49\u4e8e\u7ef4\u62a4\u4e2a\u6027\u5316\u6570\u636e\u7684\u65e5\u671f\uff1a%s\u3002", (String)"HisLineTimeTplValidator_09", (String)"hrmp-hbp-opplugin", (Object[])new Object[0]), HRDateTimeUtils.getUserSettingFormat().format(personalDate)));
        }
    }

    private void validateDeleteHisOp() {
        ExtendedDataEntity[] dataCol;
        for (ExtendedDataEntity dy : dataCol = this.getDataEntities()) {
            String dataStatus = dy.getDataEntity().getString("datastatus");
            if (HRStringUtils.equals((String)dataStatus, (String)EventOperateEnums.CHANGE_BEFORE_STATUS_TEMP.getValue())) continue;
            this.addErrorMessage(dy, ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25\uff0c\u53ea\u5141\u8bb8\u5220\u9664\u201c\u6682\u5b58\u201d\u6570\u636e\u7248\u672c\u3002", (String)"HisLineTimeTplValidator_01", (String)"hrmp-hbp-opplugin", (Object[])new Object[0]));
        }
    }

    private void validateConfirmChangeOp(Set<Long> noNeedValidateInit) {
        ExtendedDataEntity[] dataCol;
        for (ExtendedDataEntity dy : dataCol = this.getDataEntities()) {
            String dataStatus = dy.getDataEntity().getString("datastatus");
            if (HRStringUtils.equals((String)(dataStatus = Optional.ofNullable(dataStatus).orElseGet(() -> ((EventOperateEnums)EventOperateEnums.CHANGE_BEFORE_STATUS_TEMP).getValue())), (String)EventOperateEnums.CHANGE_BEFORE_STATUS_TEMP.getValue())) continue;
            this.addErrorMessage(dy, ResManager.loadKDString((String)"\u786e\u8ba4\u53d8\u66f4\u5931\u8d25\uff0c\u4ec5\u652f\u6301\u64cd\u4f5c\u201c\u6682\u5b58\u201d\u6570\u636e\u7248\u672c\u3002", (String)"HisLineTimeTplValidator_02", (String)"hrmp-hbp-opplugin", (Object[])new Object[0]));
            Object pkId = dy.getBillPkId();
            if (HRObjectUtils.isEmpty((Object)pkId)) continue;
            noNeedValidateInit.add(HRLongValueParseService.getInstance().parseLong(pkId));
        }
    }

    private void validateUnAuditDataOp() {
        ExtendedDataEntity[] dataCol = this.getDataEntities();
        DataEntityPropertyCollection properties = dataCol[0].getDataEntity().getDataEntityType().getProperties();
        if (!properties.containsKey((Object)"status") || !properties.containsKey((Object)"enable")) {
            return;
        }
        for (ExtendedDataEntity dataEntity : dataCol) {
            DynamicObject dynamicObject = dataEntity.getDataEntity();
            String status = dynamicObject.getString("status");
            String enable = dynamicObject.getString("enable");
            if (!HRStringUtils.equals((String)status, (String)"C") || !HRStringUtils.equals((String)enable, (String)"1")) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u53cd\u5ba1\u6838\u5931\u8d25\uff0c\u6570\u636e\u5df2\u8bb0\u5f55\u5386\u53f2\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"HisLineTimeTplValidator_06", (String)"hrmp-hbp-opplugin", (Object[])new Object[0]));
        }
    }

    private boolean validateIsDisableDataOp() {
        ExtendedDataEntity[] dataCol = this.getDataEntities();
        if (dataCol != null && dataCol.length == 1) {
            ExtendedDataEntity dataEntity = dataCol[0];
            String entityNumber = dataEntity.getDataEntity().getDataEntityType().getName();
            DynamicObject dynamicObject = dataEntity.getDataEntity();
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityNumber);
            String pageEnable = dynamicObject.getString("enable");
            DynamicObject dy = serviceHelper.queryOne("enable", (Object)dynamicObject.getLong("boid"));
            String enable = dy.getString("enable");
            if ("0".equals(enable) && !"0".equals(pageEnable)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e3a\u7981\u7528\u72b6\u6001\u3002", (String)"HisLineTimeTplValidator_11", (String)"hrmp-hbp-opplugin", (Object[])new Object[0]));
                return false;
            }
        }
        return true;
    }

    private void validateIsEnableDataOp() {
        QFilter isCurrentFilter;
        QFilter qFilter;
        ExtendedDataEntity[] dataCol = this.getDataEntities();
        if (dataCol == null || dataCol.length == 0) {
            return;
        }
        HashSet<Long> boIdSet = new HashSet<Long>(dataCol.length);
        HashMap<Long, ExtendedDataEntity> dataEntityMap = new HashMap<Long, ExtendedDataEntity>(dataCol.length);
        for (ExtendedDataEntity dataEntity : dataCol) {
            DynamicObject dynamicObject = dataEntity.getDataEntity();
            Long boId = dynamicObject.getLong("boid");
            boIdSet.add(boId);
            dataEntityMap.put(boId, dataEntity);
        }
        if (boIdSet == null || boIdSet.size() == 0) {
            return;
        }
        String entityNumber = dataCol[0].getDataEntity().getDataEntityType().getName();
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityNumber);
        DynamicObject[] dynamicObjects = serviceHelper.query("boid,enable", new QFilter[]{qFilter = new QFilter("boid", "in", boIdSet), isCurrentFilter = new QFilter("iscurrentversion", "=", (Object)Character.valueOf('1'))});
        if (dynamicObjects == null || dynamicObjects.length != dataCol.length) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6240\u9009\u6570\u636e\u6761\u6570\u4e0e\u6570\u636e\u5e93\u4e2dBO\u6570\u636e\u6761\u6570\u4e0d\u76f8\u540c\u3002", (String)"HisLineTimeTplValidator_13", (String)"hrmp-hbp-opplugin", (Object[])new Object[0]));
        }
        for (DynamicObject dy : dynamicObjects) {
            String enable = dy.getString("enable");
            Long boId = dy.getLong("boid");
            if (!"1".equals(enable)) continue;
            ExtendedDataEntity dataEntity = (ExtendedDataEntity)dataEntityMap.get(boId);
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e3a\u542f\u7528\u72b6\u6001\u3002", (String)"HisLineTimeTplValidator_12", (String)"hrmp-hbp-opplugin", (Object[])new Object[0]));
        }
    }

    private void validateDisableDataOp(boolean setDisableDate, Date disableDate) {
        ExtendedDataEntity[] dataCol = this.getDataEntities();
        Date today = new Date();
        if (disableDate == null) {
            long current = System.currentTimeMillis();
            long dayTime = current - (current + (long)TimeZone.getDefault().getRawOffset()) % 86400000L;
            today = new Date(dayTime);
        }
        for (ExtendedDataEntity dataEntity : dataCol) {
            DynamicObject dynamicObject = dataEntity.getDataEntity();
            Date effStartDate = dynamicObject.getDate("bsed");
            if (EnumHisDataVersionStatus.TEMP.getStatus().equals(dynamicObject.getString("datastatus")) || effStartDate == null) continue;
            if (!setDisableDate || disableDate == null) {
                disableDate = HRStringUtils.equals((String)dynamicObject.getString("datastatus"), (String)EnumHisDataVersionStatus.TO_BE_EFFECT.getStatus()) ? dynamicObject.getDate("bsed") : today;
            }
            if (disableDate.getTime() < effStartDate.getTime()) {
                if (EnumHisDataVersionStatus.TO_BE_EFFECT.getStatus().equals(dynamicObject.getString("datastatus"))) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7981\u7528\u5931\u8d25\uff0c\u7981\u7528\u65e5\u671f\u65e9\u4e8e\u6b64\u6570\u636e\u7684\u751f\u6548\u65e5\u671f\uff1a%s\u3002", (String)"HisLineTimeTplValidator_05", (String)"hrmp-hbp-opplugin", (Object[])new Object[0]), HRDateTimeUtils.formatUserSettingFromDate((Date)effStartDate)));
                    continue;
                }
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7981\u7528\u5931\u8d25\uff0c\u7981\u7528\u65e5\u671f\u65e9\u4e8e\u6b64\u6570\u636e\u7684\u5f53\u524d\u751f\u6548\u4e2d\u6570\u636e\u7248\u672c\u7684\u751f\u6548\u65e5\u671f\uff1a%s\u3002", (String)"HisLineTimeTplValidator_04", (String)"hrmp-hbp-opplugin", (Object[])new Object[0]), HRDateTimeUtils.formatUserSettingFromDate((Date)effStartDate)));
                continue;
            }
            Date personalDate = HisPersonalCommonService.getInstance().queryPersonalDate(dynamicObject.getDataEntityType().getName(), dynamicObject.get("boid"));
            if (personalDate == null) {
                return;
            }
            if (effStartDate.getTime() >= personalDate.getTime()) continue;
            this.addErrorMessage(this.getDataEntities()[0], String.format(ResManager.loadKDString((String)"\u7981\u7528\u65e5\u671f\u5e94\u665a\u4e8e\u6216\u7b49\u4e8e\u7ef4\u62a4\u4e2a\u6027\u5316\u6570\u636e\u7684\u65e5\u671f\uff1a%s\u3002", (String)"HisLineTimeTplValidator_10", (String)"hrmp-hbp-opplugin", (Object[])new Object[0]), HRDateTimeUtils.getUserSettingFormat().format(personalDate)));
        }
    }

    private void validateAlreadyDisabled(boolean setDisableDate, Date disableDate) {
        if (!setDisableDate || disableDate == null) {
            return;
        }
        ExtendedDataEntity[] dataCol = this.getDataEntities();
        String entityNum = dataCol[0].getDataEntity().getDataEntityType().getName();
        HRBaseServiceHelper helper = new HRBaseServiceHelper(entityNum);
        Set ids = Arrays.stream(dataCol).map(data -> data.getDataEntity().get("boid")).collect(Collectors.toSet());
        QFilter boIdQFilter = new QFilter("boid", "in", ids);
        QFilter dataStatusQFilter = new QFilter("datastatus", "in", Stream.of(EnumHisDataVersionStatus.TO_BE_EFFECT.getStatus(), EnumHisDataVersionStatus.EFFECTING.getStatus()).collect(Collectors.toSet()));
        QFilter dateQFilter = new QFilter("bsed", "<=", (Object)disableDate).and(new QFilter("bsled", ">=", (Object)disableDate)).or(new QFilter("bsed", ">=", (Object)disableDate));
        HashMap boIdToEnableMap = Maps.newHashMapWithExpectedSize((int)16);
        ExtendedDataEntity[] extendedDataEntityArray = null;
        try (DataSet dataset = helper.queryDataSet(((Object)((Object)this)).getClass().getName() + ".validateFutureDisable", "boid, enable", new QFilter[]{boIdQFilter, dateQFilter, dataStatusQFilter});){
            for (Row row : dataset) {
                Long boId = row.getLong("boid");
                Set enableSet = boIdToEnableMap.getOrDefault(boId, Sets.newHashSetWithExpectedSize((int)16));
                enableSet.add(row.getString("enable"));
                boIdToEnableMap.putIfAbsent(boId, enableSet);
            }
        }
        catch (Throwable object) {
            extendedDataEntityArray = object;
            throw object;
        }
        String disableDateStr = HRDateTimeUtils.getUserSettingFormat().format(disableDate);
        for (ExtendedDataEntity data2 : dataCol) {
            Set enables = (Set)boIdToEnableMap.get(data2.getDataEntity().getLong("boid"));
            if (enables == null || enables.contains("1")) continue;
            this.addErrorMessage(data2, String.format(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u5728%s\u4e4b\u540e\u88ab\u7981\u7528\u3002", (String)"HisLineTimeTplValidator_07", (String)"hrmp-hbp-opplugin", (Object[])new Object[0]), disableDateStr));
        }
    }

    private void validInitNoComplete(String operation, Set<Long> noNeedValidateInit) {
        ExtendedDataEntity[] dataCol = this.getDataEntities();
        if (dataCol == null || dataCol.length == 0) {
            return;
        }
        IDataEntityType dataEntityType = dataCol[0].getDataEntity().getDataEntityType();
        String entityNumber = dataEntityType.getName();
        for (ExtendedDataEntity data : dataCol) {
            Long id = HRLongValueParseService.getInstance().parseLong(data.getBillPkId());
            if (noNeedValidateInit != null && noNeedValidateInit.contains(id)) continue;
            Long boId = HRLongValueParseService.getInstance().parseLong(data.getValue("boid"));
            String errorMsg = HisInitValidateService.getInstance().validInitNoComplete((Date)data.getValue("bsed"), entityNumber, boId, dataEntityType, operation);
            if (!StringUtils.isNotEmpty((CharSequence)errorMsg)) continue;
            this.addErrorMessage(data, errorMsg);
        }
    }
}

