/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.opplugin.web.hismodel.validator;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.property.ParentBasedataProp;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.domain.model.newhismodel.HisBaseBo;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.constants.newhismodel.EnumHisDataVersionStatus;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public class HisLineTimeTreeTplValidator
extends AbstractValidator {
    private static final Log LOGGER = LogFactory.getLog(HisLineTimeTreeTplValidator.class);

    public void validate() {
        String operateKey;
        switch (operateKey = this.getOperateKey()) {
            case "save": 
            case "confirmchange": 
            case "confirmchangenoaudit": {
                this.validateEffDate();
                break;
            }
            case "his_disable": {
                String hisDisableDate = this.getOption().getVariableValue("hisDisableDate", null);
                boolean setDisableDate = true;
                Date disableDate = null;
                if (HRStringUtils.isNotEmpty((String)hisDisableDate)) {
                    try {
                        disableDate = HRDateTimeUtils.parseDate((String)hisDisableDate);
                    }
                    catch (ParseException ex) {
                        LOGGER.error((Throwable)ex);
                    }
                } else {
                    setDisableDate = false;
                }
                HashMap nodeChildrenMap = Maps.newHashMapWithExpectedSize((int)16);
                this.queryChildren(nodeChildrenMap);
                HashMap childrenDisableDateMap = Maps.newHashMapWithExpectedSize((int)16);
                this.validateDisableDataOp(setDisableDate, disableDate, nodeChildrenMap, childrenDisableDateMap);
                break;
            }
        }
    }

    private void queryChildren(Map<Object, DynamicObjectCollection> nodeChildrenMap) {
        String longNumberDLM = this.getLongNumberDLM();
        String number = this.getDataEntities()[0].getDataEntity().getString("number");
        QFilter longNumberQFilter = new QFilter("longnumber", "like", (Object)("%" + number + longNumberDLM + "%"));
        nodeChildrenMap.put(this.getDataEntities()[0].getBillPkId(), null);
        for (int i = 1; i < this.getDataEntities().length; ++i) {
            number = this.getDataEntities()[i].getDataEntity().getString("number");
            longNumberQFilter.or(new QFilter("longnumber", "like", (Object)("%" + number + longNumberDLM + "%")));
            nodeChildrenMap.put(this.getDataEntities()[i].getBillPkId(), null);
        }
        QFilter versionQFilter = new QFilter("iscurrentversion", "=", (Object)Character.valueOf('0'));
        QFilter dataStatusFilter = new QFilter("datastatus", "in", Stream.of(EnumHisDataVersionStatus.EFFECTING.getStatus(), EnumHisDataVersionStatus.TO_BE_EFFECT.getStatus(), EnumHisDataVersionStatus.INVALIDED.getStatus()).collect(Collectors.toSet()));
        HRBaseServiceHelper helper = new HRBaseServiceHelper(this.getEntityKey());
        DynamicObjectCollection versionDys = helper.queryOriginalCollection("boid, longnumber", new QFilter[]{longNumberQFilter, versionQFilter, dataStatusFilter});
        if (versionDys.isEmpty()) {
            return;
        }
        HashMap nodeChildrenBoIdMap = Maps.newHashMapWithExpectedSize((int)nodeChildrenMap.size());
        for (ExtendedDataEntity dataEntity : this.getDataEntities()) {
            number = dataEntity.getDataEntity().getString("number");
            for (DynamicObject versionDy2 : versionDys) {
                String longNumber = versionDy2.getString("longnumber");
                if (!longNumber.contains(number)) continue;
                Set boIds = nodeChildrenBoIdMap.getOrDefault(dataEntity.getBillPkId(), Sets.newHashSetWithExpectedSize((int)16));
                boIds.add(versionDy2.get("boid"));
                nodeChildrenBoIdMap.putIfAbsent(dataEntity.getBillPkId(), boIds);
            }
        }
        Set boIds = versionDys.stream().map(versionDy -> versionDy.get("boid")).collect(Collectors.toSet());
        DynamicObjectCollection children = helper.queryOriginalCollection("id, number, name, bsed, firstbsed, datastatus, iscurrentversion", new QFilter[]{new QFilter("id", "in", boIds)});
        Map<Object, DynamicObject> childrenMap = children.stream().collect(Collectors.toMap(dy -> dy.get("id"), dy -> dy));
        nodeChildrenBoIdMap.forEach((dataId, childrenIds) -> {
            DynamicObjectCollection dys = new DynamicObjectCollection();
            for (Object childrenId : childrenIds) {
                dys.add(childrenMap.get(childrenId));
            }
            nodeChildrenMap.put(dataId, dys);
        });
    }

    private void validateDisableDataOp(boolean setDisableDate, Date disableDate, Map<Object, DynamicObjectCollection> nodeChildrenMap, Map<Object, Date> childrenDisableDateMap) {
        ExtendedDataEntity[] dataCol = this.getDataEntities();
        HisBaseBo hisBo = new HisBaseBo();
        hisBo.setEntityNumber(dataCol[0].getDataEntity().getDataEntityType().getName());
        for (ExtendedDataEntity dataEntity : this.getDataEntities()) {
            DynamicObjectCollection children = nodeChildrenMap.get(dataEntity.getBillPkId());
            DynamicObject dynamicObject = dataEntity.getDataEntity();
            Date effStartDate = dynamicObject.getDate("bsed");
            if (EnumHisDataVersionStatus.TEMP.getStatus().equals(dynamicObject.getString("datastatus")) || effStartDate == null) continue;
            if (!setDisableDate || disableDate == null) {
                disableDate = HRStringUtils.equals((String)dynamicObject.getString("datastatus"), (String)EnumHisDataVersionStatus.TO_BE_EFFECT.getStatus()) ? dynamicObject.getDate("bsed") : this.getToday();
            }
            if (disableDate.getTime() < effStartDate.getTime()) {
                if (EnumHisDataVersionStatus.TO_BE_EFFECT.getStatus().equals(dynamicObject.getString("datastatus"))) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7981\u7528\u5931\u8d25\uff0c\u7981\u7528\u65e5\u671f\u65e9\u4e8e\u6b64\u6570\u636e\u7684\u751f\u6548\u65e5\u671f\uff1a%s\u3002", (String)"HisLineTimeTreeTplValidator_02", (String)"hrmp-hbp-opplugin", (Object[])new Object[0]), HRDateTimeUtils.getUserSettingFormat().format(effStartDate)));
                } else {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7981\u7528\u5931\u8d25\uff0c\u7981\u7528\u65e5\u671f\u65e9\u4e8e\u6b64\u6570\u636e\u7684\u5f53\u524d\u751f\u6548\u4e2d\u6570\u636e\u7248\u672c\u7684\u751f\u6548\u65e5\u671f\uff1a%s\u3002", (String)"HisLineTimeTreeTplValidator_03", (String)"hrmp-hbp-opplugin", (Object[])new Object[0]), HRDateTimeUtils.getUserSettingFormat().format(effStartDate)));
                }
            }
            for (DynamicObject child : children) {
                childrenDisableDateMap.put(child.get("id"), disableDate);
                effStartDate = child.getDate("bsed");
                if (disableDate.getTime() >= effStartDate.getTime()) continue;
                if (EnumHisDataVersionStatus.TO_BE_EFFECT.getStatus().equals(child.getString("datastatus"))) {
                    childrenDisableDateMap.put(child.get("id"), effStartDate);
                    continue;
                }
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7981\u7528\u5931\u8d25\uff0c\u7981\u7528\u65e5\u671f\u65e9\u4e8e\u5b50\u8282\u70b9\u201c%1$s\u201d\u7684\u5f53\u524d\u751f\u6548\u4e2d\u6570\u636e\u7248\u672c\u7684\u751f\u6548\u65e5\u671f\uff1a%2$s\u3002", (String)"HisLineTimeTreeTplValidator_04", (String)"hrmp-hbp-opplugin", (Object[])new Object[0]), child.getString("name"), HRDateTimeUtils.getUserSettingFormat().format(effStartDate)));
            }
        }
    }

    private void validateEffDate() {
        ExtendedDataEntity[] dataEntities;
        for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
            DynamicObject dynamicObject = dataEntity.getDataEntity();
            DynamicObject parent = (DynamicObject)dynamicObject.get("parent");
            if (parent == null) continue;
            ILocaleString name = parent.getLocaleString("name");
            Date parentStartDate = parent.getDate("bsed");
            Date currentStartDate = dynamicObject.getDate("bsed");
            if (currentStartDate.getTime() >= parentStartDate.getTime()) continue;
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u6709\u6548\u671f\u5185\uff0c\u4e0a\u7ea7\u201c%s\u201d\u4e0d\u5b58\u5728\u3002", (String)"HisLineTimeTreeTplValidator_01", (String)"hrmp-hbp-opplugin", (Object[])new Object[0]), name));
        }
    }

    private Date getToday() {
        long current = System.currentTimeMillis();
        long dayTime = current - (current + (long)TimeZone.getDefault().getRawOffset()) % 86400000L;
        Date today = new Date(dayTime);
        return today;
    }

    private String getLongNumberDLM() {
        String longNumberDLM = ".";
        IDataEntityProperty parent = (IDataEntityProperty)this.getDataEntities()[0].getDataEntity().getDataEntityType().getProperties().get((Object)"parent");
        if (parent != null) {
            longNumberDLM = ((ParentBasedataProp)parent).getLongNumberDLM();
        }
        return longNumberDLM;
    }
}

