/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.opplugin.web.hismodel.validator;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.domain.model.newhismodel.HisVersionReviseFailDataBo;
import kd.hr.hbp.business.domain.model.newhismodel.HisVersionReviseResultBo;
import kd.hr.hbp.business.domain.service.impl.newhismodel.HisReviseValidateService;
import kd.hr.hbp.common.api.HrApiResponse;

public class HisReviseSaveValidator
extends AbstractValidator {
    private static final Log LOGGER = LogFactory.getLog(HisReviseSaveValidator.class);

    public void validate() {
        String fromPage;
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        String operateKey = this.getOperateKey();
        DynamicObject[] dys = Arrays.stream(dataEntities).map(ExtendedDataEntity::getDataEntity).collect(Collectors.toList()).toArray(new DynamicObject[dataEntities.length]);
        if (operateKey.equals("save") && this.getOption().containsVariable("fromPage") && "revise".equals(fromPage = this.getOption().getVariableValue("fromPage"))) {
            HrApiResponse response = HisReviseValidateService.getInstance().saveValidate(dys);
            this.validateResponse(dataEntities, (HrApiResponse<HisVersionReviseResultBo>)response);
        }
    }

    private void validateResponse(ExtendedDataEntity[] dataEntities, HrApiResponse<HisVersionReviseResultBo> response) {
        if (response == null || response.isSuccess()) {
            return;
        }
        HisVersionReviseResultBo resultBo = (HisVersionReviseResultBo)response.getData();
        if (resultBo == null) {
            return;
        }
        List failDataBos = resultBo.getFailDataBos();
        if (failDataBos == null || failDataBos.size() < 1) {
            return;
        }
        List list = failDataBos.stream().filter(bo -> bo.getId() != 0L).collect(Collectors.toList());
        if (list.size() < 1) {
            return;
        }
        for (HisVersionReviseFailDataBo failDataBo : list) {
            if (failDataBo == null || failDataBo.getId() == null || failDataBo.getErrorMsgs() == null || CollectionUtils.isEmpty((Collection)failDataBo.getErrorMsgs())) continue;
            for (ExtendedDataEntity dataEntity : dataEntities) {
                if (failDataBo.getId().longValue() != dataEntity.getDataEntity().getLong("id")) continue;
                String errorMsg = (String)failDataBo.getErrorMsgs().get(0);
                if (failDataBo.getErrorLevel() == ErrorLevel.FatalError) {
                    this.addFatalErrorMessage(dataEntity, errorMsg);
                    continue;
                }
                if (failDataBo.getErrorLevel() != ErrorLevel.Error) continue;
                this.addErrorMessage(dataEntity, errorMsg);
            }
        }
    }
}

