/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.bussiness.cert;

import com.google.common.collect.Sets;
import java.util.Set;
import kd.bos.exception.KDBizException;
import kd.hr.hbp.bussiness.cert.HRCertUtils;

public final class HRBizCertSignHelper {
    private static final Set<String> allowedClassNameSet = Sets.newHashSet((Object[])new String[]{"kd.hr.hpfs.business.service.cert.HRLicenseRecordManager", "kd.hr.hpfs.business.service.cert.HPLicenseCertTask", "kd.swc.hsbp.business.servicehelper.SWCCertCommonHelper", "kd.sit.sitbp.business.servicehelper.SITCertCommonHelper", "kd.wtc.wtbs.business.license.WTCCertCommonHelper", "kd.tdc.tdcs.bussiness.license.TDCSCertCommonHelper", "kd.tsc.tsirm.business.license.TSIRMCertCommonHelper", "kd.opmc.pbs.business.license.PBSCertCommonHelper", "kd.sihc.soebs.business.domain.cert.impl.SIHCCertDomainServiceImpl", "kd.hr.hbp.unittest.business.cert.HRCertCommonHelperTest"});

    public static String getSignData(String data, String salt) throws KDBizException {
        HRCertUtils.isAllowedClassName(allowedClassNameSet);
        return HRCertUtils.getSignData(data, salt);
    }

    public static String[] getSignData(String[] datas, String[] salts) throws KDBizException {
        HRCertUtils.isAllowedClassName(allowedClassNameSet);
        if (datas == null || salts == null) {
            throw new KDBizException("the input datas or salts is null");
        }
        if (datas.length != salts.length) {
            throw new KDBizException("the length of the datas and the salts are not equal.");
        }
        String[] results = new String[datas.length];
        for (int idx = 0; idx < datas.length; ++idx) {
            results[idx] = HRCertUtils.getSignData(datas[idx], salts[idx]);
        }
        return results;
    }
}

