/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.bussiness.cert;

import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.context.RequestContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.hr.hbp.bussiness.cert.HRCertConstant;
import kd.hr.hbp.bussiness.cert.HRCertUtils;
import kd.hr.hbp.common.cache.HRAppCache;
import kd.hr.hbp.common.util.HRStringUtils;

final class HRCertCacheManager {
    private static final Log logger = LogFactory.getLog(HRCertCacheManager.class);
    private static final String CERT_CACHE_KEY = "hrcertcachekey";
    private static final Set<String> allowedClassNameSet = Sets.newHashSet((Object[])new String[]{"kd.hr.hbp.bussiness.cert.HRCertManager"});

    HRCertCacheManager() {
    }

    static int getUsedCertCount(String groupId) {
        String decodeUsedCount;
        String certCacheKey = HRCertCacheManager.getCertCacheKey(groupId);
        String usedCertCountStr = (String)HRAppCache.get((String)"HBSS").get(certCacheKey, String.class);
        logger.info("kd.hr.hbp.bussiness.cert.HRCertCacheManager.getUsedCertCount groupId : {} ", (Object)groupId);
        int usedCertCount = -1;
        if (!HRStringUtils.isEmpty((String)usedCertCountStr) && (decodeUsedCount = HRCertUtils.decode4Cache(usedCertCountStr)) != null) {
            usedCertCount = Integer.parseInt(decodeUsedCount);
            logger.info("kd.hr.hbp.bussiness.cert.HRCertCacheManager.getUsedCertCount usedCertCount : {} ", (Object)usedCertCount);
            int localDecodeUsedCount = HRCertLocalCacheManager.getUsedCertCount(groupId);
            logger.info("kd.hr.hbp.bussiness.cert.HRCertCacheManager.getUsedCertCount localDecodeUsedCount : {} ", (Object)localDecodeUsedCount);
            if (usedCertCount < localDecodeUsedCount) {
                logger.info("kd.hr.hbp.bussiness.cert.HRCertCacheManager.getUsedCertCount:groupId={},usedCertCount={},localDecodeUsedCount={}", new Object[]{groupId, usedCertCount, localDecodeUsedCount});
                if (usedCertCount < localDecodeUsedCount - 200) {
                    return -1;
                }
            }
        }
        return usedCertCount;
    }

    static void updateUsedCertCount(String groupId, int usedCertCount) {
        HRCertUtils.isAllowedClassName(allowedClassNameSet);
        if (usedCertCount < 0) {
            return;
        }
        HRAppCache.get((String)"HBSS").put(HRCertCacheManager.getCertCacheKey(groupId), (Object)HRCertUtils.encode4Cache(String.valueOf(usedCertCount)));
        HRCertLocalCacheManager.updateUsedCertCount(groupId, usedCertCount);
    }

    static int getPurchaseCount(String groupId) {
        return LicenseServiceHelper.getTotalNumber((Object)groupId);
    }

    private static String getCertCacheKey(String groupId) {
        return HRCertUtils.convertStringToHex(CERT_CACHE_KEY) + groupId;
    }

    static void clearCache() {
        HRCertUtils.isAllowedClassName(allowedClassNameSet);
        HRCertConstant.GROUP_ID_SET.forEach(groupId -> {
            String certCacheKey = HRCertCacheManager.getCertCacheKey(groupId);
            HRAppCache.get((String)"HBSS").remove(certCacheKey);
        });
    }

    private static final class HRCertLocalCacheManager {
        private static final Map<String, Map<String, String>> dataCenterGroupCertCountMap = new ConcurrentHashMap<String, Map<String, String>>(16);

        private HRCertLocalCacheManager() {
        }

        static int getUsedCertCount(String groupId) {
            String accountId = RequestContext.get().getAccountId();
            Map<String, String> certUsedCountMap = dataCenterGroupCertCountMap.get(accountId);
            if (certUsedCountMap == null) {
                return 0;
            }
            String certUsedCountDecodeStr = certUsedCountMap.get(groupId);
            String useCertCount = HRCertUtils.decode4Cache(certUsedCountDecodeStr);
            if (HRStringUtils.isEmpty((String)useCertCount)) {
                return 0;
            }
            return Integer.parseInt(useCertCount);
        }

        static void updateUsedCertCount(String groupId, int usedCertCount) {
            HRCertUtils.isAllowedClassName(allowedClassNameSet);
            String accountId = RequestContext.get().getAccountId();
            Map certUsedCountMap = dataCenterGroupCertCountMap.computeIfAbsent(accountId, k -> new ConcurrentHashMap(16));
            certUsedCountMap.put(groupId, HRCertUtils.encode4Cache(String.valueOf(usedCertCount)));
        }
    }
}

