/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.bussiness.cert;

import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.context.RequestContextCreator;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.threads.ThreadPools;
import kd.hr.hbp.bussiness.cert.HRCertManager;
import kd.hr.hbp.bussiness.cert.HRCertUtils;
import kd.hr.hbp.common.util.HRStringUtils;

final class HRCertCalculateRunnable
implements Runnable {
    private static final Log logger = LogFactory.getLog(HRCertCalculateRunnable.class);

    HRCertCalculateRunnable() {
    }

    @Override
    public void run() {
        logger.info("kd.hr.hbp.bussiness.cert.HRCertCalculateRunnable.run begin");
        try {
            boolean hasContext = false;
            String srcTenantId = "";
            String srcAccountId = "";
            if (RequestContext.get() != null) {
                srcTenantId = RequestContext.get().getTenantId();
                srcAccountId = RequestContext.get().getAccountId();
                hasContext = true;
            }
            List accountList = AccountUtils.getAllAccountsOfCurrentEnv();
            String curTenantId = "";
            String curAccountId = "";
            for (Account account : accountList) {
                curTenantId = account.getTenantId();
                curAccountId = account.getAccountId();
                try {
                    RequestContextCreator.createForPreheat((String)curTenantId, (String)curAccountId);
                    if (HRStringUtils.isEmpty((String)RequestContext.get().getUserId())) {
                        RequestContext.get().setUserId("1");
                    }
                    if (!HRCertUtils.isHRTenant()) continue;
                    ThreadPools.executeOnce((String)"kd.hr.hbp.bussiness.cert.HRCertCalculateRunnable.run", HRCertManager::synchronizeCertInfo);
                }
                catch (Exception e) {
                    logger.info("kd.hr.hbp.bussiness.cert.HRCertCalculateRunnable.run: synchronize HRUsedLicenseCount error!:tenantId:{},accountId{}", (Object)curTenantId, (Object)curAccountId);
                    logger.error((Throwable)e);
                }
            }
            if (hasContext && (this.isTenantIdChange(srcTenantId, curTenantId) || this.isAccountIdChange(srcAccountId, curAccountId))) {
                RequestContextCreator.createForPreheat((String)srcTenantId, (String)srcAccountId);
            }
        }
        catch (Exception e) {
            logger.info("kd.hr.hbp.bussiness.cert.HRCertCalculateRunnable.run: synchronize HRUsedLicenseCount error!");
            logger.error((Throwable)e);
        }
        logger.info("kd.hr.hbp.bussiness.cert.HRCertCalculateRunnable.run end");
    }

    private boolean isAccountIdChange(String srcAccountId, String curAccountId) {
        return curAccountId != null && !curAccountId.equals(srcAccountId);
    }

    private boolean isTenantIdChange(String srcTenantId, String curTenantId) {
        return curTenantId != null && !curTenantId.equals(srcTenantId);
    }
}

