/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.bussiness.cert;

import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.MobileBillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.PermissionControlType;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.license.api.LicenseCheckResult;
import kd.bos.list.ListShowParameter;
import kd.bos.list.MobileListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.hr.hbp.bussiness.cert.HRCertCommonHelper;

public class HRCertCheckServiceHelper {
    private static final Log logger = LogFactory.getLog(HRCertCheckServiceHelper.class);

    public static void check(FormShowParameter showParameter, PreOpenFormEventArgs e) {
        String entityTypeId = HRCertCheckServiceHelper.getEntityTypeId(showParameter);
        FormShowParameter parentShowParameter = SessionManager.getCurrent().getFormShowParameter(showParameter.getParentPageId());
        Boolean isIgnoreLicense = HRCertCheckServiceHelper.isIgnoreLicense(showParameter, parentShowParameter, entityTypeId);
        if (isIgnoreLicense.booleanValue()) {
            return;
        }
        String appId = showParameter.getCheckRightAppId();
        String formId = showParameter.getFormId();
        appId = HRCertCheckServiceHelper.getAppId(appId, entityTypeId);
        String bizObjId = formId;
        Set<Object> groupIdSet = new HashSet(16);
        if (showParameter instanceof MobileBillShowParameter || showParameter instanceof MobileListShowParameter || showParameter instanceof MobileFormShowParameter) {
            groupIdSet = HRCertCommonHelper.getGroupIdSetByBizObjID(appId, formId);
        }
        if (groupIdSet.size() <= 0) {
            groupIdSet = HRCertCommonHelper.getGroupIdSetByBizObjID(appId, entityTypeId);
            bizObjId = entityTypeId;
        }
        if (groupIdSet.size() <= 0) {
            return;
        }
        Long userId = RequestContext.get().getCurrUserId();
        logger.info("HRCertCheckServiceHelper.check:userId={},,appId={},entityTypeId={},formId={}", new Object[]{userId, appId, entityTypeId, formId});
        LicenseCheckResult licCheckResult = LicenseServiceHelper.checkByAppAndBizObj((String)appId, (String)bizObjId, (Long)RequestContext.get().getCurrUserId());
        if (licCheckResult.getHasLicense().booleanValue()) {
            return;
        }
        e.setCancel(true);
        e.setCancelFormShowParameter(licCheckResult.getCancelFormShowParameter());
    }

    private static String getGroupNumber(Long groupId) {
        QFilter groupNumberFilter = new QFilter("id", "=", (Object)groupId);
        QFilter[] filters = new QFilter[]{groupNumberFilter};
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"lic_group", (String)"number", (QFilter[])filters);
        if (dynamicObject != null) {
            return dynamicObject.getString("number");
        }
        return null;
    }

    private static void setCancelMessage(PreOpenFormEventArgs e, Set<Long> groupIdSet) {
        if (groupIdSet.size() == 1) {
            String groupName = HRCertCommonHelper.getGroupName(String.valueOf(groupIdSet.iterator().next()));
            e.setCancelMessage(String.format(ResManager.loadKDString((String)"\u6ca1\u6709%1$s\u8bb8\u53ef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"HRCertCheckServiceHelper_1", (String)"hrmp-hbp-certmanager", (Object[])new Object[0]), groupName));
        } else {
            ArrayList<String> groupNameList = new ArrayList<String>(16);
            for (Long groupId : groupIdSet) {
                groupNameList.add(HRCertCommonHelper.getGroupName(String.valueOf(groupId)));
            }
            Object[] groupNameArray = new String[groupNameList.size()];
            groupNameList.toArray(groupNameArray);
            String groupNames = Joiner.on((String)"/").join(groupNameArray);
            e.setCancelMessage(String.format(ResManager.loadKDString((String)"\u6ca1\u6709%1$s\u8bb8\u53ef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"HRCertCheckServiceHelper_1", (String)"hrmp-hbp-certmanager", (Object[])new Object[0]), groupNames));
        }
    }

    private static Boolean isIgnoreLicense(FormShowParameter showParameter, FormShowParameter parentShowParameter, String entityTypeId) {
        PermissionControlType permControlType = EntityMetadataCache.getPermissionControlType((String)entityTypeId);
        if (permControlType != null && permControlType.isAnonymousUserControl() && "-1".equalsIgnoreCase(RequestContext.get().getUserId())) {
            logger.info("checkLicenseRight perm return");
            return Boolean.TRUE;
        }
        Object param = showParameter.getCustomParam("isIgnoreLicense");
        Boolean isIgnoreLicense = HRCertCheckServiceHelper.isIgnoreByParam(param);
        if (isIgnoreLicense.booleanValue()) {
            return Boolean.TRUE;
        }
        if (HRCertCheckServiceHelper.isIgnoreByParent(parentShowParameter).booleanValue()) {
            return Boolean.TRUE;
        }
        if (parentShowParameter != null && HRCertCheckServiceHelper.isIgnoreByParent(parentShowParameter = SessionManager.getCurrent().getFormShowParameter(parentShowParameter.getParentPageId())).booleanValue()) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private static Boolean isIgnoreByParent(FormShowParameter parentShowParameter) {
        String parentFormId;
        if (parentShowParameter != null && ("ide_formdesigner".equals(parentFormId = parentShowParameter.getFormId()) || "bos_devp_pagepreview".equals(parentFormId) || "bos_devportal_bizpagelist".equals(parentFormId) || "bos_mobilepreview".equals(parentFormId) || "bos_devpn_formdesign".equals(parentFormId) || "devpn_formpreview".equals(parentFormId))) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private static Boolean isIgnoreByParam(Object param) {
        Boolean isIgnoreLicense = Boolean.FALSE;
        if (param instanceof String) {
            isIgnoreLicense = "true".equals(param);
        }
        if (param instanceof Boolean) {
            isIgnoreLicense = (Boolean)param;
        }
        return isIgnoreLicense;
    }

    private static String getEntityTypeId(FormShowParameter showParameter) {
        String formId;
        String entityTypeId = showParameter instanceof ListShowParameter ? (StringUtils.isBlank((CharSequence)(formId = ((ListShowParameter)showParameter).getBillFormId())) ? showParameter.getFormId() : FormMetadataCache.getFormConfig((String)formId).getEntityTypeId()) : (!(showParameter instanceof BillShowParameter) && !(showParameter instanceof MobileFormShowParameter) ? showParameter.getFormId() : showParameter.getFormConfig().getEntityTypeId());
        return entityTypeId;
    }

    private static String getAppId(String appId, String entityTypeId) {
        String bizAppId;
        if (StringUtils.isBlank((CharSequence)appId)) {
            FormConfig fc = FormMetadataCache.getFormConfig((String)entityTypeId);
            bizAppId = StringUtils.isBlank((CharSequence)fc.getBizAppNumber()) ? BizAppServiceHelp.getAppIdByFormNum((String)entityTypeId) : BizAppServiceHelp.getAppIdByAppNumber((String)fc.getBizAppNumber());
        } else {
            AppInfo app = AppMetadataCache.getAppInfo((String)appId);
            bizAppId = app.getId();
        }
        return bizAppId;
    }
}

