/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.bussiness.cert;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.bussiness.cert.HRCertConstant;
import kd.hr.hbp.bussiness.cert.HRCertManager;
import kd.hr.hbp.bussiness.cert.HRCertUtils;
import kd.hr.hbp.bussiness.cert.biz.HRCertCalculatorFactory;
import kd.hr.hbp.bussiness.cert.model.HRCertGroup;

public final class HRCertCommonHelper {
    private static final Log logger = LogFactory.getLog(HRCertCommonHelper.class);

    public static int getTotalCount(String bizAppID, String bizObjID) {
        return HRCertManager.getTotalCount(bizAppID, bizObjID);
    }

    public static int getUsedCount(String bizAppID, String bizObjID) {
        return HRCertManager.getUsedCount(bizAppID, bizObjID);
    }

    public static int getPurchaseCount(String bizAppID, String bizObjID) {
        return HRCertManager.getPurchaseCount(bizAppID, bizObjID);
    }

    public static int getUsableCount(String bizAppID, String bizObjID) {
        int usedCount;
        String groupId = HRCertUtils.getGroupIdByBizObjID(bizAppID, bizObjID);
        int totalCount = HRCertCommonHelper.getTotalCount(groupId);
        int num = totalCount - (usedCount = HRCertCommonHelper.getUsedCount(groupId));
        if (num > 0) {
            return num;
        }
        return 0;
    }

    public static Map<String, String> verifyCertCount(String bizAppID, String bizObjID) {
        return HRCertManager.verifyCertCount(bizAppID, bizObjID);
    }

    public static Map<String, String> verifyCertCount(String bizAppID, String bizObjID, int num) {
        return HRCertManager.verifyCertCount(bizAppID, bizObjID, num);
    }

    public static Map<String, String> updateUsedCertCount(String bizAppID, String bizObjID, int num) {
        return HRCertManager.updateUsedCertCount(bizAppID, bizObjID, num);
    }

    public static int getTotalCount(String groupId) {
        return HRCertManager.getTotalCount(groupId);
    }

    public static int getPurchaseCount(String groupId) {
        int num = HRCertManager.getPurchaseCount(groupId);
        return num;
    }

    public static int getUsableCount(String groupId) {
        int usedCount;
        int totalCount = HRCertCommonHelper.getTotalCount(groupId);
        int num = totalCount - (usedCount = HRCertCommonHelper.getUsedCount(groupId));
        if (num > 0) {
            return num;
        }
        return 0;
    }

    public static int getUsedCount(String groupId) {
        return HRCertManager.getUsedCount(groupId);
    }

    public static Map<String, String> verifyCertCount(String groupId, int num) {
        return HRCertManager.verifyCertCount(groupId, num);
    }

    public static Map<String, String> updateUsedCertCount(String groupId, int num) {
        return HRCertManager.updateUsedCertCount(groupId, num);
    }

    public static Map<String, String> verifyCertCount(String groupId) {
        return HRCertManager.verifyCertCount(groupId);
    }

    public static List<HRCertGroup> getHRCertGroupList() {
        ArrayList<HRCertGroup> groupList = new ArrayList<HRCertGroup>(10);
        for (String groupId : HRCertConstant.GROUP_ID_SET) {
            try {
                logger.info("getHRCertGroupList begin groupId:{}", (Object)groupId);
                HRCertGroup group = new HRCertGroup();
                group.setGroupId(groupId);
                group.setGroupName(HRCertUtils.getGroupName(groupId));
                group.setUsedNumber(HRCertCommonHelper.getUsedCount(groupId));
                group.setTotalNumber(HRCertCommonHelper.getPurchaseCount(groupId));
                groupList.add(group);
                logger.info("getHRCertGroupList end groupId:{}", (Object)groupId);
            }
            catch (Exception exp) {
                logger.error("create cert group info error: groupid=" + groupId);
            }
        }
        return groupList;
    }

    public static String getGroupIdByBizObjID(String bizAppID, String bizObjID) {
        return HRCertUtils.getGroupIdByBizObjID(bizAppID, bizObjID);
    }

    public static Set<Long> getGroupIdSetByBizObjID(String bizAppID, String bizObjID) {
        return HRCertUtils.getGroupIdSetByBizObjID(bizAppID, bizObjID);
    }

    public static DynamicObjectCollection getData(String groupId, List<QFilter> filter, int start, int limit) {
        return HRCertCalculatorFactory.getInstance(groupId).getData(groupId, filter, start, limit);
    }

    public static int getRealCount(String groupId, List<QFilter> filter) {
        return HRCertCalculatorFactory.getInstance(groupId).getRealCount(groupId, filter);
    }

    public static String getGroupName(String groupId) {
        return HRCertUtils.getGroupName(groupId);
    }

    public static Map<String, Object> updateBizAssignData(String groupId) {
        return HRCertCalculatorFactory.getInstance(groupId).updateBizAssignData(groupId);
    }

    public static void clearCache() {
        HRCertManager.clearCache();
        HRCertManager.checkSyncCertInfoThread();
    }
}

