/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.bussiness.cert;

import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.thread.ThreadLifeCycleManager;
import kd.bos.threads.ThreadPools;
import kd.hr.hbp.bussiness.cert.HRCertCacheManager;
import kd.hr.hbp.bussiness.cert.HRCertCalculateRunnable;
import kd.hr.hbp.bussiness.cert.HRCertDBUtils;
import kd.hr.hbp.bussiness.cert.HRCertPctManager;
import kd.hr.hbp.bussiness.cert.HRCertPromptInfoTypeEnum;
import kd.hr.hbp.bussiness.cert.HRCertUtils;
import kd.hr.hbp.bussiness.cert.biz.HRCertCalculatorFactory;
import kd.hr.hbp.common.util.HRStringUtils;

final class HRCertManager {
    private static final Log logger = LogFactory.getLog(HRCertManager.class);
    private static final String CERT_USED_COUNT_UPDATE_LOCK = "hbss/datalock/count";
    private static final int CERT_VERIFY_RIGOROUS_THRESHOLD = 200;
    private static final int CERT_THREAD_CIRCLE_TIME = 10;
    private static final Map<String, String> syncCertInfoThreadRecMap = new ConcurrentHashMap<String, String>(16);
    private static final Map<String, Boolean> queryByRealTimeMap = new ConcurrentHashMap<String, Boolean>(16);
    private static final Set<String> allowedClassNameSet = Sets.newHashSet((Object[])new String[]{"kd.hr.hbp.bussiness.cert.HRCertManager", "kd.hr.hbp.bussiness.cert.HRCertCommonHelper", "kd.hr.hbp.bussiness.cert.HRUsedCertNumWarnDataSource"});

    HRCertManager() {
    }

    static Map<String, String> verifyCertCount(String bizAppID, String bizObjID) {
        String groupId = HRCertUtils.getGroupIdByBizObjID(bizAppID, bizObjID);
        return HRCertManager.verifyCertCount(groupId);
    }

    static Map<String, String> verifyCertCount(String bizAppID, String bizObjID, int num) {
        String groupId = HRCertUtils.getGroupIdByBizObjID(bizAppID, bizObjID);
        return HRCertManager.verifyCertCount(groupId, num);
    }

    static Map<String, String> updateUsedCertCount(String bizAppID, String bizObjID, int num) {
        String groupId = HRCertUtils.getGroupIdByBizObjID(bizAppID, bizObjID);
        return HRCertManager.updateUsedCertCount(groupId, num);
    }

    static int getPurchaseCount(String bizAppID, String bizObjID) {
        String groupId = HRCertUtils.getGroupIdByBizObjID(bizAppID, bizObjID);
        return HRCertManager.getPurchaseCount(groupId);
    }

    static int getTotalCount(String bizAppID, String bizObjID) {
        String groupId = HRCertUtils.getGroupIdByBizObjID(bizAppID, bizObjID);
        return HRCertManager.getTotalCount(groupId);
    }

    static int getUsedCount(String bizAppID, String bizObjID) {
        String groupId = HRCertUtils.getGroupIdByBizObjID(bizAppID, bizObjID);
        return HRCertManager.getUsedCount(groupId);
    }

    static int getPurchaseCount(String groupId) {
        return HRCertCacheManager.getPurchaseCount(groupId);
    }

    static int getTotalCount(String groupId) {
        int purchaseCount = HRCertManager.getPurchaseCount(groupId);
        return HRCertManager.getTotalCountIncludedOverPct(groupId, purchaseCount);
    }

    static Map<String, String> getCurrentCertCountFromDB() {
        return HRCertDBUtils.getCurrentCertCountFromDB();
    }

    static int getUsedCount(String groupId) {
        int num = HRCertCacheManager.getUsedCertCount(groupId);
        if (num < 0) {
            if (!queryByRealTimeMap.containsKey(HRCertManager.getRealTimeMapKey(RequestContext.get().getAccountId(), groupId))) {
                num = HRCertDBUtils.getGroupUsedCountFromDB(groupId);
                logger.info("kd.hr.hbp.bussiness.cert.HRCertManager.getUsedCount groupId:{},num:{}, query actual used cert count by cert info table!", (Object)groupId, (Object)num);
                ThreadPools.executeOnce((String)"kd.hr.hbp.bussiness.cert.HRCertManager.updateCacheData", () -> {
                    int currentUsedCount = HRCertCalculatorFactory.getInstance(groupId).calculateUsedCertCount(groupId);
                    HRCertCacheManager.updateUsedCertCount(groupId, currentUsedCount);
                    logger.info("kd.hr.hbp.bussiness.cert.HRCertManager.getUsedCount groupId:{},currentUsedCount:{}, query actual used cert count by realtime!", (Object)groupId, (Object)currentUsedCount);
                });
            }
            if (num < 0) {
                num = HRCertCalculatorFactory.getInstance(groupId).calculateUsedCertCount(groupId);
                HRCertCacheManager.updateUsedCertCount(groupId, num);
                logger.info("kd.hr.hbp.bussiness.cert.HRCertManager.getUsedCount groupId:{},num:{}, query actual used cert count by realtime!", (Object)groupId, (Object)num);
            }
        }
        HRCertManager.checkSyncCertInfoThread();
        return num;
    }

    static Map<String, String> updateUsedCertCount(String groupId, int num) {
        int usedCertCount;
        HRCertUtils.isAllowedClassName(allowedClassNameSet);
        Map<Object, Object> resultMap = new HashMap<String, String>();
        if (num < 0) {
            resultMap.put("infoType", HRCertPromptInfoTypeEnum.FORBIDDEN.getName());
            resultMap.put("message", String.format(ResManager.loadKDString((String)"\u66f4\u65b0\u8bb8\u53ef\u5360\u7528\u6570\u91cf\u4e3a\u5f02\u5e38\u6570\u636e%s", (String)"HRCertManager_0", (String)"hrmp-hbp-certmanager", (Object[])new Object[0]), num));
            return resultMap;
        }
        resultMap = HRCertManager.verifyCertCount(groupId, num);
        String infoType = (String)resultMap.get("infoType");
        if (infoType.equals(HRCertPromptInfoTypeEnum.FORBIDDEN.getName())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bb8\u53ef\u5360\u7528\u6570\u91cf\u5df2\u8d85\u51fa\u8d2d\u4e70\u6570\u91cf\u4e0a\u9650\uff0c\u7cfb\u7edf\u529f\u80fd\u9650\u5236\u4f7f\u7528\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u8865\u5145\u8bb8\u53ef\u8d2d\u4e70\u6570\u91cf\u3002", (String)"HRCertManager_4", (String)"hrmp-hbp-certmanager", (Object[])new Object[0]));
        }
        int totalCount = Integer.parseInt((String)resultMap.get("totalCount"));
        if (totalCount - (usedCertCount = Integer.parseInt((String)resultMap.get("usedCount"))) <= 200) {
            long beginTime = System.currentTimeMillis();
            try (DLock lock = DLock.create((String)(CERT_USED_COUNT_UPDATE_LOCK + groupId));){
                lock.lock();
                HRCertCacheManager.updateUsedCertCount(groupId, usedCertCount += num);
            }
            long endTime = System.currentTimeMillis();
            logger.info("kd.hr.hbp.bussiness.cert.HRCertManager.updateUsedCertCount by fine-grain, cost:" + (endTime - beginTime));
        } else {
            HRCertCacheManager.updateUsedCertCount(groupId, usedCertCount += num);
        }
        resultMap.put("usedCount", String.valueOf(usedCertCount));
        String groupName = (String)resultMap.get("groupName");
        String message = String.format(ResManager.loadKDString((String)"\u8bb8\u53ef\u5206\u7ec4 %1$s\uff0c\u53ef\u7528\u8bb8\u53ef\u603b\u6570\u4e3a%2$s\uff0c\u5df2\u5360\u7528\u8bb8\u53ef\u6570\u91cf\u4e3a%3$s\u3002", (String)"HRCertManager_1", (String)"hrmp-hbp-certmanager", (Object[])new Object[0]), groupName, totalCount, usedCertCount);
        resultMap.put("certDetailMessage", message);
        return resultMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void checkSyncCertInfoThread() {
        String tenantId = RequestContext.get().getTenantId();
        String accountId = RequestContext.get().getAccountId();
        if (HRCertUtils.isHRTenant() && syncCertInfoThreadRecMap.isEmpty()) {
            Map<String, String> map = syncCertInfoThreadRecMap;
            synchronized (map) {
                ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
                HRCertCalculateRunnable certCalculateTask = new HRCertCalculateRunnable();
                Runnable runnable = ThreadLifeCycleManager.wrapRunnable((Runnable)certCalculateTask);
                scheduler.scheduleAtFixedRate(runnable, 0L, 10L, TimeUnit.MINUTES);
                syncCertInfoThreadRecMap.put(tenantId, accountId);
            }
        }
    }

    static Map<String, String> verifyCertCount(String groupId) {
        return HRCertManager.verifyCertCount(groupId, 0);
    }

    static Map<String, String> verifyCertCount(String groupId, int num) {
        HashMap<String, String> resultMap = new HashMap<String, String>(16);
        int purchaseCount = HRCertManager.getPurchaseCount(groupId);
        int overPctCount = HRCertManager.getOverPctCount(groupId, purchaseCount);
        int totalCount = purchaseCount + overPctCount;
        int usedCount = HRCertManager.getUsedCount(groupId);
        int warningCount = HRCertManager.getWarningCount(purchaseCount);
        resultMap.put("totalCount", String.valueOf(totalCount));
        resultMap.put("usedCount", String.valueOf(usedCount));
        String groupName = HRCertUtils.getGroupName(groupId);
        resultMap.put("groupName", groupName);
        String certDetailMessage = String.format(ResManager.loadKDString((String)"\u8bb8\u53ef\u5206\u7ec4 %1$s\uff0c\u53ef\u7528\u8bb8\u53ef\u603b\u6570\u4e3a%2$s\uff0c\u5df2\u5360\u7528\u8bb8\u53ef\u6570\u91cf\u4e3a%3$s\u3002", (String)"HRCertManager_1", (String)"hrmp-hbp-certmanager", (Object[])new Object[0]), groupName, totalCount, usedCount);
        resultMap.put("certDetailMessage", certDetailMessage);
        if (overPctCount > 0) {
            if (usedCount + num > totalCount) {
                HRCertManager.setForbiddenResultMap(resultMap, groupName);
            } else if (usedCount + num > purchaseCount) {
                resultMap.put("message", String.format(ResManager.loadKDString((String)"%1$s\u8bb8\u53ef\u5360\u7528\u6570\u91cf\u5df2\u8d85\u8fc7\u8d2d\u4e70\u6570\u91cf\u5373\u5c06\u8fbe\u5230\u53ef\u4f7f\u7528\u4e0a\u9650\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u53ca\u65f6\u8865\u5145\u8bb8\u53ef\u8d2d\u4e70\u6570\u91cf\u3002", (String)"HRCertManager_8", (String)"hrmp-hbp-certmanager", (Object[])new Object[0]), groupName));
                resultMap.put("infoType", HRCertPromptInfoTypeEnum.EXCEED.getName());
                resultMap.put("showMessage", "true");
            } else if (usedCount + num >= warningCount) {
                HRCertManager.setWarningResultMap(resultMap, groupName);
                resultMap.put("showMessage", "false");
            } else {
                resultMap.put("message", "normal");
                resultMap.put("infoType", HRCertPromptInfoTypeEnum.NORMAL.getName());
                resultMap.put("showMessage", "false");
            }
        } else if (usedCount + num > purchaseCount) {
            HRCertManager.setForbiddenResultMap(resultMap, groupName);
        } else if (usedCount + num >= warningCount) {
            HRCertManager.setWarningResultMap(resultMap, groupName);
            resultMap.put("showMessage", "true");
        } else {
            resultMap.put("message", "normal");
            resultMap.put("infoType", HRCertPromptInfoTypeEnum.NORMAL.getName());
            resultMap.put("showMessage", "false");
        }
        return resultMap;
    }

    private static void setWarningResultMap(Map<String, String> resultMap, String groupName) {
        resultMap.put("message", String.format(ResManager.loadKDString((String)"%1$s\u8bb8\u53ef\u5360\u7528\u6570\u91cf\u5373\u5c06\u8fbe\u5230\u8d2d\u4e70\u6570\u91cf\u4e0a\u9650\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u53ca\u65f6\u8865\u5145\u8bb8\u53ef\u8d2d\u4e70\u6570\u91cf\u3002", (String)"HRCertManager_6", (String)"hrmp-hbp-certmanager", (Object[])new Object[0]), groupName));
        resultMap.put("infoType", HRCertPromptInfoTypeEnum.WARNING.getName());
    }

    private static void setForbiddenResultMap(Map<String, String> resultMap, String groupName) {
        resultMap.put("message", String.format(ResManager.loadKDString((String)"%1$s\u8bb8\u53ef\u5360\u7528\u6570\u91cf\u5df2\u8d85\u51fa\u8d2d\u4e70\u6570\u91cf\u4e0a\u9650\uff0c\u7cfb\u7edf\u529f\u80fd\u9650\u5236\u4f7f\u7528\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u8865\u5145\u8bb8\u53ef\u8d2d\u4e70\u6570\u91cf\u3002", (String)"HRCertManager_7", (String)"hrmp-hbp-certmanager", (Object[])new Object[0]), groupName));
        resultMap.put("infoType", HRCertPromptInfoTypeEnum.FORBIDDEN.getName());
        resultMap.put("showMessage", "true");
    }

    static int getWarningCount(int purchaseCount) {
        BigDecimal purchaseCountDecimal = BigDecimal.valueOf(purchaseCount);
        return purchaseCountDecimal.multiply(new BigDecimal("0.9")).intValue();
    }

    protected static void synchronizeCertInfo() {
        long beginTime = System.currentTimeMillis();
        Map<String, String> currentGroupMap = HRCertDBUtils.updateCertCountToCertInfoTable();
        HRCertPctManager.updateCurrentOverPctCountFromDB();
        HRCertManager.checkUpdateCertInfoTableResult(currentGroupMap);
        try {
            HRCertManager.updateBosUsedLicenseCount(currentGroupMap);
        }
        catch (Exception e) {
            logger.error("kd.hr.hbp.bussiness.cert.HRCertManager.synchronizeCertInfo: updateBosUsedLicenseCount error!");
            logger.error((Throwable)e);
        }
        long endTime = System.currentTimeMillis();
        logger.info("kd.hr.hbp.bussiness.cert.HRCertManager.synchronizeCertInfo cost:" + (endTime - beginTime));
    }

    private static void updateBosUsedLicenseCount(Map<String, String> currentGroupMap) {
        HashMap groupUsedCountMap = new HashMap(16);
        currentGroupMap.forEach((groupId, usedCertCountStr) -> {
            String usedCertCount = HRCertUtils.decode4Cache(usedCertCountStr);
            if (HRStringUtils.isEmpty((String)usedCertCount)) {
                groupUsedCountMap.put(Long.valueOf(groupId), -1);
            } else {
                groupUsedCountMap.put(Long.valueOf(groupId), Integer.valueOf(usedCertCount));
            }
        });
        LicenseServiceHelper.updateLicGroupAssignCount(groupUsedCountMap);
    }

    private static void checkUpdateCertInfoTableResult(Map<String, String> currentGroupMap) {
        Map<String, String> groupDbResultMap = HRCertManager.getCurrentCertCountFromDB();
        String accountId = RequestContext.get().getAccountId();
        if (groupDbResultMap.isEmpty()) {
            currentGroupMap.forEach((groupId, curGroupCountStr) -> queryByRealTimeMap.put(HRCertManager.getRealTimeMapKey(accountId, groupId), Boolean.TRUE));
            return;
        }
        groupDbResultMap.forEach((curGroupId, dbGroupCountStr) -> {
            String curGroupCountStr = (String)currentGroupMap.get(curGroupId);
            HRCertManager.checkUpdatedResultByGroupCount(accountId, curGroupId, dbGroupCountStr, curGroupCountStr);
        });
    }

    private static void checkUpdatedResultByGroupCount(String accountId, String curGroupId, String dbGroupCountStr, String curGroupCountStr) {
        if (HRStringUtils.isEmpty((String)dbGroupCountStr) || HRStringUtils.isEmpty((String)curGroupCountStr)) {
            logger.error("kd.hr.hbp.bussiness.cert.HRCertManager.checkUpdatedResultByGroupCount groupId : {} update error! query actual used cert count by real time!", (Object)curGroupId);
            queryByRealTimeMap.put(HRCertManager.getRealTimeMapKey(accountId, curGroupId), Boolean.TRUE);
        } else if (!curGroupCountStr.equals(dbGroupCountStr)) {
            String decodeCurGroupCountStr = HRCertUtils.decode4Cache(curGroupCountStr);
            String decodeDbGroupCountStr = HRCertUtils.decode4Cache(dbGroupCountStr);
            if (HRStringUtils.isEmpty((String)decodeCurGroupCountStr) || HRStringUtils.isEmpty((String)decodeDbGroupCountStr)) {
                logger.error("kd.hr.hbp.bussiness.cert.HRCertManager.checkUpdatedResultByGroupCount groupId : {} update error! query actual used cert count by real time!", (Object)curGroupId);
                queryByRealTimeMap.put(HRCertManager.getRealTimeMapKey(accountId, curGroupId), Boolean.TRUE);
                return;
            }
            HRCertManager.updateRealTimeMapByGroupCount(accountId, curGroupId, decodeCurGroupCountStr, decodeDbGroupCountStr);
        } else {
            queryByRealTimeMap.remove(HRCertManager.getRealTimeMapKey(accountId, curGroupId));
        }
    }

    private static void updateRealTimeMapByGroupCount(String accountId, String curGroupId, String decodeCurGroupCountStr, String decodeDbGroupCountStr) {
        int curGroupCount = Integer.parseInt(decodeCurGroupCountStr);
        int dbGroupCount = Integer.parseInt(decodeDbGroupCountStr);
        String realTimeMapKey = HRCertManager.getRealTimeMapKey(accountId, curGroupId);
        if (curGroupCount > dbGroupCount) {
            int purchaseCount = HRCertManager.getPurchaseCount(curGroupId);
            int credibleCount = BigDecimal.valueOf(purchaseCount).multiply(new BigDecimal("0.1")).intValue();
            if (curGroupCount - dbGroupCount > credibleCount) {
                logger.error("kd.hr.hbp.bussiness.cert.HRCertManager.updateRealTimeMapByGroupCount groupId : {} update error! query actual used cert count by real time!", (Object)curGroupId);
                queryByRealTimeMap.put(realTimeMapKey, Boolean.TRUE);
            } else {
                queryByRealTimeMap.remove(realTimeMapKey);
            }
        } else {
            queryByRealTimeMap.remove(realTimeMapKey);
        }
    }

    private static int getTotalCountIncludedOverPct(String groupId, int purchaseCount) {
        int overPctCount = HRCertManager.getOverPctCount(groupId, purchaseCount);
        return purchaseCount + overPctCount;
    }

    static int getOverPctCount(String groupId, int purchaseCount) {
        int overPct = HRCertPctManager.getAllowedOverPct(groupId);
        logger.info("kd.hr.hbp.bussiness.cert.HRCertManager.getOverPctCount:overPct=" + overPct);
        BigDecimal overPctDecimal = BigDecimal.valueOf(overPct).divide(BigDecimal.valueOf(100L), 2, RoundingMode.HALF_UP);
        BigDecimal purchaseCountDecimal = BigDecimal.valueOf(purchaseCount);
        return purchaseCountDecimal.multiply(overPctDecimal).intValue();
    }

    static int getAllowedOverPct(String groupId) {
        return HRCertPctManager.getAllowedOverPct(groupId);
    }

    private static String getRealTimeMapKey(String accountId, String groupId) {
        return accountId + "_" + groupId;
    }

    static void clearCache() {
        HRCertUtils.isAllowedClassName(allowedClassNameSet);
        HRCertCacheManager.clearCache();
        HRCertPctManager.clearCache();
    }
}

