/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.bussiness.cert;

import com.google.common.collect.Sets;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.context.RequestContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.bussiness.cert.HRCertDBUtils;
import kd.hr.hbp.bussiness.cert.HRCertUtils;
import kd.hr.hbp.bussiness.cert.model.HRCertInfo;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;

final class HRCertPctManager {
    private static final Log logger = LogFactory.getLog(HRCertPctManager.class);
    private static final Set<String> allowedClassNameSet = Sets.newHashSet((Object[])new String[]{"kd.hr.hbp.bussiness.cert.HRCertManager"});
    private static final String KEY_ALLOW_OVER_PCT = "evDH+kb374rgJ6TlP2QjL5h/54vfcy+Y6yOeNfpH";
    private static final Map<String, Map<String, HRCertInfo>> accountIdOverPctMap = new ConcurrentHashMap<String, Map<String, HRCertInfo>>(16);

    HRCertPctManager() {
    }

    static void updateCurrentOverPctCountFromDB() {
        HRCertUtils.isAllowedClassName(allowedClassNameSet);
        Map<String, String> groupCertPctEncodeMap = HRCertDBUtils.getGroupCertPctStringFromDB();
        String tenantCode = RequestContext.get().getTenantCode();
        String accountId = RequestContext.get().getAccountId();
        HashMap curGroupCertPctMap = new HashMap(16);
        groupCertPctEncodeMap.forEach((groupId, pctString) -> {
            HRCertInfo hrCertInfo = HRCertPctManager.getHRCertInfo(pctString, tenantCode);
            if (hrCertInfo != null) {
                curGroupCertPctMap.put(groupId, hrCertInfo);
            }
        });
        accountIdOverPctMap.put(accountId, curGroupCertPctMap);
    }

    static int getAllowedOverPct(String groupId) {
        Date curDate;
        HRCertInfo hrCertInfo;
        HRCertUtils.isAllowedClassName(allowedClassNameSet);
        String accountId = RequestContext.get().getAccountId();
        logger.info("kd.hr.hbp.bussiness.cert.HRCertPctManager.getAllowedOverPct:accountId=" + accountId);
        Map<String, HRCertInfo> curGroupCertPctMap = accountIdOverPctMap.get(accountId);
        if (curGroupCertPctMap == null) {
            HRCertPctManager.updateCurrentOverPctCountFromDB();
            curGroupCertPctMap = accountIdOverPctMap.get(accountId);
            logger.info("kd.hr.hbp.bussiness.cert.HRCertPctManager.getAllowedOverPct by current");
        }
        if (curGroupCertPctMap != null && !curGroupCertPctMap.isEmpty() && (hrCertInfo = curGroupCertPctMap.get(groupId)) != null && (HRDateTimeUtils.dayEquals((Date)(curDate = HRDateTimeUtils.truncateDate((Date)new Date())), (Date)hrCertInfo.getEndDate()) || HRDateTimeUtils.dayEquals((Date)curDate, (Date)hrCertInfo.getBeginDate()) || HRDateTimeUtils.dayBefore((Date)curDate, (Date)hrCertInfo.getEndDate()) && HRDateTimeUtils.dayAfter((Date)curDate, (Date)hrCertInfo.getBeginDate()))) {
            return hrCertInfo.getPct();
        }
        String allowOverPct = HRCertUtils.decode4Cache(KEY_ALLOW_OVER_PCT);
        logger.info("kd.hr.hbp.bussiness.cert.HRCertPctManager.getAllowedOverPct:allowOverPct=" + allowOverPct);
        return HRStringUtils.isEmpty((String)allowOverPct) ? 0 : Integer.parseInt(allowOverPct);
    }

    private static HRCertInfo getHRCertInfo(String encodeData, String tenantCode) {
        String data = HRCertUtils.decode(encodeData, tenantCode);
        if (HRStringUtils.isEmpty((String)data)) {
            return null;
        }
        return new HRCertInfo(data, tenantCode);
    }

    static void clearCache() {
        HRCertUtils.isAllowedClassName(allowedClassNameSet);
        String accountId = RequestContext.get().getAccountId();
        accountIdOverPctMap.remove(accountId);
    }
}

