/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.bussiness.cert;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.earlywarn.EarlyWarnContext;
import kd.bos.entity.earlywarn.warn.plugin.IEarlyWarnDataSource;
import kd.bos.entity.earlywarn.warn.plugin.IEarlyWarnMessageCompiler;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.tree.TreeNode;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.bussiness.cert.HRCertCommonHelper;
import kd.hr.hbp.bussiness.cert.HRCertManager;
import kd.hr.hbp.bussiness.cert.HRCertPromptInfoTypeEnum;
import kd.hr.hbp.bussiness.cert.HRCertUtils;
import kd.hr.hbp.bussiness.cert.model.HRCertGroup;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public final class HRUsedCertNumWarnDataSource
implements IEarlyWarnDataSource,
IEarlyWarnMessageCompiler {
    private static final String PCT_SYMBOL = "%";
    private static final String SPLIT_SYMBOL = "\r\n";

    public List<QFilter> buildFilter(String var1, FilterCondition var2, EarlyWarnContext var3) {
        return null;
    }

    public DynamicObjectCollection getData(String var1, List<QFilter> var2, EarlyWarnContext var3) {
        Map<String, String> groupCertUsedCountMap = HRCertManager.getCurrentCertCountFromDB();
        DynamicObjectCollection dynWarnColl = new DynamicObjectCollection();
        ArrayList<HRCertGroup> hrCertGroupList = new ArrayList<HRCertGroup>(16);
        groupCertUsedCountMap.forEach((groupId, usedCountStr) -> {
            String decodeUsedCountStr = HRCertUtils.decode4Cache(usedCountStr);
            if (HRStringUtils.isEmpty((String)decodeUsedCountStr)) {
                return;
            }
            this.addCertGroupToList((List<HRCertGroup>)hrCertGroupList, (String)groupId, decodeUsedCountStr);
        });
        Collections.sort(hrCertGroupList);
        this.assembleWarningCollection(dynWarnColl, hrCertGroupList);
        return dynWarnColl;
    }

    private void addCertGroupToList(List<HRCertGroup> hrCertGroupList, String groupId, String decodeUsedCountStr) {
        String certUsedMsg;
        BigDecimal usedCountDecimal = new BigDecimal(decodeUsedCountStr);
        int usedCount = usedCountDecimal.intValue();
        int purchaseCount = HRCertCommonHelper.getPurchaseCount(groupId);
        if (purchaseCount <= 0) {
            return;
        }
        int overPctCount = HRCertManager.getOverPctCount(groupId, purchaseCount);
        int warningCount = HRCertManager.getWarningCount(purchaseCount);
        int allowedOverPct = HRCertManager.getAllowedOverPct(groupId);
        String groupName = HRCertUtils.getGroupName(groupId);
        HRCertGroup certGroup = new HRCertGroup();
        certGroup.setTotalNumber(purchaseCount);
        certGroup.setGroupName(HRCertUtils.getGroupName(groupId));
        certGroup.setUsedNumber(usedCount);
        certGroup.setAllowedOverPct(allowedOverPct);
        certGroup.setWarningNumber(warningCount);
        int usedPct = usedCountDecimal.divide(BigDecimal.valueOf(purchaseCount), 2, RoundingMode.HALF_DOWN).multiply(BigDecimal.valueOf(100L)).intValue();
        certGroup.setUsedPct(usedPct);
        BigDecimal usedPctDetail = usedCountDecimal.divide(BigDecimal.valueOf(purchaseCount), 5, RoundingMode.HALF_DOWN);
        certGroup.setUsedPctDetail(usedPctDetail);
        if (overPctCount > 0) {
            if (usedCount > purchaseCount + overPctCount) {
                certUsedMsg = this.getForbiddenString(usedCount, purchaseCount, groupName);
                certGroup.setGroupInfoType(HRCertPromptInfoTypeEnum.FORBIDDEN.getName());
            } else if (usedCount > purchaseCount) {
                certUsedMsg = this.getForbiddenString(usedCount, purchaseCount, groupName);
                certGroup.setGroupInfoType(HRCertPromptInfoTypeEnum.EXCEED.getName());
            } else if (usedCount >= warningCount) {
                certUsedMsg = this.getWarningString(usedCount, groupName, purchaseCount);
                certGroup.setGroupInfoType(HRCertPromptInfoTypeEnum.WARNING.getName());
            } else {
                certUsedMsg = this.getNormalString(usedCount, purchaseCount, groupName, usedPct);
                certGroup.setGroupInfoType(HRCertPromptInfoTypeEnum.NORMAL.getName());
            }
        } else if (usedCount > purchaseCount) {
            certUsedMsg = this.getForbiddenString(usedCount, purchaseCount, groupName);
            certGroup.setGroupInfoType(HRCertPromptInfoTypeEnum.FORBIDDEN.getName());
        } else if (usedCount >= warningCount) {
            certUsedMsg = this.getWarningString(usedCount, groupName, purchaseCount);
            certGroup.setGroupInfoType(HRCertPromptInfoTypeEnum.WARNING.getName());
        } else {
            certUsedMsg = this.getNormalString(usedCount, purchaseCount, groupName, usedPct);
            certGroup.setGroupInfoType(HRCertPromptInfoTypeEnum.NORMAL.getName());
        }
        certGroup.setGroupUsedMsg(certUsedMsg);
        hrCertGroupList.add(certGroup);
    }

    private void assembleWarningCollection(DynamicObjectCollection dynWarnColl, List<HRCertGroup> hrCertGroupList) {
        if (hrCertGroupList.size() <= 0) {
            return;
        }
        HRCertGroup certGroup = hrCertGroupList.get(0);
        if (certGroup.getUsedNumber() >= certGroup.getWarningNumber()) {
            hrCertGroupList.forEach(hrCertGroup -> {
                DynamicObject warnDynObj = BusinessDataServiceHelper.newDynamicObject((String)"hbss_certusedwarning");
                warnDynObj.set("groupname", (Object)hrCertGroup.getGroupName());
                warnDynObj.set("allowoverpct", (Object)hrCertGroup.getAllowedOverPct());
                warnDynObj.set("groupusedmsg", (Object)hrCertGroup.getGroupUsedMsg());
                warnDynObj.set("infotype", (Object)hrCertGroup.getGroupInfoType());
                dynWarnColl.add((Object)warnDynObj);
            });
        }
    }

    private String getNormalString(int usedCount, int purchaseCount, String groupName, int usedPct) {
        String certUsedMsg = String.format(ResManager.loadKDString((String)"%1$s\uff1a\u8d2d\u4e70\u6570\u91cf%2$s\uff0c\u5df2\u5360\u7528\u6570\u91cf%3$s\uff0c\u5269\u4f59\u8bb8\u53ef\u6570\u91cf%4$s\uff0c\u5360\u7528\u6bd4\u4f8b%5$s\uff1b", (String)"HRUsedCertNumWarnDataSource_3", (String)"hrmp-hbp-certmanager", (Object[])new Object[0]), groupName, purchaseCount, usedCount, purchaseCount - usedCount, usedPct + PCT_SYMBOL);
        return certUsedMsg;
    }

    private String getWarningString(int usedCount, String groupName, int purchaseCount) {
        String certUsedMsg = String.format(ResManager.loadKDString((String)"%1$s\uff1a\u8d2d\u4e70\u6570\u91cf%2$s\uff0c\u5df2\u5360\u7528\u6570\u91cf%3$s\uff0c\u5269\u4f59\u8bb8\u53ef\u6570\u91cf%4$s\uff0c\u5360\u7528\u6bd4\u4f8b\u5df2\u8d85\u8fc790%5$s\uff1b", (String)"HRUsedCertNumWarnDataSource_2", (String)"hrmp-hbp-certmanager", (Object[])new Object[0]), groupName, purchaseCount, usedCount, purchaseCount - usedCount, PCT_SYMBOL);
        return certUsedMsg;
    }

    private String getForbiddenString(int usedCount, int purchaseCount, String groupName) {
        String certUsedMsg = String.format(ResManager.loadKDString((String)"%1$s\uff1a\u8d2d\u4e70\u6570\u91cf%2$s, \u5df2\u5360\u7528\u6570\u91cf%3$s\uff0c\u5360\u7528\u6570\u91cf\u5df2\u8d85\u51fa\u8d2d\u4e70\u6570\u91cf%4$s\uff1b", (String)"HRUsedCertNumWarnDataSource_1", (String)"hrmp-hbp-certmanager", (Object[])new Object[0]), groupName, purchaseCount, usedCount, usedCount - purchaseCount);
        return certUsedMsg;
    }

    public String getMergeMessage(String s, List<String> list, EarlyWarnContext earlyWarnContext) {
        StringBuilder stringBuilder = new StringBuilder();
        String curDate = HRDateTimeUtils.format((Date)HRDateTimeUtils.truncateDate((Date)new Date()), (String)"yyyy-MM-dd");
        String companyName = this.getRootAdminOrgName();
        stringBuilder.append(String.format(ResManager.loadKDString((String)"%1$s \u7ba1\u7406\u5458\uff0c\u4f60\u597d:\r\n\u622a\u6b62\u5230%2$s\uff0c\u661f\u701aHR %3$s \u5404\u8bb8\u53ef\u5206\u7ec4\u5360\u7528\u60c5\u51b5\u5982\u4e0b\uff1a", (String)"HRUsedCertNumWarnDataSource_7", (String)"hrmp-hbp-certmanager", (Object[])new Object[]{companyName, curDate, companyName}), new Object[0])).append(SPLIT_SYMBOL);
        DynamicObjectCollection warnDataColl = earlyWarnContext.getWarnDataList();
        StringBuilder groupNameBuilder = new StringBuilder();
        if (warnDataColl.size() <= 0) {
            return null;
        }
        DynamicObject dynamicObject = (DynamicObject)warnDataColl.get(0);
        String infoType = dynamicObject.getString("infoType");
        if (!(HRCertPromptInfoTypeEnum.FORBIDDEN.getName().equals(infoType) || HRCertPromptInfoTypeEnum.EXCEED.getName().equals(infoType) || HRCertPromptInfoTypeEnum.WARNING.getName().equals(infoType))) {
            return null;
        }
        warnDataColl.forEach(warnDataObj -> {
            stringBuilder.append(warnDataObj.getString("groupusedmsg")).append(SPLIT_SYMBOL);
            if (HRCertPromptInfoTypeEnum.FORBIDDEN.getName().equals(warnDataObj.getString("infotype"))) {
                groupNameBuilder.append(warnDataObj.getString("groupname")).append(" ");
            }
        });
        this.assembleSumUpMsg(stringBuilder, groupNameBuilder, dynamicObject);
        return stringBuilder.toString();
    }

    private void assembleSumUpMsg(StringBuilder stringBuilder, StringBuilder groupNameBuilder, DynamicObject dynamicObject) {
        String infoType = dynamicObject.getString("infoType");
        int allowOverPct = dynamicObject.getInt("allowoverpct");
        if (allowOverPct > 0) {
            if (HRCertPromptInfoTypeEnum.FORBIDDEN.getName().equals(infoType)) {
                String certUsedSumUpMsg = String.format(ResManager.loadKDString((String)"%1$s\u5360\u7528\u6570\u91cf\u5df2\u8d85\u51fa\u8d2d\u4e70\u6570\u91cf\u4e0a\u9650\uff0c\u7cfb\u7edf\u529f\u80fd\u9650\u5236\u4f7f\u7528\uff0c\u8bf7\u5c3d\u5feb\u8865\u5145\u8bb8\u53ef\u8d2d\u4e70\u6570\u91cf\u3002", (String)"HRUsedCertNumWarnDataSource_4", (String)"hrmp-hbp-certmanager", (Object[])new Object[0]), groupNameBuilder);
                stringBuilder.append(certUsedSumUpMsg).append(SPLIT_SYMBOL);
            } else if (HRCertPromptInfoTypeEnum.EXCEED.getName().equals(infoType) || HRCertPromptInfoTypeEnum.WARNING.getName().equals(infoType)) {
                String certUsedSumUpMsg = String.format(ResManager.loadKDString((String)"\u5f53\u8bb8\u53ef\u5206\u7ec4\u5360\u7528\u6bd4\u4f8b\u8d85\u51fa%1$s\u65f6\uff0c\u7cfb\u7edf\u529f\u80fd\u5c06\u9650\u5236\u4f7f\u7528\uff0c\u4e3a\u907f\u514d\u5f71\u54cd\u4e1a\u52a1\uff0c\u8bf7\u5c3d\u5feb\u8865\u5145\u8bb8\u53ef\u8d2d\u4e70\u6570\u91cf\u3002", (String)"HRUsedCertNumWarnDataSource_5", (String)"hrmp-hbp-certmanager", (Object[])new Object[0]), 100 + dynamicObject.getInt("allowoverpct") + PCT_SYMBOL);
                stringBuilder.append(certUsedSumUpMsg).append(SPLIT_SYMBOL);
            }
        } else if (HRCertPromptInfoTypeEnum.FORBIDDEN.getName().equals(infoType)) {
            String certUsedSumUpMsg = String.format(ResManager.loadKDString((String)"%1$s\u5360\u7528\u6570\u91cf\u5df2\u8d85\u51fa\u8d2d\u4e70\u6570\u91cf\u4e0a\u9650\uff0c\u7cfb\u7edf\u529f\u80fd\u9650\u5236\u4f7f\u7528\uff0c\u8bf7\u5c3d\u5feb\u8865\u5145\u8bb8\u53ef\u8d2d\u4e70\u6570\u91cf\u3002", (String)"HRUsedCertNumWarnDataSource_4", (String)"hrmp-hbp-certmanager", (Object[])new Object[0]), groupNameBuilder);
            stringBuilder.append(certUsedSumUpMsg).append(SPLIT_SYMBOL);
        } else if (HRCertPromptInfoTypeEnum.WARNING.getName().equals(infoType)) {
            String certUsedSumUpMsg = ResManager.loadKDString((String)"\u5f53\u8bb8\u53ef\u5206\u7ec4\u5360\u7528\u6570\u91cf\u8d85\u51fa\u8d2d\u4e70\u6570\u91cf\u4e0a\u9650\u65f6\uff0c\u7cfb\u7edf\u529f\u80fd\u5c06\u9650\u5236\u4f7f\u7528\uff0c\u4e3a\u907f\u514d\u5f71\u54cd\u4e1a\u52a1\uff0c\u8bf7\u5c3d\u5feb\u8865\u5145\u8bb8\u53ef\u8d2d\u4e70\u6570\u91cf\u3002", (String)"HRUsedCertNumWarnDataSource_6", (String)"hrmp-hbp-certmanager", (Object[])new Object[0]);
            stringBuilder.append(certUsedSumUpMsg).append(SPLIT_SYMBOL);
        }
    }

    private String getRootAdminOrgName() {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("haos_adminorghr");
        DynamicObject dynamicObject = hrBaseServiceHelper.queryOne((Object)"100000");
        if (dynamicObject != null) {
            return dynamicObject.getString("name");
        }
        return "";
    }

    public List<Map<String, Object>> getCommonFilterColumns(String var1) {
        return null;
    }

    public TreeNode getSingleMessageFieldTree(String s) {
        return null;
    }

    public TreeNode getMergeMessageFieldTree(String s) {
        return null;
    }

    public String getSingleMessage(String s, List<String> list, DynamicObject dynamicObject, EarlyWarnContext earlyWarnContext) {
        return null;
    }
}

