/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.bussiness.cert.biz;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.bussiness.cert.HRCertCommonHelper;
import kd.hr.hbp.bussiness.cert.HRCertPromptInfoTypeEnum;
import kd.hr.hbp.bussiness.cert.biz.HRCertCalculatorFactory;
import kd.hr.hbp.bussiness.cert.biz.IHRCertCalculator;

public class HROPMCCertCalculator
implements IHRCertCalculator {
    private static final String KEY_CERT_ENTITY = "pbs_certdetail";
    private static final String KEY_ENTITY_CERTGROUPMEMBER = "hbss_certmember";
    private static final String KEY_SEQNUMBER = "seqnumber";

    @Override
    public int calculateUsedCertCount(String groupId) {
        HRCertCalculatorFactory.isAllowedClassName();
        return this.getRealCount(groupId, null);
    }

    @Override
    public DynamicObjectCollection getData(String groupId, List<QFilter> qFilters, int start, int limit) {
        DynamicObjectCollection doc = new DynamicObjectCollection();
        QFilter groupFilter = QFilter.of((String)"groupid=?", (Object[])new Object[]{groupId});
        Object[] objects = BusinessDataServiceHelper.load((String)KEY_CERT_ENTITY, (String)"pid", (QFilter[])new QFilter[]{groupFilter});
        if (ArrayUtils.isEmpty((Object[])objects)) {
            return new DynamicObjectCollection(new DynamicObjectType(KEY_ENTITY_CERTGROUPMEMBER), null);
        }
        Set pidSet = Arrays.stream(objects).map(o -> o.getLong("pid")).collect(Collectors.toSet());
        qFilters.add(new QFilter("personindexid", "in", pidSet));
        qFilters.add(new QFilter("iscurrentversion", "=", (Object)"1"));
        Object[] personObjs = BusinessDataServiceHelper.load((String)"hrpi_person", (String)"name,number", (QFilter[])qFilters.toArray(new QFilter[0]), (String)"", (int)(start / limit), (int)limit);
        if (ArrayUtils.isEmpty((Object[])personObjs)) {
            return new DynamicObjectCollection(new DynamicObjectType(KEY_ENTITY_CERTGROUPMEMBER), null);
        }
        AtomicInteger idx = new AtomicInteger(start);
        Arrays.stream(personObjs).forEach(o -> {
            DynamicObject dObject = BusinessDataServiceHelper.newDynamicObject((String)KEY_ENTITY_CERTGROUPMEMBER);
            dObject.set("name", (Object)o.getString("name"));
            dObject.set("number", (Object)o.getString("number"));
            dObject.set(KEY_SEQNUMBER, (Object)idx.incrementAndGet());
            doc.add((Object)dObject);
        });
        return doc;
    }

    @Override
    public int getRealCount(String groupId, List<QFilter> qFilters) {
        QFilter groupFilter = QFilter.of((String)"groupid=?", (Object[])new Object[]{groupId});
        if (qFilters != null && qFilters.size() > 0) {
            Object[] objects = BusinessDataServiceHelper.load((String)KEY_CERT_ENTITY, (String)"pid", (QFilter[])new QFilter[]{groupFilter});
            if (ArrayUtils.isEmpty((Object[])objects)) {
                return 0;
            }
            Set pidSet = Arrays.stream(objects).map(row -> row.getLong("pid")).collect(Collectors.toSet());
            ArrayList<QFilter> filters = new ArrayList<QFilter>();
            filters.add(new QFilter("personindexid", "in", pidSet));
            filters.add(new QFilter("iscurrentversion", "=", (Object)"1"));
            filters.addAll(qFilters);
            return ORM.create().count("BusinessDataServiceHelper_count", "hrpi_person", filters.toArray(new QFilter[filters.size()]));
        }
        return ORM.create().count("BusinessDataServiceHelper_count", KEY_CERT_ENTITY, new QFilter[]{groupFilter});
    }

    @Override
    public Map<String, Object> updateBizAssignData(String groupId) {
        Map<String, String> map = HRCertCommonHelper.verifyCertCount(groupId);
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)4);
        if (null == map || HRCertPromptInfoTypeEnum.FORBIDDEN.getName().equals(map.get("infoType"))) {
            resultMap.put("exeFlag", false);
            resultMap.put("msg", "verifyCertCount return FORBIDDEN");
            return resultMap;
        }
        resultMap.put("exeFlag", true);
        resultMap.put("msg", "excute opmc licenseService");
        HRMServiceHelper.invokeBizService((String)"opmc", (String)"pbs", (String)"IPBSLicenseService", (String)"updateCertDetail", (Object[])new Object[]{groupId});
        return resultMap;
    }
}

