/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbss.common.util;

import com.google.common.primitives.Bytes;
import java.util.Base64;
import java.util.List;
import kd.bos.cache.CacheConfigInfo;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.LocalMemoryCache;
import kd.bos.context.RequestContext;
import kd.bos.entity.cache.CacheKeyUtil;

public class LocalCacheUtils {
    private static LocalMemoryCache shortTimeLocalCache;
    private static LocalMemoryCache localCache;

    private LocalCacheUtils() {
    }

    public static LocalCacheUtils getInstance() {
        return SingletonInstance.INSTANCE;
    }

    public LocalMemoryCache getLocalCache() {
        return localCache;
    }

    public LocalMemoryCache getShortTimeLocalCache() {
        return shortTimeLocalCache;
    }

    public String getOrgUnFreezeCacheKey(List<Long> orgIds) {
        return "HROrgUnFreezeChecker_" + RequestContext.get().getCurrUserId() + "_" + Base64.getEncoder().encodeToString(Bytes.toArray(orgIds));
    }

    public String getSyncDutyCacheKey(String orgNumber) {
        return "HBSSService.syncDuty_" + RequestContext.get().getCurrUserId() + "_" + orgNumber;
    }

    static {
        String region = CacheKeyUtil.getAcctId() + "kd.hr.hbss.common.util.LocalCacheUtils";
        CacheConfigInfo localConfig = new CacheConfigInfo();
        localConfig.setMaxItemSize(10000);
        localConfig.setTimeout(60);
        localCache = CacheFactory.getCommonCacheFactory().$getOrCreateLocalMemoryCache(region, "org_removeCheck", localConfig);
        CacheConfigInfo localConfig2 = new CacheConfigInfo();
        localConfig2.setMaxItemSize(100);
        localConfig2.setTimeout(10);
        shortTimeLocalCache = CacheFactory.getCommonCacheFactory().$getOrCreateLocalMemoryCache(region, "org_syncDuty", localConfig2);
    }

    private static class SingletonInstance {
        private static final LocalCacheUtils INSTANCE = new LocalCacheUtils();

        private SingletonInstance() {
        }
    }
}

