/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbss.formplugin.web;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.formplugin.web.HRDataBaseList;

public class CollegeListPlugin
extends HRDataBaseList {
    private Map<Long, List<String>> schoolTypeMap = new HashMap<Long, List<String>>();
    private static final String COLLEGE_CHARACT = "collegecharact";
    private static final String COLLEGECHARACT_LBL = "collegecharactlbl";

    public void beforeBindData(EventObject eventObject) {
        DynamicObject[] allData;
        super.beforeBindData(eventObject);
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hbss_college");
        for (DynamicObject rowData : allData = helper.loadDynamicObjectArray(new QFilter[0])) {
            DynamicObjectCollection schoolTypeColl = rowData.getDynamicObjectCollection(COLLEGE_CHARACT);
            ArrayList<String> typeList = new ArrayList<String>();
            for (DynamicObject schoolType : schoolTypeColl) {
                if (Objects.isNull(schoolType.getDynamicObject("fbasedataid"))) continue;
                typeList.add(schoolType.getDynamicObject("fbasedataid").getString("name"));
            }
            long rowId = rowData.getLong("id");
            this.schoolTypeMap.put(rowId, typeList);
        }
    }

    public void packageData(PackageDataEvent event) {
        super.packageData(event);
        AbstractColumnDesc columnDesc = (AbstractColumnDesc)event.getSource();
        Long rowId = (Long)event.getRowData().getPkValue();
        List<String> shoolTypeList = this.schoolTypeMap.get(rowId);
        if (shoolTypeList != null && shoolTypeList.size() > 0) {
            String fieldKey;
            switch (fieldKey = columnDesc.getFieldKey()) {
                case "collegecharactlbl": {
                    event.setFormatValue((Object)String.join((CharSequence)",", shoolTypeList));
                    break;
                }
            }
        }
    }
}

