/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbss.formplugin.web;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbss.formplugin.web.help.EntityFieldHelper;

public class EntityFieldListDataProvider
extends ListDataProvider {
    private static final Log logger = LogFactory.getLog(EntityFieldListDataProvider.class);

    public DynamicObjectCollection getData(int start, int limit) {
        DynamicObjectCollection rows = super.getData(start, limit);
        List filters = this.getQFilters();
        if (0 == filters.size()) {
            return rows;
        }
        String entityNumber = null;
        for (QFilter filter : filters) {
            if (filter.getProperty().equals("entitynumber")) {
                entityNumber = (String)filter.getValue();
            }
            if (!filter.getProperty().equals("fieldname")) continue;
            String string = (String)filter.getValue();
        }
        if (HRStringUtils.isEmpty(entityNumber)) {
            return rows;
        }
        List<IDataEntityProperty> fields = EntityFieldHelper.getFields(entityNumber);
        for (int i = 0; i < fields.size(); ++i) {
            IDataEntityProperty field = fields.get(i);
            DynamicProperty property = (DynamicProperty)field;
            DynamicObject row = rows.addNew();
            row.set("fieldname", (Object)property.getName());
            row.set("fieldalias", (Object)property.getDisplayName());
            row.set("ftblfield", (Object)property.getAlias());
        }
        return rows;
    }
}

