/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbss.formplugin.web;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicLocaleProperty;
import kd.bos.db.DBRoute;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.TextField;
import kd.bos.mvc.base.BaseModel;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRExportDataHelper;
import kd.hr.hbp.business.servicehelper.HRExportHeadObject;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hr.hbss.formplugin.web.BSEntityPropInfo;

public class ExportBaseSysInitDataPlugIn
extends HRDataBaseEdit {
    private static final Log logger = LogFactory.getLog(ExportBaseSysInitDataPlugIn.class);

    public void itemClick(ItemClickEvent evt) {
        BaseModel baseModel;
        String bsNames;
        super.itemClick(evt);
        if ("exportbsdata".equals(evt.getItemKey()) && (bsNames = (baseModel = (BaseModel)this.getModel()).getDataEntity().getString("kdtest_bsnames")) != null) {
            String[] bsNameArrays;
            for (String bsName : bsNameArrays = bsNames.split(",")) {
                List<BSEntityPropInfo> propList = this.getEntityInfoList(bsName);
                ArrayList exportDataList = new ArrayList(16);
                StringBuilder selectPropBuffer = new StringBuilder();
                for (BSEntityPropInfo propInfo : propList) {
                    selectPropBuffer.append(propInfo.getPropNumber()).append(",");
                }
                String selectProps = selectPropBuffer.substring(0, selectPropBuffer.length() - 1);
                HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(bsName);
                DynamicObject[] dyns = serviceHelper.query(selectProps, null);
                DataEntityPropertyCollection dtPcoll = null;
                for (DynamicObject dyn : dyns) {
                    if (dtPcoll == null) {
                        IDataEntityType dtType = dyn.getDataEntityType();
                        dtPcoll = dtType.getProperties();
                    }
                    HashMap<String, String> dtMap = new HashMap<String, String>();
                    HashSet<String> propSet = new HashSet<String>();
                    for (IDataEntityProperty prop : dtPcoll) {
                        if (propSet.contains(prop.getAlias())) continue;
                        propSet.add(prop.getAlias());
                        Object obj = dyn.get(prop.getName());
                        if (obj instanceof DynamicObject) {
                            DynamicObject refDynObj = dyn.getDynamicObject(prop.getName());
                            dtMap.put(prop.getName(), refDynObj.getString("id"));
                            continue;
                        }
                        if (prop instanceof DynamicLocaleProperty) continue;
                        dtMap.put(prop.getName(), dyn.getString(prop.getName()));
                    }
                    exportDataList.add(dtMap);
                }
                List<HRExportHeadObject> exportHeadList = this.assembleExportHeadObject(dtPcoll);
                String exportUrl = null;
                try {
                    exportUrl = HRExportDataHelper.getExportExcelUrl((String)("exportdata_" + bsName), exportDataList, exportHeadList);
                }
                catch (IOException e) {
                    logger.error((Throwable)e);
                }
                if (HRStringUtils.isEmpty(exportUrl)) continue;
                IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
                clientViewProxy.addAction("download", (Object)exportUrl);
            }
        }
    }

    private List<BSEntityPropInfo> getEntityInfoList(String entityNumber) {
        StringBuilder sqlBuffer = new StringBuilder();
        sqlBuffer.append("select fid from t_meta_entitydesign where fnumber ='").append(entityNumber).append("'");
        DataSet ds = HRDBUtil.queryDataSet((String)"queryMetasByApp", (DBRoute)DBRoute.of((String)"sys"), (String)sqlBuffer.toString(), null);
        String entityId = null;
        while (ds.hasNext()) {
            Row row = ds.next();
            entityId = row.getString("fid");
        }
        ds.close();
        EntityMetadata metadata = (EntityMetadata)MetadataDao.readRuntimeMeta(entityId, (MetaCategory)MetaCategory.Entity);
        ArrayList<BSEntityPropInfo> entityPropInfoList = new ArrayList<BSEntityPropInfo>();
        List list = metadata.getItems();
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            Field field;
            String fieldKey;
            EntityItem item = (EntityItem)list.get(i);
            if (!(item instanceof Field) || (fieldKey = (field = (Field)item).getKey()) == null || HRStringUtils.isEmpty((String)fieldKey) || HRStringUtils.isEmpty((String)field.getFieldName())) continue;
            BSEntityPropInfo entityPropInfo = this.getEntityPropInfo(item);
            entityPropInfoList.add(entityPropInfo);
        }
        return entityPropInfoList;
    }

    private BSEntityPropInfo getEntityPropInfo(EntityItem item) {
        BSEntityPropInfo entityPropInfo = null;
        if (item instanceof TextField) {
            TextField textField = (TextField)item;
            String propName = !HRStringUtils.isEmpty((String)textField.getName().getLocaleValue()) ? textField.getName().getLocaleValue() : textField.getEmptyText().getLocaleValue();
            entityPropInfo = new BSEntityPropInfo(propName, item.getKey());
        } else {
            entityPropInfo = new BSEntityPropInfo(item.getName().getLocaleValue(), item.getKey());
        }
        return entityPropInfo;
    }

    private List<HRExportHeadObject> assembleExportHeadObject(DataEntityPropertyCollection dtPcoll) {
        ArrayList<HRExportHeadObject> headDataList = new ArrayList<HRExportHeadObject>();
        HashSet<String> propSet = new HashSet<String>();
        for (IDataEntityProperty dtProp : dtPcoll) {
            if (propSet.contains(dtProp.getAlias())) continue;
            propSet.add(dtProp.getAlias());
            if (dtProp instanceof DynamicLocaleProperty) continue;
            HRExportHeadObject headObj = new HRExportHeadObject();
            headObj.setColumnId(dtProp.getName());
            headObj.setColumnAlias(dtProp.getAlias());
            headDataList.add(headObj);
        }
        return headDataList;
    }
}

