/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbss.formplugin.web;

import java.util.EventObject;
import java.util.Locale;
import kd.bos.algo.AlgoException;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.isv.ISVService;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.service.rp.HRRelatePanelSetFactory;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;

public class RelatePanelSetEdit
extends HRDataBaseEdit {
    private static final String KEY_PAGETYPE = "pagetype";
    private static final String KEY_PAGEINFO = "pageinfo";
    private static final String KEY_FILTERCONDITION = "filtercondition";
    private static final String OPTION_LIST = "2";
    private static final String NUMBER = "number";
    private static final String INVALID_SOURCE_ID = "RelatePanelSetEdit_0";

    private String invalidMsg() {
        return ResManager.loadKDString((String)"\u8fc7\u6ee4\u6761\u4ef6\u4e0d\u5408\u6cd5\u3002", (String)"RelatePanelSetEdit_6", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if ("save".equals(operateKey)) {
            DynamicObject dynamicObject = this.getModel().getDataEntity();
            if (dynamicObject == null) {
                return;
            }
            String number = this.getModel().getDataEntity().getString(NUMBER).toUpperCase(Locale.ROOT);
            this.getModel().getDataEntity().set(NUMBER, (Object)number);
            if (!this.validateFilterCondition(dynamicObject)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)this.invalidMsg(), (String)INVALID_SOURCE_ID, (String)"hrmp-hbss-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (!this.validatePageType(dynamicObject)) {
                args.setCancel(true);
                return;
            }
            if (!"kingdee".equals(ISVService.getISVInfo().getId())) {
                return;
            }
            this.getModel().getDataEntity().set("issyspreset", (Object)"1");
            if (!number.endsWith("_S")) {
                this.getModel().getDataEntity().set(NUMBER, (Object)(number + "_S"));
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        DynamicObject dynObj;
        if ("save".equals(args.getOperateKey()) && (dynObj = (DynamicObject)this.getModel().getValue("entitytype")) != null && dynObj.get("id") != null) {
            String relateEntityTypeId = String.valueOf(dynObj.getLong("id"));
            HRRelatePanelSetFactory.clearHRRelatePanelSetMap((String)relateEntityTypeId);
        }
    }

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        String issyspreset = this.getModel().getDataEntity().getString("issyspreset");
        if ("kingdee".equals(ISVService.getISVInfo().getId()) && HRStringUtils.equals((String)issyspreset, (String)"1")) {
            this.getView().getFormShowParameter().setStatus(OperationStatus.VIEW);
        }
    }

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        DynamicObject dynamicObject = this.getModel().getDataEntity();
        if (dynamicObject == null) {
            this.setVisible(false, KEY_FILTERCONDITION);
            return;
        }
        String optionValue = dynamicObject.getString(KEY_PAGETYPE);
        if (!HRStringUtils.equals((String)OPTION_LIST, (String)optionValue)) {
            this.setVisible(false, KEY_FILTERCONDITION);
            return;
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        super.propertyChanged(args);
        String propertyName = args.getProperty().getName();
        ChangeData changeData = args.getChangeSet()[0];
        DynamicObject dynamicObject = changeData.getDataEntity();
        if (dynamicObject == null) {
            return;
        }
        if (HRStringUtils.equals((String)KEY_PAGEINFO, (String)propertyName)) {
            this.autoSelectPageType(dynamicObject);
        }
        if (HRStringUtils.equals((String)KEY_PAGETYPE, (String)propertyName)) {
            String changeDataValue = dynamicObject.getString(KEY_PAGETYPE);
            if (!HRStringUtils.equals((String)OPTION_LIST, (String)changeDataValue)) {
                this.setVisible(false, KEY_FILTERCONDITION);
            } else {
                this.setVisible(true, KEY_FILTERCONDITION);
            }
        } else if (HRStringUtils.equals((String)KEY_FILTERCONDITION, (String)propertyName)) {
            this.validateFilterCondition(dynamicObject);
        }
    }

    private void setVisible(boolean isShow, String ctrlName) {
        this.getView().setVisible(Boolean.valueOf(isShow), new String[]{ctrlName});
        if (!isShow) {
            this.getView().getModel().setValue(KEY_FILTERCONDITION, (Object)"");
        }
    }

    private boolean validateFilterCondition(DynamicObject dynamicObject) {
        String changeDataValue = dynamicObject.getString(KEY_FILTERCONDITION);
        if (HRStringUtils.isEmpty((String)changeDataValue)) {
            return true;
        }
        try {
            QFilter.of((String)changeDataValue, (Object[])new Object[0]);
            return true;
        }
        catch (AlgoException exception) {
            this.getView().showTipNotification(ResManager.loadKDString((String)this.invalidMsg(), (String)INVALID_SOURCE_ID, (String)"hrmp-hbss-formplugin", (Object[])new Object[0]));
        }
        catch (ClassCastException exception) {
            this.getView().showTipNotification(ResManager.loadKDString((String)this.invalidMsg(), (String)INVALID_SOURCE_ID, (String)"hrmp-hbss-formplugin", (Object[])new Object[0]));
        }
        catch (Exception exception) {
            throw new KDBizException(exception.getMessage());
        }
        return false;
    }

    private boolean validatePageType(DynamicObject dynamicObject) {
        String pageType = dynamicObject.getString(KEY_PAGETYPE);
        DynamicObject dynObj = (DynamicObject)dynamicObject.get(KEY_PAGEINFO);
        String pageInfoType = dynObj.getString("modeltype");
        boolean isVail = true;
        if (HRStringUtils.isEmpty((String)pageType) || HRStringUtils.isEmpty((String)pageInfoType)) {
            return false;
        }
        IFormView view = this.getView();
        switch (pageInfoType) {
            case "BillFormModel": {
                isVail = this.handleBillFormModel(pageType);
                break;
            }
            case "BaseFormModel": {
                isVail = this.showBaseFormModel(pageType, isVail, view);
                break;
            }
            case "QueryListModel": {
                isVail = this.handleQueryListModel(pageType);
                break;
            }
            case "DynamicFormModel": {
                isVail = this.handleDynamicFormModel(pageType);
                break;
            }
            default: {
                view.showTipNotification(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u8be5\u7c7b\u578b\u7684\u9875\u9762\u4fe1\u606f\u3002", (String)"RelatePanelSetEdit_5", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]));
                isVail = false;
            }
        }
        return isVail;
    }

    private boolean handleBillFormModel(String pageType) {
        if (!pageType.contains("1")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9875\u9762\u4fe1\u606f\u4e3a\u5355\u636e\uff0c\u8bf7\u9009\u62e9\u9875\u9762\u7c7b\u578b\u4e3a\u201c\u8868\u5355\u201d\u3002", (String)"RelatePanelSetEdit_1", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean handleQueryListModel(String pageType) {
        if (!pageType.contains(OPTION_LIST)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9875\u9762\u4fe1\u606f\u4e3a\u67e5\u8be2\u5217\u8868\uff0c\u8bf7\u9009\u62e9\u9875\u9762\u7c7b\u578b\u4e3a\u201c\u5217\u8868\u201d\u3002", (String)"RelatePanelSetEdit_3", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean handleDynamicFormModel(String pageType) {
        if (!pageType.contains("3")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9875\u9762\u4fe1\u606f\u4e3a\u52a8\u6001\u8868\u5355\uff0c\u8bf7\u9009\u62e9\u9875\u9762\u7c7b\u578b\u4e3a\u201c\u52a8\u6001\u8868\u5355\u201d\u3002", (String)"RelatePanelSetEdit_4", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean showBaseFormModel(String pageType, boolean isVail, IFormView view) {
        if (!(pageType.contains(OPTION_LIST) || pageType.contains("4") || pageType.contains("1"))) {
            view.showTipNotification(ResManager.loadKDString((String)"\u9875\u9762\u4fe1\u606f\u4e3a\u57fa\u7840\u8d44\u6599\uff0c\u8bf7\u9009\u62e9\u9875\u9762\u7c7b\u578b\u4e3a\u201c\u5217\u8868\u201d\u6216\u201c\u5361\u7247\u89c6\u56fe\u201d\u3002", (String)"RelatePanelSetEdit_2", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]));
            isVail = false;
        }
        return isVail;
    }

    private void autoSelectPageType(DynamicObject dynamicObject) {
        DynamicObject dynObj = (DynamicObject)dynamicObject.get(KEY_PAGEINFO);
        String pageInfoType = dynObj.getString("modeltype");
        if (HRStringUtils.isEmpty((String)pageInfoType)) {
            return;
        }
        IDataModel model = this.getView().getModel();
        switch (pageInfoType) {
            case "DynamicFormModel": {
                model.setValue(KEY_PAGETYPE, (Object)"3");
                break;
            }
            case "BillFormModel": {
                model.setValue(KEY_PAGETYPE, (Object)"1");
                break;
            }
            case "BaseFormModel": {
                model.setValue(KEY_PAGETYPE, (Object)OPTION_LIST);
                break;
            }
            case "QueryListModel": {
                model.setValue(KEY_PAGETYPE, (Object)OPTION_LIST);
                break;
            }
        }
    }
}

