/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbss.formplugin.web;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;

public class SupplierEdit
extends HRDataBaseEdit {
    private static final String FIELD_ISSYSCONTACT = "issyscontact";
    private static final String FIELD_MOBILE = "mobile";
    private static final String FIELD_EMAIL = "email";
    private static final String FIELD_BLACKLISTEVENT = "blacklistevent";
    private static final String FIELD_ISBLACKLIST = "isblacklist";
    private static final String FIELD_SEREFFECTDATE = "sereffectdate";
    private static final String FIELD_SERLOSEDATE = "serlosedate";
    private static final String FIELD_SERVICESTATUS = "servicestatus";
    private static final String ADVCONTOOLBARAP = "advcontoolbarap";
    private static final String STARTDATE = "startdate";
    private static final String ENDDATE = "enddate";
    private static final String CONTACTNAME = "contactname";
    private static final String LANDLINE = "landline";

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        this.addItemClickListeners(new String[]{ADVCONTOOLBARAP});
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        IFormView view = this.getView();
        switch (operateKey) {
            case "newentry": {
                this.setIsSysContact();
                break;
            }
            case "deleteentry": {
                this.setIsSysContact();
                break;
            }
            case "submit": {
                view.setVisible(Boolean.FALSE, new String[]{ADVCONTOOLBARAP});
                view.setEnable(Boolean.FALSE, new String[]{"attachmentpanelap"});
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        if (org.apache.commons.lang3.StringUtils.equals((CharSequence)operate.getOperateKey(), (CharSequence)"save") || org.apache.commons.lang3.StringUtils.equals((CharSequence)operate.getOperateKey(), (CharSequence)"submit")) {
            this.checkField(args);
        }
        if ("deleteentry".equals(operate.getOperateKey())) {
            IDataModel model = this.getModel();
            IFormView view = this.getView();
            DynamicObjectCollection entryEntity = model.getEntryEntity("entryentity");
            if (entryEntity.size() == 1) {
                view.showErrorNotification(ResManager.loadKDString((String)"\u5fc5\u987b\u6709\u4e00\u4e2a\u9ed8\u8ba4\u8054\u7cfb\u4eba\u4fe1\u606f\u3002", (String)"SupplierEdit_0", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String fieldKey;
        super.propertyChanged(args);
        switch (fieldKey = args.getProperty().getName()) {
            case "issyscontact": {
                this.checkSysContact(args.getChangeSet());
                break;
            }
            case "isblacklist": {
                this.showBlackEvent();
                this.chgServiceStatusByBlack();
                break;
            }
            case "startdate": 
            case "enddate": {
                this.handleEndDate();
                break;
            }
        }
    }

    private void handleEndDate() {
        IDataModel model = this.getModel();
        if (model.getValue(STARTDATE) != null && model.getValue(ENDDATE) != null) {
            this.chgServiceStatusByDate();
        } else if (model.getValue(STARTDATE) == null && model.getValue(ENDDATE) == null) {
            model.setValue(FIELD_SERVICESTATUS, null);
        }
    }

    public void afterBindData(EventObject eventObject) {
        String dataStatus;
        super.afterBindData(eventObject);
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        boolean isChanged = model.getDataChanged();
        OperationStatus status = view.getFormShowParameter().getStatus();
        if (OperationStatus.ADDNEW == status) {
            model.setValue(FIELD_ISSYSCONTACT, (Object)Boolean.TRUE, 0);
        }
        if (OperationStatus.VIEW == status) {
            view.setVisible(Boolean.FALSE, new String[]{ADVCONTOOLBARAP});
        }
        if (!HRStringUtils.isEmpty((String)(dataStatus = (String)model.getValue("status"))) && !"A".equals(dataStatus)) {
            view.setEnable(Boolean.FALSE, new String[]{"attachmentpanelap"});
            view.setVisible(Boolean.FALSE, new String[]{ADVCONTOOLBARAP});
        }
        this.showBlackEvent();
        if (!isChanged) {
            model.setDataChanged(false);
        }
    }

    private void showBlackEvent() {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        boolean isBlack = (Boolean)model.getValue(FIELD_ISBLACKLIST);
        if (isBlack) {
            view.setVisible(Boolean.TRUE, new String[]{FIELD_BLACKLISTEVENT});
        } else {
            view.setVisible(Boolean.FALSE, new String[]{FIELD_BLACKLISTEVENT});
        }
    }

    private void checkField(BeforeDoOperationEventArgs args) {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        DynamicObjectCollection entryEntity = model.getEntryEntity("entryentity");
        List legalCollection = entryEntity.stream().filter(dy -> dy.getBoolean(FIELD_ISSYSCONTACT)).collect(Collectors.toList());
        if (legalCollection == null || legalCollection.size() == 0) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u5fc5\u987b\u6709\u4e00\u4e2a\u9ed8\u8ba4\u8054\u7cfb\u4eba\u4fe1\u606f\u3002", (String)"SupplierEdit_0", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        if (!this.notNullCheck(entryEntity, args)) {
            return;
        }
        if (!this.complianceCheck(entryEntity, args)) {
            return;
        }
    }

    private boolean notNullCheck(DynamicObjectCollection entryEntity, BeforeDoOperationEventArgs args) {
        for (DynamicObject dy : entryEntity) {
            if (!HRStringUtils.isEmpty((String)dy.getString(FIELD_MOBILE)) || !HRStringUtils.isEmpty((String)dy.getString(LANDLINE))) continue;
            String showEmailErr = ResManager.loadKDString((String)"\u624b\u673a\u53f7\u548c\u5ea7\u673a\u81f3\u5c11\u4e00\u4e2a\u5fc5\u586b\u3002", (String)"SupplierEdit_7", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]);
            String validContact = dy.getString(CONTACTNAME);
            this.getView().showErrorNotification(validContact + showEmailErr);
            args.setCancel(true);
            return false;
        }
        return true;
    }

    private boolean complianceCheck(DynamicObjectCollection entryEntity, BeforeDoOperationEventArgs args) {
        List validEmailList = entryEntity.stream().filter(dy -> org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)dy.getString(FIELD_EMAIL)) && !StringUtils.isEmail((String)dy.getString(FIELD_EMAIL))).map(dy -> dy.getString(CONTACTNAME)).collect(Collectors.toList());
        if (validEmailList.size() > 0 && validEmailList.get(0) != null) {
            String validContact = org.apache.commons.lang3.StringUtils.join(validEmailList, (String)",");
            String showEmailErr = ResManager.loadKDString((String)"\u7535\u5b50\u90ae\u7bb1\u683c\u5f0f\u6709\u8bef\u3002", (String)"SupplierEdit_3", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(validContact + showEmailErr);
            args.setCancel(true);
            return false;
        }
        return true;
    }

    private void setIsSysContact() {
        IDataModel model = this.getModel();
        DynamicObjectCollection entryEntity = model.getEntryEntity("entryentity");
        if (entryEntity.size() == 1) {
            model.setValue(FIELD_ISSYSCONTACT, (Object)Boolean.TRUE, 0);
        }
    }

    private void checkSysContact(ChangeData[] changeSet) {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        if (changeSet.length == 0) {
            return;
        }
        DynamicObjectCollection entryEntity = model.getEntryEntity("entryentity");
        int rowIndex = changeSet[0].getRowIndex();
        boolean newSysContact = (Boolean)changeSet[0].getNewValue();
        if (newSysContact) {
            for (DynamicObject dy : entryEntity) {
                boolean isContact = dy.getBoolean(FIELD_ISSYSCONTACT);
                int seq = dy.getInt("seq");
                if (!isContact || seq - 1 == rowIndex) continue;
                model.setValue(FIELD_ISSYSCONTACT, (Object)Boolean.FALSE, seq - 1);
            }
            view.updateView("entryentity");
        }
    }

    private void chgServiceStatusByBlack() {
        IDataModel model = this.getModel();
        boolean isBlack = (Boolean)model.getValue(FIELD_ISBLACKLIST);
        if (isBlack) {
            model.setValue(FIELD_SERVICESTATUS, (Object)"2");
        } else if (model.getValue(STARTDATE) != null) {
            model.setValue(FIELD_SERVICESTATUS, (Object)this.getServiceStaByDate());
        } else {
            model.setValue(FIELD_SERVICESTATUS, null);
        }
    }

    private void chgServiceStatusByDate() {
        IDataModel model = this.getModel();
        boolean isBlack = (Boolean)model.getValue(FIELD_ISBLACKLIST);
        if (model.getValue(ENDDATE) != null) {
            if (isBlack) {
                if (!"2".equals(model.getValue(FIELD_SERVICESTATUS))) {
                    model.setValue(FIELD_SERVICESTATUS, (Object)this.getServiceStaByDate());
                }
            } else {
                model.setValue(FIELD_SERVICESTATUS, (Object)this.getServiceStaByDate());
            }
        } else if (isBlack) {
            model.setValue(FIELD_SERVICESTATUS, (Object)"2");
        } else {
            model.setValue(FIELD_SERVICESTATUS, null);
        }
    }

    private String getServiceStaByDate() {
        IDataModel model = this.getModel();
        Date startDate = (Date)model.getValue(STARTDATE);
        Date endDate = (Date)model.getValue(ENDDATE);
        ZoneId zone = ZoneId.systemDefault();
        LocalDate startLocalDate = LocalDateTime.ofInstant(startDate.toInstant(), zone).toLocalDate();
        LocalDate endLocalDate = LocalDateTime.ofInstant(endDate.toInstant(), zone).toLocalDate();
        if (startLocalDate.isAfter(LocalDate.now())) {
            return "0";
        }
        if (endLocalDate.isBefore(LocalDate.now())) {
            return "2";
        }
        return "1";
    }
}

