/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbss.formplugin.web.basicdata;

import java.util.Date;
import java.util.EventObject;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hr.hbss.formplugin.web.basicdata.SignCompanyFormHelper;

public class SignCompanyChFormPlugin
extends HRDataBaseEdit {
    private static final String EDIT_SAVE = "editsave";
    private static final String PERMISSION_CHANGE = "4730fc9f000029ae";
    private static final String DEFAULT_APP_ID = "1WXBXYCLS05D";
    private static final String BOS_DEVPORTAL_BIZAPP = "bos_devportal_bizapp";
    private static final String HLCM = "hlcm";

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setEditEnable(Boolean.FALSE);
        IDataModel model = this.getModel();
        model.setValue("modifier", (Object)RequestContext.get().getCurrUserId());
        model.setValue("modifytime", (Object)new Date());
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if (HRStringUtils.equals((String)EDIT_SAVE, (String)operateKey) || HRStringUtils.equals((String)"submit", (String)operateKey)) {
            if (!this.checkPermission()) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u201c\u8058\u7528\u5355\u4f4d\u201d\u53d8\u66f4\u6743\u9650\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u65e0\u6cd5\u7ee7\u7eed\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u9875\u9762\u3002", (String)"SignCompanyChFormPlugin_2", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]), MessageBoxOptions.None);
                args.setCancel(true);
                return;
            }
            DynamicObject dataEntity = this.getModel().getDataEntity();
            if (this.changeTypeCancel()) {
                return;
            }
            IFormView view = this.getView();
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbss_signcompany");
            DynamicObject oldDy = serviceHelper.queryOne("lawentity,reorg", dataEntity.getPkValue());
            if (oldDy != null) {
                DynamicObject oldOrg = oldDy.getDynamicObject("lawentity");
                DynamicObject org = dataEntity.getDynamicObject("lawentity");
                if (oldOrg == null && org != null ? SignCompanyFormHelper.orgValidator(args, view, dataEntity) : oldOrg != null && org != null && oldOrg.getLong("id") != org.getLong("id") && SignCompanyFormHelper.orgValidator(args, view, dataEntity)) {
                    return;
                }
                DynamicObject oldReOrg = oldDy.getDynamicObject("reorg");
                DynamicObject reOrg = dataEntity.getDynamicObject("reorg");
                if (oldReOrg == null && reOrg != null) {
                    SignCompanyFormHelper.reOrgValidator(args, view, dataEntity);
                } else if (oldReOrg != null && reOrg != null && oldReOrg.getLong("id") != reOrg.getLong("id")) {
                    SignCompanyFormHelper.reOrgValidator(args, view, dataEntity);
                }
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if (args.getOperationResult().isSuccess() && (HRStringUtils.equals((String)EDIT_SAVE, (String)operateKey) || HRStringUtils.equals((String)"submit", (String)operateKey))) {
            IFormView parentView = this.getView().getParentView();
            if (parentView != null) {
                parentView.invokeOperation("refresh");
                String successMsg = HRStringUtils.equals((String)EDIT_SAVE, (String)operateKey) ? ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"SignCompanyChFormPlugin_0", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u63d0\u4ea4\u6210\u529f\u3002", (String)"SignCompanyChFormPlugin_1", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]);
                parentView.showSuccessNotification(successMsg);
                this.getView().sendFormAction(parentView);
            }
            this.getView().close();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        IDataModel model = this.getModel();
        DynamicObject dataEntity = model.getDataEntity();
        if (HRStringUtils.equals((String)"changetype", (String)name)) {
            if (this.changeTypeCancel(dataEntity)) {
                this.resetValue();
            }
            switch (dataEntity.getString("changetype")) {
                case "1": {
                    model.setValue("ischangecon", (Object)Boolean.TRUE);
                    this.setEditEnable(Boolean.FALSE);
                    break;
                }
                case "2": 
                case "3": {
                    model.setValue("ischangecon", (Object)Boolean.FALSE);
                    this.setEditEnable(Boolean.TRUE);
                    break;
                }
                default: {
                    model.setValue("ischangecon", (Object)Boolean.FALSE);
                    this.setEditEnable(Boolean.FALSE);
                    break;
                }
            }
        } else if (HRStringUtils.equals((String)"lawentity", (String)name)) {
            if (this.changeTypeCancel()) {
                return;
            }
            SignCompanyFormHelper.orgChangedCh(this.getView(), model);
        } else if (HRStringUtils.equals((String)"reorg", (String)name)) {
            if (this.changeTypeCancel()) {
                return;
            }
            SignCompanyFormHelper.reOrgChanged(model);
        }
    }

    private void resetValue() {
        IDataModel model = this.getModel();
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("hbss_signcompany");
        DynamicObject signCompanyDy = hrBaseServiceHelper.queryOne("lawentity,reorg,ctrlstrategy,name,representative,unifiedcode,address,contactnumber,postalcode", model.getDataEntity().getPkValue());
        model.setValue("ctrlstrategy", signCompanyDy.get("ctrlstrategy"));
        model.setValue("name", signCompanyDy.get("name"));
        model.setValue("representative", signCompanyDy.get("representative"));
        model.setValue("unifiedcode", signCompanyDy.get("unifiedcode"));
        model.setValue("address", signCompanyDy.get("address"));
        model.setValue("contactnumber", signCompanyDy.get("contactnumber"));
        model.setValue("postalcode", signCompanyDy.get("postalcode"));
        model.setValue("lawentity", signCompanyDy.get("lawentity"));
        model.setValue("reorg", signCompanyDy.get("reorg"));
    }

    private boolean changeTypeCancel(DynamicObject dataEntity) {
        String newValue = dataEntity.getString("changetype");
        return HRStringUtils.isNotEmpty((String)newValue) && HRStringUtils.equals((String)"1", (String)newValue);
    }

    private boolean changeTypeCancel() {
        String newValue = (String)this.getModel().getValue("changetype");
        return HRStringUtils.isEmpty((String)newValue) || HRStringUtils.equals((String)"1", (String)newValue);
    }

    private void setEditEnable(Boolean enable) {
        this.getView().setEnable(enable, new String[]{"name", "lawentity", "reorg", "ctrlstrategy", "description", "unifiedcode", "address", "contactnumber", "postalcode", "representative"});
    }

    public boolean checkPermission() {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(BOS_DEVPORTAL_BIZAPP);
        QFilter appFilter = new QFilter("number", "=", (Object)HLCM);
        DynamicObject appDy = serviceHelper.queryOne("id", appFilter);
        String appId = appDy == null ? DEFAULT_APP_ID : appDy.getString("id");
        Long userId = RequestContext.get().getCurrUserId();
        return PermissionServiceHelper.checkPermission((Long)userId, (String)appId, (String)"hbss_signcompany", (String)PERMISSION_CHANGE);
    }
}

