/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbss.formplugin.web.basicdata;

import java.util.EventObject;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hr.hbss.formplugin.web.basicdata.SignCompanyFormHelper;

public class SignCompanyFormPlugin
extends HRDataBaseEdit {
    private static final String KEY_ENTRYENTITY = "entryentity";
    private static final String OP_INDIVIDUATION = "individuation";
    private static final String CHANGE = "change";

    public void afterBindData(EventObject e) {
        DynamicObject reOrg;
        super.afterBindData(e);
        IDataModel model = this.getModel();
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (status != OperationStatus.ADDNEW && (reOrg = model.getDataEntity().getDynamicObject("reorg")) != null) {
            model.setValue("startdate", reOrg.get("startdate"));
            model.setValue("enddate", reOrg.get("enddate"));
            model.setDataChanged(false);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        IFormView view = this.getView();
        if (this.isAddNew(view)) {
            return;
        }
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if (HRStringUtils.equals((String)"save", (String)operateKey) || HRStringUtils.equals((String)"submit", (String)operateKey) || HRStringUtils.equals((String)"saveandnew", (String)operateKey)) {
            DynamicObject dataEntity = this.getModel().getDataEntity();
            if (SignCompanyFormHelper.orgValidator(args, view, dataEntity)) {
                return;
            }
            SignCompanyFormHelper.reOrgValidator(args, view, dataEntity);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        OperationResult operationResult = args.getOperationResult();
        IDataModel model = this.getModel();
        if (HRStringUtils.equals((String)CHANGE, (String)operateKey) && operationResult != null && operationResult.isSuccess()) {
            Object pkValue = model.getDataEntity().getPkValue();
            BaseShowParameter formShowParameter = new BaseShowParameter();
            formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            formShowParameter.setFormId("hbss_signcompanych");
            formShowParameter.setStatus(OperationStatus.EDIT);
            formShowParameter.setPkId(pkValue);
            formShowParameter.setHasRight(true);
            this.getView().showForm((FormShowParameter)formShowParameter);
        } else if (HRStringUtils.equals((String)OP_INDIVIDUATION, (String)operateKey) && operationResult != null && operationResult.isSuccess()) {
            int index = model.getEntryCurrentRowIndex(KEY_ENTRYENTITY);
            DynamicObject entryRowEntity = model.getEntryRowEntity(KEY_ENTRYENTITY, index);
            Object id = entryRowEntity.get("hisid");
            this.showForm(id);
        }
    }

    private void showForm(Object hisId) {
        BaseShowParameter formShowParameter = new BaseShowParameter();
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setFormId("hbss_signcompanyhis");
        formShowParameter.setStatus(OperationStatus.VIEW);
        String caption = ResManager.loadKDString((String)"\u8058\u7528\u5355\u4f4d\u8be6\u60c5", (String)"SignCompanyFormPlugin_0", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]);
        formShowParameter.setCaption(caption);
        formShowParameter.setPkId(hisId);
        formShowParameter.setHasRight(true);
        this.getView().showForm((FormShowParameter)formShowParameter);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        IFormView view = this.getView();
        if (this.isAddNew(view)) {
            return;
        }
        IDataEntityProperty property = e.getProperty();
        String name = property.getName();
        IDataModel model = this.getModel();
        if (HRStringUtils.equals((String)"lawentity", (String)name)) {
            SignCompanyFormHelper.orgChanged(view, model);
        } else if (HRStringUtils.equals((String)"reorg", (String)name)) {
            SignCompanyFormHelper.reOrgChanged(model);
        }
    }

    private boolean isAddNew(IFormView view) {
        OperationStatus opStatus = view.getFormShowParameter().getStatus();
        return !opStatus.equals((Object)OperationStatus.ADDNEW);
    }
}

