/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbss.formplugin.web.capacity;

import java.text.MessageFormat;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.datamanager.DataEntityCacheManager;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbss.bussiness.config.HRConfigServiceHelper;
import kd.hr.hbss.common.util.CapacityUtils;

public class CapacityRankSchemeEditPlugin
extends AbstractFormPlugin
implements RowClickEventListener {
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setOrderValue();
        this.getModel().setDataChanged(false);
        this.setDisableBtnVisible();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        if (this.getModel().getEntryEntity("entryentity").getRowCount() >= 100) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u8d85\u8fc7\u6700\u5927\u884c\u6570\u3002", (String)"CapacityRankSchemeEditPlugin_0", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
        if ("save".equals(formOperate.getOperateKey()) || "submit".equals(formOperate.getOperateKey())) {
            if (this.checkRankInfo()) {
                DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
                String rankInfo = "";
                for (int i = 0; i < entryEntity.size(); ++i) {
                    String entryName = ((DynamicObject)entryEntity.get(i)).getString("entryname");
                    if (StringUtils.isEmpty((CharSequence)entryName)) continue;
                    rankInfo = i == 0 ? entryName : CapacityUtils.appendStr((String[])new String[]{rankInfo, "\uff1b", entryName});
                }
                this.getModel().setValue("rankinfo", (Object)rankInfo);
            } else {
                args.setCancel(true);
            }
        }
    }

    private boolean checkRankInfo() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        String defeatedControlName = "";
        HashSet<String> errorControlName = new HashSet<String>(4);
        for (int i = 0; i < entryEntity.size(); ++i) {
            String entryNumber = ((DynamicObject)entryEntity.get(i)).getString("entrynumber");
            String entryName = ((DynamicObject)entryEntity.get(i)).getString("entryname");
            if (StringUtils.isEmpty((CharSequence)entryNumber)) {
                errorControlName.add(ResManager.loadKDString((String)"\u7b49\u7ea7\u7f16\u7801", (String)"CapacityRankSchemeEditPlugin_4", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]));
            }
            if (!StringUtils.isEmpty((CharSequence)entryName)) continue;
            errorControlName.add(ResManager.loadKDString((String)"\u7b49\u7ea7\u540d\u79f0", (String)"CapacityRankSchemeEditPlugin_5", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]));
        }
        if (!CollectionUtils.isEmpty(errorControlName)) {
            Iterator iterator = errorControlName.iterator();
            int index = 0;
            while (iterator.hasNext()) {
                defeatedControlName = index == 0 ? CapacityUtils.appendStr((String[])new String[]{"\u201c", (String)iterator.next(), "\u201c"}) : CapacityUtils.appendStr((String[])new String[]{defeatedControlName, "\u3001", "\u201c", (String)iterator.next(), "\u201c"});
                ++index;
            }
        }
        if (!StringUtils.isEmpty((CharSequence)defeatedControlName)) {
            this.getView().showTipNotification(MessageFormat.format(ResManager.loadKDString((String)"\u8bf7\u5b8c\u5584\u201c{0}\u201d\u3002", (String)"CapacityRankSchemeEditPlugin_3", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]), defeatedControlName));
            return false;
        }
        return true;
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if ("moveentrydown".equals(operateKey) || "moveentryup".equals(operateKey)) {
            this.setOrderValue();
        }
        if ("save".equals(operateKey) && args.getOperationResult().isSuccess()) {
            DataEntityCacheManager manager = new DataEntityCacheManager("t_hbss_caprankinfoentry");
            manager.removeByDt();
        }
        this.setDisableBtnVisible();
    }

    public void afterAddRow(AfterAddRowEventArgs args) {
        this.setOrderValue();
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs args) {
        this.setOrderValue();
    }

    public void propertyChanged(PropertyChangedArgs args) {
        if ("entrynumber".equals(args.getProperty().getName()) || "entryname".equals(args.getProperty().getName())) {
            HashSet<String> numberSet = new HashSet<String>(8);
            HashSet<String> nameSet = new HashSet<String>(8);
            DynamicObjectCollection certEntry = this.getModel().getEntryEntity("entryentity");
            Boolean numberNoError = Boolean.TRUE;
            Boolean nameNoError = Boolean.TRUE;
            for (DynamicObject dynamicObject : certEntry) {
                String entryNumber = dynamicObject.getString("entrynumber");
                String entryName = dynamicObject.getString("entryname");
                if (numberNoError.booleanValue() && !StringUtils.isEmpty((CharSequence)entryNumber) && numberSet.contains(entryNumber.trim())) {
                    numberNoError = Boolean.FALSE;
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u7b49\u7ea7\u540d\u79f0\u201c{0}\u201d\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"CapacityRankSchemeEditPlugin_1", (String)"hrmp-hbss-formplugin", (Object[])new Object[]{entryNumber}));
                }
                if (nameNoError.booleanValue() && !StringUtils.isEmpty((CharSequence)entryName) && nameSet.contains(entryName.trim())) {
                    nameNoError = Boolean.FALSE;
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u7b49\u7ea7\u540d\u79f0\u201c{0}\u201d\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"CapacityRankSchemeEditPlugin_2", (String)"hrmp-hbss-formplugin", (Object[])new Object[]{entryName}));
                }
                if (!StringUtils.isEmpty((CharSequence)entryNumber)) {
                    numberSet.add(entryNumber);
                }
                if (StringUtils.isEmpty((CharSequence)entryName)) continue;
                nameSet.add(entryName);
            }
        }
    }

    private void setOrderValue() {
        DynamicObjectCollection dynamicObjects = this.getModel().getEntryEntity("entryentity");
        for (int i = 0; i < dynamicObjects.size(); ++i) {
            this.getModel().setValue("order", (Object)(i + 1), i);
        }
    }

    private void setDisableBtnVisible() {
        String status = (String)this.getModel().getValue("status");
        if ("A".equals(status)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"bar_disable"});
        } else {
            Map paramMap = HRConfigServiceHelper.getParamByEntity((String)"hbss_capacityrankscheme");
            if (CollectionUtils.isEmpty((Map)paramMap) || !((Boolean)paramMap.get("auditcheck")).booleanValue()) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"bar_disable"});
                return;
            }
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"bar_disable"});
        }
    }
}

