/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbss.formplugin.web.college;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import org.apache.commons.lang3.StringUtils;

public class CollegeListPlugin
extends HRDataBaseList {
    private Map<Long, List<String>> schoolTypeMap = new HashMap<Long, List<String>>();
    private Map<Long, List<String>> formerNameMap = new HashMap<Long, List<String>>();
    private static final String MAIN_PAGE_COLLEGE_CHARACT = "collegecharact";
    private static final String MAIN_PAGE_COLLEGECHARACT_LBL = "collegecharactlbl";
    private static final String MAIN_PAGE_ENTITY_NAME = "hbss_college";
    private static final String FORMER_NAME_DYN = "formernameshow";

    public void setFilter(SetFilterEvent e) {
        e.setOrderBy("enable DESC,number ASC");
        super.setFilter(e);
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                DynamicObjectCollection rows = super.getData(start, limit);
                if (rows.isEmpty()) {
                    return rows;
                }
                ArrayList<Long> idList = new ArrayList<Long>(rows.size());
                for (DynamicObject row : rows) {
                    idList.add(row.getLong("id"));
                }
                if (!idList.isEmpty()) {
                    CollegeListPlugin.this.formerNameMap = CollegeListPlugin.this.getFormerNameByMainEntityPK(idList);
                }
                return rows;
            }
        });
    }

    public void beforeBindData(EventObject e) {
        DynamicObject[] allData;
        super.beforeBindData(e);
        HRBaseServiceHelper helper = new HRBaseServiceHelper(MAIN_PAGE_ENTITY_NAME);
        for (DynamicObject rowData : allData = helper.loadDynamicObjectArray(new QFilter[0])) {
            DynamicObjectCollection schoolTypeColl = rowData.getDynamicObjectCollection(MAIN_PAGE_COLLEGE_CHARACT);
            ArrayList<String> typeList = new ArrayList<String>();
            for (DynamicObject schoolType : schoolTypeColl) {
                DynamicObject dyn = schoolType.getDynamicObject("fbasedataid");
                if (dyn == null) continue;
                typeList.add(dyn.getString("name"));
            }
            long rowId = rowData.getLong("id");
            this.schoolTypeMap.put(rowId, typeList);
        }
    }

    public void packageData(PackageDataEvent e) {
        String fieldKey;
        super.packageData(e);
        AbstractColumnDesc columnDesc = (AbstractColumnDesc)e.getSource();
        Long rowId = (Long)e.getRowData().getPkValue();
        List<String> shoolTypeList = this.schoolTypeMap.get(rowId);
        switch (fieldKey = columnDesc.getFieldKey()) {
            case "collegecharactlbl": {
                if (shoolTypeList == null || shoolTypeList.size() <= 0) break;
                e.setFormatValue((Object)String.join((CharSequence)",", shoolTypeList));
                break;
            }
            case "formernameshow": {
                Long id = (Long)e.getRowData().getPkValue();
                List<String> formerNames = this.formerNameMap.get(id);
                if (formerNames == null || formerNames.size() <= 0) break;
                e.setFormatValue((Object)String.join((CharSequence)",", formerNames));
            }
        }
    }

    private Map<Long, List<String>> getFormerNameByMainEntityPK(List<Long> ids) {
        if (ids == null || ids.size() == 0) {
            return new HashMap<Long, List<String>>(0);
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(MAIN_PAGE_ENTITY_NAME);
        QFilter queryEntity = new QFilter("id", "in", ids);
        DynamicObject[] dynFormerNames = serviceHelper.queryOriginalArray("id,formernameentry.formername", new QFilter[]{queryEntity});
        if (dynFormerNames != null) {
            HashMap<Long, List<String>> result = new HashMap<Long, List<String>>(ids.size());
            for (DynamicObject dyn : dynFormerNames) {
                Long id = dyn.getLong("id");
                String formerName = dyn.getString("formernameentry.formername");
                List formerNames = result.computeIfAbsent(id, k -> new ArrayList(0));
                if (!StringUtils.isNotBlank((CharSequence)formerName)) continue;
                formerNames.add(formerName);
            }
            return result;
        }
        return new HashMap<Long, List<String>>(0);
    }
}

