/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbss.formplugin.web.costcenter;

import java.util.EventObject;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.mvc.base.BaseView;
import kd.hr.hbp.business.servicehelper.HRPermissionServiceHelper;
import kd.hr.hbp.common.util.HRBaseUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import org.apache.commons.lang3.ObjectUtils;

public class CostCenterEdit
extends HRDataBaseEdit {
    private static final String LBL_ORG = "lblorg";
    private static final String OPPARAM_AFTERCONFIRM = "afterconfirm";
    private static final String VIEW_COSTCENTER_INCLUDEORG = "hbss_costcenterincorg";

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        this.addClickListeners(new String[]{LBL_ORG});
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control field = (Control)evt.getSource();
        switch (key = field.getKey()) {
            case "lblorg": {
                this.showOrgForm();
                break;
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (OperationStatus.ADDNEW.equals((Object)status)) {
            DynamicObject createOrg = (DynamicObject)this.getView().getModel().getValue("createorg");
            if (ObjectUtils.isNotEmpty((Object)createOrg)) {
                this.getModel().setValue("createorg", ((DynamicObject)this.getView().getModel().getValue("createorg")).getPkValue());
            } else {
                this.getModel().setValue("createorg", (Object)RequestContext.getOrCreate().getOrgId());
            }
        }
    }

    public void afterBindData(EventObject e) {
        BillOperationStatus billStatus = ((BillShowParameter)this.getView().getFormShowParameter()).getBillStatus();
        String status = this.getModel().getDataEntity().getString("status");
        if (this.getView() instanceof BaseView && BillOperationStatus.VIEW.equals((Object)billStatus)) {
            switch (status) {
                case "C": {
                    ((BaseView)this.getView()).setBillStatus(BillOperationStatus.AUDIT);
                    break;
                }
                case "B": {
                    ((BaseView)this.getView()).setBillStatus(BillOperationStatus.SUBMIT);
                    break;
                }
            }
        }
    }

    private void showOrgForm() {
        this.checkPermission(VIEW_COSTCENTER_INCLUDEORG);
        this.getView().invokeOperation("refresh");
        String enableStatus = (String)this.getModel().getValue("enable");
        if (HRStringUtils.equals((String)enableStatus, (String)"2")) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8be5\u6210\u672c\u4e2d\u5fc3\u672a\u542f\u7528\uff0c\u4e0d\u80fd\u7ef4\u62a4\u6216\u67e5\u770b\u4e0e\u884c\u653f\u7ec4\u7ec7\u4e4b\u95f4\u7684\u5173\u7cfb", (String)"CostCenterEdit_0", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]));
        } else {
            FormShowParameter parameter = new FormShowParameter();
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            parameter.setFormId("hbss_orgincostcenter");
            parameter.getShowParameter().setCustomParam("caption", (Object)this.getCostCenterName());
            Object ccaid = this.getModel().getValue("masterid");
            parameter.getShowParameter().setCustomParam("ccaid", ccaid);
            parameter.getShowParameter().setCustomParam("ccaEnable", this.getModel().getValue("enable"));
            this.getView().showForm(parameter);
        }
    }

    private String getCostCenterName() {
        String name = ((OrmLocaleValue)this.getModel().getValue("name")).getLocaleValue();
        String number = (String)this.getModel().getValue("number");
        String result = String.format(ResManager.loadKDString((String)"\u6210\u672c\u4e2d\u5fc3\uff1a%1$s(%2$s)", (String)"CostCenterEdit_1", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]), name, number);
        return result;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operKey;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (operKey = formOperate.getOperateKey()) {
            case "disable": {
                String enable = (String)this.getModel().getValue("enable");
                if (!HRStringUtils.equals((String)enable, (String)"1")) break;
                RefObject confirm = new RefObject();
                if (formOperate.getOption().tryGetVariableValue(OPPARAM_AFTERCONFIRM, confirm)) break;
                args.setCancel(true);
                String message = ResManager.loadKDString((String)"\u7981\u7528HR\u6210\u672c\u627f\u62c5\u5355\u4f4d\u540c\u65f6\u5c06\u4f1a\u7ec8\u6b62\u6240\u6709\u7ec4\u7ec7\u548c\u8be5HR\u6210\u672c\u627f\u62c5\u5355\u4f4d\u7684\u5173\u7cfb\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u5728\u5f53\u524d\u65e5\u671f\u7981\u7528\u6b64HR\u6210\u672c\u627f\u62c5\u5355\u4f4d", (String)"CostCenterEdit_2", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]);
                this.getView().showConfirm(message, MessageBoxOptions.OKCancel, new ConfirmCallBackListener("disable_confirmcallback"));
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent boxClosedEvent) {
        super.confirmCallBack(boxClosedEvent);
        if ("disable_confirmcallback".equals(boxClosedEvent.getCallBackId()) && MessageBoxResult.Yes.equals((Object)boxClosedEvent.getResult())) {
            OperateOption op = OperateOption.create();
            op.setVariableValue(OPPARAM_AFTERCONFIRM, "true");
            this.getView().invokeOperation("disable", op);
        }
    }

    private void checkPermission(String entityName) {
        long userId = Long.parseLong(RequestContext.get().getUserId());
        boolean hasPerm = HRPermissionServiceHelper.hasPerm((long)userId, (String)entityName, (String)"47150e89000000ac");
        if (!hasPerm) {
            throw new KDBizException(HRBaseUtils.getNoPermMsg());
        }
    }
}

