/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbss.formplugin.web.cycle;

import java.text.MessageFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FieldTip;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Label;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hr.hbss.bussiness.util.ShowConfigTipsUtils;
import kd.hr.hbss.common.model.CycleSchemeBo;
import kd.hr.hbss.common.util.CycleSchemUtils;

public class CycleSchemeEdit
extends HRDataBaseEdit
implements BeforeF7SelectListener {
    private static final String CYCLETYPE = "cycletype";
    private static final String HBSS_CYCLESCHEME = "hbss_cyclescheme";
    private static final String PERIODSTARTYEAR = "periodstartyear";
    private static final String PERIODENDYEAR = "periodendyear";
    private static final String ENTRYENTITY = "entryentity";
    private static final String PREFPERIOD = "prefperiod";
    private static final String PERIODSTART = "periodstart";
    private static final String PERIODEND = "periodend";
    private static final String PERIODFLAG = "periodflag";
    private static final String FMT = "MM-dd";
    private static final String DATE_FMT = "yyyy-MM-dd";
    private static final String LABELAP_CREATOR = "labelap_creator";
    private static final String LABELAP_CREATETIME = "labelap_createtime";
    private static final String COPYENTRYROW = "copyentryrow";
    private static final String FLEXPANELAP = "flexpanelap";
    private static final String DATA_FORMAT_REX = "-|\\.|/";
    private static final String REPLACE_LEVEL = "-";
    private static final String ZERO_STR = "0";
    private static final int MAX_ENTRY_VALUE = 999;
    private static final int DATE_LENTH = 5;
    private static final int DATE_MMDD_FMT_LENTH = 2;
    private static final String PERIODENDYEAR_NOT_TIPS = "periodendyear_not_tips";
    private static final String DELETEENTRY = "deleteentry";
    private static final String CHANGETYPEFLAG = "changeTypeFlag";
    private static final String HR_NODATA = "hr_nodata";
    private static final Log LOGGER = LogFactory.getLog(CycleSchemeEdit.class);

    public void afterBindData(EventObject e) {
        ShowConfigTipsUtils.setColumnTips((IFormView)this.getView(), (String)PERIODSTART, (String)ENTRYENTITY, (String)HBSS_CYCLESCHEME);
        ShowConfigTipsUtils.setColumnTips((IFormView)this.getView(), (String)PERIODEND, (String)ENTRYENTITY, (String)HBSS_CYCLESCHEME);
        super.afterBindData(e);
        this.initHeadPanel();
    }

    private void initHeadPanel() {
        DynamicObject dynamicObject = this.getModel().getDataEntity();
        Label creator = (Label)this.getView().getControl(LABELAP_CREATOR);
        creator.setText(dynamicObject.getLocaleString("creator.name").getLocaleValue());
        Label createTime = (Label)this.getView().getControl(LABELAP_CREATETIME);
        createTime.setText(HRDateTimeUtils.format((Date)dynamicObject.getDate("createtime"), (String)DATE_FMT));
    }

    private void showPperiodPanel() {
        DynamicObject appDynObj = (DynamicObject)this.getModel().getValue(CYCLETYPE);
        if (!HRObjectUtils.isEmpty((Object)appDynObj)) {
            String cycleTypeNumber;
            switch (cycleTypeNumber = appDynObj.getString("number")) {
                case "1010_S": {
                    this.setDatapperiod(CycleSchemUtils.getYearList());
                    break;
                }
                case "1020_S": {
                    this.setDatapperiod(CycleSchemUtils.getHalfYearList());
                    break;
                }
                case "1030_S": {
                    this.setDatapperiod(CycleSchemUtils.getQuaterList());
                    break;
                }
                case "1040_S": {
                    this.setDatapperiod(CycleSchemUtils.getMonthList());
                    break;
                }
            }
        }
    }

    private void setDatapperiod(List<CycleSchemeBo> dataList) {
        this.reSetPeriondDate();
        if (CollectionUtils.isEmpty(dataList)) {
            return;
        }
        this.getModel().batchCreateNewEntryRow(ENTRYENTITY, dataList.size());
        DynamicObjectCollection entryentityCol = this.getModel().getDataEntity(true).getDynamicObjectCollection(ENTRYENTITY);
        for (int index = 0; index < entryentityCol.size(); ++index) {
            DynamicObject entryentity = (DynamicObject)entryentityCol.get(index);
            entryentity.set(PREFPERIOD, (Object)dataList.get(index).getPrefperiod());
            entryentity.set(PERIODSTARTYEAR, (Object)dataList.get(index).getPeriodstartyear());
            entryentity.set(PERIODSTART, (Object)dataList.get(index).getPeriodstart());
            entryentity.set(PERIODENDYEAR, (Object)dataList.get(index).getPeriodendyear());
            entryentity.set(PERIODEND, (Object)dataList.get(index).getPeriodend());
            entryentity.set(PERIODFLAG, (Object)dataList.get(index).getPeriodFlag());
        }
        this.getView().updateView(ENTRYENTITY);
    }

    private void reSetPeriondDate() {
        this.getModel().deleteEntryData(ENTRYENTITY);
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        String actionId = event.getCallBackId();
        if (CYCLETYPE.contains(actionId)) {
            if (event.getResult() == MessageBoxResult.Yes) {
                this.showPperiodPanel();
                return;
            }
            IPageCache iPageCache = this.getPageCache();
            if (event.getResult() == MessageBoxResult.Cancel && HRStringUtils.isNotEmpty((String)iPageCache.get(CYCLETYPE))) {
                iPageCache.put(CHANGETYPEFLAG, Boolean.TRUE.toString());
                this.getModel().setValue(CYCLETYPE, (Object)Long.valueOf(iPageCache.get(CYCLETYPE)));
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        ChangeData changeData;
        String propertyName = args.getProperty().getName();
        if (CYCLETYPE.equals(propertyName)) {
            changeData = args.getChangeSet()[0];
            IPageCache iPageCache = this.getPageCache();
            DynamicObject oldValue = (DynamicObject)changeData.getOldValue();
            DynamicObject newValue = (DynamicObject)changeData.getNewValue();
            if (Objects.isNull(newValue) && Objects.isNull(oldValue)) {
                return;
            }
            if (Objects.isNull(newValue) && !Objects.isNull(oldValue)) {
                iPageCache.put(CHANGETYPEFLAG, Boolean.TRUE.toString());
                iPageCache.put(CYCLETYPE, oldValue.getString("id"));
                this.getModel().setValue(CYCLETYPE, (Object)oldValue.getString("id"));
                return;
            }
            String oldCycleTypeID = iPageCache.get(CYCLETYPE);
            if (StringUtils.isNotEmpty((String)oldCycleTypeID) && Objects.isNull(oldValue) && Objects.equals(oldCycleTypeID, newValue.getPkValue().toString())) {
                iPageCache.remove(CHANGETYPEFLAG);
                return;
            }
            if (HRStringUtils.isEmpty((String)iPageCache.get(CHANGETYPEFLAG))) {
                ConfirmCallBackListener confirmListener = new ConfirmCallBackListener(CYCLETYPE, (IFormPlugin)this);
                if (!this.checkData()) {
                    iPageCache.put(CYCLETYPE, Objects.isNull(oldValue) ? null : oldValue.getString("id"));
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u5468\u671f\u7c7b\u578b\u540e\uff0c\u5df2\u7f16\u8f91\u7684\u6570\u636e\u5c06\u65e0\u6cd5\u6062\u590d\uff0c\u786e\u5b9a\u5207\u6362\uff1f", (String)"CycleSchemeEdit_4", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, confirmListener);
                } else {
                    this.showPperiodPanel();
                }
            } else {
                iPageCache.remove(CHANGETYPEFLAG);
            }
        }
        if (PERIODSTART.equals(propertyName) || PERIODEND.equals(propertyName)) {
            changeData = args.getChangeSet()[0];
            Date newValDate = this.coverterDataFormater((String)changeData.getNewValue());
            if (Objects.isNull(newValDate)) {
                this.getModel().setValue(propertyName, null, changeData.getRowIndex());
                DynamicObjectCollection collection = this.getModel().getEntryEntity(ENTRYENTITY);
                this.getModel().updateEntryCache(collection);
                return;
            }
            if (Objects.isNull(changeData.getOldValue()) || !HRDateTimeUtils.dayEquals((Date)this.coverterDataFormater((String)changeData.getOldValue()), (Date)newValDate)) {
                this.cycleValidate(propertyName, changeData.getRowIndex());
            } else if (!Objects.equals((String)changeData.getOldValue(), (String)changeData.getNewValue())) {
                this.entryDataFormatDeal(changeData.getRowIndex());
            }
        }
    }

    private void cycleValidate(String propertyName, int rowIndex) {
        if (PERIODEND.equals(propertyName) && this.valPeriodStartIsNull(rowIndex)) {
            return;
        }
        if (this.valStartAndEndDateFormat(rowIndex)) {
            return;
        }
        this.entryDataFormatDeal(rowIndex);
    }

    private void entryDataFormatDeal(int rowIndex) {
        DynamicObjectCollection entryentity = this.getModel().getDataEntity(true).getDynamicObjectCollection(ENTRYENTITY);
        this.getModel().setValue(PERIODSTART, (Object)this.converData2Fmt(((DynamicObject)entryentity.get(rowIndex)).getString(PERIODSTART)), rowIndex);
        this.getModel().setValue(PERIODEND, (Object)this.converData2Fmt(((DynamicObject)entryentity.get(rowIndex)).getString(PERIODEND)), rowIndex);
        DynamicObjectCollection collection = this.getModel().getEntryEntity(ENTRYENTITY);
        this.getModel().updateEntryCache(collection);
    }

    private String converData2Fmt(String source) {
        if (StringUtils.isEmpty((String)source)) {
            return source;
        }
        if ((source = source.replaceFirst(DATA_FORMAT_REX, REPLACE_LEVEL)).length() >= 5) {
            return source;
        }
        String[] sourceArr = source.split(REPLACE_LEVEL);
        if (sourceArr.length != 2) {
            return source;
        }
        for (int index = 0; index < sourceArr.length; ++index) {
            if (sourceArr[index].length() >= 2) continue;
            sourceArr[index] = String.format("%s%s", ZERO_STR, sourceArr[index]);
        }
        return String.format("%s%s%s", sourceArr[0], REPLACE_LEVEL, sourceArr[1]);
    }

    private boolean valStartAndEndDateFormat(int rowIndex) {
        DynamicObjectCollection entryentity = this.getModel().getDataEntity(true).getDynamicObjectCollection(ENTRYENTITY);
        DynamicObject dynamicObject = (DynamicObject)entryentity.get(rowIndex);
        String periodend = dynamicObject.getString(PERIODEND);
        String periodstart = dynamicObject.getString(PERIODSTART);
        String periodendyear = dynamicObject.getString(PERIODENDYEAR);
        Date start = this.coverterDataFormater(periodstart);
        Date end = this.coverterDataFormater(periodend);
        if (Objects.isNull(start) || Objects.isNull(end)) {
            return false;
        }
        if (HRDateTimeUtils.dayEquals((Date)end, (Date)start)) {
            this.showTipsBetweenEnd();
            this.getModel().setValue(PERIODEND, null, rowIndex);
            return true;
        }
        if (HRDateTimeUtils.dayBefore((Date)end, (Date)start) && Objects.equals("1", periodendyear)) {
            this.getModel().setValue(PERIODENDYEAR, (Object)"2", rowIndex);
        }
        if (HRDateTimeUtils.dayAfter((Date)end, (Date)start) && Objects.equals("2", periodendyear)) {
            this.getModel().setValue(PERIODENDYEAR, (Object)"1", rowIndex);
        }
        return false;
    }

    private boolean valPeriodStartIsNull(int rowIndex) {
        DynamicObjectCollection entryentity = this.getModel().getDataEntity(true).getDynamicObjectCollection(ENTRYENTITY);
        DynamicObject dynamicObject = (DynamicObject)entryentity.get(rowIndex);
        String periodend = dynamicObject.getString(PERIODEND);
        String periodstart = dynamicObject.getString(PERIODSTART);
        if (HRStringUtils.isEmpty((String)periodstart) && HRStringUtils.isNotEmpty((String)periodend)) {
            this.showTipsChooseStart();
            return true;
        }
        return false;
    }

    private boolean checkData() {
        DynamicObjectCollection cols = this.getModel().getEntryEntity(ENTRYENTITY);
        return ObjectUtils.isEmpty((Object)cols);
    }

    private Date coverterDataFormater(String dataStr) {
        try {
            if (StringUtils.isEmpty((String)dataStr)) {
                return null;
            }
            if (dataStr.length() > 5) {
                this.showDateFmtError(dataStr);
                return null;
            }
            String coverterStr = dataStr.replaceFirst(DATA_FORMAT_REX, REPLACE_LEVEL);
            Date startperiod = HRDateTimeUtils.parseDate((String)coverterStr, (String)FMT);
            return startperiod;
        }
        catch (ParseException e) {
            this.showDateFmtError(dataStr);
            LOGGER.error((Throwable)e);
            return null;
        }
    }

    private void showTipsBetweenEnd() {
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u7b49\u4e8e\u5f00\u59cb\u65e5\u671f\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"CostCenterEdit_4", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]));
    }

    private void showTipsChooseStart() {
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u5bf9\u5e94\u671f\u95f4\u201c\u5f00\u59cb\u65e5\u671f\u201d", (String)"CostCenterEdit_5", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]));
    }

    private void showDateFmtError(String name) {
        this.getView().showTipNotification(MessageFormat.format(ResManager.loadKDString((String)"{0}\u683c\u5f0f\u9519\u8bef\u3002", (String)"CostCenterEdit_8", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]), name));
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        DynamicObjectCollection entryentity;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operKey = formOperate.getOperateKey();
        if ((HRStringUtils.equals((String)"save", (String)operKey) || HRStringUtils.equals((String)"submit", (String)operKey)) && this.entryEntryCheck(args)) {
            return;
        }
        if ((HRStringUtils.equals((String)"newentry", (String)operKey) || HRStringUtils.equals((String)COPYENTRYROW, (String)operKey)) && (entryentity = this.getModel().getDataEntity(true).getDynamicObjectCollection(ENTRYENTITY)).size() > 999) {
            args.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8003\u6838\u671f\u95f4\u8bbe\u7f6e\u6570\u91cf\u4e0a\u9650\u4e3a1000\u3002", (String)"CostCenterEdit_9", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]));
        }
    }

    private boolean checkCalcMustInput(String ... keys) {
        boolean checkFlag = true;
        for (String key : keys) {
            FieldTip nameTip;
            if (HRObjectUtils.isEmpty((Object)this.getModel().getValue(key))) {
                nameTip = this.showValidaTip(false, ResManager.loadKDString((String)"\u503c\u4e0d\u80fd\u4e3a\u7a7a", (String)"CycleSchemeEdit_20", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]), key);
                checkFlag = false;
            } else {
                nameTip = this.showValidaTip(true, null, key);
            }
            this.getView().showFieldTip(nameTip);
        }
        return checkFlag;
    }

    private FieldTip showValidaTip(boolean isHide, String msg, String field) {
        FieldTip fieldTip = new FieldTip();
        fieldTip.setSuccess(isHide);
        fieldTip.setFieldKey(field);
        if (!isHide) {
            fieldTip.setTip(msg);
        }
        return fieldTip;
    }

    public void click(EventObject evt) {
        super.click(evt);
    }

    private boolean entryEntryCheck(BeforeDoOperationEventArgs args) {
        DynamicObjectCollection entryentity = this.getModel().getDataEntity(true).getDynamicObjectCollection(ENTRYENTITY);
        if (entryentity.size() == 0) {
            return false;
        }
        for (DynamicObject dynamicObject : entryentity) {
            boolean checkPperiod;
            String periodstart = dynamicObject.getString(PERIODSTART);
            String periodend = dynamicObject.getString(PERIODEND);
            Date periodstartDate = this.coverterDataFormater(periodstart);
            if (Objects.isNull(periodstartDate)) {
                args.setCancel(true);
                return true;
            }
            Date periodendDate = this.coverterDataFormater(periodend);
            if (Objects.isNull(periodendDate)) {
                args.setCancel(true);
                return true;
            }
            String periodstartyear = dynamicObject.getString(PERIODSTARTYEAR);
            String periodendyear = dynamicObject.getString(PERIODENDYEAR);
            DynamicObject appDynObj = (DynamicObject)this.getModel().getValue(CYCLETYPE);
            String cycleTypeNumber = appDynObj.getString("number");
            boolean bl = checkPperiod = HRStringUtils.equals((String)cycleTypeNumber, (String)"1010_S") && (HRStringUtils.isEmpty((String)periodstartyear) || HRStringUtils.isEmpty((String)periodendyear));
            if (checkPperiod) {
                args.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5468\u671f\u65b9\u6848\u8003\u6838\u671f\u95f4\u4fe1\u606f\u7684\u5e74\u4efd", (String)"CostCenterEdit_12", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]));
                return true;
            }
            if (HRStringUtils.isEmpty((String)periodstart)) {
                args.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5468\u671f\u65b9\u6848\u8003\u6838\u671f\u95f4\u4fe1\u606f\u7684\u5f00\u59cb\u65e5\u671f\u3002", (String)"CostCenterEdit_14", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]));
                return true;
            }
            if (!HRStringUtils.isEmpty((String)periodend)) continue;
            args.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5468\u671f\u65b9\u6848\u8003\u6838\u671f\u95f4\u4fe1\u606f\u7684\u7ed3\u675f\u65e5\u671f\u3002", (String)"CostCenterEdit_15", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }
}

