/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbss.formplugin.web.diff;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import kd.bos.cache.CacheFactory;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public class DiffAOPTempConfigGeneratePlugin
extends HRDynamicFormBasePlugin {
    private static final Log logger = LogFactory.getLog(DiffAOPTempConfigGeneratePlugin.class);
    private static final byte[] key = "kingdee".getBytes(StandardCharsets.UTF_8);

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String userId = RequestContext.get().getUid();
        String userName = RequestContext.get().getUserName();
        if ("generatetempaopconfig".equals(afterDoOperationEventArgs.getOperateKey())) {
            DynamicObjectCollection dynColl = this.getModel().getEntryEntity("entryentity");
            JSONArray jsonArray = new JSONArray();
            for (DynamicObject dynObj : dynColl) {
                String className = dynObj.getString("classname");
                String methodName = dynObj.getString("methodname");
                if (StringUtils.isBlank((CharSequence)className) || StringUtils.isBlank((CharSequence)methodName)) continue;
                JSONObject item = new JSONObject();
                item.put("aopType", (Object)dynObj.getString("targetlocation"));
                item.put("methodName", (Object)methodName);
                item.put("className", (Object)className);
                item.put("userId", (Object)userId);
                item.put("userName", (Object)userName);
                jsonArray.put((Object)item);
            }
            if (!jsonArray.isEmpty()) {
                this.save(jsonArray);
            }
        }
    }

    private void save(JSONArray jsonArray) {
        ByteArrayOutputStream byteArrayOutputStream = null;
        DataOutputStream dataOutputstream = null;
        ByteArrayInputStream byteArrayInputStream = null;
        try {
            String content = this.codeForAopInfo(jsonArray.toString());
            byteArrayOutputStream = new ByteArrayOutputStream();
            dataOutputstream = new DataOutputStream(byteArrayOutputStream);
            dataOutputstream.writeBytes(content);
            dataOutputstream.flush();
            byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            String exportUrl = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl("apiaopconfig_temp.json", (InputStream)byteArrayInputStream, 10000);
            if (!HRStringUtils.isEmpty((String)exportUrl)) {
                IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
                clientViewProxy.addAction("download", (Object)exportUrl);
            }
            this.closeStream(byteArrayOutputStream, dataOutputstream, byteArrayInputStream);
        }
        catch (IOException e) {
            try {
                throw new KDBizException((Throwable)e, BosErrorCode.apiIO, new Object[]{e.getMessage()});
            }
            catch (Throwable throwable) {
                this.closeStream(byteArrayOutputStream, dataOutputstream, byteArrayInputStream);
                throw throwable;
            }
        }
    }

    private void closeStream(ByteArrayOutputStream byteArrayOutputStream, DataOutputStream dataOutputstream, ByteArrayInputStream byteArrayInputStream) {
        if (byteArrayOutputStream != null) {
            try {
                byteArrayOutputStream.close();
            }
            catch (IOException e) {
                logger.error((Throwable)e);
            }
        }
        if (dataOutputstream != null) {
            try {
                dataOutputstream.close();
            }
            catch (IOException e) {
                logger.error((Throwable)e);
            }
        }
        if (byteArrayInputStream != null) {
            try {
                byteArrayInputStream.close();
            }
            catch (IOException e) {
                logger.error((Throwable)e);
            }
        }
    }

    public String codeForAopInfo(String str) {
        byte[] bytes = str.getBytes(StandardCharsets.UTF_8);
        for (int index = 0; index < bytes.length; ++index) {
            int n = index;
            bytes[n] = (byte)(bytes[n] ^ key[index % key.length]);
        }
        return new String(bytes, StandardCharsets.UTF_8);
    }
}

