/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbss.formplugin.web.diff;

import com.google.common.base.Joiner;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DBRoute;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.sqlscript.PreInsDataScriptBuilder;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;

public class DiffHandlerPreSQLHelper {
    private static final String STR_WRAP = "\r\n";

    protected String generateStdSQLFile(AbstractListPlugin listPlugIn, List<Long> idList) {
        try {
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbss_diffhandler");
            QFilter[] qFilters = new QFilter[]{new QFilter("id", "in", idList), new QFilter("type", "=", (Object)"HANDLER")};
            DynamicObject[] dynObjs = serviceHelper.query("id", qFilters);
            List<Long> handlerIdList = Arrays.stream(dynObjs).map(item -> item.getLong("id")).collect(Collectors.toList());
            if (handlerIdList.size() < 1) {
                return null;
            }
            StringBuilder sqlBuilder = new StringBuilder();
            sqlBuilder.append("/****** diff handler SQL ******/").append(STR_WRAP);
            String stdHandlerSQL = this.generateStdHandlerPreSQL(handlerIdList);
            sqlBuilder.append(stdHandlerSQL).append(STR_WRAP);
            String stdHandlerParamSQL = this.generateStdHandlerMethodParamPreSQL(handlerIdList);
            sqlBuilder.append(stdHandlerParamSQL);
            String sqlFileName = String.format("%s_%s.sql", "diff_init", new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()));
            try (ByteArrayInputStream ins = new ByteArrayInputStream(sqlBuilder.toString().getBytes(StandardCharsets.UTF_8));){
                this.exportFile(listPlugIn, ins, sqlFileName);
            }
            catch (Exception e) {
                throw new KDException((Throwable)e, BosErrorCode.downloadFailed, new Object[]{String.format("KSQLExpPlugin error:%s.", e.getMessage())});
            }
            return sqlFileName;
        }
        catch (Exception e) {
            throw new KDBizException((Throwable)e, BosErrorCode.bOS, new Object[]{String.format("KSQLExpPlugin Error:%s.", e.getMessage())});
        }
    }

    private String generateStdHandlerMethodParamPreSQL(List<Long> idList) {
        String exportFields = "FID, FENTRYID, FSEQ, FPARAMNAME, FPARAMTYPE, FPARAMDESC";
        String splitIds = Joiner.on((String)",").join(idList);
        String whereCondition = "FID IN (" + splitIds + ")";
        PreInsDataScriptBuilder builder = new PreInsDataScriptBuilder();
        Map map = builder.genInsertSQLScript(DBRoute.of((String)"hmp"), "t_hbss_diffhandlerparam", exportFields, whereCondition, null, null);
        String sql = (String)map.get("sql");
        String multiLanExportFields = "FPKID, FENTRYID, FLOCALEID, FPARAMDESC";
        String paramWhereCondition = "FENTRYID IN (SELECT FENTRYID FROM t_hbss_diffhandlerparam WHERE FID IN (" + splitIds + "))";
        Map multiLanMap = builder.genInsertSQLScript(DBRoute.of((String)"hmp"), "t_hbss_diffhandlerparam_l", multiLanExportFields, paramWhereCondition, null, null);
        String multiLanSQL = (String)multiLanMap.get("sql");
        return sql + STR_WRAP + multiLanSQL;
    }

    private String generateStdHandlerPreSQL(List<Long> idList) {
        String exportFields = "FID, FFORMID, FSOURCECLASSNAME, FSOURCEMETHODNAME, FSOURCEMETHODSIGN, FISOVERRIDE, FISV, FCLOUDID, FAPPID, FCREATORID, FCREATETIME, FMODIFIERID, FMODIFYTIME, FNUMBER, FISSYSPRESET, FRETURNVALUETYPE, FNAME, FRETURNVALUEDESC, FFUNCTIONNAME, FAPITYPE, FDESCRIPTION, FTYPE";
        String splitIds = Joiner.on((String)",").join(idList);
        String whereCondition = "FID IN (" + splitIds + ")";
        PreInsDataScriptBuilder builder = new PreInsDataScriptBuilder();
        Map map = builder.genInsertSQLScript(DBRoute.of((String)"hmp"), "t_hbss_diffhandler", exportFields, whereCondition, null, null);
        String sql = (String)map.get("sql");
        String multiLanExportFields = "FID, FPKID, FLOCALEID, FNAME, FFUNCTIONNAME, FDESCRIPTION";
        Map multiLanMap = builder.genInsertSQLScript(DBRoute.of((String)"hmp"), "t_hbss_diffhandler_l", multiLanExportFields, whereCondition, null, null);
        String multiLanSQL = (String)multiLanMap.get("sql");
        return sql + STR_WRAP + multiLanSQL;
    }

    protected void generateDiffSQLFile(AbstractListPlugin listPlugIn, List<Long> enableIdList) {
        try {
            StringBuilder sqlBuilder = new StringBuilder();
            sqlBuilder.append("/****** diff AOP SQL ******/").append(STR_WRAP);
            String aopDiffHandlerSQL = this.generateAOPDiffHandlerPreSQL(enableIdList);
            String aopTargetSQL = this.generateDiffAOPTargetPreSQL(enableIdList);
            String sqlFileName = String.format("%s_%s.sql", "diff_init", new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()));
            sqlBuilder.append(aopDiffHandlerSQL).append(STR_WRAP).append(aopTargetSQL);
            sqlBuilder.append("/****** diff HANDLER SQL ******/").append(STR_WRAP);
            String diffHandlerTargetSQL = this.generateDiffHandlerTargetPreSQL(enableIdList);
            sqlBuilder.append(diffHandlerTargetSQL);
            try (ByteArrayInputStream ins = new ByteArrayInputStream(sqlBuilder.toString().getBytes(StandardCharsets.UTF_8));){
                this.exportFile(listPlugIn, ins, sqlFileName);
            }
            catch (Exception e) {
                throw new KDException((Throwable)e, BosErrorCode.downloadFailed, new Object[]{String.format("KSQLExpPlugin error:%s.", e.getMessage())});
            }
        }
        catch (Exception e) {
            throw new KDBizException((Throwable)e, BosErrorCode.bOS, new Object[]{String.format("KSQLExpPlugin Error:%s.", e.getMessage())});
        }
    }

    private String generateAOPDiffHandlerPreSQL(List<Long> enableIdList) {
        PreInsDataScriptBuilder builder = new PreInsDataScriptBuilder();
        String exportFields = "FID, FFORMID, FSOURCECLASSNAME, FSOURCEMETHODNAME, FSOURCEMETHODSIGN, FISOVERRIDE, FISV, FCLOUDID, FAPPID, FCREATORID, FCREATETIME, FMODIFIERID, FMODIFYTIME, FNUMBER, FISSYSPRESET, FRETURNVALUETYPE, FNAME, FRETURNVALUEDESC, FFUNCTIONNAME, FAPITYPE, FDESCRIPTION, FTYPE";
        StringBuilder whereCondition = this.getAOPWhereCondition(enableIdList);
        Map map = builder.genInsertSQLScript(DBRoute.of((String)"hmp"), "t_hbss_diffhandler", exportFields, whereCondition.toString(), null, null);
        String sql = (String)map.get("sql");
        String exportMultiLanFields = "FPKID, FID, FLOCALEID, FNAME, FFUNCTIONNAME, FDESCRIPTION";
        String multiLanWhere = "FID IN (SELECT FID FROM t_hbss_diffhandler where " + whereCondition + ")";
        Map multiLanMap = builder.genInsertSQLScript(DBRoute.of((String)"hmp"), "t_hbss_diffhandler_l", exportMultiLanFields, multiLanWhere, null, null);
        String multiLanSQL = (String)multiLanMap.get("sql");
        return sql + STR_WRAP + multiLanSQL;
    }

    private StringBuilder getAOPWhereCondition(List<Long> enableIdList) {
        StringBuilder whereCondition = new StringBuilder();
        String splitIds = Joiner.on((String)",").join(enableIdList);
        whereCondition.append("FID IN (SELECT FDIFFHANDLERID FROM T_HBSS_DIFFCUSCONFIG WHERE FID IN (").append(splitIds).append("))");
        whereCondition.append(" AND FTYPE='").append("APIAOP").append("'");
        return whereCondition;
    }

    private String generateDiffHandlerTargetPreSQL(List<Long> enableIdList) {
        PreInsDataScriptBuilder builder = new PreInsDataScriptBuilder();
        String exportFields = "FID, FNUMBER, FNAME, FENABLE, FTARGETCLASSNAME, FTARGETMETHODNAME, FDESCRIPTION, FDIFFHANDLERID, FISV, FCLOUDID, FAPPID, FCREATORID, FCREATETIME, FMODIFIERID, FMODIFYTIME, FISSYSPRESET";
        StringBuilder whereConditionBuilder = new StringBuilder();
        String splitIds = Joiner.on((String)",").join(enableIdList);
        whereConditionBuilder.append(" FID IN (").append(splitIds).append(")").append(" AND FTYPE='").append("HANDLER").append("'");
        Map map = builder.genInsertSQLScript(DBRoute.of((String)"hmp"), "T_HBSS_DIFFCUSCONFIG", exportFields, whereConditionBuilder.toString(), null, null);
        String sql = (String)map.get("sql");
        String exportMultiLanFields = "FPKID, FID, FLOCALEID, FNAME, FFUNCTIONNAME, FDESCRIPTION";
        String multiLanWhere = "FID IN (SELECT FID FROM T_HBSS_DIFFCUSCONFIG where " + whereConditionBuilder + ")";
        Map multiLanMap = builder.genInsertSQLScript(DBRoute.of((String)"hmp"), "T_HBSS_DIFFCUSCONFIG_L", exportMultiLanFields, multiLanWhere, null, null);
        String multiLanSQL = (String)multiLanMap.get("sql");
        return sql + STR_WRAP + multiLanSQL;
    }

    private String generateDiffAOPTargetPreSQL(List<Long> enableIdList) {
        PreInsDataScriptBuilder builder = new PreInsDataScriptBuilder();
        String exportFields = "FID, FNUMBER, FNAME, FSOURCECLASSNAME, FSOURCEMETHODNAME, FENABLE, FDIFFHANDLERID, FISV, FCLOUDID, FAPPID, FCREATORID, FCREATETIME, FMODIFIERID, FMODIFYTIME, FISSYSPRESET, FFUNCTIONNAME, FDESCRIPTION, FTYPE, FTARGETLOCATION, FTARGETCLASSNAME, FTARGETMETHODNAME";
        StringBuilder whereConditionBuilder = new StringBuilder();
        String splitIds = Joiner.on((String)",").join(enableIdList);
        whereConditionBuilder.append(" FID IN (").append(splitIds).append(")").append(" AND FTYPE='").append("APIAOP").append("'");
        Map map = builder.genInsertSQLScript(DBRoute.of((String)"hmp"), "T_HBSS_DIFFCUSCONFIG", exportFields, whereConditionBuilder.toString(), null, null);
        String sql = (String)map.get("sql");
        String exportMultiLanFields = "FPKID, FID, FLOCALEID, FNAME, FFUNCTIONNAME, FDESCRIPTION";
        String multiLanWhere = "FID IN (SELECT FID FROM T_HBSS_DIFFCUSCONFIG where " + whereConditionBuilder + ")";
        Map multiLanMap = builder.genInsertSQLScript(DBRoute.of((String)"hmp"), "T_HBSS_DIFFCUSCONFIG_L", exportMultiLanFields, multiLanWhere, null, null);
        String multiLanSQL = (String)multiLanMap.get("sql");
        return sql + STR_WRAP + multiLanSQL;
    }

    protected void generateStdImplSQLFile(AbstractListPlugin listPlugIn, List<Long> idList) {
        try {
            StringBuilder sqlBuilder = new StringBuilder();
            sqlBuilder.append("/****** std implement SQL ******/").append(STR_WRAP);
            String diffImplSQL = this.generateStdImplPreSQL(idList);
            sqlBuilder.append(diffImplSQL);
            String diffImplMethodSQL = this.generateStdImplMethodPreSQL(idList);
            sqlBuilder.append(diffImplMethodSQL);
            String diffImplParamSQL = this.generateStdImplMethodParamPreSQL(idList);
            sqlBuilder.append(diffImplParamSQL);
            String sqlFileName = String.format("%s_%s.sql", "impl_init", new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()));
            try (ByteArrayInputStream ins = new ByteArrayInputStream(sqlBuilder.toString().getBytes(StandardCharsets.UTF_8));){
                this.exportFile(listPlugIn, ins, sqlFileName);
            }
            catch (Exception e) {
                throw new KDException((Throwable)e, BosErrorCode.downloadFailed, new Object[]{String.format("KSQLExpPlugin error:%s.", e.getMessage())});
            }
        }
        catch (Exception e) {
            throw new KDBizException((Throwable)e, BosErrorCode.bOS, new Object[]{String.format("KSQLExpPlugin Error:%s.", e.getMessage())});
        }
    }

    private String generateStdImplPreSQL(List<Long> idList) {
        PreInsDataScriptBuilder builder = new PreInsDataScriptBuilder();
        String exportFields = "FID, FNUMBER, FNAME, FISV, FCLOUDID, FAPPID, FSERVICE, FAPITYPE, FFUNCTIONNAME,FDESCRIPTION, FISV, FCREATORID, FCREATETIME, FMODIFIERID, FMODIFYTIME, FISSYSPRESET";
        StringBuilder whereConditionBuilder = new StringBuilder();
        String splitIds = Joiner.on((String)",").join(idList);
        whereConditionBuilder.append(" FID IN (").append(splitIds).append(")");
        Map map = builder.genInsertSQLScript(DBRoute.of((String)"hmp"), "T_HBSS_DIFFIMPLEMENT", exportFields, whereConditionBuilder.toString(), null, null);
        String sql = (String)map.get("sql");
        String exportMultiLanFields = "FPKID, FID, FLOCALEID, FNAME, FFUNCTIONNAME, FDESCRIPTION";
        Map multiLanMap = builder.genInsertSQLScript(DBRoute.of((String)"hmp"), "T_HBSS_DIFFIMPLEMENT_L", exportMultiLanFields, whereConditionBuilder.toString(), null, null);
        String multiLanSQL = (String)multiLanMap.get("sql");
        return sql + STR_WRAP + multiLanSQL;
    }

    private String generateStdImplMethodPreSQL(List<Long> idList) {
        PreInsDataScriptBuilder builder = new PreInsDataScriptBuilder();
        String exportFields = "FID, FENTRYID, FMETHODNAME, FMETHODDESC, FRETURNVALUETYPE, FRETURNVALUEDESC";
        StringBuilder whereConditionBuilder = new StringBuilder();
        String splitIds = Joiner.on((String)",").join(idList);
        whereConditionBuilder.append(" FID IN (").append(splitIds).append(")");
        Map map = builder.genInsertSQLScript(DBRoute.of((String)"hmp"), "T_HBSS_DIFFIMPLMETHOD", exportFields, whereConditionBuilder.toString(), null, null);
        String sql = (String)map.get("sql");
        String exportMultiLanFields = "FPKID, FEntryID, FLOCALEID, FMETHODDESC, FRETURNVALUEDESC";
        String whereString = "FEntryID in (select FEntryID from T_HBSS_DIFFIMPLMETHOD where " + whereConditionBuilder + ")";
        Map multiLanMap = builder.genInsertSQLScript(DBRoute.of((String)"hmp"), "T_HBSS_DIFFIMPLMETHOD_L", exportMultiLanFields, whereString, null, null);
        String multiLanSQL = (String)multiLanMap.get("sql");
        return sql + STR_WRAP + multiLanSQL;
    }

    private String generateStdImplMethodParamPreSQL(List<Long> idList) {
        PreInsDataScriptBuilder builder = new PreInsDataScriptBuilder();
        String exportFields = "FENTRYID, FDETAILID, FSEQ, FPARAMNAME, FPARAMTYPE, FPARAMDESC";
        StringBuilder whereConditionBuilder = new StringBuilder();
        String splitIds = Joiner.on((String)",").join(idList);
        whereConditionBuilder.append("FEntryID IN (select FEntryID FROM T_HBSS_DIFFIMPLMETHOD WHERE FID IN (").append(splitIds).append("))");
        Map map = builder.genInsertSQLScript(DBRoute.of((String)"hmp"), "T_HBSS_DIFFIMPLPARAM", exportFields, whereConditionBuilder.toString(), null, null);
        String sql = (String)map.get("sql");
        String exportMultiLanFields = "FPKID, FDETAILID, FLOCALEID, FPARAMDESC";
        String whereString = "FDETAILID in (select FDETAILID from T_HBSS_DIFFIMPLPARAM where (" + whereConditionBuilder + "))";
        Map multiLanMap = builder.genInsertSQLScript(DBRoute.of((String)"hmp"), "T_HBSS_DIFFIMPLPARAM_L", exportMultiLanFields, whereString, null, null);
        String multiLanSQL = (String)multiLanMap.get("sql");
        return sql + STR_WRAP + multiLanSQL;
    }

    protected void generateDiffImplSQLFile(AbstractListPlugin listPlugIn, List<Long> enableIdList) {
        try {
            StringBuilder sqlBuilder = new StringBuilder();
            sqlBuilder.append("/****** diff implement SQL ******/").append(STR_WRAP);
            String diffHandlerTargetSQL = this.generateDiffImplPreSQL(enableIdList);
            sqlBuilder.append(diffHandlerTargetSQL);
            String sqlFileName = String.format("%s_%s.sql", "impl_init", new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()));
            try (ByteArrayInputStream ins = new ByteArrayInputStream(sqlBuilder.toString().getBytes(StandardCharsets.UTF_8));){
                this.exportFile(listPlugIn, ins, sqlFileName);
            }
            catch (Exception e) {
                throw new KDException((Throwable)e, BosErrorCode.downloadFailed, new Object[]{String.format("KSQLExpPlugin error:%s.", e.getMessage())});
            }
        }
        catch (Exception e) {
            throw new KDBizException((Throwable)e, BosErrorCode.bOS, new Object[]{String.format("KSQLExpPlugin Error:%s.", e.getMessage())});
        }
    }

    private String generateDiffImplPreSQL(List<Long> enableIdList) {
        PreInsDataScriptBuilder builder = new PreInsDataScriptBuilder();
        String exportFields = "FID, FNUMBER, FNAME, FDIFFIMPLID, FSERVICEIMPL, FENABLE, FDESCRIPTION, FISV, FISV, FCREATORID, FCREATETIME, FMODIFIERID, FMODIFYTIME, FISSYSPRESET";
        StringBuilder whereConditionBuilder = new StringBuilder();
        String splitIds = Joiner.on((String)",").join(enableIdList);
        whereConditionBuilder.append(" FID IN (").append(splitIds).append(")");
        Map map = builder.genInsertSQLScript(DBRoute.of((String)"hmp"), "T_HBSS_DIFFCUSIMPL", exportFields, whereConditionBuilder.toString(), null, null);
        String sql = (String)map.get("sql");
        String exportMultiLanFields = "FPKID, FID, FLOCALEID, FNAME, FDESCRIPTION";
        Map multiLanMap = builder.genInsertSQLScript(DBRoute.of((String)"hmp"), "T_HBSS_DIFFCUSIMPL_L", exportMultiLanFields, whereConditionBuilder.toString(), null, null);
        String multiLanSQL = (String)multiLanMap.get("sql");
        return sql + STR_WRAP + multiLanSQL;
    }

    private void exportFile(AbstractListPlugin listPlugIn, InputStream ins, String sqlFileName) {
        String url = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(sqlFileName, ins, 5000);
        listPlugIn.getView().openUrl(url);
    }
}

