/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbss.formplugin.web.hrbu;

import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.DataEntitySerializer;
import kd.bos.dataentity.serialization.DataEntitySerializerOption;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.tree.TreeNode;
import kd.bos.entity.tree.TreeNodeLabel;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.entity.validate.ValidateResultCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.list.IListView;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.ILogService;
import kd.bos.log.api.OpLogAppInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.business.dao.factory.HRBaseDaoFactory;
import kd.hr.hbp.business.export.ExportTaskClick;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRQueryEntityHelper;
import kd.hr.hbp.common.cache.HRAppCache;
import kd.hr.hbp.common.cache.IHRAppCache;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRStandardTreeList;
import kd.hr.hbss.bussiness.service.hrbu.HRBUSyncStrategyService;
import kd.hr.hbss.bussiness.service.hrbu.HRBUValidationService;
import kd.hr.hbss.bussiness.servicehelper.HRBUExtServiceHelper;
import kd.hr.hbss.common.constants.HRBUConstants;
import kd.hr.hbss.common.model.OrgInfo;
import kd.hr.hbss.formplugin.web.hrbu.model.HROrgValidateType;

public abstract class HRBUCommonTreeList
extends HRStandardTreeList {
    public HRBUCommonTreeList(String entityName, String rootId, boolean isInCludeChild) {
        super(entityName, rootId, isInCludeChild);
    }

    public static void writeOpLog(String appId, String entityNum, String opKey, MultiLangEnumBridge opName, MultiLangEnumBridge msg) {
        ILogService service = (ILogService)ServiceFactory.getService(ILogService.class);
        OpLogAppInfo appLogInfo = new OpLogAppInfo();
        appLogInfo.setOpName(opKey, opName);
        appLogInfo.setOpDesc(msg, new String[0]);
        appLogInfo.setBizObjID(entityNum);
        appLogInfo.setBizAppID(PermCommonUtil.getAppIdFromSuspectedAppNum((String)appId));
        appLogInfo.setUserID(Long.valueOf(RequestContext.get().getCurrUserId()));
        service.addLog((AppLogInfo)appLogInfo);
    }

    protected void writeRemoveOpLog() {
        MultiLangEnumBridge msgDs = new MultiLangEnumBridge("\u79fb\u9664\u64cd\u4f5c", "HRBUCommonTreeList_3", "hrmp-hbss-formplugin");
        MultiLangEnumBridge opName = new MultiLangEnumBridge("\u79fb\u9664", "HRBUCommonTreeList_2", "hrmp-hbss-formplugin");
        HRBUCommonTreeList.writeOpLog(this.getView().getFormShowParameter().getAppId(), this.getListEntityNumber(), "remove", opName, msgDs);
    }

    protected void writeFreezeOpLog() {
        MultiLangEnumBridge msgDs = new MultiLangEnumBridge("\u5c01\u5b58\u64cd\u4f5c", "HRBUCommonTreeList_4", "hrmp-hbss-formplugin");
        MultiLangEnumBridge opName = new MultiLangEnumBridge("\u5c01\u5b58", "HRBUCommonTreeList_6", "hrmp-hbss-formplugin");
        HRBUCommonTreeList.writeOpLog(this.getView().getFormShowParameter().getAppId(), this.getListEntityNumber(), "freeze", opName, msgDs);
    }

    protected void writeUnFreezeOpLog() {
        MultiLangEnumBridge msgDs = new MultiLangEnumBridge("\u89e3\u5c01\u64cd\u4f5c", "HRBUCommonTreeList_5", "hrmp-hbss-formplugin");
        MultiLangEnumBridge opName = new MultiLangEnumBridge("\u89e3\u5c01", "HRBUCommonTreeList_7", "hrmp-hbss-formplugin");
        HRBUCommonTreeList.writeOpLog(this.getView().getFormShowParameter().getAppId(), this.getListEntityNumber(), "unfreeze", opName, msgDs);
    }

    private String getFreezeActionName() {
        return ResManager.loadKDString((String)"\u5c01\u5b58", (String)"HRBUCommonTreeList_6", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]);
    }

    private String getUnFreezeActionName() {
        return ResManager.loadKDString((String)"\u89e3\u5c01", (String)"HRBUCommonTreeList_7", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]);
    }

    private String getSuccessUnFreezeTip() {
        return ResManager.loadKDString((String)"\u89e3\u5c01\u6210\u529f", (String)"HRBUCommonTreeList_9", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]);
    }

    private String getSuccessFreezeTip() {
        return ResManager.loadKDString((String)"\u5c01\u5b58\u6210\u529f", (String)"HRBUCommonTreeList_8", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"freeze", "unfreeze"});
    }

    protected boolean checkUserPermission(String permItemId, String entityNum) {
        return PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)"XYRL3+A8Z+Z", (String)entityNum, (String)permItemId);
    }

    protected void startJob(List<Long> orgIdList, Long viewId, HROrgValidateType orgValidateType) {
        IHRAppCache appCache = HRAppCache.get((String)"hbss");
        appCache.put("HROrgValidateTask" + RequestContext.get().getCurrUserId(), orgIdList);
        JobInfo jobInfo = new JobInfo();
        jobInfo.setRunByLang(Lang.get());
        jobInfo.setAppId("hbss");
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setRunByUserId(RequestContext.get().getCurrUserId());
        jobInfo.setName(this.getCaption(orgValidateType));
        jobInfo.setId(UUID.randomUUID().toString());
        jobInfo.setRunByLang(RequestContext.get().getLang());
        jobInfo.setTaskClassname(orgValidateType.getValidateClass());
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("orgIdList", orgIdList);
        params.put("viewId", viewId);
        params.put("tip", this.getTip());
        jobInfo.setParams(params);
        this.getView().getFormShowParameter().getCustomParams().putAll(params);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, orgValidateType.getActionId());
        JobFormInfo jobFormInfo = new JobFormInfo(jobInfo);
        jobFormInfo.setCloseCallBack(closeCallBack);
        jobFormInfo.setCanBackground(true);
        jobFormInfo.setCanStop(true);
        jobFormInfo.setClickClassName(ExportTaskClick.class.getName());
        this.dispatch(jobFormInfo, this.getView());
    }

    private String getCaption(HROrgValidateType orgValidateType) {
        if (HROrgValidateType.RENOVE == orgValidateType) {
            return ResManager.loadKDString((String)"\u79fb\u9664\u7ec4\u7ec7\u6821\u9a8c", (String)"HROrgValidateType_1", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]);
        }
        return ResManager.loadKDString((String)"\u5c01\u5b58\u7ec4\u7ec7\u6821\u9a8c", (String)"HROrgValidateType_0", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]);
    }

    private String getTip() {
        return ResManager.loadKDString((String)"\u6821\u9a8c\u8fdb\u884c\u4e2d\uff0c\u8bf7\u7a0d\u5019...", (String)"HROrgValidateType_2", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]);
    }

    private void dispatch(JobFormInfo jobFormInfo, IFormView view) {
        jobFormInfo.setRootPageId(view.getFormShowParameter().getRootPageId());
        jobFormInfo.setParentPageId(view.getPageId());
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("hbss_taskprogress");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        if (StringUtils.isNotBlank((CharSequence)jobFormInfo.getCaption())) {
            showParameter.setCaption(jobFormInfo.getCaption());
        } else if (StringUtils.isNotBlank((CharSequence)jobFormInfo.getJobInfo().getName())) {
            showParameter.setCaption(jobFormInfo.getJobInfo().getName());
        }
        showParameter.getCustomParams().put("ServiceAppId", view.getFormShowParameter().getServiceAppId());
        String jobInfoStr = SerializationUtils.toJsonString((Object)jobFormInfo);
        showParameter.getCustomParams().put("sch_clientjobinfo", jobInfoStr);
        showParameter.setCloseCallBack(jobFormInfo.getCloseCallBack());
        view.showForm(showParameter);
    }

    protected void doTaskEnd(ClosedCallBackEvent event) {
        if (HRStringUtils.equals((String)event.getActionId(), (String)HROrgValidateType.RENOVE.getActionId())) {
            IHRAppCache appCache = HRAppCache.get((String)"hbss");
            appCache.remove("HROrgValidateTask" + RequestContext.get().getCurrUserId());
            Map result = (Map)event.getReturnData();
            if (result == null) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u79fb\u9664\u64cd\u4f5c\u5df2\u88ab\u7ec8\u6b62\u3002", (String)"HRBUCommonTreeList_1", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]));
                return;
            }
            String taskInfoStr = (String)result.get("taskinfo");
            TaskInfo taskInfo = (TaskInfo)SerializationUtils.fromJsonString((String)taskInfoStr, TaskInfo.class);
            Map taskInfoMap = (Map)SerializationUtils.fromJsonString((String)taskInfo.getData(), Map.class);
            if (Objects.isNull(taskInfoMap)) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u79fb\u9664\u64cd\u4f5c\u5df2\u88ab\u7ec8\u6b62\u3002", (String)"HRBUCommonTreeList_1", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]));
                return;
            }
            Boolean allSuccess = (Boolean)taskInfoMap.get("allSuccess");
            if (allSuccess.booleanValue()) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u79fb\u9664\u6210\u529f", (String)"HRBUCommonTreeList_0", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]));
                return;
            }
            Integer count = (Integer)taskInfoMap.get("count");
            if (count == 1) {
                StringBuilder content = new StringBuilder();
                Map checkErrorResult = (Map)taskInfoMap.get("checkResult");
                Collection values = checkErrorResult.values();
                List next = (List)values.iterator().next();
                if (next.size() == 1) {
                    Map org = (Map)next.get(0);
                    OrgInfo orgInfo = (OrgInfo)SerializationUtils.fromJsonString((String)JSONObject.toJSONString((Object)org), OrgInfo.class);
                    HRBUValidationService.initRefData((OrgInfo)orgInfo, (StringBuilder)content);
                    this.getView().showErrorNotification(content.toString());
                    return;
                }
            }
            FormShowParameter fsp = new FormShowParameter();
            fsp.setFormId("hbss_orgcheckresult");
            fsp.setHasRight(true);
            fsp.getOpenStyle().setShowType(ShowType.Modal);
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "checkValidateTaskResult");
            fsp.setCloseCallBack(closeCallBack);
            fsp.setCustomParams(result);
            this.getView().showForm(fsp);
        } else if (HRStringUtils.equals((String)event.getActionId(), (String)HROrgValidateType.FREEZE.getActionId())) {
            Map result = (Map)event.getReturnData();
            if (result == null) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5c01\u5b58\u64cd\u4f5c\u5df2\u88ab\u7ec8\u6b62\u3002", (String)"HRBUCommonTreeList_16", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]));
                return;
            }
            String taskInfoStr = (String)result.get("taskinfo");
            TaskInfo taskInfo = (TaskInfo)SerializationUtils.fromJsonString((String)taskInfoStr, TaskInfo.class);
            Map taskInfoMap = (Map)SerializationUtils.fromJsonString((String)taskInfo.getData(), Map.class);
            if (Objects.isNull(taskInfoMap)) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5c01\u5b58\u64cd\u4f5c\u5df2\u88ab\u7ec8\u6b62\u3002", (String)"HRBUCommonTreeList_16", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]));
                return;
            }
            Object count = taskInfoMap.get("count");
            Object successCount = taskInfoMap.get("successCount");
            Object failCount = taskInfoMap.get("failCount");
            Map detail = (Map)taskInfoMap.get("result");
            this.showValidateResult(detail, count, successCount, failCount, this.getFreezeActionName(), this.getSuccessFreezeTip());
        }
    }

    private void showValidateResult(Map<Long, List<String>> detail, Object count, Object successCount, Object failCount, String actionName, String successTip) {
        if ("0".equals(String.valueOf(failCount))) {
            this.getView().showSuccessNotification(successTip);
            return;
        }
        if ("1".equals(String.valueOf(count))) {
            StringBuilder tips = new StringBuilder();
            detail.values().forEach(value -> tips.append(Joiner.on((String)";").join((Iterable)value)));
            this.getView().showErrorNotification(tips.toString());
            return;
        }
        String title = String.format(ResManager.loadKDString((String)"\u5171%1$s\u6761\u6570\u636e\uff0c%2$s\u6210\u529f%3$s\u6761\uff0c\u5931\u8d25%4$s\u6761", (String)"HRBUCommonTreeList_10", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]), count, actionName, successCount, failCount);
        OperationResult operationResult = new OperationResult();
        operationResult.setMessage(title);
        operationResult.setSuccess(false);
        ValidateResultCollection validateResultCollection = new ValidateResultCollection();
        ValidateResult validateResult = new ValidateResult();
        ArrayList errorInfoList = Lists.newArrayList();
        for (List<String> value2 : detail.values()) {
            OperateErrorInfo operateErrorInfo = new OperateErrorInfo();
            operateErrorInfo.setMessage(Joiner.on((String)";").join(value2));
            operateErrorInfo.setTitle(actionName);
            operateErrorInfo.setErrorCode("errorcode_001");
            operateErrorInfo.setLevel(ErrorLevel.Error);
            errorInfoList.add(operateErrorInfo);
        }
        validateResult.setAllErrorInfo((List)errorInfoList);
        validateResult.setMessage(title);
        validateResult.setValidatorKey("freeze");
        validateResultCollection.addValidateError(actionName, validateResult);
        validateResultCollection.setMessage(title);
        operationResult.setValidateResult(validateResultCollection);
        FormShowParameter parameters = new FormShowParameter();
        parameters.getOpenStyle().setShowType(ShowType.Modal);
        parameters.setFormId("bos_operationresult");
        parameters.setShowTitle(false);
        IPageCache pageCache = this.getPageCache();
        DataEntitySerializerOption option = new DataEntitySerializerOption();
        option.setIncludeComplexProperty(true);
        String serialResult = DataEntitySerializer.serializerToString((Object)operationResult, (DataEntitySerializerOption)option);
        pageCache.put("operationresult", serialResult);
        List errorOrValidateInfos = operationResult.getAllErrorOrValidateInfo();
        parameters.setCustomParam("hasMore", (Object)(errorOrValidateInfos.size() > 5 ? 1 : 0));
        ArrayList<String> list = new ArrayList<String>();
        int len = errorOrValidateInfos.size();
        for (int i = 0; i < 5 && i < len; ++i) {
            IOperateInfo errorInfo = (IOperateInfo)errorOrValidateInfos.get(i);
            list.add(errorInfo.getMessage());
        }
        parameters.setCustomParam("errorMsg", list);
        parameters.setCustomParam("title", (Object)title);
        this.getView().showForm(parameters);
    }

    protected boolean isFreezeTreeNode(Object bosOrgId, Object viewId, boolean isTip) {
        QFilter qFilter = new QFilter("org.id", "=", (Object)Long.valueOf(String.valueOf(bosOrgId)));
        qFilter.and("isfreeze", "=", (Object)"1");
        qFilter.and("view.id", "=", viewId);
        boolean bos_org_structure = new HRBaseServiceHelper("bos_org_structure").isExists(qFilter);
        if (bos_org_structure) {
            if (isTip) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u4e3a\u5df2\u5c01\u5b58\u7ec4\u7ec7\u6dfb\u52a0\u4e0b\u7ea7\u7ec4\u7ec7\u3002", (String)"HRBUCommonTreeList_11", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]));
            }
            return true;
        }
        return false;
    }

    public void itemClick(ItemClickEvent evt) {
        if (HRStringUtils.equals((String)evt.getItemKey(), (String)"freeze")) {
            if (this.checkFreezePermission()) {
                return;
            }
            if (((IListView)this.getView()).getSelectedRows().size() != 0) {
                List orgInfo;
                Integer customParam = (Integer)this.getView().getFormShowParameter().getCustomParam("HRBUCAId");
                Long viewId = customParam == null ? HRBUConstants.HR_VIEW_ID : Long.valueOf(String.valueOf(customParam));
                List bosOrgStructIdList = Arrays.stream(((IListView)this.getView()).getSelectedRows().getPrimaryKeyValues()).collect(Collectors.toList());
                List orgIdList = HRBUExtServiceHelper.transferOrgStructId2OrgId(bosOrgStructIdList);
                if (orgIdList.size() == 1 && ((OrgInfo)(orgInfo = HRBUExtServiceHelper.getOrgInfo((List)orgIdList, (Long)viewId)).get(0)).isFreeze()) {
                    this.getView().showErrorNotification(HRBUValidationService.getTipOfFreeze((OrgInfo)((OrgInfo)orgInfo.get(0))));
                    return;
                }
                List childViewDys = HRBUSyncStrategyService.getChildViewDys((long)viewId);
                if (childViewDys != null && childViewDys.stream().anyMatch(dy -> dy.getLong("id") != viewId.longValue())) {
                    ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("freeze", (IFormPlugin)this);
                    String name = childViewDys.stream().filter(dy -> dy.getLong("id") != viewId.longValue()).map(dy -> dy.getString("name")).collect(Collectors.joining("\uff0c"));
                    String confirmTip = ResManager.loadKDString((String)"\u201c%1$s\u201d\u7684\u540c\u6b65\u7b56\u7565\u4e0e\u5f53\u524d\u89c6\u56fe\u4fdd\u6301\u4e00\u81f4\u3002\u82e5\u5728\u5f53\u524d\u89c6\u56fe\u4e2d\u5c01\u5b58\u6240\u9009\u7ec4\u7ec7\uff0c\u5c06\u4f1a\u5728\u4ee5\u4e0a\u89c6\u56fe\u4e2d\u540c\u6b65\u5c01\u5b58\u3002\u786e\u5b9a\u5c01\u5b58\u5417\uff1f", (String)"HRBUCommonTreeList_12", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]);
                    this.getView().showConfirm(String.format(confirmTip, name), MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBacks);
                } else {
                    this.writeFreezeOpLog();
                    this.startJob(orgIdList, viewId, HROrgValidateType.FREEZE);
                }
            }
        } else if (HRStringUtils.equals((String)evt.getItemKey(), (String)"unfreeze")) {
            if (this.checkUnfreezePermission()) {
                return;
            }
            if (((IListView)this.getView()).getSelectedRows().size() != 0) {
                List orgInfo;
                Integer customParam = (Integer)this.getView().getFormShowParameter().getCustomParam("HRBUCAId");
                Long viewId = customParam == null ? HRBUConstants.HR_VIEW_ID : Long.valueOf(String.valueOf(customParam));
                List bosOrgStructIdList = Arrays.stream(((IListView)this.getView()).getSelectedRows().getPrimaryKeyValues()).collect(Collectors.toList());
                List orgIdList = HRBUExtServiceHelper.transferOrgStructId2OrgId(bosOrgStructIdList);
                if (((IListView)this.getView()).getSelectedRows().size() == 1 && !((OrgInfo)(orgInfo = HRBUExtServiceHelper.getOrgInfo((List)orgIdList, (Long)viewId)).get(0)).isFreeze()) {
                    this.getView().showErrorNotification(HRBUValidationService.getTipOfUnFreeze((OrgInfo)((OrgInfo)orgInfo.get(0))));
                    return;
                }
                List childViewDys = HRBUSyncStrategyService.getChildViewDys((long)viewId);
                if (childViewDys != null && childViewDys.stream().anyMatch(dy -> dy.getLong("id") != viewId.longValue())) {
                    ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("unfreeze", (IFormPlugin)this);
                    String name = childViewDys.stream().filter(dy -> dy.getLong("id") != viewId.longValue()).map(dy -> dy.getString("name")).collect(Collectors.joining("\uff0c"));
                    String confirmTip = ResManager.loadKDString((String)"\u201c%1$s\u201d\u7684\u540c\u6b65\u7b56\u7565\u4e0e\u5f53\u524d\u89c6\u56fe\u4fdd\u6301\u4e00\u81f4\u3002\u82e5\u5728\u5f53\u524d\u89c6\u56fe\u4e2d\u89e3\u5c01\u6240\u9009\u7ec4\u7ec7\uff0c\u5c06\u4f1a\u5728\u4ee5\u4e0a\u89c6\u56fe\u4e2d\u540c\u6b65\u89e3\u5c01\u3002\u786e\u5b9a\u89e3\u5c01\u5417\uff1f", (String)"HRBUCommonTreeList_13", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]);
                    this.getView().showConfirm(String.format(confirmTip, name), MessageBoxOptions.OKCancel, ConfirmTypes.Delete, confirmCallBacks);
                } else {
                    this.orgUnFreezeClick(viewId, orgIdList);
                }
            }
        }
    }

    private boolean checkUnfreezePermission() {
        if (!this.checkUserPermission("3FM810Q+TCG=", "hbss_hrbuca")) {
            String msg = ResManager.loadKDString((String)"\u65e0\u201cHR\u4e1a\u52a1\u7ba1\u7406\u89c6\u56fe\u201d\u7684\u201c\u89e3\u5c01\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"HRBUViewQueryTreeList_13", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(msg);
            return true;
        }
        return false;
    }

    private boolean checkFreezePermission() {
        if (!this.checkUserPermission("3FM808TGOYR1", "hbss_hrbuca")) {
            String msg = ResManager.loadKDString((String)"\u65e0\u201cHR\u4e1a\u52a1\u7ba1\u7406\u89c6\u56fe\u201d\u7684\u201c\u5c01\u5b58\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"HRBUViewQueryTreeList_12", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(msg);
            return true;
        }
        return false;
    }

    private void orgUnFreezeClick(Long viewId, List<Long> orgIdList) {
        this.writeUnFreezeOpLog();
        Map validateResult = HRBUValidationService.orgUnFreezeValidate(orgIdList, (Long)viewId);
        this.showValidateResult(validateResult, orgIdList.size(), orgIdList.size() - validateResult.size(), validateResult.size(), this.getUnFreezeActionName(), this.getSuccessUnFreezeTip());
        this.updatePage1();
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        if (event.getResult() == MessageBoxResult.Yes) {
            Integer customParam = (Integer)this.getView().getFormShowParameter().getCustomParam("HRBUCAId");
            Long viewId = customParam == null ? HRBUConstants.HR_VIEW_ID : Long.valueOf(String.valueOf(customParam));
            List bosOrgStructIdList = Arrays.stream(((IListView)this.getView()).getSelectedRows().getPrimaryKeyValues()).collect(Collectors.toList());
            List orgIdList = HRBUExtServiceHelper.transferOrgStructId2OrgId(bosOrgStructIdList);
            if (StringUtils.equals((CharSequence)"freeze", (CharSequence)event.getCallBackId())) {
                if (this.checkFreezePermission()) {
                    return;
                }
                this.writeFreezeOpLog();
                this.startJob(orgIdList, viewId, HROrgValidateType.FREEZE);
            } else if (StringUtils.equals((CharSequence)"unfreeze", (CharSequence)event.getCallBackId())) {
                if (this.checkUnfreezePermission()) {
                    return;
                }
                this.orgUnFreezeClick(viewId, orgIdList);
            }
        }
    }

    protected void updatePage() {
        this.getView().updateView();
        this.getTreeListView().focusRootNode();
        this.getTreeListView().refreshTreeView();
        this.getTreeListView().refresh();
    }

    protected void updatePage1() {
        this.getTreeListView().focusRootNode();
        this.getTreeListView().refreshTreeView();
        this.getTreeListView().refresh();
    }

    protected DynamicObject getRootDynamicObject() {
        String selectFields = "org.id id,org.name name,parent,longnumber";
        QFilter filter = new QFilter("org.id", "=", (Object)Long.valueOf(this.getRootId()));
        QFilter viewFilter = this.setViewFilter();
        if (null != viewFilter) {
            filter.and(viewFilter);
        }
        QFilter[] filters = new QFilter[]{filter};
        return HRBaseDaoFactory.getInstance((String)this.getEntityName()).queryOriginalOne(selectFields, filters);
    }

    protected abstract QFilter setViewFilter();

    protected abstract QFilter getNodeClicFilter();

    protected DynamicObjectCollection getTreeViewCollection(String entityName, String parentId) {
        String selectFields = "org.id,org.name,parent,longnumber,isleaf,bos_org.enable,isfreeze";
        QFilter filter = new QFilter("parent", "=", (Object)Long.valueOf(parentId));
        QFilter viewFilter = this.setViewFilter();
        if (null != viewFilter) {
            filter.and(viewFilter);
        }
        QFilter[] filters = new QFilter[]{filter};
        QueryEntityType queryEntityType = (QueryEntityType)EntityMetadataCache.getDataEntityType((String)"hbss_hrbuviewquery");
        return HRQueryEntityHelper.getInstance().getQueryDyoColl(queryEntityType, selectFields, filters, "longnumber");
    }

    protected QFilter buildNodeClickFilter(BuildTreeListFilterEvent event) {
        String focusNodeId = event.getNodeId().toString();
        QFilter nodeClicFilter = this.getNodeClicFilter();
        if (!this.getTreeModel().getRoot().getId().equals(focusNodeId)) {
            ArrayList<Long> ids = new ArrayList<Long>();
            QFilter focusNodeFilter = new QFilter("org.id", "=", (Object)Long.valueOf(focusNodeId));
            focusNodeFilter.and(this.setViewFilter());
            DynamicObject dynamicObject = HRBaseDaoFactory.getInstance((String)this.getEntityName()).queryOne("longnumber", focusNodeFilter);
            if (ObjectUtils.isEmpty((Object)dynamicObject)) {
                TreeNode treeNode = new TreeNode();
                treeNode.setId(focusNodeId);
                this.getTreeModel().deleteNode(treeNode, true);
                this.getTreeListView().focusRootNode();
                this.getTreeListView().refreshTreeView();
                this.getTreeListView().refresh();
            } else {
                String focusNodeLongNumber = dynamicObject.getString("longnumber");
                QFilter filter = new QFilter("longnumber", "like", (Object)(focusNodeLongNumber + "!" + "%"));
                filter.or(focusNodeFilter);
                QFilter[] filters = new QFilter[]{filter};
                DynamicObjectCollection dyColl = HRBaseDaoFactory.getInstance((String)this.getEntityName()).queryColl("id", filters, null);
                for (DynamicObject object : dyColl) {
                    ids.add(object.getLong("id"));
                }
                if (null == nodeClicFilter) {
                    nodeClicFilter = new QFilter("bos_org_structure.id", "in", ids);
                } else {
                    QFilter bosOrgStructFilter = new QFilter("bos_org_structure.id", "in", ids);
                    nodeClicFilter.and(bosOrgStructFilter);
                }
            }
        }
        return nodeClicFilter;
    }

    public void refreshNode(RefreshNodeEvent refreshNodeEvent) {
        List<TreeNode> childNodes;
        String nodeId = refreshNodeEvent.getNodeId().toString();
        TreeNode node = this.getTreeModel().getRoot().getTreeNode(nodeId, 15);
        if (this.getTreeModel().getRoot().getId().equals(nodeId)) {
            childNodes = this.getChildNodesWrap(this.getEntityName(), this.getRootId());
        } else {
            childNodes = this.getChildNodesWrap(this.getEntityName(), nodeId);
            if (childNodes.size() > 0) {
                node.setIsOpened(true);
            }
        }
        refreshNodeEvent.setChildNodes(childNodes);
    }

    protected List<TreeNode> getChildNodesWrap(String entityName, String parentId) {
        ArrayList treeView = new ArrayList();
        DynamicObjectCollection dyColl = this.getTreeViewCollection(entityName, parentId);
        if (dyColl != null) {
            for (DynamicObject dy : dyColl) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("id", dy.getString("org.id"));
                map.put("name", dy.getString("org.name"));
                map.put("parent", dy.getString("parent"));
                map.put("isleaf", dy.getBoolean("isleaf") ? "1" : "0");
                map.put("isfreeze", dy.getBoolean("isfreeze") ? "1" : "0");
                map.put("enable", dy.getString("bos_org.enable"));
                treeView.add(map);
            }
        }
        return this.buildTreeChildNodes(treeView);
    }

    protected TreeNode genTreeNodeWrap(Map<String, String> map) {
        String enable;
        String isFreeze;
        TreeNode node = new TreeNode();
        String parentId = map.get("parent");
        node.setParentid(parentId);
        String nodeId = map.get("id");
        if (HRStringUtils.isEmpty((String)nodeId)) {
            return node;
        }
        node.setId(nodeId);
        String nodeName = map.get("name");
        if (HRStringUtils.isEmpty((String)nodeName)) {
            return node;
        }
        node.setText(nodeName);
        String longNumber = map.get("longnumber");
        node.setData((Object)longNumber);
        String isLeaf = map.get("isleaf");
        if ("0".equals(isLeaf)) {
            ArrayList list = new ArrayList();
            node.setChildren(list);
        }
        if ("1".equals(isFreeze = map.get("isfreeze"))) {
            node.setColor("#B2B2B2");
            node.setLabelPara((List)Lists.newArrayList((Object[])new TreeNodeLabel[]{new TreeNodeLabel(ResManager.loadKDString((String)"\u5c01", (String)"HRBUCommonTreeList_14", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]), "#666666")}));
            node.setLabelShowType(1);
        }
        if ("0".equals(enable = map.get("enable"))) {
            node.setColor("#B2B2B2");
            node.setLabelPara((List)Lists.newArrayList((Object[])new TreeNodeLabel[]{new TreeNodeLabel(ResManager.loadKDString((String)"\u7981", (String)"HRBUCommonTreeList_15", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]), "#666666")}));
            node.setLabelShowType(1);
        }
        return node;
    }
}

