/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbss.formplugin.web.hrbu;

import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.metadata.form.mcontrol.SearchAp;
import kd.bos.mvc.list.ListView;
import kd.bos.org.model.OrgTreeSearchParam;
import kd.bos.org.utils.OrgTreeUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbss.bussiness.service.hrbu.HRBUValidationService;
import kd.hr.hbss.bussiness.servicehelper.HRBUExtServiceHelper;
import kd.hr.hbss.common.constants.HRBUConstants;
import kd.hr.hbss.formplugin.web.hrbu.HRBUCommonTreeList;
import kd.hr.hbss.formplugin.web.hrbu.model.HROrgValidateType;

public class HRBUQueryTreeList
extends HRBUCommonTreeList
implements ClickListener {
    private static final String ORG_ID = "org.id";

    public HRBUQueryTreeList() {
        super("bos_org_structure", "0", false);
    }

    public String getRootId() {
        return String.valueOf(HRBUExtServiceHelper.queryChildrenViewRootByViewId((Object)HRBUConstants.HR_VIEW_ID).getLong(ORG_ID));
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"dobatchsave", "dodelete", "new"});
    }

    @Override
    protected QFilter setViewFilter() {
        return new QFilter("view.id", "=", (Object)Long.valueOf("11"));
    }

    @Override
    protected QFilter getNodeClicFilter() {
        return new QFilter("bos_org_structure.view.id", "=", (Object)Long.valueOf("11"));
    }

    public void search(SearchEnterEvent evt) {
        OrgTreeSearchParam searchParam = new OrgTreeSearchParam(evt.getText(), (ListView)this.getView(), "11");
        searchParam.setClickNode(true);
        OrgTreeUtils.searchFromLazyOrgTree((OrgTreeSearchParam)searchParam);
    }

    public void listRowClick(ListRowClickEvent evt) {
        ListSelectedRowCollection currentListAllRowCollection = ((BillList)evt.getSource()).getCurrentListAllRowCollection();
        Map rowMap = currentListAllRowCollection.stream().collect(Collectors.toMap(ListSelectedRow::getPrimaryKeyValue, Function.identity()));
        ListSelectedRowCollection listSelectedRowCollection = evt.getListSelectedRowCollection();
        if (listSelectedRowCollection.size() != 0) {
            listSelectedRowCollection.forEach(row -> {
                if (Objects.nonNull(rowMap.get(row.getPrimaryKeyValue()))) {
                    row.setName(((ListSelectedRow)rowMap.get(row.getPrimaryKeyValue())).getName());
                }
            });
        }
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        if (HRStringUtils.equals((String)evt.getItemKey(), (String)"dobatchsave")) {
            if (!this.checkUserPermission("0A3C+Y9O0ANY", "hbss_hrbuquery")) {
                String msg = ResManager.loadKDString((String)"\u65e0\u201cHR\u7ba1\u7406\u7ec4\u7ec7\u201d\u7684\u201c\u4ece\u4e1a\u52a1\u5355\u5143\u5f15\u5165\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"HRBUQueryTreeList_0", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]);
                this.getView().showErrorNotification(msg);
                return;
            }
            Object bosOrgId = this.getTreeListView().getTreeModel().getCurrentNodeId();
            if (this.isFreezeTreeNode(bosOrgId, HRBUConstants.HR_VIEW_ID, true)) {
                return;
            }
            ListShowParameter baseBuShowParameter = ShowFormHelper.createShowListForm((String)"bos_org", (boolean)true, (int)1, (boolean)true);
            baseBuShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "dobatchsave"));
            baseBuShowParameter.getListFilterParameter().setFilter(this.batchImportQFilter());
            baseBuShowParameter.setCustomParam("islockfunc", (Object)Boolean.TRUE);
            baseBuShowParameter.setLookUp(true);
            this.getView().showForm((FormShowParameter)baseBuShowParameter);
        } else if (HRStringUtils.equals((String)evt.getItemKey(), (String)"dodelete")) {
            if (this.checkRemovePermission()) {
                return;
            }
            if (((IListView)this.getView()).getSelectedRows().size() != 0) {
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("dodelete", (IFormPlugin)this);
                String confirmTip = ResManager.loadKDString((String)"\u79fb\u9664\u5f53\u524d\u7ec4\u7ec7\uff0c\u5176\u4e0b\u7ea7\u7ec4\u7ec7\u540c\u6837\u4f1a\u88ab\u79fb\u9664\uff0c\u786e\u5b9a\u79fb\u9664\u5417\uff1f", (String)"HRBUQueryTreeList_3", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]);
                this.getView().showConfirm(confirmTip, MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBacks);
            }
        } else if (HRStringUtils.equals((String)evt.getItemKey(), (String)"new")) {
            if (!this.checkUserPermission("47156aff000000ac", "hbss_hrbuquery")) {
                String msg = ResManager.loadKDString((String)"\u65e0\u201cHR\u7ba1\u7406\u7ec4\u7ec7\u201d\u7684\u201c\u65b0\u589e\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"HRBUQueryTreeList_4", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]);
                this.getView().showErrorNotification(msg);
                return;
            }
            Object bosOrgId = this.getTreeListView().getTreeModel().getCurrentNodeId();
            long orgId = Long.parseLong(String.valueOf(bosOrgId));
            if (this.isFreezeTreeNode(bosOrgId, HRBUConstants.HR_VIEW_ID, false)) {
                orgId = 0L;
            }
            BillShowParameter showParameter = new BillShowParameter();
            showParameter.setCustomParam("bosorg", (Object)orgId);
            showParameter.setCustomParam("parent", (Object)orgId);
            showParameter.setFormId("hbss_hrbuext");
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    private boolean checkRemovePermission() {
        if (!this.checkUserPermission("0=KX5+RLFFVN", "hbss_hrbuquery")) {
            String msg = ResManager.loadKDString((String)"\u65e0\u201cHR\u7ba1\u7406\u7ec4\u7ec7\u201d\u7684\u201c\u79fb\u9664\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"HRBUQueryTreeList_1", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(msg);
            return true;
        }
        return false;
    }

    private QFilter batchImportQFilter() {
        DynamicObject[] bosOrgDys = HRBUExtServiceHelper.getAllBosOrgStructureByView((Object)HRBUConstants.HR_VIEW_ID);
        QFilter qFilter = new QFilter("id", "not in", Arrays.stream(bosOrgDys).map(dy -> dy.getLong(ORG_ID)).collect(Collectors.toList()));
        qFilter.and(new QFilter("enable", "=", (Object)"1"));
        return qFilter;
    }

    public void beforeShowBill(BeforeShowBillFormEvent event) {
        BillShowParameter billShowParameter = event.getParameter();
        if (billShowParameter.getStatus().equals((Object)OperationStatus.ADDNEW)) {
            OpenStyle style = new OpenStyle();
            style.setShowType(ShowType.Modal);
            billShowParameter.setOpenStyle(style);
            Object parentid = this.getTreeModel().getCurrentNodeId();
            billShowParameter.setCustomParam("parent", parentid);
        }
    }

    public void setFilter(SetFilterEvent event) {
        event.getQFilters().add(this.getNodeClicFilter());
        event.setOrderBy("bos_org_structure.longnumber asc");
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
        BillList queryList = (BillList)args.getHyperLinkClickEvent().getSource();
        ListSelectedRow listRow = queryList.getCurrentSelectedRowInfo();
        Object bosOrgId = listRow.getQueryEntityPrimayKeyValue();
        BillShowParameter showParameter = new BillShowParameter();
        DynamicObject hrbuExtDy = HRBUExtServiceHelper.getHrbuExtByQueryListId((Object)bosOrgId);
        if (null == hrbuExtDy) {
            showParameter.setCustomParam("bosorg", bosOrgId);
        } else {
            Long hrbuExtId = hrbuExtDy.getLong("id");
            showParameter.setCustomParam("bosorg", bosOrgId);
            showParameter.setPkId((Object)hrbuExtId);
        }
        showParameter.setFormId("hbss_hrbuext");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        if (this.validateModifyPermission()) {
            showParameter.setStatus(OperationStatus.EDIT);
        } else {
            showParameter.setStatus(OperationStatus.VIEW);
        }
        StyleCss css = new StyleCss();
        showParameter.getOpenStyle().setInlineStyleCss(css);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private boolean validateModifyPermission() {
        return PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)"XYRL3+A8Z+Z", (String)"hbss_hrbuquery", (String)"4715a0df000000ac");
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
    }

    @Override
    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        if (event.getResult() == MessageBoxResult.Yes && StringUtils.equals((CharSequence)"dodelete", (CharSequence)event.getCallBackId())) {
            if (this.checkRemovePermission()) {
                return;
            }
            DynamicObject[] hrbuExtDys = this.setDelHRBUExtDys();
            TreeNode rootOrgTreeNode = HRBUExtServiceHelper.getRootOrgByViewId((Long)HRBUConstants.HR_VIEW_ID);
            List<Long> orgIdList = Arrays.stream(hrbuExtDys).map(el -> el.getLong("bosorg")).collect(Collectors.toList());
            if (orgIdList.stream().anyMatch(el -> el == Long.parseLong(rootOrgTreeNode.getId()))) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"%s\uff1a\u4e0d\u5141\u8bb8\u79fb\u9664\u6839\u7ec4\u7ec7\u3002", (String)"HRBUQueryTreeList_6", (String)"hrmp-hbss-formplugin", (Object[])new Object[]{rootOrgTreeNode.getText()}));
                this.updatePage();
                return;
            }
            this.writeRemoveOpLog();
            this.startJob(orgIdList, HRBUConstants.HR_VIEW_ID, HROrgValidateType.RENOVE);
        }
    }

    private DynamicObject[] setDelHRBUExtDys() {
        BillList queryList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectRows = queryList.getSelectedRows();
        DynamicObject[] hrbuExtDys = new DynamicObject[selectRows.size()];
        for (int i = 0; i < selectRows.size(); ++i) {
            ListSelectedRow listRow = selectRows.get(i);
            Object id = listRow.getPrimaryKeyValue();
            Object mainEntityId = listRow.getQueryEntityPrimayKeyValue();
            hrbuExtDys[i] = this.setDelHRBUExtDy(id, mainEntityId);
        }
        return hrbuExtDys;
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        IFormView view = this.getView();
        if (StringUtils.equals((CharSequence)event.getActionId(), (CharSequence)"dobatchsave") && event.getReturnData() != null) {
            Object currentNodeId = this.getTreeListView().getTreeModel().getCurrentNodeId();
            ListSelectedRowCollection bosOrgCollection = (ListSelectedRowCollection)event.getReturnData();
            DynamicObject[] hrbuExtDys = HRBUExtServiceHelper.setBosViewDys((ListSelectedRowCollection)bosOrgCollection, (String)"11", (Long)HRBUConstants.BU_VIEW_ID, (Object)currentNodeId);
            if (null == hrbuExtDys) {
                view.showErrorNotification(ResManager.loadKDString((String)"\u5f15\u5165\u5931\u8d25", (String)"HRBUQueryTreeList_7", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]));
                return;
            }
            OperationResult opResult = OperationServiceHelper.executeOperate((String)"dobatchsave", (String)"hbss_hrbuviewext", (DynamicObject[])hrbuExtDys, (OperateOption)OperateOption.create());
            if (opResult.isSuccess()) {
                view.showSuccessNotification(ResManager.loadKDString((String)"\u5f15\u5165\u6210\u529f", (String)"HRBUQueryTreeList_8", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]));
                HRBUExtServiceHelper.saveHRBUExt((ListSelectedRowCollection)bosOrgCollection);
            } else {
                view.showErrorNotification(opResult.getMessage());
            }
        } else {
            if (StringUtils.equals((CharSequence)event.getActionId(), (CharSequence)"ConfirmDisable")) {
                String opResult = view.getPageCache().get("opResult");
                if (opResult == null) {
                    view.showErrorNotification(ResManager.loadKDString((String)"\u7981\u7528\u5931\u8d25", (String)"HRBUQueryTreeList_9", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]));
                } else if ("success".equals(opResult)) {
                    view.showSuccessNotification(ResManager.loadKDString((String)"\u7981\u7528\u6210\u529f", (String)"HRBUQueryTreeList_10", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]));
                } else {
                    view.showErrorNotification(opResult);
                }
                this.updatePage1();
                return;
            }
            if (StringUtils.equals((CharSequence)event.getActionId(), (CharSequence)"UpdateView")) {
                this.updatePage1();
                return;
            }
            if (StringUtils.equals((CharSequence)event.getActionId(), (CharSequence)"Close")) {
                return;
            }
        }
        this.doTaskEnd(event);
        this.updatePage1();
    }

    private DynamicObject setDelHRBUExtDy(Object id, Object bosOrgId) {
        HRBaseServiceHelper editEntityhelper = new HRBaseServiceHelper("hbss_hrbuext");
        DynamicObject dy = editEntityhelper.generateEmptyDynamicObject();
        dy.set("id", id);
        dy.set("bosorg", bosOrgId);
        return dy;
    }

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        this.updateSearch();
        this.getView().setVisible(Boolean.valueOf(false), HRBUValidationService.getHideTag());
    }

    private void updateSearch() {
        SearchAp search = new SearchAp();
        search.setKey("searchap");
        search.setSearchEmptyText(new LocaleString(ResManager.loadKDString((String)"\u641c\u7d22\u7ec4\u7ec7\u540d\u79f0", (String)"HRBUQueryTreeList_11", (String)"hrmp-hbss-formplugin", (Object[])new Object[0])));
        this.getView().updateControlMetadata("searchap", search.createControl());
    }
}

