/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbss.formplugin.web.hrbu;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.BackgroundTaskSubscriber;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.schedule.form.TaskClientProxy;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.bos.threads.ThreadPools;

public class HRBUTaskProgressFormEdit
extends AbstractFormPlugin
implements ProgresssListener {
    private boolean canClose = false;
    private JobFormInfo jobFormInfo;

    public static Map<String, String> packageReturnResult(TaskInfo taskInfo) {
        if (taskInfo == null) {
            return null;
        }
        HashMap<String, String> result = new HashMap<String, String>();
        String taskInfoStr = SerializationUtils.toJsonString((Object)taskInfo);
        result.put("taskinfo", taskInfoStr);
        result.put("taskend", String.valueOf(taskInfo.isTaskEnd()));
        return result;
    }

    private static boolean isShowStackTrace() {
        Object isShowStackTrace;
        String showStackTrace = System.getProperty("exception_showstacktrace");
        if ("true".equals(showStackTrace)) {
            return true;
        }
        Map cache = SystemParamServiceHelper.loadPublicParametersFromCache();
        if (cache != null && cache.size() > 0 && (isShowStackTrace = cache.get("showstacktrace")) != null) {
            return (Boolean)isShowStackTrace;
        }
        return false;
    }

    private JobFormInfo getJobFormInfo() {
        if (this.jobFormInfo == null) {
            String str = (String)this.getView().getFormShowParameter().getCustomParam("sch_clientjobinfo");
            if (StringUtils.isBlank((CharSequence)str)) {
                return null;
            }
            this.jobFormInfo = (JobFormInfo)SerializationUtils.fromJsonString((String)str, JobFormInfo.class);
        }
        return this.jobFormInfo;
    }

    private String getTaskId() {
        return this.getView().getFormShowParameter().getCustomParams().containsKey("sch_taskid") ? (String)this.getView().getFormShowParameter().getCustomParam("sch_taskid") : this.getPageCache().get("sch_taskid");
    }

    private void setTaskId(String taskId) {
        this.getPageCache().put("sch_taskid", taskId);
    }

    private boolean isStart() {
        String start = this.getPageCache().get("isstart");
        return StringUtils.isBlank((CharSequence)start) ? false : Boolean.parseBoolean(start);
    }

    private void setStart(boolean start) {
        this.getPageCache().put("isstart", String.valueOf(start));
    }

    private boolean isFinished() {
        String finished = this.getPageCache().get("isfinished");
        return StringUtils.isBlank((CharSequence)finished) ? false : Boolean.parseBoolean(finished);
    }

    private void setFinished(boolean finished) {
        this.getPageCache().put("isfinished", String.valueOf(finished));
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ProgressBar bar = (ProgressBar)this.getView().getControl("progressbarap");
        bar.addProgressListener((ProgresssListener)this);
        this.addClickListeners(new String[]{"btnstop", "btnmin"});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.startBar();
        this.getView().setVisible(Boolean.FALSE, new String[]{"btnstop", "btnmin"});
        String taskId = this.getTaskId();
        if (StringUtils.isBlank((CharSequence)taskId)) {
            this.setProgressDesc(ResManager.loadKDString((String)"\u51c6\u5907\u542f\u52a8\u4efb\u52a1", (String)"TaskProgressFormEdit_1", (String)"bos-schedule-form", (Object[])new Object[0]));
        } else {
            TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)taskId);
            int progress = taskInfo.getProgress();
            if (progress >= 100) {
                progress = 99;
            }
            ProgressBar bar = (ProgressBar)this.getView().getControl("progressbarap");
            bar.setPercent(progress);
            this.setProgressDesc(taskInfo.getDesc());
            JobFormInfo jobFormInfo = this.getJobFormInfo();
            if (jobFormInfo != null) {
                this.setButtonVisible(jobFormInfo);
            }
        }
    }

    public void click(EventObject e) {
        Control source = (Control)e.getSource();
        if (StringUtils.equals((CharSequence)source.getKey(), (CharSequence)"btnstop")) {
            this.stop();
        } else if (StringUtils.equals((CharSequence)source.getKey(), (CharSequence)"btnmin")) {
            this.tranBackground();
        }
    }

    public void onProgress(ProgressEvent e) {
        String taskId = this.getTaskId();
        boolean start = this.isStart();
        this.setStart(true);
        if (!start && StringUtils.isBlank((CharSequence)taskId)) {
            this.dispatchTask();
        } else if (!StringUtils.isBlank((CharSequence)taskId)) {
            TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)taskId);
            if (taskInfo.isTaskEnd()) {
                this.complete(taskInfo, e);
            } else {
                int progress = taskInfo.getProgress();
                if (progress >= 100) {
                    progress = 99;
                }
                String desc = taskInfo.getDesc();
                e.setProgress(progress);
                if (StringUtils.isNotBlank((CharSequence)desc)) {
                    this.setProgressDesc(desc);
                }
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        String taskId;
        JobFormInfo jobFormInfo;
        super.beforeClosed(e);
        if (!this.isStart()) {
            e.setCancel(true);
        } else if (!(this.canClose || this.isFinished() || (jobFormInfo = this.getJobFormInfo()) == null || StringUtils.isBlank((CharSequence)(taskId = this.getTaskId())))) {
            if (jobFormInfo.isCanStop()) {
                this.stop();
                e.setCancel(true);
            } else if (jobFormInfo.isCanBackground()) {
                this.tranBackground();
                e.setCancel(true);
            } else {
                e.setCancel(true);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        if (evt.getResult() != MessageBoxResult.Yes) {
            this.startBar();
        } else if (StringUtils.equals((CharSequence)evt.getCallBackId(), (CharSequence)"continue_background")) {
            this.doTranBackground();
        } else {
            this.doStop();
            this.closeForm();
        }
    }

    private void startBar() {
        ProgressBar bar = (ProgressBar)this.getView().getControl("progressbarap");
        bar.start();
    }

    private void stopBar() {
        ProgressBar bar = (ProgressBar)this.getView().getControl("progressbarap");
        bar.stop();
    }

    private void closeForm() {
        this.canClose = true;
        TaskClientProxy.setProgressPageId((String)this.getTaskId(), (String)"");
        this.getView().close();
    }

    private void dispatchTask() {
        JobFormInfo jobFormInfo = this.getJobFormInfo();
        if (jobFormInfo != null) {
            if (StringUtils.isBlank((CharSequence)jobFormInfo.getJobInfo().getAppId())) {
                jobFormInfo.getJobInfo().setAppId(this.getView().getFormShowParameter().getServiceAppId());
            }
            String taskId = ScheduleServiceHelper.dispatch((JobInfo)jobFormInfo.getJobInfo());
            this.setTaskId(taskId);
            this.setButtonVisible(jobFormInfo);
        }
    }

    private void complete(TaskInfo taskInfo, ProgressEvent e) {
        boolean isFinished = this.isFinished();
        this.setFinished(true);
        if (StringUtils.equalsIgnoreCase((CharSequence)"FAILED", (CharSequence)taskInfo.getStatus())) {
            if (HRBUTaskProgressFormEdit.isShowStackTrace()) {
                this.getView().showErrMessage(taskInfo.getFailureReason(), "");
            } else {
                String errMsg = ResManager.loadKDString((String)"\u4efb\u52a1\u6267\u884c\u51fa\u9519\uff0c\u8be6\u60c5\u8bf7\u67e5\u9605\u65e5\u5fd7\u3002", (String)"TaskProgressFormEdit_2", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]);
                this.getView().showErrorNotification(errMsg);
            }
            this.stopBar();
        } else if (!isFinished) {
            e.setProgress(99);
            this.setProgressDesc(ResManager.loadKDString((String)"\u4efb\u52a1\u6267\u884c\u5b8c\u6bd5", (String)"TaskProgressFormEdit_3", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]));
        } else {
            this.returnResult(null);
            if (StringUtils.equalsIgnoreCase((CharSequence)"COMPLETED", (CharSequence)taskInfo.getStatus())) {
                this.returnResult(taskInfo);
            }
            this.stopBar();
            e.setProgress(100);
            this.closeForm();
        }
    }

    private void stop() {
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("continue_stop", (IFormPlugin)this);
        HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
        btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u7ee7\u7eed\u6267\u884c", (String)"TaskProgressFormEdit_4", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]));
        btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u7ec8\u6b62\u6267\u884c", (String)"TaskProgressFormEdit_5", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]));
        MessageBoxOptions options = MessageBoxOptions.OKCancel;
        String msg = ResManager.loadKDString((String)"\u4efb\u52a1\u8fd8\u672a\u6267\u884c\uff0c\u786e\u8ba4\u7ec8\u6b62\u6267\u884c\u5417\uff1f", (String)"TaskProgressFormEdit_6", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]);
        this.getView().showConfirm(msg, "", options, ConfirmTypes.Default, confirmCallBacks, btnNameMaps);
        this.stopBar();
    }

    private void doStop() {
        this.stopBar();
        String taskId = this.getTaskId();
        if (!StringUtils.isBlank((CharSequence)taskId)) {
            ScheduleServiceHelper.stopTask((String)taskId);
            TaskClientProxy.suspend((JobFormInfo)this.jobFormInfo, (String)taskId);
        }
    }

    private void tranBackground() {
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("continue_background", (IFormPlugin)this);
        HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
        btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"TaskProgressFormEdit_7", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]));
        btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u540e\u53f0\u6267\u884c", (String)"TaskProgressFormEdit_8", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]));
        MessageBoxOptions options = MessageBoxOptions.OKCancel;
        String msg = ResManager.loadKDString((String)"\u4efb\u52a1\u8fd8\u672a\u6267\u884c\u5b8c\u6210\uff0c\u786e\u8ba4\u8f6c\u5165\u540e\u53f0\u6267\u884c\u5417\uff1f", (String)"TaskProgressFormEdit_9", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]);
        this.getView().showConfirm(msg, "", options, ConfirmTypes.Default, confirmCallBacks, btnNameMaps);
        this.stopBar();
    }

    private void doTranBackground() {
        this.closeForm();
        String taskId = this.getTaskId();
        if (!StringUtils.isBlank((CharSequence)taskId)) {
            TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)taskId);
            if (!TaskClientProxy.isExistTask((String)taskId)) {
                TaskClientProxy.addTask((IFormView)this.getView(), (JobFormInfo)this.getJobFormInfo(), (TaskInfo)taskInfo);
                BackgroundTaskSubscriber subscriber = new BackgroundTaskSubscriber(RequestContext.get(), this.getJobFormInfo(), taskId);
                ThreadPools.executeOnce((String)"task-background-monitor", (Runnable)subscriber);
            }
        }
    }

    private void setProgressDesc(String desc) {
        Label lblDesc = (Label)this.getControl("lblprogress");
        lblDesc.setText(desc);
    }

    private void setButtonVisible(JobFormInfo jobFormInfo) {
        if (jobFormInfo.isCanStop()) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"btnstop"});
        }
        if (jobFormInfo.isCanBackground()) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"btnmin"});
        }
    }

    private void returnResult(TaskInfo taskInfo) {
        Map<String, String> result = HRBUTaskProgressFormEdit.packageReturnResult(taskInfo);
        if (result != null) {
            this.getView().returnDataToParent(result);
        }
    }
}

