/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbss.formplugin.web.hrbu;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListColumn;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.metadata.form.mcontrol.SearchAp;
import kd.bos.mvc.list.ListView;
import kd.bos.org.model.OrgTreeSearchParam;
import kd.bos.org.utils.OrgTreeUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbss.bussiness.servicehelper.HRBUExtServiceHelper;
import kd.hr.hbss.common.constants.HRBUConstants;
import kd.hr.hbss.formplugin.web.hrbu.HRBUCommonTreeList;
import kd.hr.hbss.formplugin.web.hrbu.model.HROrgValidateType;

public class HRBUViewQueryTreeList
extends HRBUCommonTreeList
implements ClickListener {
    private static final String ORG_ID = "org.id";

    public HRBUViewQueryTreeList() {
        super("bos_org_structure", "0", false);
    }

    public String getRootId() {
        return String.valueOf(HRBUExtServiceHelper.queryChildrenViewRootByViewId((Object)this.getView().getFormShowParameter().getCustomParam("HRBUCAId")).getLong(ORG_ID));
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"dobatchsave", "dodelete"});
    }

    @Override
    protected QFilter setViewFilter() {
        Object hrbuCAId = this.getView().getFormShowParameter().getCustomParam("HRBUCAId");
        if (null == hrbuCAId) {
            return null;
        }
        return new QFilter("view.id", "=", hrbuCAId);
    }

    @Override
    protected QFilter getNodeClicFilter() {
        Object hrbuCAId = this.getView().getFormShowParameter().getCustomParam("HRBUCAId");
        if (null == hrbuCAId) {
            return null;
        }
        return new QFilter("bos_org_structure.view.id", "=", hrbuCAId);
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        if (HRStringUtils.equals((String)evt.getItemKey(), (String)"dobatchsave")) {
            Object hrbuCAId;
            if (!this.checkUserPermission("350Z814BH+9L", "hbss_hrbuca")) {
                String msg = ResManager.loadKDString((String)"\u65e0\u201cHR\u4e1a\u52a1\u7ba1\u7406\u89c6\u56fe\u201d\u7684\u201c\u4eceHR\u7ba1\u7406\u7ec4\u7ec7\u5f15\u5165\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"HRBUViewQueryTreeList_0", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]);
                this.getView().showErrorNotification(msg);
                return;
            }
            Object bosOrgId = this.getTreeListView().getTreeModel().getCurrentNodeId();
            if (this.isFreezeTreeNode(bosOrgId, hrbuCAId = this.getView().getFormShowParameter().getCustomParam("HRBUCAId"), true)) {
                return;
            }
            ListShowParameter showListForm = ShowFormHelper.createShowListForm((String)"hbss_hrbulist", (boolean)true, (int)1, (boolean)true);
            showListForm.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "dobatchsave"));
            showListForm.getListFilterParameter().setQFilters(this.batchImportQFilter());
            showListForm.setCustomParam("orgFuncId", (Object)"11");
            this.getView().showForm((FormShowParameter)showListForm);
        } else if (HRStringUtils.equals((String)evt.getItemKey(), (String)"dodelete")) {
            if (this.checkRemovePermission()) {
                return;
            }
            if (((IListView)this.getView()).getSelectedRows().size() != 0) {
                ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("dodelete", (IFormPlugin)this);
                String confirmTip = ResManager.loadKDString((String)"\u79fb\u9664\u5f53\u524d\u7ec4\u7ec7\uff0c\u5176\u4e0b\u7ea7\u7ec4\u7ec7\u540c\u6837\u4f1a\u88ab\u79fb\u9664\uff0c\u786e\u5b9a\u79fb\u9664\u5417\uff1f", (String)"HRBUViewQueryTreeList_3", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]);
                this.getView().showConfirm(confirmTip, MessageBoxOptions.OKCancel, ConfirmTypes.Delete, confirmCallBackListener);
            }
        }
    }

    private boolean checkRemovePermission() {
        if (!this.checkUserPermission("0=KX5+RLFFVN", "hbss_hrbuca")) {
            String msg = ResManager.loadKDString((String)"\u65e0\u201cHR\u4e1a\u52a1\u7ba1\u7406\u89c6\u56fe\u201d\u7684\u201c\u79fb\u9664\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"HRBUViewQueryTreeList_1", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(msg);
            return true;
        }
        return false;
    }

    private List<QFilter> batchImportQFilter() {
        ArrayList qFilterList = Lists.newArrayListWithCapacity((int)16);
        Object bosViewId = this.getView().getFormShowParameter().getCustomParam("HRBUCAId");
        DynamicObject[] bosOrgDys = HRBUExtServiceHelper.getAllBosOrgStructureByView((Object)bosViewId);
        QFilter qFilter = new QFilter("id", "not in", Arrays.stream(bosOrgDys).map(dy -> dy.getLong(ORG_ID)).collect(Collectors.toList()));
        qFilter.and(new QFilter("enable", "=", (Object)"1"));
        qFilterList.add(qFilter);
        QFilter qFilter2 = new QFilter("structure.isfreeze", "=", (Object)"0");
        qFilter2.and(new QFilter("structure.view.id", "=", (Object)HRBUConstants.HR_VIEW_ID));
        qFilterList.add(qFilter2);
        QFilter qFilter3 = new QFilter("bos_org_structure.view.id", "=", (Object)HRBUConstants.HR_VIEW_ID);
        qFilter3.setJoinEntityPath("bos_org_structure");
        qFilterList.add(qFilter3);
        return qFilterList;
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        IListColumn listColumn = args.getListColumn("parent.name");
        if (!HRObjectUtils.isEmpty((Object)listColumn)) {
            Integer customParam = (Integer)this.getView().getFormShowParameter().getCustomParam("HRBUCAId");
            String hrbuCAId = String.valueOf(customParam);
            HRBaseServiceHelper hrbucafuncHelper = new HRBaseServiceHelper("bos_org_biz");
            DynamicObject result = hrbucafuncHelper.queryOriginalOne("fname,userdefinename", new QFilter("id", "=", (Object)Long.valueOf(hrbuCAId)));
            String name = result.getString("fname");
            if (StringUtils.isNotBlank((CharSequence)result.getString("userdefinename"))) {
                name = result.getString("userdefinename");
            }
            LocaleString localeString = new LocaleString(String.format(ResManager.loadKDString((String)"\u4e0a\u7ea7%s", (String)"HRBUViewQueryTreeList_4", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]), name));
            listColumn.setCaption(localeString);
        }
    }

    public void search(SearchEnterEvent evt) {
        OrgTreeSearchParam searchParam = new OrgTreeSearchParam(evt.getText(), (ListView)this.getView(), "11");
        searchParam.setClickNode(true);
        OrgTreeUtils.searchFromLazyOrgTree((OrgTreeSearchParam)searchParam);
    }

    public void beforeShowBill(BeforeShowBillFormEvent beforeShowBillFormEvent) {
        BillShowParameter billShowParameter = beforeShowBillFormEvent.getParameter();
        if (billShowParameter.getStatus().equals((Object)OperationStatus.ADDNEW)) {
            OpenStyle openStyle = new OpenStyle();
            openStyle.setShowType(ShowType.Modal);
            billShowParameter.setOpenStyle(openStyle);
            Object parentId = this.getTreeModel().getCurrentNodeId();
            billShowParameter.setCustomParam("parent", parentId);
            Long hrbuCAId = Long.parseLong(this.getView().getFormShowParameter().getCustomParam("HRBUCAId") + "");
            billShowParameter.setCustomParam("HRBUCAId", (Object)hrbuCAId);
        }
    }

    public void setFilter(SetFilterEvent event) {
        event.getQFilters().add(this.getNodeClicFilter());
        event.setOrderBy("longnumber asc");
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
        BillList queryList = (BillList)args.getHyperLinkClickEvent().getSource();
        ListSelectedRow listRow = queryList.getCurrentSelectedRowInfo();
        Object bosOrgStructId = listRow.getQueryEntityPrimayKeyValue();
        BillShowParameter showParameter = new BillShowParameter();
        DynamicObject hrbuExtDy = HRBUExtServiceHelper.getHrBuViewExtByQueryListId((Object)bosOrgStructId);
        if (null == hrbuExtDy) {
            showParameter.setCustomParam("bosorgstructure", bosOrgStructId);
        } else {
            Long hrbuExtId = hrbuExtDy.getLong("id");
            showParameter.setPkId((Object)hrbuExtId);
        }
        showParameter.setFormId("hbss_hrbuviewext");
        Object bosViewId = this.getView().getFormShowParameter().getCustomParam("HRBUCAId");
        showParameter.setCustomParam("HRBUCAId", bosViewId);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        if (this.validateModifyPermission()) {
            showParameter.setStatus(OperationStatus.EDIT);
        } else {
            showParameter.setStatus(OperationStatus.VIEW);
        }
        HRBaseServiceHelper hrbucafuncHelper = new HRBaseServiceHelper("bos_org_biz");
        DynamicObject result = hrbucafuncHelper.queryOriginalOne("fname,userdefinename", new QFilter("id", "=", bosViewId));
        String name = result.getString("fname");
        if (StringUtils.isNotBlank((CharSequence)result.getString("userdefinename"))) {
            name = result.getString("userdefinename");
        }
        showParameter.setCaption(name);
        showParameter.setCustomParam("parentorg_identify", (Object)name);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private boolean validateModifyPermission() {
        return PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)"XYRL3+A8Z+Z", (String)"hbss_hrbuca", (String)"4715a0df000000ac");
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        IFormView view = this.getView();
        if ((StringUtils.equals((CharSequence)event.getActionId(), (CharSequence)"dobatchsave") || StringUtils.equals((CharSequence)event.getActionId(), (CharSequence)"donew")) && event.getReturnData() != null) {
            Object currentNodeId = this.getTreeListView().getTreeModel().getCurrentNodeId();
            Object bosViewId = view.getFormShowParameter().getCustomParam("HRBUCAId");
            String viewNumber = HRBUExtServiceHelper.getViewNumberById((Object)bosViewId);
            ListSelectedRowCollection bosOrgCollection = (ListSelectedRowCollection)event.getReturnData();
            if (!this.validate(bosOrgCollection, currentNodeId)) {
                view.showErrorNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u76f8\u540c\u5c42\u7ea7\u4e0b\u5b58\u5728\u91cd\u540d\u7ec4\u7ec7\uff0c\u8bf7\u4fee\u6539\u540d\u79f0\u3002", (String)"HRBUViewQueryTreeList_6", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObject[] hrbuExtDys = HRBUExtServiceHelper.setBosViewDys((ListSelectedRowCollection)bosOrgCollection, (String)viewNumber, (Long)HRBUConstants.HR_VIEW_ID, (Object)currentNodeId);
            if (null == hrbuExtDys) {
                view.showErrorNotification(ResManager.loadKDString((String)"\u5f15\u5165\u5931\u8d25", (String)"HRBUViewQueryTreeList_7", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]));
                return;
            }
            OperationResult opResult = OperationServiceHelper.executeOperate((String)"dobatchsave", (String)"hbss_hrbuviewext", (DynamicObject[])hrbuExtDys, (OperateOption)OperateOption.create());
            if (opResult.isSuccess()) {
                view.showSuccessNotification(ResManager.loadKDString((String)"\u5f15\u5165\u6210\u529f", (String)"HRBUViewQueryTreeList_8", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]));
            } else {
                view.showErrorNotification(opResult.getMessage());
            }
        } else {
            if (StringUtils.equals((CharSequence)event.getActionId(), (CharSequence)"ConfirmDisable")) {
                this.updatePage1();
                return;
            }
            if (StringUtils.equals((CharSequence)event.getActionId(), (CharSequence)"UpdateView")) {
                this.updatePage1();
                return;
            }
            if (StringUtils.equals((CharSequence)event.getActionId(), (CharSequence)"Close")) {
                return;
            }
        }
        this.doTaskEnd(event);
        this.updatePage1();
    }

    private boolean validate(ListSelectedRowCollection bosOrgCollection, Object currentNodeId) {
        DynamicObject[] bosOrgDys;
        Long parentNode = Long.valueOf(String.valueOf(currentNodeId));
        Object[] bosOrgIds = bosOrgCollection.getPrimaryKeyValues();
        HRBaseServiceHelper bosOrgStHelper = new HRBaseServiceHelper("bos_org_structure");
        HRBaseServiceHelper bosOrgHelper = new HRBaseServiceHelper("bos_org");
        QFilter idFilter = new QFilter("id", "in", (Object)bosOrgIds);
        for (DynamicObject bosOrgDy : bosOrgDys = bosOrgHelper.query("id,name,number", new QFilter[]{idFilter})) {
            DynamicObject[] viewColl;
            String editName = bosOrgDy.getString("name");
            QFilter stFilter = new QFilter("org", "!=", (Object)bosOrgDy.getLong("id"));
            stFilter.and(new QFilter("parent.id", "=", (Object)parentNode));
            for (DynamicObject obj : viewColl = bosOrgStHelper.queryOriginalArray("org.name,org.number,org.fisadministrative,parent.id", new QFilter[]{stFilter})) {
                String name = obj.getString("org.name");
                boolean isadministrative = obj.getBoolean("org.fisadministrative");
                if (!HRStringUtils.equals((String)editName, (String)name) || isadministrative) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        if (StringUtils.equals((CharSequence)"dodelete", (CharSequence)event.getCallBackId()) && event.getResult() == MessageBoxResult.Yes) {
            if (this.checkRemovePermission()) {
                return;
            }
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("dodelete", "true");
            DynamicObject[] hrbuExtDys = this.setDelHRBUExtDys();
            Object bosViewId = this.getView().getFormShowParameter().getCustomParam("HRBUCAId");
            Long viewId = Long.valueOf(String.valueOf(bosViewId));
            TreeNode rootOrgTreeNode = HRBUExtServiceHelper.getRootOrgByViewId((Long)viewId);
            List<Long> orgIdList = Arrays.stream(hrbuExtDys).map(el -> el.getLong("name")).collect(Collectors.toList());
            if (orgIdList.stream().anyMatch(el -> el == Long.parseLong(rootOrgTreeNode.getId()))) {
                String msg = String.format(ResManager.loadKDString((String)"%s\uff1a\u4e0d\u5141\u8bb8\u79fb\u9664\u6839\u7ec4\u7ec7\u3002", (String)"HRBUViewQueryTreeList_10", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]), rootOrgTreeNode.getText());
                this.getView().showErrorNotification(msg);
                this.updatePage();
                return;
            }
            this.writeRemoveOpLog();
            this.startJob(orgIdList, viewId, HROrgValidateType.RENOVE);
        }
    }

    private DynamicObject[] setDelHRBUExtDys() {
        BillList queryList = (BillList)this.getControl("billlistap");
        IListView listView = (IListView)this.getView();
        Object bosViewId = listView.getFormShowParameter().getCustomParam("HRBUCAId");
        String viewNumber = HRBUExtServiceHelper.getViewNumberById((Object)bosViewId);
        ListSelectedRowCollection selectRows = queryList.getSelectedRows();
        ArrayList bosOrgIdList = Lists.newArrayListWithExpectedSize((int)selectRows.size());
        for (ListSelectedRow listSelectedRow : selectRows) {
            bosOrgIdList.add(listSelectedRow.getQueryEntityPrimayKeyValue());
        }
        DynamicObject[] bosOrgStructDys = HRBUExtServiceHelper.getBosOrgStructuresByBosOrgs((List)bosOrgIdList);
        HashMap<Long, Long> bosOrgIdToStructIdMap = new HashMap<Long, Long>(bosOrgStructDys.length);
        for (DynamicObject dy : bosOrgStructDys) {
            Long bosOrgId = dy.getLong(ORG_ID);
            Long bosOrgStructId = dy.getLong("id");
            bosOrgIdToStructIdMap.put(bosOrgStructId, bosOrgId);
        }
        DynamicObject[] hrbuExtDys = new DynamicObject[selectRows.size()];
        for (int i = 0; i < selectRows.size(); ++i) {
            ListSelectedRow listRow = selectRows.get(i);
            Object id = listRow.getPrimaryKeyValue();
            Object mainEntityId = listRow.getQueryEntityPrimayKeyValue();
            Object bosOrgId = bosOrgIdToStructIdMap.get(Long.valueOf(mainEntityId.toString()));
            hrbuExtDys[i] = this.setDelHRBUExtDy(id, mainEntityId, bosOrgId, viewNumber);
        }
        return hrbuExtDys;
    }

    private DynamicObject setDelHRBUExtDy(Object id, Object bosOrgStructId, Object bosOrgId, String viewNumber) {
        HRBaseServiceHelper editEntityhelper = new HRBaseServiceHelper("hbss_hrbuviewext");
        DynamicObject dy = editEntityhelper.generateEmptyDynamicObject();
        dy.set("id", id);
        dy.set("bosorgstructure", bosOrgStructId);
        dy.set("name", bosOrgId);
        dy.set("viewnumber", (Object)viewNumber);
        return dy;
    }

    public void beforeBindData(EventObject object) {
        super.beforeBindData(object);
        this.updateSearch();
    }

    private void updateSearch() {
        SearchAp searchAp = new SearchAp();
        searchAp.setKey("searchap");
        searchAp.setSearchEmptyText(new LocaleString(ResManager.loadKDString((String)"\u641c\u7d22\u7ec4\u7ec7\u540d\u79f0", (String)"HRBUViewQueryTreeList_11", (String)"hrmp-hbss-formplugin", (Object[])new Object[0])));
        this.getView().updateControlMetadata("searchap", searchAp.createControl());
    }

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        long hrbuCAId = Long.parseLong(this.getView().getFormShowParameter().getCustomParam("HRBUCAId") + "");
        DynamicObject hrBuCaDy = HRBUExtServiceHelper.getHrBuCaDyById((long)hrbuCAId);
        String syncStrategy = hrBuCaDy.getString("syncstrategy");
        if ("0".equals(syncStrategy)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"new", "dodelete", "doenable", "dodisable", "dobatchsave", "freeze", "unfreeze"});
        } else {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"new", "dodelete", "doenable", "dodisable", "dobatchsave", "refresh", "Close", "freeze", "unfreeze"});
        }
    }
}

