/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbss.formplugin.web.hrbu.event;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import kd.bos.bec.api.IEventServicePlugin;
import kd.bos.bec.model.KDBizEvent;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.model.OperationType;
import kd.bos.org.model.OrgDutyView;
import kd.bos.org.model.OrgParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbss.bussiness.service.hrbu.HRBUValidationService;
import kd.hr.hbss.bussiness.servicehelper.HRBUExtServiceHelper;

public class ReRootOrgEventPlugin
implements IEventServicePlugin {
    private static final Log LOGGER = LogFactory.getLog(ReRootOrgEventPlugin.class);
    private static final Long HR_VIEW_ID = 11L;

    public Object handleEvent(KDBizEvent evt) {
        LOGGER.info("ReRootOrgEventPlugin.handleEvent(),begin");
        try {
            String variableStr = evt.getVariables();
            JSONObject variablesJson = (JSONObject)SerializationUtils.fromJsonString((String)variableStr, JSONObject.class);
            ArrayList orgParamList = Lists.newArrayList();
            Set versionView = HRBUValidationService.getVersionView();
            Map allChildrenViewRoot = HRBUExtServiceHelper.queryAllChildrenViewRoot((Set)versionView);
            JSONObject operationParams = variablesJson.getJSONObject("base_orgchange_resetroot");
            JSONArray synViews = operationParams.getJSONArray("synviews");
            LOGGER.info("ReRootOrgEventPlugin.handleEvent(),synviews:{}", (Object)synViews.toJSONString());
            boolean hasSynHROrgView = synViews.stream().anyMatch(json -> ((JSONObject)json).getLong("viewid").longValue() == HR_VIEW_ID.longValue());
            OrgParam orgParamAdd = new OrgParam();
            if (hasSynHROrgView) {
                DynamicObject newRootDy = (DynamicObject)allChildrenViewRoot.get(HR_VIEW_ID);
                long newRootDyLong = newRootDy.getLong("org.id");
                String newRootDyName = newRootDy.getString("name");
                String newRootDyNumber = newRootDy.getString("number");
                long newRootDyOrgParent = newRootDy.getLong("orgpattern.id");
                orgParamAdd.setId(newRootDyLong);
                orgParamAdd.setParentId(0L);
                orgParamAdd.setName(newRootDyName);
                orgParamAdd.setSimpleName(newRootDyName);
                orgParamAdd.setNumber(newRootDyNumber);
                orgParamAdd.setOrgPatternId(newRootDyOrgParent);
                OrgDutyView orgDutyView = new OrgDutyView(0L);
                TreeMap<String, OrgDutyView> multiViewMap = new TreeMap<String, OrgDutyView>();
                HashMap updateMap = Maps.newHashMapWithExpectedSize((int)versionView.size());
                for (Long view : versionView) {
                    TreeMap<String, OrgDutyView> multiViewMapUpdate;
                    if (view.longValue() == HR_VIEW_ID.longValue()) continue;
                    String viewNum = String.valueOf(view);
                    orgParamAdd.setDuty(viewNum);
                    multiViewMap.put(viewNum, orgDutyView);
                    DynamicObject childViewRoot = (DynamicObject)allChildrenViewRoot.get(view);
                    if (childViewRoot == null) continue;
                    OrgParam orgParamUpdate = (OrgParam)updateMap.get(childViewRoot.getLong("org.id"));
                    if (orgParamUpdate == null) {
                        orgParamUpdate = new OrgParam();
                        orgParamUpdate.setParentId(newRootDyLong);
                        orgParamUpdate.setDuty(String.valueOf(view));
                        orgParamUpdate.setId(childViewRoot.getLong("org.id"));
                        orgParamUpdate.setName(childViewRoot.getString("name"));
                        orgParamUpdate.setNumber(childViewRoot.getString("number"));
                        orgParamUpdate.setSimpleName(childViewRoot.getString("name"));
                        orgParamUpdate.setOrgPatternId(childViewRoot.getLong("orgpattern.id"));
                        multiViewMapUpdate = new TreeMap<String, OrgDutyView>();
                        multiViewMapUpdate.put(viewNum, new OrgDutyView(newRootDyLong));
                        orgParamUpdate.setMultiViewMap(multiViewMapUpdate);
                    } else {
                        multiViewMapUpdate = orgParamUpdate.getMultiViewMap();
                        multiViewMapUpdate.put(viewNum, new OrgDutyView(newRootDyLong));
                        orgParamUpdate.setMultiViewMap((TreeMap)multiViewMapUpdate);
                    }
                    updateMap.put(childViewRoot.getLong("org.id"), orgParamUpdate);
                }
                orgParamAdd.setMultiViewMap(multiViewMap);
                orgParamList.add(orgParamAdd);
                orgParamList.addAll(updateMap.values());
                OrgUnitServiceHelper.addOrUpdate((List)orgParamList);
            } else {
                Long newRootId = synViews.getJSONObject(0).getLong("newrootid");
                DynamicObject rootDy = new HRBaseServiceHelper("bos_org").queryOriginalOne("name,number,orgpattern.id", new QFilter("id", "=", (Object)newRootId));
                orgParamAdd.setOperationType(OperationType.addDuty);
                orgParamAdd.setId(newRootId.longValue());
                orgParamAdd.setName(rootDy.getString("name"));
                orgParamAdd.setSimpleName(rootDy.getString("name"));
                orgParamAdd.setNumber(rootDy.getString("number"));
                orgParamAdd.setOrgPatternId(rootDy.getLong("orgpattern.id"));
                TreeMap<String, OrgDutyView> multiViewMap = new TreeMap<String, OrgDutyView>();
                for (Long viewId : versionView) {
                    if (HR_VIEW_ID.longValue() == viewId.longValue()) continue;
                    DynamicObject childViewRoot = (DynamicObject)allChildrenViewRoot.get(viewId);
                    orgParamAdd.setParentId(childViewRoot.getLong("org.id"));
                    orgParamAdd.setDuty(String.valueOf(viewId));
                    OrgDutyView orgDutyView = new OrgDutyView(childViewRoot.getLong("org.id"));
                    multiViewMap.put(String.valueOf(viewId), orgDutyView);
                }
                orgParamAdd.setMultiViewMap(multiViewMap);
                orgParamList.add(orgParamAdd);
                OrgUnitServiceHelper.addDuty((List)orgParamList);
            }
        }
        catch (Exception exception) {
            LOGGER.error("ReRootOrgEventPlugin.handleEvent(),error:", (Throwable)exception);
        }
        LOGGER.info("ReRootOrgEventPlugin.handleEvent(),end");
        return evt.getEventId();
    }
}

