/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbss.formplugin.web.login;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.ext.hr.web.dto.LoginOpDTO;
import kd.bos.ext.hr.web.util.HrGuestUrlUtil;
import kd.bos.ext.hr.web.util.HrUserCacheUtil;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.form.control.Label;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.inte.api.EnabledLang;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.model.Language;
import kd.bos.login.user.LanguageService;
import kd.bos.message.api.MessageChannels;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.session.SessionManager;
import kd.bos.session.SystemPropertyUtils;
import kd.bos.url.UrlService;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.hr.hbp.business.application.impl.common.HRLongValueParseService;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbss.bussiness.domain.repository.login.HrLoginCommonRepository;
import kd.hr.hbss.common.constants.login.EnumLoginType;
import kd.hr.hbss.formplugin.web.login.util.HrHideUtil;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.RandomStringUtils;

public interface AbstractCommonLogin {
    public static final Log LOGGER = LogFactory.getLog(AbstractCommonLogin.class);
    public static final String CONTROL_PRIVACY = "privacy";
    public static final Map<String, String> METHOD_MAP = new HashMap<String, String>(){
        private static final long serialVersionUID = -3147996238459245961L;
        {
            this.put(EnumLoginType.PHONE.getType(), "checkUserIdAndPhone");
            this.put(EnumLoginType.EMAIL.getType(), "checkUserIdAndEmail");
            this.put(EnumLoginType.ANONYMOUS.getType(), "checkUserIdAndUserNamePassword");
        }
    };

    default public String hidePhone(String phone) {
        if (HRStringUtils.isEmpty((String)phone)) {
            return "";
        }
        return phone.split("-")[0] + "-" + HrHideUtil.hide(phone.split("-")[1]);
    }

    default public String hideEmail(String email) {
        return HrHideUtil.hideEmail(email);
    }

    default public String getLocaleIdByLangNumber(String langCode) {
        List enabledLangList = InteServiceHelper.getEnabledLang();
        LOGGER.info("Got enable lang list: {} and langCode: {}.", (Object)enabledLangList, (Object)langCode);
        String localeid = "";
        for (EnabledLang enabledLang : enabledLangList) {
            LOGGER.info("Enabled lang id: {} code: {} number: {} name: {}.", new Object[]{enabledLang.getId(), enabledLang.getLangCode(), enabledLang.getNumber(), enabledLang.getName()});
            if (!enabledLang.getNumber().equals(langCode)) continue;
            localeid = enabledLang.getId();
        }
        return localeid;
    }

    default public void setLabelValue(IFormView formView, String key, String value) {
        String tips1 = ResManager.loadKDString((String)"\u9a8c\u8bc1\u7801\u5df2\u53d1\u9001(5\u5206\u949f\u5185\u6709\u6548)\u3002", (String)"AbstractCommonLogin_17", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]);
        String tips2 = ResManager.loadKDString((String)"\u5df2\u53d1\u9001\u9a8c\u8bc1\u7801\uff0c5\u5206\u949f\u5185\u6709\u6548\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c\u3002", (String)"AbstractCommonLogin_14", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]);
        if (HRStringUtils.equals((String)tips1, (String)value) || HRStringUtils.equals((String)tips2, (String)value)) {
            Label label = (Label)formView.getControl("labelap_err1");
            label.setText(value);
            formView.setVisible(Boolean.FALSE, new String[]{key});
            formView.setVisible(Boolean.TRUE, new String[]{"labelap_err1"});
        } else {
            Label label = (Label)formView.getControl(key);
            label.setText(value);
            formView.setVisible(Boolean.FALSE, new String[]{"labelap_err1"});
            formView.setVisible(Boolean.TRUE, new String[]{key});
        }
        formView.updateView(key);
        formView.updateView("labelap_err1");
    }

    default public DynamicObject getBizAppObject(String bizAppId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("bos_devportal_bizapp");
        return serviceHelper.queryOne("number,bizcloud.id,bizcloud.number", new QFilter[]{new QFilter("id", "=", (Object)bizAppId)});
    }

    default public boolean isBatch(Map<String, Object> params) {
        if (params == null) {
            return false;
        }
        return (Boolean)params.getOrDefault("batch", false);
    }

    default public void viewPrivacy(IFormView formView, long privacyId, ShowType showType, String backFormId, String privacyFormId) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId(privacyFormId);
        formShowParameter.getOpenStyle().setShowType(showType);
        FormShowParameter oldFormShowParameter = formView.getFormShowParameter();
        formShowParameter.setCustomParams(oldFormShowParameter.getCustomParams());
        formShowParameter.setCustomParam("backFormId", (Object)backFormId);
        formShowParameter.setCustomParam("privacyId", (Object)privacyId);
        boolean selectFlag = (Boolean)formView.getModel().getValue("selectstatus");
        formShowParameter.setCustomParam(privacyId + "_isUserAgree", (Object)selectFlag);
        formShowParameter.setCustomParam("privacyId", (Object)privacyId);
        if (formView.getPageCache().get("versionUpdate") != null) {
            formShowParameter.setCustomParam("versionUpdate", (Object)"true");
        }
        formView.showForm(formShowParameter);
    }

    default public boolean signPrivacy(String bizUserId, long userTypeId, long privacyId) {
        boolean isSignedSuccess = false;
        HashMap<String, Object> signMap = new HashMap<String, Object>();
        signMap.put("id", privacyId);
        signMap.put("system", false);
        signMap.put("user", bizUserId);
        signMap.put("userType", userTypeId);
        signMap.put("modifyTime", new Date());
        List signMapList = Collections.singletonList(signMap);
        Map signResultMap = HrLoginCommonRepository.signPrivacy(signMapList);
        if (signResultMap.get("responseCode").toString().equals("500")) {
            LOGGER.error("signPrivacyError,errMessage:{}", (Object)signResultMap.get("errMessage").toString());
        } else if (signResultMap.get("responseCode").toString().equals("200")) {
            isSignedSuccess = true;
        }
        return isSignedSuccess;
    }

    default public boolean invokeEmailService(String email, String content, long verifyCodeId) {
        boolean sendFlag = false;
        try {
            String hrUserLoginMessageTplNumber = "hr_user_login_verify_code_email";
            String notifyType = MessageChannels.EMAIL.getNumber();
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("msg_template");
            DynamicObject item = serviceHelper.queryOriginalOne("msgchannel", new QFilter("number", "=", (Object)hrUserLoginMessageTplNumber));
            if (null != item) {
                notifyType = item.getString("msgchannel");
            }
            MessageInfo message = new MessageInfo();
            message.setMessageTitle((ILocaleString)ResManager.getLocaleString((String)"\u5916\u90e8\u7528\u6237\u767b\u5f55\u9a8c\u8bc1", (String)"AbstractCommonLogin_1", (String)"hrmp-hbss-formplugin"));
            message.setType("message");
            message.setContent(content);
            message.setSendTime(new Date(System.currentTimeMillis()));
            message.setNotifyType(notifyType);
            message.setTemplateNumber(hrUserLoginMessageTplNumber);
            message.setEntityNumber("hbss_verifycodelog");
            message.setBizDataId(Long.valueOf(verifyCodeId));
            message.addParam("email", Collections.singletonList(email));
            MessageCenterServiceHelper.sendMessage((MessageInfo)message);
            sendFlag = true;
        }
        catch (Exception ex) {
            LOGGER.error("invokeEmailServiceError", (Throwable)ex);
        }
        return sendFlag;
    }

    default public boolean invokeMsgService(String phone, String content, long verifyCodeId) {
        boolean sendFlag = false;
        try {
            phone = phone.replace("+", "");
            String hrUserLoginMessageTplNumber = "hr_user_login_verify_code";
            String notifyType = MessageChannels.SMS.getNumber();
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("msg_template");
            DynamicObject item = serviceHelper.queryOriginalOne("msgchannel", new QFilter("number", "=", (Object)hrUserLoginMessageTplNumber));
            if (null != item) {
                notifyType = item.getString("msgchannel");
            }
            MessageInfo message = new MessageInfo();
            message.setMessageTitle((ILocaleString)ResManager.getLocaleString((String)"\u5916\u90e8\u7528\u6237\u767b\u5f55\u9a8c\u8bc1", (String)"AbstractCommonLogin_1", (String)"hrmp-hbss-formplugin"));
            message.setType("message");
            message.setContent(content);
            message.setSendTime(new Date(System.currentTimeMillis()));
            message.setNotifyType(notifyType);
            message.setTemplateNumber(hrUserLoginMessageTplNumber);
            message.setEntityNumber("hbss_verifycodelog");
            message.setBizDataId(Long.valueOf(verifyCodeId));
            message.addParam("phone", Collections.singletonList(phone));
            long a = MessageCenterServiceHelper.sendMessage((MessageInfo)message);
            sendFlag = true;
        }
        catch (Exception ex) {
            LOGGER.error("invokeMsgServiceError", (Throwable)ex);
        }
        return sendFlag;
    }

    default public void languagePropertyChanged(IFormPlugin formPlugin, IFormView formView, String formKey, String callBackId, Consumer<Void> consumer) {
        String sysLang = (String)formView.getModel().getValue(formKey);
        LOGGER.info("Got current lang: {} and sysLang: {}.", (Object)RequestContext.get().getLang().name(), (Object)sysLang);
        if (HRStringUtils.isEmpty((String)sysLang)) {
            formView.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u79cd\u8bed\u8a00\u3002", (String)"AbstractCommonLogin_2", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]));
            return;
        }
        if (HRStringUtils.equals((String)sysLang, (String)RequestContext.get().getLang().name())) {
            return;
        }
        String businessFormId = formView.getPageCache().get("businessFormId");
        long localeId = Long.parseLong(this.getLocaleIdByLangNumber(sysLang));
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("privacystatement");
        DynamicObject[] privacyDynamicObjects = serviceHelper.query("id", new QFilter[]{new QFilter("form.id", "=", (Object)businessFormId), new QFilter("locale.id", "=", (Object)localeId), new QFilter("enable", "=", (Object)"1"), new QFilter("status", "=", (Object)"C")}, "version desc");
        String loginType = (String)formView.getModel().getValue("currentlogintype");
        if (!(privacyDynamicObjects != null && privacyDynamicObjects.length != 0 || EnumLoginType.ANONYMOUS.getType().equals(loginType))) {
            this.setLabelValue(formView, "labelap_err", ResManager.loadKDString((String)"\u9690\u79c1\u670d\u52a1\u5df2\u88ab\u7981\u7528\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"AbstractCommonLogin_3", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]));
            consumer.accept(null);
        } else {
            ConfirmCallBackListener callBackListener = new ConfirmCallBackListener(callBackId, formPlugin);
            formView.showConfirm(ResManager.loadKDString((String)"\u60a8\u5df2\u9009\u62e9\u5176\u4ed6\u8bed\u8a00\uff0c\u5207\u6362\u540e\u5c06\u4f1a\u5237\u65b0\u9875\u9762\uff0c\u786e\u5b9a\u5207\u6362\u5417\uff1f", (String)"AbstractCommonLogin_4", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, callBackListener);
        }
    }

    default public boolean switchLanguage(IFormView formView, String terminalType, String sysLang, String formId) {
        boolean needChange = false;
        if (!HRStringUtils.equals((String)sysLang, (String)RequestContext.get().getLang().name())) {
            LOGGER.info("before switchLanguage: {}.", (Object)RequestContext.get().getLang().name());
            for (Language langObj : LanguageService.getAllLanguage((Account)AccountUtils.getCorrectAccount((String)RequestContext.get().getAccountId(), (String)RequestContext.get().getTenantId()))) {
                if (!sysLang.equalsIgnoreCase(langObj.getNumber())) continue;
                needChange = true;
                break;
            }
            if (needChange) {
                SessionManager.editSessionValue((String)RequestContext.get().getGlobalSessionId(), (String)"language", (String)sysLang);
                RequestContext.get().setLang(Lang.from((String)sysLang));
                LOGGER.info("after switchLanguage: {}.", (Object)RequestContext.get().getLang().name());
                FormShowParameter formShowParameter = formView.getFormShowParameter();
                String accountId = RequestContext.get().getAccountId();
                String loginConfigNumber = (String)formShowParameter.getCustomParam("loginConfigNumber");
                String bizFormId = (String)formShowParameter.getCustomParam("bizFormId");
                String bizUserId = (String)formShowParameter.getCustomParam("bizUserId");
                String bizCustomParam = (String)formShowParameter.getCustomParam("bizCustomParam");
                String queryParam = "&loginConfigNumber=" + loginConfigNumber + "&bizFormId=" + bizFormId + "&bizUserId=" + bizUserId;
                if (HRStringUtils.isNotEmpty((String)bizCustomParam)) {
                    queryParam = queryParam + "&bizCustomParam=" + bizCustomParam;
                }
                String url = UrlService.getDomainContextUrl() + "/mobile.html?userId=Guest&needReset=true&accountId=" + accountId + "&form=" + formId + queryParam + "&language=" + RequestContext.get().getLang();
                if (HRStringUtils.equals((String)"1", (String)terminalType)) {
                    url = UrlService.getDomainContextUrl() + "/index.html?userId=Guest&needReset=true&accountId=" + accountId + "&formId=" + formId + queryParam + "&language=" + RequestContext.get().getLang();
                }
                LOGGER.info("Got last url: {}.", (Object)url);
                IClientViewProxy proxy = (IClientViewProxy)formView.getService(IClientViewProxy.class);
                HashMap<String, String> urlMap = new HashMap<String, String>(2);
                urlMap.put("url", url);
                urlMap.put("openStyle", "0");
                proxy.addAction("openUrl", urlMap);
            }
            LOGGER.info("sysLang: {}, needChange: {}.", (Object)sysLang, (Object)needChange);
        }
        return needChange;
    }

    default public boolean isValidPrivacySelectStatus(IFormView formView, Boolean privacySelectStatus) {
        if (null == privacySelectStatus || !privacySelectStatus.booleanValue()) {
            this.setLabelValue(formView, "labelap_err", ResManager.loadKDString((String)"\u8bf7\u5148\u52fe\u9009\u9690\u79c1\u58f0\u660e\u3002", (String)"AbstractCommonLogin_28", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]));
            LOGGER.info("PrivacySelectStatus is not selected.");
            return false;
        }
        return true;
    }

    default public boolean isValidPhone(IFormView formView, String phone) {
        if (HRStringUtils.isEmpty((String)phone)) {
            this.setLabelValue(formView, "labelap_err", ResManager.loadKDString((String)"\u624b\u673a\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AbstractCommonLogin_5", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]));
            LOGGER.info("Phone is empty.");
            return false;
        }
        return true;
    }

    default public boolean isValidEmail(IFormView formView, String email) {
        if (HRStringUtils.isEmpty((String)email)) {
            this.setLabelValue(formView, "labelap_err", ResManager.loadKDString((String)"\u90ae\u7bb1\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AbstractCommonLogin_7", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]));
            LOGGER.info("Email is empty.");
            return false;
        }
        return true;
    }

    default public boolean isValidUserPassword(IFormView formView, String userName, String password) {
        if (HRStringUtils.isEmpty((String)userName)) {
            this.setLabelValue(formView, "labelap_err", ResManager.loadKDString((String)"\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AbstractCommonLogin_18", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]));
            LOGGER.info("UserName is empty.");
            return false;
        }
        if (HRStringUtils.isEmpty((String)password)) {
            this.setLabelValue(formView, "labelap_err", ResManager.loadKDString((String)"\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AbstractCommonLogin_19", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]));
            LOGGER.info("Password is empty.");
            return false;
        }
        return true;
    }

    default public boolean checkUserId() {
        String checkUserId = SystemPropertyUtils.getProptyByTenant((String)"kd.hr.guest.commonlogin.checkuserid", (String)RequestContext.get().getTenantId());
        if (HRStringUtils.isNotEmpty((String)checkUserId) && !Boolean.parseBoolean(checkUserId)) {
            LOGGER.info("System property kd.hr.guest.commonlogin.checkuserid is true.");
            return true;
        }
        return false;
    }

    default public boolean checkPageCacheCanSend(IFormView formView, String bizUserId, String loginType, String value) {
        String isValid = formView.getPageCache().get(bizUserId + "_" + value);
        if (HRStringUtils.isNotEmpty((String)isValid)) {
            boolean canSendMsg = Boolean.parseBoolean(isValid);
            if (!canSendMsg) {
                this.setLabelValue(formView, "labelap_err", this.getMisMatchUserIdAndValueTips(loginType));
            }
            LOGGER.info("Page cache[bizUserId_value] is: {}.", (Object)canSendMsg);
            return canSendMsg;
        }
        return true;
    }

    default public boolean checkUserIdAndValue(IFormView formView, String bizUserId, String loginType, String value1, String value2) {
        if (this.checkUserId()) {
            return true;
        }
        if (!this.checkPageCacheCanSend(formView, bizUserId, loginType, value1 + "#" + value2)) {
            return false;
        }
        String bizAppId = formView.getPageCache().get("bizAppId");
        DynamicObject bizAppObject = this.getBizAppObject(bizAppId);
        String cloudId = bizAppObject.getString("bizcloud.number").toLowerCase();
        String appId = bizAppObject.getString("number").toLowerCase();
        Object[] params = Lists.newArrayList((Object[])new String[]{bizUserId, value1, value2}).stream().filter(Objects::nonNull).toArray(Object[]::new);
        boolean flag = false;
        try {
            flag = (Boolean)DispatchServiceHelper.invokeBizService((String)cloudId, (String)appId, (String)"IHrBizLoginService", (String)METHOD_MAP.get(loginType), (Object[])params);
        }
        catch (Exception ex) {
            LOGGER.info(ResManager.loadKDString((String)"\u7cfb\u7edf\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"AbstractCommonLogin_23", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]));
            LOGGER.info("Invoke IHrBizLoginService service error! Maybe RPC service is not exists! error :{} , cloudId : {}, AppID{}", new Object[]{ex.getMessage(), cloudId, appId});
            this.setLabelValue(formView, "labelap_err", ResManager.loadKDString((String)"\u7cfb\u7edf\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"AbstractCommonLogin_23", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]));
        }
        if (!flag) {
            this.setLabelValue(formView, "labelap_err", this.getMisMatchUserIdAndValueTips(loginType));
        }
        formView.getPageCache().put(bizUserId + "_" + value1 + "#" + value2, String.valueOf(flag));
        LOGGER.info("Got checkUserIdAndValue result: {} with userId: {}.", (Object)flag, (Object)bizUserId);
        return flag;
    }

    default public String getMisMatchUserIdAndValueTips(String loginType) {
        switch (loginType) {
            case "1": {
                return ResManager.loadKDString((String)"\u624b\u673a\u53f7\u4e0d\u5b58\u5728\u6216\u9519\u8bef\u3002", (String)"AbstractCommonLogin_20", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]);
            }
            case "2": {
                return ResManager.loadKDString((String)"\u90ae\u7bb1\u4e0d\u5b58\u5728\u6216\u9519\u8bef\u3002", (String)"AbstractCommonLogin_21", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]);
            }
            case "3": {
                return ResManager.loadKDString((String)"\u8d26\u53f7\u5bc6\u7801\u9519\u8bef\u3002", (String)"AbstractCommonLogin_22", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]);
            }
        }
        return ResManager.loadKDString((String)"\u8eab\u4efd\u9a8c\u8bc1\u4e0d\u901a\u8fc7\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"AbstractCommonLogin_8", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]);
    }

    default public DynamicObject getVerifyCodeMessage(String loginType, String value) {
        ArrayList verifyCodeFilters = Lists.newArrayList((Object[])new QFilter[]{new QFilter("enable", "=", (Object)"0")});
        if (HRStringUtils.equals((String)EnumLoginType.PHONE.getType(), (String)loginType)) {
            verifyCodeFilters.add(new QFilter("phone", "=", (Object)this.hidePhone(value)));
        } else if (HRStringUtils.equals((String)EnumLoginType.EMAIL.getType(), (String)loginType)) {
            verifyCodeFilters.add(new QFilter("email", "=", (Object)this.hideEmail(value)));
        }
        return HrLoginCommonRepository.getVerifyCodeMessage((QFilter[])verifyCodeFilters.toArray(new QFilter[0]));
    }

    default public boolean validCode(IFormView formView, String loginType, String value1, String value2) {
        String myCode;
        long dateTime;
        if (HRStringUtils.isEmpty((String)value2)) {
            this.setLabelValue(formView, "labelap_err", ResManager.loadKDString((String)"\u9a8c\u8bc1\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AbstractCommonLogin_9", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (value2.length() != 6) {
            this.setLabelValue(formView, "labelap_err", ResManager.loadKDString((String)"\u9a8c\u8bc1\u7801\u9519\u8bef\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"AbstractCommonLogin_10", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]));
            return false;
        }
        String codeAndTime = formView.getPageCache().get(value1);
        DynamicObject item = this.getVerifyCodeMessage(loginType, value1);
        if (HRStringUtils.isEmpty((String)codeAndTime) && item == null) {
            this.setLabelValue(formView, "labelap_err", ResManager.loadKDString((String)"\u8bf7\u5148\u83b7\u53d6\u9a8c\u8bc1\u7801\u3002", (String)"AbstractCommonLogin_11", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (HRStringUtils.isNotEmpty((String)codeAndTime)) {
            long time = Long.parseLong(codeAndTime.split("_")[1]);
            if (!this.isLessThanMin(time)) {
                this.setLabelValue(formView, "labelap_err", ResManager.loadKDString((String)"\u9a8c\u8bc1\u7801\u5df2\u8fc7\u671f\uff0c\u8bf7\u91cd\u65b0\u83b7\u53d6\u3002", (String)"AbstractCommonLogin_12", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]));
                return false;
            }
        } else if (item != null && !this.isLessThanMin(dateTime = item.getDate("createtime").getTime())) {
            this.setLabelValue(formView, "labelap_err", ResManager.loadKDString((String)"\u9a8c\u8bc1\u7801\u5df2\u8fc7\u671f\uff0c\u8bf7\u91cd\u65b0\u83b7\u53d6\u3002", (String)"AbstractCommonLogin_12", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (!HRStringUtils.equals((String)value2, (String)(myCode = this.getVerifyCode(codeAndTime, item)))) {
            this.setLabelValue(formView, "labelap_err", ResManager.loadKDString((String)"\u9a8c\u8bc1\u7801\u9519\u8bef\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"AbstractCommonLogin_10", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    default public String getVerifyCode(String codeAndTime, DynamicObject dynamicObject) {
        if (HRStringUtils.isNotEmpty((String)codeAndTime)) {
            return codeAndTime.split("_")[0];
        }
        if (dynamicObject != null) {
            return dynamicObject.getString("verifyCode");
        }
        return "";
    }

    default public boolean isLessThanMin(long time) {
        long betweenSecond = this.getBetweenSecond(time);
        return betweenSecond >= 0L && betweenSecond <= 300L;
    }

    default public int getBetweenSecond(long time) {
        long currentTime = System.currentTimeMillis();
        int betweenSecond = (int)((currentTime - time) / 1000L);
        return 300 - betweenSecond;
    }

    default public void lessThanMinTip(IFormView formView, long dateTime) {
        int second = this.getBetweenSecond(dateTime);
        String msg = ResManager.loadKDString((String)"\u5df2\u53d1\u9001\u9a8c\u8bc1\u7801\uff0c5\u5206\u949f\u5185\u6709\u6548\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c\u3002", (String)"AbstractCommonLogin_14", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]);
        this.setLabelValue(formView, "labelap_err", msg);
    }

    default public String generateVerifyCode() {
        return RandomStringUtils.random((int)6, (String)"0123456789");
    }

    default public String getVerificationCodeMessage(String code) {
        return String.format(ResManager.loadKDString((String)"\u9a8c\u8bc1\u7801\uff1a%s(5\u5206\u949f\u5185\u6709\u6548)\uff0c\u4e3a\u4fdd\u969c\u4fe1\u606f\u5b89\u5168\uff0c\u8bf7\u52ff\u544a\u8bc9\u4ed6\u4eba\u3002", (String)"AbstractCommonLogin_15", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]), code);
    }

    default public String getVerificationCodeMessageForEmail(String code) {
        return String.format(ResManager.loadKDString((String)"<p>\u4eb2\u7231\u7684\u7528\u6237\uff0c\u60a8\u597d\u3002</p><p>\u00a0</p><p>\u60a8\u7684\u9a8c\u8bc1\u7801\u662f\uff1a%s</p><p>\u6b64\u9a8c\u8bc1\u7801\u5c06\u7528\u4e8e\u9a8c\u8bc1\u8eab\u4efd\u3002\u8bf7\u52ff\u5c06\u9a8c\u8bc1\u7801\u900f\u6f0f\u7ed9\u5176\u4ed6\u4eba\u3002</p><p>\u00a0</p><p>\u672c\u90ae\u4ef6\u7531\u7cfb\u7edf\u81ea\u52a8\u53d1\u9001\uff0c\u8bf7\u52ff\u76f4\u63a5\u56de\u590d\uff01\u611f\u8c22\u60a8\u7684\u8bbf\u95ee\uff0c\u795d\u60a8\u751f\u6d3b\u6109\u5feb\uff01</p>", (String)"AbstractCommonLogin_16", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]), code);
    }

    default public DynamicObject saveMessageToDb(String bizUserId, String value, String verifyCode, String message, String purpose) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"hbss_verifycodelog");
        dynamicObject.set("businessid", (Object)bizUserId);
        dynamicObject.set("verifyCode", (Object)verifyCode);
        dynamicObject.set("message", (Object)message);
        dynamicObject.set("issend", (Object)"1");
        dynamicObject.set("purpose", (Object)purpose);
        dynamicObject.set("enable", (Object)"0");
        dynamicObject.set("createtime", (Object)new Date());
        if (HRStringUtils.equals((String)"0", (String)purpose)) {
            dynamicObject.set("phone", (Object)this.hidePhone(value));
        } else {
            dynamicObject.set("email", (Object)this.hideEmail(value));
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
        return dynamicObject;
    }

    default public void sendMessage(IFormView formView, String bizUserId, String loginType, String value) {
        Date createDate;
        long dateTime;
        String codeAndTime = formView.getPageCache().get(value);
        DynamicObject dynamicObject = this.getVerifyCodeMessage(loginType, value);
        if (HRStringUtils.isNotEmpty((String)codeAndTime)) {
            long dateTime2 = Long.parseLong(codeAndTime.split("_")[1]);
            if (this.isLessThanMin(dateTime2)) {
                this.lessThanMinTip(formView, dateTime2);
                return;
            }
        } else if (dynamicObject != null && this.isLessThanMin(dateTime = (createDate = dynamicObject.getDate("createtime")).getTime())) {
            this.lessThanMinTip(formView, dateTime);
            return;
        }
        String verifyCode = this.generateVerifyCode();
        formView.getPageCache().put(value, verifyCode + "_" + System.currentTimeMillis());
        String message = HRStringUtils.equals((String)"1", (String)loginType) ? this.getVerificationCodeMessage(verifyCode) : this.getVerificationCodeMessageForEmail(verifyCode);
        String purpose = HRStringUtils.equals((String)"1", (String)loginType) ? "0" : "1";
        DynamicObject verifyCodeItem = this.saveMessageToDb(bizUserId, value, verifyCode, message, purpose);
        if (HRStringUtils.equals((String)"1", (String)loginType)) {
            this.invokeMsgService(value, message, verifyCodeItem.getLong("id"));
        } else {
            this.invokeEmailService(value, message, verifyCodeItem.getLong("id"));
        }
        this.setLabelValue(formView, "labelap_err", ResManager.loadKDString((String)"\u9a8c\u8bc1\u7801\u5df2\u53d1\u9001(5\u5206\u949f\u5185\u6709\u6548)\u3002", (String)"AbstractCommonLogin_17", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]));
    }

    default public void updateMessageStatus(String loginType, String value1, String value2) {
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>();
        qFilterList.add(new QFilter("verifycode", "=", (Object)value2));
        qFilterList.add(new QFilter("enable", "=", (Object)"0"));
        if (HRStringUtils.equals((String)"1", (String)loginType)) {
            value1 = this.hidePhone(value1);
            qFilterList.add(new QFilter("phone", "=", (Object)value1));
        } else if (HRStringUtils.equals((String)"2", (String)loginType)) {
            value1 = this.hideEmail(value1);
            qFilterList.add(new QFilter("email", "=", (Object)value1));
        }
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"hbss_verifycodelog", (String)"enable", (QFilter[])qFilterList.toArray(new QFilter[0]), (String)"createtime", (int)1);
        if (dynamicObjects != null && dynamicObjects.length > 0) {
            dynamicObjects[0].set("enable", (Object)"1");
            SaveServiceHelper.save((DynamicObject[])dynamicObjects);
        }
    }

    default public boolean hrUserLogin(IFormView formView, String formId, String loginConfigNumber, String originalBizUserId, String bizUserId, String bizCustomParam, String loginType, String value1, String value2) {
        String hideValue1 = value1;
        if (HRStringUtils.equals((String)"1", (String)loginType)) {
            hideValue1 = this.hidePhone(value1);
        } else if (HRStringUtils.equals((String)"2", (String)loginType)) {
            hideValue1 = this.hideEmail(value1);
        }
        String authInfo = loginType + "#" + value1 + "#" + hideValue1 + "#" + value2 + "#" + System.currentTimeMillis();
        String randomTag = RandomStringUtils.randomAlphanumeric((int)6);
        String accountId = RequestContext.get().getAccountId();
        HrUserCacheUtil.set((String)accountId, (String)("auth_" + randomTag), (String)authInfo);
        String uri = "hr/auth/login.do?userId=Guest&randomTag=" + randomTag + "&form=" + formId + "&loginConfigNumber=" + loginConfigNumber + "&bizUserId=" + originalBizUserId + "&realBizUserId=" + bizUserId;
        if (HRStringUtils.isNotEmpty((String)bizCustomParam)) {
            uri = uri + "&bizCustomParam=" + bizCustomParam;
        }
        try {
            HashMap<String, String> urlMap = new HashMap<String, String>(2);
            urlMap.put("url", uri);
            urlMap.put("openStyle", "0");
            IClientViewProxy clientViewProxy = (IClientViewProxy)formView.getService(IClientViewProxy.class);
            clientViewProxy.addAction("openUrl", urlMap);
        }
        catch (Exception e) {
            LOGGER.error("hrUserLoginError,hideValue1" + hideValue1, (Throwable)e);
            return false;
        }
        return true;
    }

    default public List<ComboItem> buildLoginTypeComboItems(DynamicObject loginConfigDynamicObject, Map<String, Object> params) {
        String strDatabaseLoginTypes = loginConfigDynamicObject.getString("logintype");
        String strParamLoginTypes = "";
        if (MapUtils.isNotEmpty(params)) {
            strParamLoginTypes = (String)params.getOrDefault("loginType", "");
        }
        if (HRStringUtils.isEmpty((String)strDatabaseLoginTypes) && HRStringUtils.isEmpty((String)strParamLoginTypes)) {
            return null;
        }
        String[] databaseLoginTypes = strDatabaseLoginTypes.split(",");
        String[] paramLoginTypes = strParamLoginTypes.split(",");
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>();
        for (String paramLoginType : paramLoginTypes) {
            if (HRStringUtils.isEmpty((String)paramLoginType)) continue;
            for (String databaseLoginType : databaseLoginTypes) {
                if (!HRStringUtils.equals((String)databaseLoginType, (String)paramLoginType)) continue;
                ComboItem comboItem = new ComboItem();
                comboItem.setValue(paramLoginType);
                comboItem.setCaption(new LocaleString(paramLoginType));
                comboItems.add(comboItem);
            }
        }
        if (comboItems.isEmpty()) {
            for (String databaseLoginType : databaseLoginTypes) {
                if (HRStringUtils.isEmpty((String)databaseLoginType)) continue;
                ComboItem comboItem = new ComboItem();
                comboItem.setValue(databaseLoginType);
                comboItem.setCaption(new LocaleString(databaseLoginType));
                comboItems.add(comboItem);
            }
        }
        return comboItems;
    }

    default public Map<String, Object> getSafeUriParamsFromCache(String originalUrlParams, IPageCache pageCache) {
        Map params;
        String objParams = pageCache.get("safeUriParams");
        if (objParams == null || objParams.toString().equals("{}")) {
            if (originalUrlParams == null) {
                return null;
            }
            DynamicObject safeUriItem = HrLoginCommonRepository.querySafeUriByParams((String)originalUrlParams);
            params = (Map)Optional.ofNullable(safeUriItem).map(it -> it.getString("args")).filter(HRStringUtils::isNotEmpty).map(it -> SerializationUtils.fromJsonString((String)it, Map.class)).orElseGet(HashMap::new);
            pageCache.put("safeUriParams", SerializationUtils.toJsonString((Object)params));
        } else {
            params = (Map)SerializationUtils.fromJsonString((String)pageCache.get("safeUriParams"), Map.class);
        }
        return params;
    }

    default public String getBizUserId(String terminalType, DynamicObject loginConfigItem, String bizUserId, Map<String, Object> params, String loginType, String value) {
        boolean isBatch = this.isBatch(params);
        if (!isBatch) {
            LOGGER.info("Got isBatch: false and return original bizUserId: {}.", (Object)bizUserId);
            return bizUserId;
        }
        String bizAppId = HRStringUtils.equals((String)"1", (String)terminalType) ? loginConfigItem.getString("redirectappformid.bizappid.id") : loginConfigItem.getString("redirectform.bizappid.id");
        DynamicObject bizAppObject = this.getBizAppObject(bizAppId);
        String cloudId = bizAppObject.getString("bizcloud.number").toLowerCase();
        String appId = bizAppObject.getString("number").toLowerCase();
        String realBizUserId = (String)HRMServiceHelper.invokeBizService((String)cloudId, (String)appId, (String)"IHrBizLoginService", (String)"getRealBizUserId", (Object[])new Object[]{bizUserId, loginType, value});
        LOGGER.info("Got real biz user id: {} with bizUserId: {}, loginType: {}, value: {}.", new Object[]{realBizUserId, bizUserId, loginType, value});
        return HRStringUtils.isEmpty((String)realBizUserId) ? "0" : realBizUserId;
    }

    default public List<ComboItem> buildDefaultLangComboList(List<String> loginTypeList, String formId) {
        List enabledLangList = InteServiceHelper.getEnabledLang();
        ArrayList<ComboItem> comboItemList = new ArrayList<ComboItem>(enabledLangList.size());
        if (loginTypeList != null && loginTypeList.size() == 1 && HRStringUtils.equals((String)EnumLoginType.ANONYMOUS.getType(), (String)loginTypeList.get(0))) {
            for (EnabledLang enabledLang : enabledLangList) {
                if (enabledLang == null) continue;
                ComboItem comboItem = new ComboItem();
                comboItem.setValue(enabledLang.getNumber());
                comboItem.setCaption(new LocaleString(enabledLang.getName()));
                comboItemList.add(comboItem);
            }
        } else {
            DynamicObject[] allPrivacyDynamicObjects = HrLoginCommonRepository.queryPrivacyStatementByFormId((String)formId);
            Map<String, EnabledLang> enabledLangMap = enabledLangList.stream().collect(Collectors.toMap(EnabledLang::getId, it -> it, (oldValue, newValue) -> oldValue));
            for (DynamicObject tempObject : allPrivacyDynamicObjects) {
                EnabledLang enabledLang = enabledLangMap.get(tempObject.getString("locale.id"));
                if (enabledLang == null) continue;
                ComboItem comboItem = new ComboItem();
                comboItem.setValue(enabledLang.getNumber());
                comboItem.setCaption(new LocaleString(enabledLang.getName()));
                comboItemList.add(comboItem);
            }
        }
        return comboItemList;
    }

    default public void initPrivacy(DynamicObject loginConfigItem, String bizUserId, Map<String, Object> params, IPageCache pageCache, IFormView formView, IDataModel dataModel) {
        long localeId;
        long currPrivacyId = loginConfigItem.getLong("privacystmt.id");
        DynamicObject privacyItem = HrLoginCommonRepository.queryPrivacyStatementByCurrPrivacyId((long)currPrivacyId);
        String currVersion = privacyItem.getString("version");
        String formId = privacyItem.getString("form.id");
        DynamicObject maxVersionItem = HrLoginCommonRepository.queryPrivacyStatementByFormIdAndLocale((String)formId, (long)(localeId = Long.parseLong(this.getLocaleIdByLangNumber(RequestContext.get().getLang().toString()))));
        if (maxVersionItem == null || !HRStringUtils.equals((String)"1", (String)maxVersionItem.getString("enable"))) {
            String loginType = (String)dataModel.getValue("currentlogintype");
            if (!EnumLoginType.ANONYMOUS.getType().equals(loginType)) {
                pageCache.put("privacyDisable", "true");
                formView.setEnable(Boolean.valueOf(false), new String[]{"btn_login"});
                this.setLabelValue(formView, "labelap_err", ResManager.loadKDString((String)"\u9690\u79c1\u670d\u52a1\u5df2\u88ab\u7981\u7528\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"AbstractCommonLogin_3", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]));
            } else {
                formView.setEnable(Boolean.valueOf(true), new String[]{"btn_login"});
            }
            return;
        }
        String maxVersion = maxVersionItem.getString("version");
        if (!currVersion.equals(maxVersion)) {
            pageCache.put("versionUpdate", "true");
        }
        long maxPrivacyStatementId = maxVersionItem.getLong("id");
        pageCache.put("userTypeId", loginConfigItem.getString("usertype.id"));
        pageCache.put("maxPrivacyStatementId", String.valueOf(maxPrivacyStatementId));
        pageCache.put("maxVersion", maxVersion);
        pageCache.put("businessFormId", formId);
        String privacyTitle = maxVersionItem.getString("name");
        CustomControl privacyControl = (CustomControl)formView.getControl(CONTROL_PRIVACY);
        HashMap<String, Object> privacyData = new HashMap<String, Object>();
        privacyData.put("method", "init");
        privacyData.put("date", String.valueOf(new Date().getTime()));
        privacyData.put("key", "data");
        HashMap<String, String> privacyItemData = new HashMap<String, String>();
        privacyItemData.put("prefix", ResManager.loadKDString((String)"\u6211\u5df2\u9605\u8bfb\u5e76\u540c\u610f", (String)"AbstractCommonLogin_26", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]));
        privacyItemData.put("title", String.format(ResManager.loadKDString((String)"\u300a%1$s\u300b", (String)"AbstractCommonLogin_27", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]), privacyTitle));
        privacyData.put("value", privacyItemData);
        privacyControl.setData(privacyData);
        FormShowParameter formShowParameter = formView.getFormShowParameter();
        if (formShowParameter.getCustomParam(maxPrivacyStatementId + "_isUserAgree") != null) {
            boolean isUserAgree = (Boolean)formShowParameter.getCustomParam(maxPrivacyStatementId + "_isUserAgree");
            dataModel.setValue("selectstatus", (Object)isUserAgree);
            formView.setEnable(Boolean.valueOf(isUserAgree), new String[]{"btn_login"});
        } else if (!this.isBatch(params)) {
            HashMap<String, Object> signHistoryMap = new HashMap<String, Object>();
            signHistoryMap.put("user", bizUserId);
            signHistoryMap.put("userType", loginConfigItem.getLong("usertype.id"));
            HashMap<String, HashSet> formToLangIdsMap = new HashMap<String, HashSet>();
            formToLangIdsMap.put(formId, Sets.newHashSet((Object[])new Long[]{localeId}));
            signHistoryMap.put("group", formToLangIdsMap);
            signHistoryMap.put("system", false);
            Map newVersionPrivacyMap = HrLoginCommonRepository.getNewVersionPrivacy(signHistoryMap);
            String responseCode = newVersionPrivacyMap.get("responseCode").toString();
            if (!responseCode.equals("200")) {
                LOGGER.info("getNewVersionPrivacyError,response:{}", (Object)newVersionPrivacyMap);
                dataModel.setValue("selectstatus", (Object)false);
                formView.setEnable(Boolean.valueOf(false), new String[]{"btn_login"});
                return;
            }
            dataModel.setValue("selectstatus", (Object)false);
            formView.setEnable(Boolean.valueOf(false), new String[]{"btn_login"});
            List dataMapList = (List)newVersionPrivacyMap.get("data");
            if (CollectionUtils.isEmpty((Collection)dataMapList)) {
                dataModel.setValue("selectstatus", (Object)false);
                formView.setEnable(Boolean.valueOf(false), new String[]{"btn_login"});
                return;
            }
            boolean isSignedMaxVersion = false;
            for (Map tempMap : dataMapList) {
                String isAgree;
                String signedVersion = tempMap.get("version").toString();
                if (!signedVersion.equals(maxVersion) || !tempMap.containsKey("isAgree") || !(isAgree = tempMap.get("isAgree").toString()).equals("1")) continue;
                isSignedMaxVersion = true;
                break;
            }
            if (isSignedMaxVersion) {
                dataModel.setValue("selectstatus", (Object)true);
                formView.setEnable(Boolean.valueOf(true), new String[]{"btn_login"});
            }
        }
    }

    default public void refreshLoginButtonEnable(IDataModel dataModel, IFormView formView) {
        String loginType = (String)dataModel.getValue("currentlogintype");
        Boolean isSelect = (Boolean)dataModel.getValue("selectstatus");
        if (EnumLoginType.ANONYMOUS.getType().equals(loginType)) {
            formView.setEnable(Boolean.TRUE, new String[]{"btn_login"});
        } else if (isSelect.booleanValue()) {
            formView.setEnable(Boolean.TRUE, new String[]{"btn_login"});
        } else {
            formView.setEnable(Boolean.FALSE, new String[]{"btn_login"});
        }
    }

    default public List<String> transComboItemListToSet(List<ComboItem> comboItemList) {
        if (CollectionUtils.isEmpty(comboItemList)) {
            return null;
        }
        ArrayList loginTypeList = Lists.newArrayListWithCapacity((int)comboItemList.size());
        for (ComboItem comboItem : comboItemList) {
            loginTypeList.add(comboItem.getValue());
        }
        return loginTypeList;
    }

    default public void addFailureTimes(IFormView formView, IPageCache pageCache, String bizUserId) {
        String lockedTimeKey = "lockedTime_" + bizUserId;
        String failureTimesKey = "failureTimes_" + bizUserId;
        long failureTimes = HRLongValueParseService.getInstance().parseLong((Object)pageCache.get(failureTimesKey));
        pageCache.put(failureTimesKey, String.valueOf(++failureTimes));
        if (failureTimes >= 10L) {
            long nowTime = new Date().getTime();
            pageCache.put(lockedTimeKey, String.valueOf(nowTime));
            formView.showTipNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u592a\u9891\u7e41\uff0c\u8bf760\u79d2\u540e\u518d\u8bd5\u3002", (String)"AbstractCommonLogin_25", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]));
        }
    }

    default public boolean validateRestFailureTime(IFormView formView, IPageCache pageCache, String bizUserId) {
        String lockedTimeKey = "lockedTime_" + bizUserId;
        String failureTimesKey = "failureTimes_" + bizUserId;
        long lockedTime = HRLongValueParseService.getInstance().parseLong((Object)pageCache.get(lockedTimeKey));
        if (lockedTime == 0L) {
            return true;
        }
        long nowTime = new Date().getTime();
        long restSecond = 60L - (nowTime - lockedTime) / 1000L;
        if (restSecond > 0L) {
            pageCache.put(lockedTimeKey, String.valueOf(nowTime));
            formView.showTipNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u592a\u9891\u7e41\uff0c\u8bf760\u79d2\u540e\u518d\u8bd5\u3002", (String)"AbstractCommonLogin_25", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]));
            return false;
        }
        pageCache.remove(lockedTimeKey);
        pageCache.remove(failureTimesKey);
        return true;
    }

    default public void validatePhoneBeforeDoOperation(IFormView formView, IPageCache pageCache, IDataModel dataModel, BeforeDoOperationEventArgs args, String phone, String bizUserId, String loginType, long privacyId, String terminalType) {
        if (!this.isValidPhone(formView, phone)) {
            args.setCancel(true);
            return;
        }
        if (!this.checkUserIdAndValue(formView, bizUserId, loginType, phone, null)) {
            args.setCancel(true);
            return;
        }
        if (!this.validateRestFailureTime(formView, pageCache, bizUserId)) {
            args.setCancel(true);
            return;
        }
        String phoneCode = (String)dataModel.getValue("telephonecode");
        if (!this.validCode(formView, loginType, phone, phoneCode)) {
            this.addFailureTimes(formView, pageCache, bizUserId);
            args.setCancel(true);
            this.insertLoginOpLog(terminalType, bizUserId, loginType, "verifyCode");
        } else {
            long userTypeId = HRLongValueParseService.getInstance().parseLong((Object)pageCache.get("userTypeId"));
            this.signPrivacy(bizUserId, userTypeId, privacyId);
        }
    }

    default public void validateEmailBeforeDoOperation(IFormView formView, IPageCache pageCache, IDataModel dataModel, BeforeDoOperationEventArgs args, String email, String bizUserId, String loginType, long privacyId, String terminalType) {
        if (!this.isValidEmail(formView, email)) {
            args.setCancel(true);
            return;
        }
        String emailCode = (String)dataModel.getValue("emailcode");
        if (!this.validateRestFailureTime(formView, pageCache, bizUserId)) {
            args.setCancel(true);
            return;
        }
        if (!this.checkUserIdAndValue(formView, bizUserId, loginType, email, null)) {
            this.addFailureTimes(formView, pageCache, bizUserId);
            args.setCancel(true);
            return;
        }
        if (this.validCode(formView, loginType, email, emailCode)) {
            long userTypeId = HRLongValueParseService.getInstance().parseLong((Object)pageCache.get("userTypeId"));
            this.signPrivacy(bizUserId, userTypeId, privacyId);
        } else {
            this.addFailureTimes(formView, pageCache, bizUserId);
            args.setCancel(true);
            this.insertLoginOpLog(terminalType, bizUserId, loginType, "verifyCode");
        }
    }

    default public void validatePasswordBeforeDoOperation(IFormView formView, IPageCache pageCache, BeforeDoOperationEventArgs args, String userName, String password, String bizUserId, String loginType, String terminalType) {
        if (!this.isValidUserPassword(formView, userName, password)) {
            args.setCancel(true);
            return;
        }
        if (!this.validateRestFailureTime(formView, pageCache, bizUserId)) {
            args.setCancel(true);
            return;
        }
        if (!this.checkUserIdAndValue(formView, bizUserId, loginType, userName, password)) {
            this.addFailureTimes(formView, pageCache, bizUserId);
            args.setCancel(true);
            this.insertLoginOpLog(terminalType, bizUserId, loginType, "userNameCode");
        }
    }

    default public void insertLoginOpLog(String terminalType, String realBizUserId, String loginType, String opDetailType) {
        String clientType = HRStringUtils.equals((String)"1", (String)terminalType) ? "web" : "mobile";
        LoginOpDTO loginOpDTO = new LoginOpDTO(HrGuestUrlUtil.transFromUserID((String)realBizUserId, (String)loginType), "login", opDetailType, clientType);
        DispatchServiceHelper.invokeBizService((String)"hrmp", (String)"hbss", (String)"IHBSSLoginService", (String)"insertLoginOpLog", (Object[])new Object[]{loginOpDTO});
    }
}

