/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbss.formplugin.web.login.mobile;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.ext.hr.web.util.HrGuestUrlUtil;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.model.Language;
import kd.bos.login.user.LanguageService;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.session.SessionManager;
import kd.bos.session.SystemPropertyUtils;
import kd.bos.url.UrlService;
import kd.hr.hbp.business.application.impl.common.HRLongValueParseService;
import kd.hr.hbp.common.util.DynamicObjectJsonSerializer;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbss.bussiness.domain.repository.login.HrLoginCommonRepository;
import kd.hr.hbss.common.constants.login.EnumLoginType;
import kd.hr.hbss.common.constants.login.LoginCommonConstants;
import kd.hr.hbss.common.constants.login.LoginFormConstants;
import kd.hr.hbss.formplugin.web.login.AbstractCommonLogin;
import org.apache.commons.lang.StringUtils;

public class PhoneCommonLoginPlugin
extends AbstractMobFormPlugin
implements AbstractCommonLogin,
LoginCommonConstants,
LoginFormConstants {
    private static final Log LOGGER = LogFactory.getLog(PhoneCommonLoginPlugin.class);
    private static final String DONOTHING_SENDMSG = "donothing_sendmsg";
    private static final String DONOTHING_CONFIEM = "donothing_confirm";
    private static String FORM_HBSS_COMMONLOGIN = "hbss_commonlogin";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"telephonelogintype", "emaillogintype", "usernamelogintype"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Object eventSource = evt.getSource();
        if (eventSource instanceof Container) {
            String containerKey = ((Container)eventSource).getKey();
            LOGGER.info("Click with containerKey: {}.", (Object)containerKey);
            switch (containerKey) {
                case "telephonelogintype": {
                    this.getModel().setValue("currentlogintype", (Object)EnumLoginType.PHONE.getType());
                    break;
                }
                case "emaillogintype": {
                    this.getModel().setValue("currentlogintype", (Object)EnumLoginType.EMAIL.getType());
                    break;
                }
                case "usernamelogintype": {
                    this.getModel().setValue("currentlogintype", (Object)EnumLoginType.ANONYMOUS.getType());
                    this.getView().setEnable(Boolean.valueOf(true), new String[]{"btn_login"});
                    break;
                }
                default: {
                    LOGGER.info("Ignore with key: {}.", (Object)containerKey);
                }
            }
            this.setLabelValue("labelap_err", "");
        } else {
            LOGGER.info("Ignore with eventSource: {}.", eventSource);
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        this.getModel().setValue("telephone", formShowParameter.getCustomParam("phone"));
        this.getModel().setValue("telephonecode", formShowParameter.getCustomParam("verifyCode"));
        this.getModel().setValue("email", formShowParameter.getCustomParam("email"));
        this.getModel().setValue("emailcode", formShowParameter.getCustomParam("emailcode"));
        this.getModel().setValue("username", formShowParameter.getCustomParam("username"));
        this.getModel().setValue("passwordcode", formShowParameter.getCustomParam("passwordcode"));
        String loginConfigNumber = (String)formShowParameter.getCustomParam("loginConfigNumber");
        if (HRStringUtils.isEmpty((String)loginConfigNumber)) {
            return;
        }
        String bizUserId = (String)formShowParameter.getCustomParam("bizUserId");
        DynamicObject loginConfigDynamicObject = HrLoginCommonRepository.loadLoginConfigByNumber((String)loginConfigNumber);
        if (loginConfigDynamicObject == null) {
            return;
        }
        this.getPageCache().put("loginConfigItem", DynamicObjectJsonSerializer.convertDynamicObjectToJson((DynamicObject)loginConfigDynamicObject));
        String bizAppId = loginConfigDynamicObject.getString("redirectform.bizappid.id");
        this.getPageCache().put("bizAppId", bizAppId);
        List<String> loginTypeList = this.initLoginType(loginConfigNumber, bizUserId, loginConfigDynamicObject, (String)formShowParameter.getCustomParam("currentlogintype"));
        this.initPic(loginConfigDynamicObject);
        String bizCustomParam = (String)this.getView().getFormShowParameter().getCustomParam("bizCustomParam");
        String originalUrlParams = HrGuestUrlUtil.getMobileHtmlUrl((String)RequestContext.get().getAccountId(), (String)loginConfigNumber, (String)bizUserId, (String)bizCustomParam).replace(UrlService.getDomainContextUrl() + "/", "");
        Map params = this.getSafeUriParamsFromCache(originalUrlParams, this.getPageCache());
        this.initPrivacy(loginConfigDynamicObject, bizUserId, params, this.getPageCache(), this.getView(), this.getModel());
        this.initLanguage(loginTypeList);
        this.refreshLoginButtonEnable(this.getModel(), this.getView());
    }

    private void initPic(DynamicObject loginConfigItem) {
        String backgroundPicUrl;
        String bannerPicUrl;
        String imageServerUrl = UrlService.getDomainContextUrl() + "/" + "attachment" + "/" + "downloadImage";
        String bannerGroup = loginConfigItem.getString("bannergroup");
        String bannerPic = loginConfigItem.getString("bannerpic");
        if (HRStringUtils.equals((String)"99", (String)bannerGroup)) {
            bannerPicUrl = !bannerPic.startsWith("/images") && !bannerPic.startsWith("/kingdee") ? (bannerPic.startsWith("/") ? imageServerUrl + bannerPic : imageServerUrl + "/" + bannerPic) : bannerPic;
        } else {
            bannerPicUrl = loginConfigItem.getString("sysbannerpic");
            String nonZHImage = loginConfigItem.getString("sysbannerpicl");
            if (HRStringUtils.isNotEmpty((String)nonZHImage) && !RequestContext.get().getLang().getLangTag().startsWith("zh-")) {
                bannerPicUrl = nonZHImage;
            }
        }
        ((Image)this.getControl("bannerpic")).setUrl(bannerPicUrl);
        String backgroundGroup = loginConfigItem.getString("backgroundgroup");
        String backgroundPic = loginConfigItem.getString("backgroundpic");
        String string = backgroundPicUrl = HRStringUtils.equals((String)"99", (String)backgroundGroup) && !backgroundPic.startsWith("/images") && !backgroundPic.startsWith("/kingdee") ? imageServerUrl + backgroundPic : backgroundPic;
        backgroundPicUrl = HRStringUtils.equals((String)"99", (String)backgroundGroup) ? (!backgroundPic.startsWith("/images") && !backgroundPic.startsWith("/kingdee") ? imageServerUrl + backgroundPic : backgroundPic) : loginConfigItem.getString("sysbackgroundpic");
        Container flexPanel = (Container)this.getView().getControl("flexpanelap_login");
        flexPanel.setBackgroundImg(backgroundPicUrl);
    }

    private List<String> initLoginType(String loginConfigNumber, String bizUserId, DynamicObject loginConfigDynamicObject, String defaultLoginType) {
        String bizCustomParam = (String)this.getView().getFormShowParameter().getCustomParam("bizCustomParam");
        String originalUrlParams = HrGuestUrlUtil.getMobileHtmlUrl((String)RequestContext.get().getAccountId(), (String)loginConfigNumber, (String)bizUserId, (String)bizCustomParam).replace(UrlService.getDomainContextUrl(), "");
        Map params = this.getSafeUriParamsFromCache(originalUrlParams, this.getPageCache());
        List comboItemList = this.buildLoginTypeComboItems(loginConfigDynamicObject, params);
        ComboEdit loginTypeEdit = (ComboEdit)this.getControl("currentlogintype");
        loginTypeEdit.setComboItems(comboItemList);
        if (StringUtils.isEmpty((String)defaultLoginType)) {
            this.getModel().setValue("currentlogintype", (Object)((ComboItem)comboItemList.get(0)).getValue());
        } else {
            this.getModel().setValue("currentlogintype", (Object)defaultLoginType);
        }
        Set loginTypes = comboItemList.stream().map(ComboItem::getValue).collect(Collectors.toSet());
        if (!loginTypes.contains("1")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"telephonelogintype"});
        }
        if (!loginTypes.contains("2")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"emaillogintype"});
        }
        if (!loginTypes.contains("3")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"usernamelogintype"});
        }
        if (1 == comboItemList.size()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"otherlogintype"});
        }
        return this.transComboItemListToSet(comboItemList);
    }

    private void initLanguage(List<String> loginTypeList) {
        String loginType = (String)this.getModel().getValue("currentlogintype");
        String formId = this.getPageCache().get("businessFormId");
        List comboItemList = this.buildDefaultLangComboList(loginTypeList, formId);
        ComboEdit sysLangEdit = (ComboEdit)this.getControl("lang");
        sysLangEdit.setComboItems(comboItemList);
        Set sysLangNumberSet = comboItemList.stream().map(ComboItem::getValue).collect(Collectors.toSet());
        String currentLangNumber = RequestContext.get().getLang().name();
        LOGGER.info("Init language with currentLangNumber: {}, sysLangNumberSet: {}, loginType: {}.", new Object[]{currentLangNumber, sysLangNumberSet, loginType});
        this.showCurrentLang();
    }

    private void showCurrentLang() {
        this.getModel().beginInit();
        this.getModel().setValue("lang", (Object)RequestContext.get().getLang().name());
        this.getView().updateView("lang");
        this.getModel().endInit();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldKey;
        super.propertyChanged(e);
        switch (fieldKey = e.getProperty().getName()) {
            case "lang": {
                this.languagePropertyChanged((IFormPlugin)this, this.getView(), "lang", "langCallBackId", it -> this.showCurrentLang());
                break;
            }
            case "selectstatus": 
            case "currentlogintype": {
                boolean flag = (Boolean)this.getModel().getValue("selectstatus");
                this.getView().setEnable(Boolean.valueOf(flag), new String[]{"btn_login"});
                break;
            }
            case "telephonecode": {
                break;
            }
            case "telephone": 
            case "email": {
                this.setLabelValue(this.getView(), "labelap_err", "");
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (MessageBoxResult.Yes == messageBoxClosedEvent.getResult()) {
            this.switchLanguage((String)this.getModel().getValue("lang"));
        } else {
            this.showCurrentLang();
        }
    }

    private void realValidPhoneCode() {
        String code = (String)this.getModel().getValue("telephonecode");
        if (HRStringUtils.isEmpty((String)code)) {
            this.setLabelValue("labelap_err", ResManager.loadKDString((String)"\u9a8c\u8bc1\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AbstractCommonLogin_9", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]));
            return;
        }
        if (code.length() != 6) {
            this.setLabelValue("labelap_err", ResManager.loadKDString((String)"\u9a8c\u8bc1\u7801\u9519\u8bef\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"AbstractCommonLogin_10", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]));
        } else {
            this.setLabelValue("labelap_err", "");
        }
    }

    private boolean switchLanguage(String sysLang) {
        boolean needChange = false;
        if (!HRStringUtils.equals((String)sysLang, (String)RequestContext.get().getLang().name())) {
            LOGGER.info("before switchLanguage:" + RequestContext.get().getLang().name());
            for (Language langObj : this.getSysLanguageList()) {
                if (!sysLang.equalsIgnoreCase(langObj.getNumber())) continue;
                needChange = true;
                break;
            }
            if (needChange) {
                SessionManager.editSessionValue((String)RequestContext.get().getGlobalSessionId(), (String)"language", (String)sysLang);
                RequestContext.get().setLang(Lang.from((String)sysLang));
                LOGGER.info("after switchLanguage:" + RequestContext.get().getLang().name());
                FormShowParameter formShowParameter = this.getView().getFormShowParameter();
                String accountId = RequestContext.get().getAccountId();
                String loginConfigNumber = (String)formShowParameter.getCustomParam("loginConfigNumber");
                String bizFormId = (String)formShowParameter.getCustomParam("bizFormId");
                String bizUserId = (String)formShowParameter.getCustomParam("bizUserId");
                String bizCustomParam = (String)formShowParameter.getCustomParam("bizCustomParam");
                String queryParam = "&loginConfigNumber=" + loginConfigNumber + "&bizFormId=" + bizFormId + "&bizUserId=" + bizUserId;
                if (HRStringUtils.isNotEmpty((String)bizCustomParam)) {
                    queryParam = queryParam + "&bizCustomParam=" + bizCustomParam;
                }
                String url = this.getFormUrlByGuest(accountId, FORM_HBSS_COMMONLOGIN) + queryParam + "&language=" + RequestContext.get().getLang().toString();
                IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
                HashMap<String, String> urlMap = new HashMap<String, String>(2);
                urlMap.put("url", url);
                urlMap.put("openStyle", "0");
                proxy.addAction("openUrl", urlMap);
            }
            LOGGER.info("sysLang:" + sysLang + ", needChange:" + needChange);
        }
        return needChange;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String privacyEnable = this.getPageCache().get("privacyDisable");
        String loginType = (String)this.getModel().getValue("currentlogintype");
        if (HRStringUtils.isNotEmpty((String)privacyEnable) && !EnumLoginType.ANONYMOUS.getType().equals(loginType)) {
            this.setLabelValue("labelap_err", ResManager.loadKDString((String)"\u9690\u79c1\u670d\u52a1\u5df2\u88ab\u7981\u7528\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"AbstractCommonLogin_3", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        this.updateCacheCodeAndTime();
        String formOp = ((FormOperate)args.getSource()).getOperateKey();
        String originalBizUserId = (String)this.getView().getFormShowParameter().getCustomParam("bizUserId");
        String bizUserId = null;
        DynamicObject loginConfigItem = DynamicObjectJsonSerializer.parseDynamicObjectJson((String)this.getPageCache().get("loginConfigItem"), (String)"hbss_loginconfig");
        Map params = this.getSafeUriParamsFromCache(null, this.getPageCache());
        String email = (String)this.getModel().getValue("email");
        String phone = (String)this.getModel().getValue("telephone");
        Boolean privacySelectStatus = (Boolean)this.getModel().getValue("selectstatus");
        long privacyId = HRLongValueParseService.getInstance().parseLong((Object)this.getPageCache().get("maxPrivacyStatementId"));
        block6 : switch (formOp) {
            case "donothing_sendmsg": {
                if (!this.isValidPrivacySelectStatus(this.getView(), privacySelectStatus) || !this.isValidPhone(this.getView(), phone)) {
                    args.setCancel(true);
                    break;
                }
                bizUserId = this.getBizUserId("2", loginConfigItem, originalBizUserId, params, loginType, phone);
                if (this.checkUserIdAndValue(this.getView(), bizUserId, loginType, phone, null)) break;
                args.setCancel(true);
                break;
            }
            case "sendemail": {
                if (!this.isValidPrivacySelectStatus(this.getView(), privacySelectStatus) || !this.isValidEmail(this.getView(), email)) {
                    args.setCancel(true);
                    break;
                }
                bizUserId = this.getBizUserId("2", loginConfigItem, originalBizUserId, params, loginType, email);
                if (this.checkUserIdAndValue(this.getView(), bizUserId, loginType, email, null)) break;
                args.setCancel(true);
                break;
            }
            case "donothing_privacyshow": {
                if (privacyId != 0L) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9690\u79c1\u58f0\u660e\u4e3a\u7a7a\u3002", (String)"AbstractCommonLogin_24", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                break;
            }
            case "donothing_confirm": {
                String terminalType = "2";
                switch (loginType) {
                    case "1": {
                        bizUserId = this.getBizUserId(terminalType, loginConfigItem, originalBizUserId, params, loginType, phone);
                        this.validatePhoneBeforeDoOperation(this.getView(), this.getPageCache(), this.getModel(), args, phone, bizUserId, loginType, privacyId, "2");
                        break block6;
                    }
                    case "2": {
                        bizUserId = this.getBizUserId(terminalType, loginConfigItem, originalBizUserId, params, loginType, email);
                        this.validateEmailBeforeDoOperation(this.getView(), this.getPageCache(), this.getModel(), args, email, bizUserId, loginType, privacyId, "2");
                        break block6;
                    }
                    case "3": {
                        String userName = (String)this.getModel().getValue("username");
                        String password = (String)this.getModel().getValue("passwordcode");
                        bizUserId = this.getBizUserId(terminalType, loginConfigItem, originalBizUserId, params, loginType, userName);
                        this.validatePasswordBeforeDoOperation(this.getView(), this.getPageCache(), args, userName, password, bizUserId, loginType, "2");
                        break block6;
                    }
                }
                break;
            }
        }
        this.getPageCache().put("tempBizUserId", bizUserId);
    }

    private List<Language> getSysLanguageList() {
        String tenantId = RequestContext.get().getTenantId();
        Account currentCenter = AccountUtils.getCorrectAccount((String)RequestContext.get().getAccountId(), (String)tenantId);
        return LanguageService.getAllLanguage((Account)currentCenter);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String formOp;
        super.afterDoOperation(args);
        String bizUserId = this.getPageCache().get("tempBizUserId");
        String loginType = (String)this.getModel().getValue("currentlogintype");
        switch (formOp = ((FormOperate)args.getSource()).getOperateKey()) {
            case "donothing_sendmsg": {
                String phone = (String)this.getModel().getValue("telephone");
                this.sendMessage(this.getView(), bizUserId, loginType, phone);
                break;
            }
            case "sendemail": {
                String email = (String)this.getModel().getValue("email");
                this.sendMessage(this.getView(), bizUserId, loginType, email);
                break;
            }
            case "donothing_confirm": {
                String value1 = "";
                String value2 = "";
                if (HRStringUtils.equals((String)EnumLoginType.PHONE.getType(), (String)loginType)) {
                    value1 = (String)this.getModel().getValue("telephone");
                    value2 = (String)this.getModel().getValue("telephonecode");
                } else if (HRStringUtils.equals((String)EnumLoginType.EMAIL.getType(), (String)loginType)) {
                    value1 = (String)this.getModel().getValue("email");
                    value2 = (String)this.getModel().getValue("emailcode");
                } else if (HRStringUtils.equals((String)EnumLoginType.ANONYMOUS.getType(), (String)loginType)) {
                    value1 = (String)this.getModel().getValue("username");
                    value2 = (String)this.getModel().getValue("passwordcode");
                }
                String formId = (String)this.getView().getFormShowParameter().getCustomParam("bizFormId");
                String loginConfigNumber = (String)this.getView().getFormShowParameter().getCustomParam("loginConfigNumber");
                String originalBizUserId = (String)this.getView().getFormShowParameter().getCustomParam("bizUserId");
                String bizCustomParam = (String)this.getView().getFormShowParameter().getCustomParam("bizCustomParam");
                this.updateMessageStatus(loginType, value1, value2);
                this.hrUserLogin(this.getView(), formId, loginConfigNumber, originalBizUserId, bizUserId, bizCustomParam, loginType, value1, value2);
                break;
            }
            case "donothing_privacyshow": {
                FormShowParameter formShowParameter = new FormShowParameter();
                formShowParameter.setFormId("hbss_privacy");
                formShowParameter.getOpenStyle().setShowType(ShowType.Floating);
                FormShowParameter oldFormShowParameter = this.getView().getFormShowParameter();
                formShowParameter.setCustomParams(oldFormShowParameter.getCustomParams());
                long privacyId = HRLongValueParseService.getInstance().parseLong((Object)this.getPageCache().get("maxPrivacyStatementId"));
                formShowParameter.setCustomParam("privacyId", (Object)privacyId);
                boolean selectFlag = (Boolean)this.getModel().getValue("selectstatus");
                formShowParameter.setCustomParam(privacyId + "_isUserAgree", (Object)selectFlag);
                formShowParameter.setCustomParam("privacyId", (Object)privacyId);
                if (HRStringUtils.equals((String)EnumLoginType.PHONE.getType(), (String)loginType)) {
                    formShowParameter.setCustomParam("phone", this.getModel().getValue("telephone"));
                    formShowParameter.setCustomParam("verifyCode", this.getModel().getValue("telephonecode"));
                } else if (HRStringUtils.equals((String)EnumLoginType.EMAIL.getType(), (String)loginType)) {
                    formShowParameter.setCustomParam("email", this.getModel().getValue("email"));
                    formShowParameter.setCustomParam("emailcode", this.getModel().getValue("emailcode"));
                } else if (HRStringUtils.equals((String)EnumLoginType.ANONYMOUS.getType(), (String)loginType)) {
                    formShowParameter.setCustomParam("username", this.getModel().getValue("username"));
                    formShowParameter.setCustomParam("passwordcode", this.getModel().getValue("passwordcode"));
                }
                formShowParameter.setCustomParam("currentlogintype", (Object)loginType);
                if (this.getPageCache().get("versionUpdate") != null) {
                    formShowParameter.setCustomParam("versionUpdate", (Object)"true");
                }
                this.getView().showForm(formShowParameter);
                break;
            }
        }
    }

    public void customEvent(CustomEventArgs eventArgs) {
        String eventKey = eventArgs.getKey();
        if (HRStringUtils.equals((String)"privacy", (String)eventKey)) {
            long privacyId = HRLongValueParseService.getInstance().parseLong((Object)this.getPageCache().get("maxPrivacyStatementId"));
            String loginType = (String)this.getModel().getValue("currentlogintype");
            if (privacyId == 0L) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9690\u79c1\u58f0\u660e\u4e3a\u7a7a\u3002", (String)"AbstractCommonLogin_24", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]));
                return;
            }
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("hbss_privacy");
            formShowParameter.getOpenStyle().setShowType(ShowType.Floating);
            FormShowParameter oldFormShowParameter = this.getView().getFormShowParameter();
            formShowParameter.setCustomParams(oldFormShowParameter.getCustomParams());
            formShowParameter.setCustomParam("privacyId", (Object)privacyId);
            boolean selectFlag = (Boolean)this.getModel().getValue("selectstatus");
            formShowParameter.setCustomParam(privacyId + "_isUserAgree", (Object)selectFlag);
            formShowParameter.setCustomParam("privacyId", (Object)privacyId);
            if (HRStringUtils.equals((String)EnumLoginType.PHONE.getType(), (String)loginType)) {
                formShowParameter.setCustomParam("phone", this.getModel().getValue("telephone"));
                formShowParameter.setCustomParam("verifyCode", this.getModel().getValue("telephonecode"));
            } else if (HRStringUtils.equals((String)EnumLoginType.EMAIL.getType(), (String)loginType)) {
                formShowParameter.setCustomParam("email", this.getModel().getValue("email"));
                formShowParameter.setCustomParam("emailcode", this.getModel().getValue("emailcode"));
            } else if (HRStringUtils.equals((String)EnumLoginType.ANONYMOUS.getType(), (String)loginType)) {
                formShowParameter.setCustomParam("username", this.getModel().getValue("username"));
                formShowParameter.setCustomParam("passwordcode", this.getModel().getValue("passwordcode"));
            }
            formShowParameter.setCustomParam("currentlogintype", (Object)loginType);
            if (this.getPageCache().get("versionUpdate") != null) {
                formShowParameter.setCustomParam("versionUpdate", (Object)"true");
            }
            this.getView().showForm(formShowParameter);
        }
    }

    private boolean checkUseridAndPhone(BeforeDoOperationEventArgs e) {
        boolean isCheckUserId = true;
        String checkUserId = SystemPropertyUtils.getProptyByTenant((String)"kd.hr.guest.commonlogin.checkuserid", (String)RequestContext.get().getTenantId());
        if (HRStringUtils.isNotEmpty((String)checkUserId)) {
            isCheckUserId = Boolean.parseBoolean(checkUserId);
        }
        if (!isCheckUserId) {
            return true;
        }
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String userId = (String)formShowParameter.getCustomParam("bizUserId");
        String phone = (String)this.getModel().getValue("telephone");
        String isValid = this.getPageCache().get(userId + "_" + phone);
        if (HRStringUtils.isNotEmpty((String)isValid)) {
            boolean canSendMsg = Boolean.parseBoolean(isValid);
            if (!canSendMsg) {
                this.setLabelValue("labelap_err", ResManager.loadKDString((String)"\u624b\u673a\u53f7\u4e0d\u5b58\u5728\u6216\u9519\u8bef\u3002", (String)"AbstractCommonLogin_20", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
            }
            return canSendMsg;
        }
        String bizAppId = this.getPageCache().get("bizAppId");
        DynamicObject bizAppObject = this.getBizAppObject(bizAppId);
        String cloudId = bizAppObject.getString("bizcloud.number").toLowerCase();
        String appId = bizAppObject.getString("number").toLowerCase();
        boolean flag = (Boolean)DispatchServiceHelper.invokeBizService((String)cloudId, (String)appId, (String)"IHrBizLoginService", (String)"checkUserIdAndPhone", (Object[])new Object[]{userId, phone});
        this.getPageCache().put(userId + "_" + phone, String.valueOf(flag));
        if (!flag) {
            this.setLabelValue("labelap_err", ResManager.loadKDString((String)"\u624b\u673a\u53f7\u4e0d\u5b58\u5728\u6216\u9519\u8bef\u3002", (String)"AbstractCommonLogin_20", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
        }
        return flag;
    }

    private String getFormUrlByGuest(String accountId, String formId) {
        String domainContextUrl = UrlService.getDomainContextUrl();
        StringBuilder sb = new StringBuilder();
        sb.append(domainContextUrl).append("/mobile.html?userId=Guest&needReset=true").append("&accountId=").append(accountId).append("&form=").append(formId);
        return sb.toString();
    }

    private DynamicObject getVerifyCodeMessage() {
        String phone = (String)this.getModel().getValue("telephone");
        phone = this.hidePhone(phone);
        return HrLoginCommonRepository.getVerifyCodeMessage((String)EnumLoginType.PHONE.getType(), (String)phone);
    }

    private void updateCacheCodeAndTime() {
        long dateTime;
        int second;
        String codeAndTime = this.getCacheCodeAndTime();
        if (HRStringUtils.isNotEmpty((String)codeAndTime) && (second = this.getBetweenSecond(dateTime = HRLongValueParseService.getInstance().parseLong((Object)codeAndTime.split("_")[1]).longValue())) <= 0) {
            String phone = (String)this.getModel().getValue("telephone");
            this.getPageCache().remove(phone);
        }
    }

    private String getCacheCodeAndTime() {
        String phone = (String)this.getModel().getValue("telephone");
        return this.getPageCache().get(phone);
    }

    private void setLabelValue(String key, String value) {
        Label label = (Label)this.getView().getControl(key);
        label.setText(value);
    }
}

