/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbss.formplugin.web.login.mobile;

import com.google.common.collect.Maps;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.hr.hbp.business.application.impl.common.HRLongValueParseService;
import kd.hr.hbp.common.util.HRStringUtils;

public class PrivacyPlugin
extends AbstractMobFormPlugin {
    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.showPrivacy();
    }

    private void showPrivacy() {
        HashMap param = Maps.newHashMapWithExpectedSize((int)1);
        param.put("formId", "hbss_privacysign");
        FormShowParameter showParameter = FormShowParameter.createFormShowParameter((Map)param);
        showParameter.getCustomParams().putAll(this.getView().getFormShowParameter().getCustomParams());
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey("privacycontent");
        this.getView().showForm(showParameter);
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String formOp;
        switch (formOp = ((FormOperate)e.getSource()).getOperateKey()) {
            case "donothing_close": {
                this.agreeOrDisagree(false);
                break;
            }
            case "donothing_confirm": {
                this.agreeOrDisagree(true);
                break;
            }
        }
    }

    private void agreeOrDisagree(boolean isUserAgree) {
        FormShowParameter oldFormShowParameter = this.getView().getFormShowParameter();
        String backFormId = (String)oldFormShowParameter.getCustomParam("backFormId");
        if (HRStringUtils.isEmpty((String)backFormId)) {
            backFormId = "hbss_commonlogin";
        }
        FormShowParameter newFormShowParameter = new FormShowParameter();
        newFormShowParameter.setFormId(backFormId);
        newFormShowParameter.getOpenStyle().setShowType(ShowType.Floating);
        newFormShowParameter.setCustomParams(oldFormShowParameter.getCustomParams());
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        if (formShowParameter.getCustomParams().containsKey("privacyId")) {
            long privacyId = HRLongValueParseService.getInstance().parseLong(formShowParameter.getCustomParam("privacyId"));
            newFormShowParameter.setCustomParam(privacyId + "_isUserAgree", (Object)isUserAgree);
        }
        this.getView().showForm(newFormShowParameter);
    }
}

