/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbss.formplugin.web.perflevel;

import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbss.bussiness.domain.preflevel.enums.PerfLevelChangeTypeEnum;

public class LevelRuleMapPlugin
extends AbstractFormPlugin
implements AfterF7SelectListener,
BeforeF7SelectListener {
    private static final String LEVEL_RULE_CONFIROM_KEY = "levelruleconfironkey";
    private static final String RULE_CHANGE = "rulechange";
    private static final String RULEGRADE_ID = "rulegrade.id";

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        String actionId = event.getCallBackId();
        IPageCache iPageCache = this.getPageCache();
        if (HRStringUtils.equals((String)actionId, (String)RULE_CHANGE)) {
            if (event.getResult() == MessageBoxResult.Yes) {
                DynamicObject dynamicObject = this.getModel().getDataEntity();
                BasedataEdit scoreSys = (BasedataEdit)this.getView().getParentView().getControl("rulegradef7");
                ArrayList<Long> ids = new ArrayList<Long>(this.getFilterIds());
                ids.add(dynamicObject.getLong(RULEGRADE_ID));
                scoreSys.setQFilter(new QFilter("id", "not in", ids));
                scoreSys.click();
                this.getView().getParentView().getPageCache().put("scoresystemcurrentpage", this.getView().getPageId());
                this.getView().sendFormAction(this.getView().getParentView());
                FormShowParameter showParameter = this.getView().getFormShowParameter();
                String pageId = (String)showParameter.getCustomParam("parentId");
                this.levelScoreMapReload(pageId);
            }
            iPageCache.remove(LEVEL_RULE_CONFIROM_KEY);
        }
    }

    private List<Long> getFilterIds() {
        ArrayList<Long> ids = new ArrayList<Long>();
        IFormView iFormView = this.getView().getParentView();
        IPageCache pageCache = iFormView.getPageCache();
        Set pageIdSet = (Set)SerializationUtils.fromJsonString((String)pageCache.get("rulemapentitypage"), Set.class);
        if (pageIdSet.size() > 0) {
            for (String pageId : pageIdSet) {
                IFormView childView = this.getView().getView(pageId);
                if (HRObjectUtils.isEmpty((Object)childView)) continue;
                IDataModel childModel = childView.getModel();
                ids.add(childModel.getDataEntity().getLong(RULEGRADE_ID));
            }
        }
        return ids;
    }

    public void afterF7Select(AfterF7SelectEvent afterF7SelectEvent) {
        String fieldKey = ((Control)afterF7SelectEvent.getSource()).getKey();
        if (HRStringUtils.equals((String)"rulegrade", (String)fieldKey)) {
            this.initComboItem();
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String fieldKey = ((Control)beforeF7SelectEvent.getSource()).getKey();
        IPageCache iPageCache = this.getPageCache();
        beforeF7SelectEvent.setCancel(true);
        if (HRStringUtils.isEmpty((String)iPageCache.get(LEVEL_RULE_CONFIROM_KEY)) && HRStringUtils.equals((String)"rulegrade", (String)fieldKey) && !HRObjectUtils.isEmpty((Object)this.getModel().getValue("rulegrade"))) {
            iPageCache.put(LEVEL_RULE_CONFIROM_KEY, Boolean.TRUE.toString());
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5982\u91cd\u65b0\u9009\u62e9\u6807\u5c3a\u7b49\u7ea7\uff0c\u539f\u914d\u7f6e\u4fe1\u606f\u5c06\u88ab\u6e05\u7a7a\uff0c\u786e\u8ba4\u64cd\u4f5c\uff1f", (String)"LevelRuleMapPlugin_2", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener(RULE_CHANGE, (IFormPlugin)this));
        } else if (HRStringUtils.equals((String)"rulegrade", (String)fieldKey) && HRObjectUtils.isEmpty((Object)this.getModel().getValue("rulegrade"))) {
            ArrayList<Long> ids = new ArrayList<Long>(this.getFilterIds());
            BasedataEdit rule = (BasedataEdit)this.getView().getParentView().getControl("rulegradef7");
            rule.setQFilter(new QFilter("id", "not in", ids));
            rule.click();
            this.getView().getParentView().getPageCache().put("scoresystemcurrentpage", this.getView().getPageId());
            this.getView().sendFormAction(this.getView().getParentView());
            iPageCache.remove(LEVEL_RULE_CONFIROM_KEY);
        }
    }

    private void initComboItem() {
        DynamicObject dynamicObject = this.getModel().getDataEntity().getDynamicObject("rulegrade");
        if (HRObjectUtils.isEmpty((Object)dynamicObject)) {
            return;
        }
        DynamicObjectCollection dycs = dynamicObject.getDynamicObjectCollection("gradeconfigentry");
        HashSet<String> item = new HashSet<String>();
        ComboEdit newRuler = (ComboEdit)this.getControl("rulegradelevel");
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(16);
        for (int index = 0; index < dycs.size(); ++index) {
            ComboItem comboItem = new ComboItem(new LocaleString(((DynamicObject)dycs.get(index)).getString("rulegrade")), String.valueOf(index + 1));
            if (item.contains(((DynamicObject)dycs.get(index)).getString("rulegrade")) || comboItems.contains(comboItem) || !HRStringUtils.isNotEmpty((String)((DynamicObject)dycs.get(index)).getString("rulegrade"))) continue;
            comboItems.add(comboItem);
            item.add(((DynamicObject)dycs.get(index)).getString("rulegrade"));
        }
        newRuler.setComboItems(comboItems);
    }

    public void afterCreateNewData(EventObject eventObject) {
        super.afterCreateNewData(eventObject);
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        String index = (String)showParameter.getCustomParam("index");
        String pageId = (String)showParameter.getCustomParam("parentId");
        Long ruleID = (Long)showParameter.getCustomParam("rule_id");
        Boolean relRuleGradeFlag = (Boolean)showParameter.getCustomParam("isrelrulegrade");
        IFormView iFormView = this.getView().getView((String)showParameter.getCustomParam("parentId"));
        HashSet<String> pageIdSet = HRStringUtils.isNotEmpty((String)iFormView.getPageCache().get("rulemapentitypage")) ? (Set)SerializationUtils.fromJsonString((String)iFormView.getPageCache().get("rulemapentitypage"), Set.class) : new HashSet<String>();
        pageIdSet.add(this.getView().getPageId());
        iFormView.getPageCache().put("rulemapentitypage", SerializationUtils.toJsonString(pageIdSet));
        if (!HRObjectUtils.isEmpty((Object)ruleID)) {
            this.getModel().setValue("rulegrade", (Object)ruleID);
            this.initComboItem();
            this.getView().setVisible(Boolean.FALSE, new String[]{"delete"});
            this.levelScoreMapReload(pageId);
            HashSet<String> mustPageIdSet = HRStringUtils.isNotEmpty((String)iFormView.getPageCache().get("rulemustmapentitypage")) ? (Set)SerializationUtils.fromJsonString((String)iFormView.getPageCache().get("rulemustmapentitypage"), Set.class) : new HashSet<String>();
            mustPageIdSet.add(this.getView().getPageId());
            iFormView.getPageCache().put("rulemustmapentitypage", SerializationUtils.toJsonString(mustPageIdSet));
        } else if (HRStringUtils.isNotEmpty((String)index)) {
            this.showParentEntry(index, pageId, relRuleGradeFlag);
        } else {
            this.levelScoreMapReload(pageId);
        }
    }

    private void showParentEntry(String index, String pageId, Boolean relRuleGradeFlag) {
        DynamicObjectCollection entryEntities = this.getView().getView(pageId).getModel().getEntryEntity("rulemapentryentity");
        if (entryEntities.size() == 0) {
            return;
        }
        this.getModel().deleteEntryData("entryentity");
        DynamicObject dynamicObject = (DynamicObject)entryEntities.get(Integer.parseInt(index));
        DynamicObject dyc = this.getModel().getDataEntity();
        dyc.set("rulegrade", dynamicObject.get("rulegrade"));
        dyc.set("entryboidrule", dynamicObject.get("entryboidrule"));
        this.initComboItem();
        this.setEntryEntry(dynamicObject);
        if (relRuleGradeFlag.booleanValue() || dynamicObject.getBoolean("isrelrulegrade")) {
            dyc.set("isrelrulegrade", (Object)true);
            this.getView().setVisible(Boolean.FALSE, new String[]{"delete"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"rulegrade"});
        }
    }

    private void setEntryEntry(DynamicObject dynamicObject) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        DynamicObjectCollection subEntryEntities = dynamicObject.getDynamicObjectCollection("rulesubentryentity");
        model.beginInit();
        TableValueSetter setter = new TableValueSetter(new String[0]);
        setter.addField("perflevelrule", new Object[0]);
        setter.addField("rulegradelevel", new Object[0]);
        setter.addField("ruledescription", new Object[0]);
        setter.addField("entryboidrulesub", new Object[0]);
        for (DynamicObject entry : subEntryEntities) {
            setter.addRow(new Object[]{entry.get("perflevelrule"), entry.get("rulegradelevel"), entry.get("ruledescription"), entry.get("entryboidrulesub")});
        }
        model.batchCreateNewEntryRow("entryentity", setter);
        model.endInit();
        this.getView().updateView("entryentity");
    }

    private void levelScoreMapReload(String pageId) {
        this.getModel().deleteEntryData("entryentity");
        IFormView iFormView = this.getView();
        AbstractFormDataModel model = (AbstractFormDataModel)iFormView.getModel();
        model.beginInit();
        DynamicObjectCollection entryEntities = this.getView().getView(pageId).getModel().getDataEntity(Boolean.TRUE.booleanValue()).getDynamicObjectCollection("entryentity");
        TableValueSetter setter = new TableValueSetter(new String[0]);
        setter.addField("perflevelrule", new Object[0]);
        for (DynamicObject entry : entryEntities) {
            setter.addRow(new Object[]{entry.get("levelname")});
        }
        model.batchCreateNewEntryRow("entryentity", setter);
        model.endInit();
        iFormView.updateView("entryentity");
        this.setParentBoId();
    }

    private void levelScoreMapUpdate(String pageId) {
        IFormView iFormView = this.getView();
        AbstractFormDataModel model = (AbstractFormDataModel)iFormView.getModel();
        model.beginInit();
        DynamicObjectCollection entryEntities = this.getView().getView(pageId).getModel().getDataEntity(Boolean.TRUE.booleanValue()).getDynamicObjectCollection("entryentity");
        for (int index = 0; index < entryEntities.size(); ++index) {
            model.setValue("perflevelrule", (Object)((DynamicObject)entryEntities.get(index)).getString("levelname"), index);
        }
        model.endInit();
        iFormView.updateView("entryentity");
    }

    private void setParentBoId() {
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        String rows = (String)showParameter.getCustomParam("index");
        String pageId = (String)showParameter.getCustomParam("parentId");
        DynamicObjectCollection ruleMapEntryEntities = this.getView().getView(pageId).getModel().getEntryEntity("rulemapentryentity");
        DynamicObjectCollection entryEntities = this.getView().getView(pageId).getModel().getDataEntity(Boolean.TRUE.booleanValue()).getDynamicObjectCollection("entryentity");
        for (int index = 0; index < entryEntities.size(); ++index) {
            DynamicObject dynamicObject;
            DynamicObjectCollection subEntryEntities;
            if (ruleMapEntryEntities.size() <= 0 || !HRStringUtils.isNotEmpty((String)rows) || index >= (subEntryEntities = (dynamicObject = (DynamicObject)ruleMapEntryEntities.get(Integer.parseInt(rows))).getDynamicObjectCollection("rulesubentryentity")).size()) continue;
            this.getModel().setValue("entryboidrulesub", (Object)((DynamicObject)subEntryEntities.get(index)).getString("entryboidrulesub"), index);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        OperationResult opResult = afterDoOperationEventArgs.getOperationResult();
        if (opResult != null && opResult.isSuccess()) {
            FormShowParameter showParameter = this.getView().getFormShowParameter();
            switch (afterDoOperationEventArgs.getOperateKey()) {
                case "reload": {
                    this.levelScoreMapReload((String)showParameter.getCustomParam("parentId"));
                    break;
                }
                case "update": {
                    this.levelScoreMapUpdate((String)showParameter.getCustomParam("parentId"));
                    break;
                }
                case "delete": {
                    IFormView iFormView = this.getView().getView((String)showParameter.getCustomParam("parentId"));
                    Set pageIdSet = (Set)SerializationUtils.fromJsonString((String)iFormView.getPageCache().get("rulemapentitypage"), Set.class);
                    String numStr = iFormView.getPageCache().get("ruleLevelNumber");
                    int num = Integer.parseInt(numStr) - 1;
                    if (num < 1 || !HRObjectUtils.isEmpty((Object)pageIdSet) && pageIdSet.size() <= 1) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u5173\u95ed\u201c\u542f\u7528\u201d\u5f00\u5173\uff0c\u5373\u53ef\u53d6\u6d88\u8bc4\u5206\u5206\u5236\u4e0e\u7ee9\u6548\u7b49\u7ea7\u7684\u6620\u5c04\u914d\u7f6e\u3002", (String)"LevelRuleMapPlugin_1", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    iFormView.getPageCache().put("ruleLevelNumber", String.valueOf(num));
                    pageIdSet.remove(this.getView().getPageId());
                    iFormView.getPageCache().put("rulemapentitypage", SerializationUtils.toJsonString((Object)pageIdSet));
                    this.getView().close();
                    break;
                }
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs evt) {
        String fieldKey;
        switch (fieldKey = evt.getProperty().getName()) {
            case "rulegradelevel": {
                this.checkRuleLevel(evt);
                break;
            }
            case "rulegrade": {
                this.initComboItem();
                break;
            }
        }
        this.setChangeType();
    }

    private void setChangeType() {
        String pageId = (String)this.getView().getFormShowParameter().getCustomParam("parentId");
        IFormView iFormView = this.getView().getView(pageId);
        String hisAction = (String)iFormView.getFormShowParameter().getCustomParam("his_action");
        if (HRStringUtils.equals((String)"open_insert_data_page", (String)hisAction)) {
            String[] values;
            HashSet<String> changeType = new HashSet<String>(16);
            String oldType = iFormView.getModel().getDataEntity().getString("changetype");
            for (String value : values = oldType.split(",")) {
                if (!HRStringUtils.isNotEmpty((String)value)) continue;
                changeType.add(value);
            }
            changeType.add(PerfLevelChangeTypeEnum.LEVEL_RULE_CHANGE.getChangeType());
            if (!HRObjectUtils.isEmpty(changeType) && changeType.size() > 0) {
                TreeSet set = new TreeSet(changeType);
                iFormView.getModel().setValue("changetype", (Object)("," + Joiner.on((String)",").join(set) + ","));
            }
            iFormView.updateView("changetype");
            this.getView().sendFormAction(iFormView);
        }
    }

    private void checkRuleLevel(PropertyChangedArgs evt) {
        DynamicObjectCollection entryEntities = this.getView().getModel().getDataEntity(Boolean.TRUE.booleanValue()).getDynamicObjectCollection("entryentity");
        for (int index = 1; index < entryEntities.size(); ++index) {
            int last;
            int differ;
            int currtent = ((DynamicObject)entryEntities.get(index)).getInt("rulegradelevel");
            if (currtent == 0 || (differ = currtent - (last = ((DynamicObject)entryEntities.get(index - 1)).getInt("rulegradelevel"))) >= 0) continue;
            Object oldValue = evt.getChangeSet()[0].getOldValue();
            this.getModel().setValue("rulegradelevel", oldValue, index);
            this.showRuleCheckTip();
            break;
        }
    }

    private void showRuleCheckTip() {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("hbss_rulechecktip");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(parameter);
    }

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        BasedataEdit personEdit = (BasedataEdit)this.getView().getControl("rulegrade");
        personEdit.addAfterF7SelectListener((AfterF7SelectListener)this);
        personEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }
}

