/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbss.formplugin.web.taxunit;

import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.QueryResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import org.apache.commons.lang3.StringUtils;

public class TaxUnitListPlugin
extends AbstractListPlugin {
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String key;
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (key = formOperate.getOperateKey()) {
            case "revise": {
                this.reviseTaxUnit();
                break;
            }
        }
    }

    private void reviseTaxUnit() {
        ListSelectedRowCollection selectedRows = this.getSelectedRows();
        if (selectedRows == null || selectedRows.size() == 0) {
            return;
        }
        if (selectedRows.size() != 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u8bb0\u5f55\u3002", (String)"TaxUnitListPlugin_0", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]));
            return;
        }
        BillList billList = (BillList)this.getControl("billlistap");
        QueryResult queryResult = billList.queryDataBySelectedRows(selectedRows);
        DynamicObjectCollection collection = queryResult.getCollection();
        DynamicObject taxUnit = (DynamicObject)collection.get(0);
        String status = taxUnit.getString("status");
        boolean enable = taxUnit.getBoolean("enable");
        if (!StringUtils.equals((CharSequence)status, (CharSequence)"C") || !enable) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5df2\u5ba1\u6838\u4e14\u53ef\u7528\u7684\u8bb0\u5f55\u3002", (String)"TaxUnitListPlugin_1", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]));
            return;
        }
        BaseShowParameter showParameter = new BaseShowParameter();
        showParameter.setFormId("hbss_taxunit");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setStatus(OperationStatus.EDIT);
        showParameter.setPkId(selectedRows.get(0).getPrimaryKeyValue());
        showParameter.setCustomParam("isrevise", (Object)Boolean.TRUE);
        this.getView().showForm((FormShowParameter)showParameter);
    }
}

